/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.lock;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.lock.IShareLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.Mutex;
import kd.bos.mutex.lock.ZkStore;

public class ShareLockImpl
extends Mutex
implements IShareLock {
    private static final Log log = LogFactory.getLog(ShareLockImpl.class);
    private String flag = null;
    private boolean isShareLock = true;
    private static long maxTimeout = 3600L;

    private boolean requireLockInner(int tryCount, long secsToTimeout) {
        if (tryCount > 3) {
            return false;
        }
        if (this.hasLocked(this.lockPath)) {
            String lockType;
            String data = null;
            try {
                data = ZkStore.read((String)this.lockPath, null);
            }
            catch (KDException e) {
                log.info("Share lock deleteed,read lock error!", (Object)e);
                return this.requireNewLock(tryCount, secsToTimeout);
            }
            if (data == null || data.trim().length() == 0) {
                return this.requireLockInner(++tryCount, secsToTimeout);
            }
            Map mapData = (Map)JSON.parseObject((String)data, Map.class);
            String dataStr = (String)mapData.get("data");
            String[] datas = dataStr.split("#");
            if (datas.length > 1) {
                long timeout = Long.parseLong(datas[1]);
                long lockTime = Long.parseLong((String)mapData.get("lockedTime"));
                if (System.currentTimeMillis() - lockTime > timeout * 1000L) {
                    List children = ZkStore.getChildren((String)this.lockPath);
                    if (!children.isEmpty()) {
                        children.forEach(c -> ZkStore.delete((String)(this.lockPath + "/" + c)));
                    }
                    ZkStore.delete((String)this.lockPath);
                    return this.requireLockInner(++tryCount, secsToTimeout);
                }
            }
            if ("true".equalsIgnoreCase(lockType = datas[0])) {
                if (this.isShareLock) {
                    try {
                        this.succ();
                        mapData.put("lockedTime", String.valueOf(System.currentTimeMillis()));
                        ZkStore.write((String)this.lockPath, (String)JSON.toJSONString((Object)mapData));
                    }
                    catch (KDException e) {
                        log.info("Share lock deleteed,read lock error!", (Object)e);
                        return this.requireNewLock(tryCount, secsToTimeout);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return this.requireNewLock(tryCount, secsToTimeout);
    }

    private boolean requireNewLock(int tryCount, long secsToTimeout) {
        this.writeLock = null;
        if (!this.require(this.lockObjKey)) {
            if (this.isShareLock) {
                return this.requireLockInner(++tryCount, secsToTimeout);
            }
            return false;
        }
        this.succ();
        return true;
    }

    private void succ() {
        String childrenPath = this.lockPath + "/" + this.flag;
        ZkStore.write((String)childrenPath, (String)String.valueOf(this.isShareLock));
    }

    protected void afterRelease() {
        List children;
        String childrenPath;
        boolean isSuccessLock;
        if (log.isInfoEnabled()) {
            log.info(Thread.currentThread().getName() + " share lock close.");
        }
        if (isSuccessLock = ZkStore.existed((String)(childrenPath = this.lockPath + "/" + this.flag))) {
            ZkStore.delete((String)childrenPath);
        }
        if (ZkStore.existed((String)this.lockPath) && isSuccessLock && (children = ZkStore.getChildren((String)this.lockPath)).isEmpty()) {
            ZkStore.delete((String)this.lockPath);
        }
    }

    protected boolean hasLocked(String path) {
        return ZkStore.existed((String)path);
    }

    @Override
    public void release() {
        super.release();
        this.afterRelease();
    }

    @Override
    public boolean requireLock(String key, boolean shared, long secsToTimeout) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.prepared();
        this.flag = UUID.randomUUID().toString();
        if (secsToTimeout == 0L) {
            secsToTimeout = maxTimeout;
        }
        this.data = (String.valueOf(shared) + "#" + secsToTimeout).getBytes(UTF_8);
        this.lockObjKey = this.processSpecialString(key);
        this.isShareLock = shared;
        this.lockPath = this.getBasePath() + "/" + this.lockObjKey;
        return this.requireLockInner(0, secsToTimeout);
    }

    @Override
    public boolean refreshLock(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.prepared();
        this.lockObjKey = this.processSpecialString(key);
        this.lockPath = this.getBasePath() + "/" + this.lockObjKey;
        if (this.hasLocked(this.lockPath)) {
            String data = ZkStore.read((String)this.lockPath, null);
            Map mapData = (Map)JSON.parseObject((String)data, Map.class);
            mapData.put("lockedTime", String.valueOf(System.currentTimeMillis()));
            ZkStore.write((String)this.lockPath, (String)JSON.toJSONString((Object)mapData));
            return true;
        }
        return false;
    }

    @Override
    public boolean setTimeout(String key, long secsToTimeout, boolean refreshLock) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.prepared();
        this.lockObjKey = this.processSpecialString(key);
        this.lockPath = this.getBasePath() + "/" + this.lockObjKey;
        if (this.hasLocked(this.lockPath)) {
            String data = ZkStore.read((String)this.lockPath, null);
            Map mapData = (Map)JSON.parseObject((String)data, Map.class);
            String dataStr = (String)mapData.get("data");
            String[] datas = dataStr.split("#");
            dataStr = datas[0] + "#" + secsToTimeout;
            mapData.put("data", new String(dataStr.getBytes(UTF_8), UTF_8));
            if (refreshLock) {
                mapData.put("lockedTime", String.valueOf(System.currentTimeMillis()));
            }
            ZkStore.write((String)this.lockPath, (String)JSON.toJSONString((Object)mapData));
            return true;
        }
        return false;
    }

    @Override
    public void forceRelease(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.prepared();
        this.lockObjKey = this.processSpecialString(key);
        this.lockPath = this.getBasePath() + "/" + this.lockObjKey;
        if (this.hasLocked(this.lockPath)) {
            List children = ZkStore.getChildren((String)this.lockPath);
            if (!children.isEmpty()) {
                children.forEach(c -> ZkStore.delete((String)(this.lockPath + "/" + c)));
            }
            ZkStore.delete((String)this.lockPath);
        }
    }
}

