/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.bizrule;

import java.util.ArrayList;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.validate.VoucherStateValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AutoProcessVoucherOpAction
extends AbstractOpBizRuleAction {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new VoucherStateValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        DynamicObject[] intellBusinesses = new DynamicObject[bills.length];
        int i = 0;
        for (DynamicObject bill : bills) {
            DynamicObject intellBusiness;
            DynamicObject[] trackers;
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.add(new QFilter("sourcebillid", "=", (Object)bill.getLong("id")));
            DapVoucherUtil.addBillTypeFilter(bill.getDataEntityType().getName(), filterList);
            for (DynamicObject tracker : trackers = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"voucherid", (QFilter[])filterList.toArray(new QFilter[0]))) {
                long voucherid = tracker.getLong("voucherid");
                DeleteServiceHelper deleteservice = new DeleteServiceHelper();
                deleteservice.deleteOperate("gl_voucher", new Object[]{voucherid}, OperateOption.create());
            }
            intellBusinesses[i] = intellBusiness = this.createIntellBusinessDb(bill);
            ++i;
        }
        try (TXHandle t = TX.requiresNew((String)"DapBusinessCanCreateVoucherOpAction");){
            SaveServiceHelper.save((DynamicObject[])intellBusinesses);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
    }

    private DynamicObject createIntellBusinessDb(DynamicObject bill) {
        DynamicObject intellBusiness = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"iep_businesstask"));
        intellBusiness.set("business", (Object)bill.getDataEntityType().getName());
        intellBusiness.set("oper", (Object)"buildvoucher");
        intellBusiness.set("entityid", bill.getPkValue());
        return intellBusiness;
    }
}

