/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.bizrule;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.operation.bizrule.BgControlOpAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;

public class BgRequestBudgetOpAction
extends AbstractOpBizRuleAction
implements BgControlOpAction {
    private static final Log log = LogFactory.getLog(BgRequestBudgetOpAction.class);

    public void initialize(InitOperationArgs e) {
        super.initialize(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if (e.getDataEntities() == null || e.getDataEntities().length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u6570\u636e\u5305\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"BgRequestBudgetOpAction_0", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        this.doAction(e.getDataEntities(), this.getMethodName(), e.getOperationKey());
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        this.rollBack(e.getDataEntitys(), this.getRollBackMethod());
    }

    private String getMethodName() {
        return "requestBudget";
    }

    @Override
    public String getRollBackMethod() {
        return "budgetRollBack";
    }

    @Override
    public void setBillWarningFlag(Object result, DynamicObject bill) {
        if (result == null || bill == null) {
            return;
        }
        Class<?> resultClass = result.getClass();
        try {
            String resultClassName = resultClass.getName();
            log.info("has get resultClass name:" + resultClassName);
            if ("java.util.HashMap".equalsIgnoreCase(resultClassName) || result instanceof HashMap) {
                Map warningMap;
                Object warningObj;
                String warningClassName;
                Map resultMap = (Map)result;
                if (resultMap != null && resultMap.containsKey("warningResult") && ("java.util.HashMap".equalsIgnoreCase(warningClassName = (warningObj = resultMap.get("warningResult")).getClass().getName()) || warningObj instanceof HashMap) && (warningMap = (Map)warningObj) != null && warningMap.size() > 0) {
                    this.setBillWarningStatus(warningMap, bill);
                }
            } else if ("kd.epm.eb.control.impl.model.ControlResult".equals(resultClassName)) {
                Method method = resultClass.getMethod("getWarningResult", new Class[0]);
                if (method != null) {
                    ReflectionUtils.makeAccessible((Method)method);
                    Object warningObj = method.invoke(result, new Object[0]);
                    if (warningObj instanceof Map) {
                        Map warningMap = (Map)warningObj;
                        if (warningObj != null && warningMap.size() > 0) {
                            this.setBillWarningStatus(warningMap, bill);
                        }
                    }
                }
            } else {
                log.info("parse class error" + resultClassName);
            }
        }
        catch (IllegalAccessException ex) {
            throw new KDBizException("IllegalAccessException:" + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new KDBizException("IllegalArgumentException:" + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            throw new KDBizException("InvocationTargetException:" + ex.getMessage());
        }
        catch (NoSuchMethodException ex) {
            throw new KDBizException("NoSuchMethodException:" + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new KDBizException("SecurityException:" + ex.getMessage());
        }
        catch (Exception ex) {
            throw new KDBizException("Exception:" + ex.getMessage());
        }
    }

    private void setBillWarningStatus(Map<String, Object> warningMap, DynamicObject bill) {
        if (warningMap == null || warningMap.isEmpty() || bill == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : warningMap.entrySet()) {
            String warningKey = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            String warningValue = value.toString();
            boolean isWarning = true;
            if (warningValue.equals("0") || warningValue.equalsIgnoreCase("false")) {
                isWarning = false;
            }
            bill.set(warningKey, (Object)isWarning);
            log.info(String.format("get field:[%s] ,value:[%s] ", warningKey, warningValue));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        try {
            Set ids = Arrays.stream(bills).map(k -> k.getString("id")).collect(Collectors.toSet());
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"requestSuccess", (Object[])new Object[]{bills[0].getDataEntityType().getName(), ids});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

