/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod.result;

import java.io.Serializable;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.fcm.CheckExecutionResult;
import kd.bos.ext.fi.fcm.ExecuteStatus;
import kd.bos.ext.fi.fcm.mservice.CheckItemDetail;
import kd.bos.orm.query.QFilter;

public class CloseCheckItemResult
implements Serializable {
    private static final long serialVersionUID = -6005591570111252007L;
    private static final String DEFAULT_ICON = "kingdee/fi/images/pc/icon/menu/7qmjz_48_48.png";
    private String checkItem;
    private String checkState;
    private String formQuery;
    private String formNumber;
    private String message;
    private String checkItemCardMessage;
    private String menuId;
    private ErrorLevel errorLevel = ErrorLevel.Error;

    public String getCheckItem() {
        return this.checkItem;
    }

    public void setCheckItem(String checkItem) {
        this.checkItem = checkItem;
    }

    public String getCheckState() {
        return this.checkState;
    }

    public void setCheckState(String checkState) {
        this.checkState = checkState;
    }

    public String getFormQuery() {
        return this.formQuery;
    }

    public void setFormQuery(String formQuery) {
        this.formQuery = formQuery;
    }

    public String getFormNumber() {
        return this.formNumber;
    }

    public void setFormNumber(String formNumber) {
        this.formNumber = formNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCheckItemCardMessage() {
        return this.checkItemCardMessage;
    }

    public void setCheckItemCardMessage(String checkItemCardMessage) {
        this.checkItemCardMessage = checkItemCardMessage;
    }

    public String getMenuId() {
        return this.menuId;
    }

    public void setMenuId(String menuId) {
        this.menuId = menuId;
        if (StringUtils.isBlank((CharSequence)menuId)) {
            this.menuId = DEFAULT_ICON;
        }
    }

    public ErrorLevel getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(ErrorLevel errorLevel) {
        this.errorLevel = errorLevel;
    }

    public static CloseCheckItemResult buildFailed(String checkItem, String message) {
        return CloseCheckItemResult.buildFailed(checkItem, message, null, null, null);
    }

    public static CloseCheckItemResult buildFailed(String checkItem, String message, String menuId, String formNumber, String formQuery) {
        return CloseCheckItemResult.build("0", checkItem, message, menuId, formNumber, formQuery);
    }

    public static CloseCheckItemResult buildSuccess(String checkItem, String message, String menuId, String formNumber, String formQuery) {
        return CloseCheckItemResult.build("1", checkItem, message, menuId, formNumber, formQuery);
    }

    public static CloseCheckItemResult build(String state, String checkItem, String message, String menuId, String formNumber, String formQuery) {
        CloseCheckItemResult result = new CloseCheckItemResult();
        result.setCheckState(state);
        result.setCheckItem(checkItem);
        result.setMessage(message);
        result.setCheckItemCardMessage(message);
        result.setMenuId(menuId);
        result.setFormNumber(formNumber);
        result.setFormQuery(formQuery);
        return result;
    }

    public static CloseCheckItemResult fromCheckResultWrapper(CheckExecutionResult.CheckResultWrapper checkResultWrapper) {
        CheckItemDetail checkItem = checkResultWrapper.getCheckItem();
        CloseCheckItemResult itemResultVO = new CloseCheckItemResult();
        ExecuteStatus executeStatus = checkResultWrapper.getExecuteStatus();
        itemResultVO.setCheckItem(checkItem.getName());
        itemResultVO.setMenuId(checkItem.getCustomizeIcon());
        String errMsg = checkResultWrapper.getErrMsg();
        if (ExecuteStatus.PASS == executeStatus) {
            itemResultVO.setCheckState("1");
        } else if (ExecuteStatus.FAIL == executeStatus) {
            if (StringUtils.isBlank((CharSequence)errMsg)) {
                errMsg = checkItem.getName();
            }
            String onlineViewId = checkItem.getOnlineViewId();
            String filterStr = "";
            QFilter[] billFilters = checkResultWrapper.getBillFilters();
            if (!Objects.isNull(billFilters) && billFilters.length > 0) {
                QFilter filter = null;
                for (QFilter qFilter : billFilters) {
                    filter = null == filter ? qFilter : filter.and(qFilter);
                }
                if (null != filter) {
                    filterStr = filter.toSerializedString();
                }
            }
            itemResultVO.setFormNumber(onlineViewId);
            itemResultVO.setFormQuery(filterStr);
            itemResultVO.setMessage(checkItem.getName());
            itemResultVO.setCheckItemCardMessage(errMsg);
            if (StringUtils.isNotBlank((CharSequence)onlineViewId)) {
                itemResultVO.setCheckItemCardMessage(null);
            }
            itemResultVO.setCheckState("0");
        } else {
            itemResultVO.setCheckState("0");
            itemResultVO.setMessage(checkItem.getName());
            itemResultVO.setCheckItemCardMessage(errMsg);
        }
        return itemResultVO;
    }
}

