/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod.result;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.ext.fi.operation.closeperiod.result.CloseCheckItemResult;
import kd.bos.ext.fi.operation.closeperiod.result.IClosePeriodResultService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class ClosePeriodResultCacheService
implements IClosePeriodResultService {
    private static final IAppCache CACHE = AppCache.get((String)"gl");

    @Override
    public boolean recordItemResult(String closeResultUniqueKey, List<CloseCheckItemResult> itemResults) {
        if (CollectionUtils.isEmpty(itemResults)) {
            return true;
        }
        String cacheInfo = (String)CACHE.get("periodClose_" + closeResultUniqueKey, String.class);
        DynamicObject resultDyn = StringUtils.isNotEmpty((String)cacheInfo) ? (DynamicObject)DataEntitySerializer.deSerializerFromString((String)cacheInfo, (IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_closecheckitem")) : BusinessDataServiceHelper.newDynamicObject((String)"bd_closecheckitem");
        DynamicObjectCollection entries = resultDyn.getDynamicObjectCollection("entryentity");
        for (CloseCheckItemResult itemResult : itemResults) {
            DynamicObject entry = entries.addNew();
            entry.set("seq", (Object)entries.size());
            entry.set("checkitem", (Object)itemResult.getCheckItem());
            entry.set("checkstate", (Object)itemResult.getCheckState());
            entry.set("formquery", (Object)itemResult.getFormQuery());
            entry.set("formnumber", (Object)itemResult.getFormNumber());
            entry.set("message", (Object)itemResult.getCheckItemCardMessage());
            entry.set("menuid", (Object)itemResult.getMenuId());
        }
        CACHE.put("periodClose_" + closeResultUniqueKey, (Object)DataEntitySerializer.serializerToString((Object)resultDyn));
        return true;
    }

    @Override
    public List<CloseCheckItemResult> getResults(String closeResultUniqueKey) {
        String cacheInfo = (String)CACHE.get("periodClose_" + closeResultUniqueKey, String.class);
        if (StringUtils.isEmpty((String)cacheInfo)) {
            return new ArrayList<CloseCheckItemResult>(1);
        }
        DynamicObject resultDyn = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)cacheInfo, (IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_closecheckitem"));
        DynamicObjectCollection entries = resultDyn.getDynamicObjectCollection("entryentity");
        return entries.stream().map(x -> CloseCheckItemResult.build(x.getString("checkstate"), x.getString("checkitem"), x.getString("message"), x.getString("menuid"), x.getString("formnumber"), x.getString("formquery"))).collect(Collectors.toList());
    }

    @Override
    public boolean clear(String closeResultUniqueKey) {
        CACHE.remove("periodClose_" + closeResultUniqueKey);
        return true;
    }
}

