/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod.validator;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.ext.fi.operation.closeperiod.validator.AbstractClosePeriodValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.util.StringUtils;

public class ClosePeriodLockValidator
extends AbstractClosePeriodValidator {
    private static final Log LOG = LogFactory.getLog(ClosePeriodLockValidator.class);
    private final List<String> lockedDataList;

    public ClosePeriodLockValidator(List<String> lockedDataList) {
        this.lockedDataList = lockedDataList;
    }

    @Override
    public void doValidate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        List requireList = Arrays.stream(extendedDataEntities).map(x -> this.buildRequireParam(x.getBillPkId())).collect(Collectors.toList());
        String orgProp = this.getBookRegisterInfo().getOrgFieldOnCloseEntity();
        String bookTypeProp = this.getBookRegisterInfo().getBookTypeFieldOnCloseEntity();
        try (DataMutex dataMutex = DataMutex.create();){
            Map lockResult = dataMutex.batchrequire(requireList);
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                Boolean required = lockResult.getOrDefault(String.valueOf(extendedDataEntity.getBillPkId()), false);
                if (!required.booleanValue()) {
                    long orgId = extendedDataEntity.getDataEntity().getLong(orgProp + ".id");
                    long bookTypeId = StringUtils.isEmpty((String)bookTypeProp) ? 0L : extendedDataEntity.getDataEntity().getLong(bookTypeProp + ".id");
                    this.addFlatError(extendedDataEntity, orgId, bookTypeId, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6b63\u5728\u7ed3\u8d26\u4e2d", (String)"ClosePeriodLockValidator_0", (String)"bos-ext-fi", (Object[])new Object[0]));
                    continue;
                }
                this.lockedDataList.add(String.valueOf(extendedDataEntity.getBillPkId()));
            }
        }
        catch (IOException e) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                long orgId = extendedDataEntity.getDataEntity().getLong(orgProp + ".id");
                long bookTypeId = StringUtils.isEmpty((String)bookTypeProp) ? 0L : extendedDataEntity.getDataEntity().getLong(bookTypeProp + ".id");
                this.addFlatError(extendedDataEntity, orgId, bookTypeId, ResManager.loadKDString((String)"\u7533\u8bf7\u7ed3\u8d26\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7", (String)"ClosePeriodLockValidator_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            }
            LOG.error("ClosePeriod require lock failed.", (Throwable)e);
        }
    }

    private Map<String, Object> buildRequireParam(Object bookId) {
        HashMap<String, Object> requireParam = new HashMap<String, Object>(16);
        requireParam.put("dataObjId", bookId.toString());
        requireParam.put("dataObjNumber", bookId.toString());
        requireParam.put("groupId", this.getAppNumber() + "_closeperiod");
        requireParam.put("entityKey", this.getBookRegisterInfo().getCloseEntityOfCloseOp());
        requireParam.put("operationKey", this.getBookRegisterInfo().getCloseOperationKey());
        requireParam.put("isStrict", true);
        requireParam.put("ignoreModify", false);
        requireParam.put("callSource", "default");
        requireParam.put("isOpenIntentLocks", false);
        return requireParam;
    }
}

