/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod.validator;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.gl.closeperiod.RelatedBookQueryServiceHelper;
import kd.bos.ext.fi.operation.closeperiod.ClosePeriodService;
import kd.bos.ext.fi.operation.closeperiod.result.CloseCheckItemResult;
import kd.bos.ext.fi.operation.closeperiod.validator.AbstractClosePeriodValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class IntellCheckValidator
extends AbstractClosePeriodValidator {
    private static final String ICON = "/icons/pc/entrance/zz_pztx_48_48.png";
    private static final Log LOGGER = LogFactory.getLog(IntellCheckValidator.class);
    private static final String FAIL = "2";
    private static final String ERROR = "7";
    private final Table<Long, Long, ClosePeriodService.CloseData> closeDataTable;

    public IntellCheckValidator(Table<Long, Long, ClosePeriodService.CloseData> closeDataTable) {
        this.closeDataTable = closeDataTable;
    }

    @Override
    public void doValidate() {
        String appNumber = this.getAppNumber();
        if ("gl".equals(appNumber)) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String orgProp = this.getBookRegisterInfo().getOrgFieldOnCloseEntity();
        String bookTypeProp = this.getBookRegisterInfo().getBookTypeFieldOnCloseEntity();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            QFilter filter;
            List arPolicyIds;
            Long closePeriodId;
            DynamicObject data = dataEntity.getDataEntity();
            long orgId = data.getLong(orgProp + ".id");
            long bookTypeId = StringUtils.isNotEmpty((String)bookTypeProp) ? data.getLong(bookTypeProp + ".id") : 0L;
            ClosePeriodService.CloseData closeData = (ClosePeriodService.CloseData)this.closeDataTable.get((Object)orgId, (Object)bookTypeId);
            if (closeData == null || (closePeriodId = closeData.getClosePeriodId()) == 0L) continue;
            Long bookId = "ar".equals(appNumber) ? Long.valueOf((arPolicyIds = QueryServiceHelper.queryPrimaryKeys((String)"ar_policy", (QFilter[])(filter = new QFilter(this.getBookRegisterInfo().getOrgFieldOnBookEntity(), "=", (Object)orgId).and(new QFilter(this.getBookRegisterInfo().getBookTypeFieldOnBookEntity(), "=", (Object)bookTypeId))).toArray(), null, (int)1)).size() > 0 ? (Long)arPolicyIds.get(0) : 0L) : (StringUtils.isEmpty((String)this.getBookRegisterInfo().getBookEntityId()) ? Long.valueOf(0L) : (Long)dataEntity.getBillPkId());
            HashMap<String, Object> param = new HashMap<String, Object>(8);
            param.put("periodId", closePeriodId);
            param.put("appNumber", appNumber);
            param.put("bizBookId", bookId);
            param.put("orgId", orgId);
            param.put("init", false);
            Map variables = this.getOption().getVariables();
            if (variables.containsKey("oriResult")) {
                param.put("oriResult", variables.get("oriResult"));
            }
            this.check(dataEntity, orgId, bookTypeId, param);
        }
    }

    private void check(ExtendedDataEntity dataEntity, long orgId, long bookTypeId, Map<String, Object> param) {
        String result;
        String errorCode;
        String errorMsg;
        block8: {
            errorMsg = null;
            errorCode = null;
            result = null;
            try {
                LOGGER.info("con_check_mservice, param:" + JSONObject.toJSONString(param));
                result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{JSONObject.toJSONString(param)});
            }
            catch (KDBizException e) {
                errorMsg = e.getMessage();
                errorCode = e.getErrorCode().getCode();
                if (e.getArgs().length <= 0) break block8;
                result = e.getArgs()[0].toString();
            }
        }
        LOGGER.info("con_check_result:" + errorMsg);
        if (errorMsg != null) {
            LOGGER.info("con_check_result:error");
            if (FAIL.equals(errorCode)) {
                CloseCheckItemResult closeCheckItemResult = CloseCheckItemResult.buildFailed(ResManager.loadKDString((String)"\u672c\u671f\u4e0e\u603b\u8d26\u5bf9\u8d26\u4e0d\u5e73", (String)"IntellCheckValidator_0", (String)"bos-ext-fi", (Object[])new Object[0]), errorMsg, ICON, "frm_reconciliation_rst_fst", result);
                closeCheckItemResult.setCheckItemCardMessage(null);
                this.addCheckItemResult(dataEntity, orgId, bookTypeId, closeCheckItemResult);
            } else if (ERROR.equals(errorCode)) {
                CloseCheckItemResult closeCheckItemResult = CloseCheckItemResult.buildFailed(ResManager.loadKDString((String)"\u672c\u671f\u4e0e\u603b\u8d26\u5bf9\u8d26\u4e0d\u5e73", (String)"IntellCheckValidator_0", (String)"bos-ext-fi", (Object[])new Object[0]), errorMsg, ICON, "frm_reconciliation_rst_fst", result);
                closeCheckItemResult.setCheckItemCardMessage(null);
                this.addCheckItemResult(dataEntity, orgId, bookTypeId, closeCheckItemResult);
            } else {
                this.addCheckItemResult(dataEntity, orgId, bookTypeId, CloseCheckItemResult.buildFailed(ResManager.loadKDString((String)"\u672c\u671f\u4e0e\u603b\u8d26\u5bf9\u8d26\u4e0d\u5e73", (String)"IntellCheckValidator_0", (String)"bos-ext-fi", (Object[])new Object[0]), errorMsg, ICON, null, null));
            }
        } else {
            LOGGER.info("con_check_result:success");
            this.addCheckItemResult(dataEntity, orgId, bookTypeId, CloseCheckItemResult.buildSuccess(ResManager.loadKDString((String)"\u671f\u672b\u5bf9\u8d26\u68c0\u67e5", (String)"IntellCheckValidator_1", (String)"bos-ext-fi", (Object[])new Object[0]), null, ICON, null, null));
        }
    }

    private boolean existsGLAccountBook(String appNumber, Long bizBookId, Long orgIdOnBizBook) {
        QFilter bookFilter = new QFilter("org", "=", (Object)orgIdOnBizBook).and("enable", "=", (Object)Character.valueOf('1'));
        if (StringUtils.isNotEmpty((String)this.getBookRegisterInfo().getBookEntityId())) {
            DynamicObject[] accountBooks;
            for (DynamicObject accountBook : accountBooks = BusinessDataServiceHelper.load((String)"gl_accountbook", (String)"id", (QFilter[])bookFilter.toArray())) {
                List<Long> bizBooks = this.queryBizBookOnGLBook(appNumber, accountBook.getLong("id"));
                if (!bizBooks.contains(bizBookId)) continue;
                return true;
            }
        } else {
            if (bizBookId == null || bizBookId == 0L) {
                bookFilter.and("bookstype.accounttype", "=", (Object)Character.valueOf('1'));
            }
            return QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])bookFilter.toArray());
        }
        return false;
    }

    private List<Long> queryBizBookOnGLBook(String appNumber, long accountBookId) {
        Map<String, List<Long>> bizBookMap = RelatedBookQueryServiceHelper.queryAllBizAccountBook(accountBookId);
        return bizBookMap.getOrDefault(appNumber, Collections.emptyList());
    }
}

