/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.botp.helper.QuotationHelper;
import kd.bos.ext.fi.plugin.ArApConvert.helper.BOTPHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class InitServiceHelper {
    public static final String ExRate_CONVERT_MODE_DIRECT = "0";
    public static final String ExRate_CONVERT_MODE_INDIRECT = "1";

    public static Map<Long, DynamicObject> loadInitInfos(Set<Long> orgIds, boolean isAr) {
        HashMap<Long, DynamicObject> initInfoMap = new HashMap<Long, DynamicObject>(8);
        QFilter qFilter = new QFilter("org", "in", orgIds);
        if (isAr) {
            DynamicObject[] inits;
            for (DynamicObject initInfo : inits = BusinessDataServiceHelper.load((String)"ar_init", (String)(InitServiceHelper.getInitSelectors() + ", policytype.type"), (QFilter[])new QFilter[]{qFilter})) {
                Long orgId = initInfo.getLong("org.id");
                String policytype = initInfo.getString("policytype.type");
                if ("master".equals(policytype)) {
                    initInfoMap.put(orgId, initInfo);
                    continue;
                }
                initInfoMap.putIfAbsent(orgId, initInfo);
            }
        } else {
            DynamicObject[] inits;
            for (DynamicObject initInfo : inits = BusinessDataServiceHelper.load((String)"ap_init", (String)InitServiceHelper.getInitSelectors(), (QFilter[])new QFilter[]{qFilter})) {
                initInfoMap.put(initInfo.getLong("org.id"), initInfo);
            }
        }
        return initInfoMap;
    }

    public static void checkOrgInit(DynamicObject org, Map<Long, DynamicObject> orgInitMap, boolean isAr) {
        DynamicObject orgInit = orgInitMap.get(org.getLong("id"));
        boolean isInit = true;
        if (orgInit == null) {
            isInit = false;
        } else {
            Date startdate = orgInit.getDate("startdate");
            if (startdate == null) {
                isInit = false;
            }
        }
        if (!isInit) {
            ErrorCode ARAPORGNAME_NOT_SET = isAr ? new ErrorCode("ARAPORGNAME_NOT_SET_2", ResManager.loadKDString((String)"\u7ec4\u7ec7:%1$s\u6ca1\u6709\u8fdb\u884c\u5e94\u6536\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u5230\u5e94\u6536\u5e94\u7528\u4e0b\u5148\u8fdb\u884c\u7ed3\u675f\u521d\u59cb\u5316\u540e\u518d\u8bd5\u3002", (String)"ARAPORGNAME_NOT_SET_2", (String)"bos-ext-fi", (Object[])new Object[0])) : new ErrorCode("ARAPORGNAME_NOT_SET_1", ResManager.loadKDString((String)"\u7ec4\u7ec7:%1$s\u6ca1\u6709\u8fdb\u884c\u5e94\u4ed8\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u5230\u5e94\u4ed8\u5e94\u7528\u4e0b\u5148\u8fdb\u884c\u7ed3\u675f\u521d\u59cb\u5316\u540e\u518d\u8bd5\u3002", (String)"ARAPORGNAME_NOT_SET_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            throw new KDBizException(ARAPORGNAME_NOT_SET, new Object[]{org.getLocaleString("name").getLocaleValue()});
        }
        InitServiceHelper.checkOrgInitValue(orgInit, isAr);
    }

    private static String getInitSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(8);
        selectors.add("id");
        selectors.add("org");
        selectors.add("standardcurrency");
        selectors.add("exratetable");
        selectors.add("isfinishinit");
        selectors.add("startdate");
        selectors.add("currentdate");
        selectors.add("periodtype");
        return String.join((CharSequence)",", selectors);
    }

    public static void setBizDate(DynamicObject finBill, DynamicObject init, ConvertRuleElement rule) {
        boolean isSettingForBizDate = BOTPHelper.ruleIsSetting(rule, false, "bizdate");
        Date bizdate = finBill.getDate("bizdate");
        if (!isSettingForBizDate) {
            Date currentdate;
            Date date = currentdate = ObjectUtils.isEmpty((Object)init.getDate("currentdate")) ? init.getDate("startdate") : init.getDate("currentdate");
            if (currentdate != null && bizdate != null && currentdate.compareTo(bizdate) > 0) {
                finBill.set("bizdate", (Object)currentdate);
            }
        }
        if (bizdate == null) {
            finBill.set("bizdate", (Object)new Date());
        }
    }

    public static void setInitValue(DynamicObject finBill, DynamicObject init, boolean isSetting) {
        DynamicObject basecurrency = init.getDynamicObject("standardcurrency");
        finBill.set("basecurrency", (Object)basecurrency);
        if (ObjectUtils.isEmpty((Object)finBill.get("exratetable"))) {
            finBill.set("exratetable", (Object)init.getDynamicObject("exratetable"));
        }
        if (ObjectUtils.isEmpty((Object)finBill.get("exratedate"))) {
            finBill.set("exratedate", (Object)new Date());
        }
        long srcCurrencyId = finBill.getLong("currency.id");
        String quotation = finBill.getString("quotation");
        BigDecimal exchangerate = finBill.getBigDecimal("exchangerate");
        if (!isSetting || ObjectUtils.isEmpty((Object)exchangerate) || BigDecimal.ZERO.compareTo(exchangerate) == 0 || ObjectUtils.isEmpty((Object)quotation) || quotation.equals(ExRate_CONVERT_MODE_DIRECT)) {
            long destCurrencyId = basecurrency.getLong("id");
            if (srcCurrencyId == destCurrencyId) {
                finBill.set("quotation", (Object)ExRate_CONVERT_MODE_DIRECT);
                finBill.set("exchangerate", (Object)BigDecimal.valueOf(1L));
            } else {
                QuotationHelper quotationHelper = new QuotationHelper();
                Tuple<String, BigDecimal> tuple = quotationHelper.getExchangeRateMap(finBill.getLong("exratetable.id"), srcCurrencyId, destCurrencyId, finBill.getDate("exratedate"));
                if (ObjectUtils.isEmpty((Object)quotation) || quotation.equals(ExRate_CONVERT_MODE_DIRECT)) {
                    finBill.set("quotation", tuple.item1);
                }
                if (!isSetting || ObjectUtils.isEmpty((Object)exchangerate) || BigDecimal.ZERO.compareTo(exchangerate) == 0) {
                    finBill.set("exchangerate", tuple.item2);
                }
            }
        }
    }

    public static void checkOrgInitValue(DynamicObject orgInit, boolean isAr) {
        StringBuilder errMsg = new StringBuilder();
        if (ObjectUtils.isEmpty((Object)orgInit.getDynamicObject("standardcurrency"))) {
            errMsg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e3b\u5e01\u79cd", (String)"InitServiceHelper_1", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)orgInit.getDynamicObject("exratetable"))) {
            if (errMsg.length() > 0) {
                errMsg.append("\u3001");
            }
            errMsg.append(ResManager.loadKDString((String)"\u6c47\u7387\u8868", (String)"InitServiceHelper_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)orgInit.getDynamicObject("periodtype"))) {
            if (errMsg.length() > 0) {
                errMsg.append("\u3001");
            }
            errMsg.append(ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b", (String)"InitServiceHelper_3", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        if (errMsg.length() > 0) {
            String appName = isAr ? ResManager.loadKDString((String)"\u5e94\u6536", (String)"InitServiceHelper_4", (String)"bos-ext-fi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u4ed8", (String)"InitServiceHelper_5", (String)"bos-ext-fi", (Object[])new Object[0]);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\u521d\u59cb\u5316\u8bbe\u7f6e\u5b57\u6bb5%2$s\u9519\u8bef\uff0c\u8bf7\u5230%3$s\u5e94\u7528\u4e0b\u68c0\u67e5\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"InitServiceHelper_0", (String)"bos-ext-fi", (Object[])new Object[0]), orgInit.getString("org.name"), errMsg.toString(), appName));
        }
    }
}

