/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert.Plan;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ConditionInfo;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ConditionServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.DetailGroupData;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.DimensionValue;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ICoreBillLoader;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.IPlanSplitService;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanRowData;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanSplitSchemeServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanSplitServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PmPurOrderLoader;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.SmSalOrderLoader;
import kd.bos.ext.fi.plugin.ArApConvert.helper.SystemParameterHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public abstract class PlanSplitService
implements IPlanSplitService {
    private static final Log logger = LogFactory.getLog(PlanSplitService.class);
    private static final String DIMENSIONKEY_PREIX = "dimensionkeyPreix";
    protected DynamicObject finBill;
    protected List<String> dimensions;
    protected String entityName;
    protected String detailEntryName;
    protected String detailPriceTaxTotalName;
    protected String detailPriceTaxTotalLocalName;
    protected String priceTaxTotalName;
    protected String priceTaxTotalLocalName;
    protected String paycondName;
    protected String detailCoreBillTypeName;
    protected String detailCoreBillTypeValue;
    protected String detailCoreBillNo;
    protected String detailCoreBillId;
    protected List<DynamicObject> needGroupDetailEntries;

    public PlanSplitService(DynamicObject finBill, DynamicObject scheme) {
        this.finBill = finBill;
        this.entityName = finBill.getDataEntityType().getName();
        this.dimensions = scheme != null ? PlanSplitSchemeServiceHelper.getDimensionsByScheme(scheme) : new ArrayList<String>(8);
    }

    public PlanSplitService(DynamicObject finBill, List<DynamicObject> detailEntries, DynamicObject scheme) {
        this.finBill = finBill;
        this.entityName = finBill.getDataEntityType().getName();
        this.dimensions = scheme != null ? PlanSplitSchemeServiceHelper.getDimensionsByScheme(scheme) : new ArrayList<String>(8);
        this.needGroupDetailEntries = detailEntries;
    }

    public PlanSplitService(DynamicObject finBill, List<String> dimensions) {
        this.finBill = finBill;
        this.entityName = finBill.getDataEntityType().getName();
        this.dimensions = dimensions;
    }

    @Override
    public List<PlanRowData> execute() {
        boolean isPlanSettle = SystemParameterHelper.isPlanSettle(this.finBill.getLong("org.id"), "ar_finarbill".equals(this.entityName));
        boolean allowMaterialSplitPlanEntry = PlanSplitServiceHelper.allowMaterialSplitPlanEntry();
        if (!isPlanSettle) {
            if (allowMaterialSplitPlanEntry && PlanSplitServiceHelper.isSplitByCoreBill()) {
                this.dimensions.add(this.detailCoreBillNo);
                this.dimensions.add(this.detailCoreBillId);
            }
        } else if (PlanSplitServiceHelper.isSplitByCoreBill()) {
            this.dimensions.add(this.detailCoreBillNo);
            this.dimensions.add(this.detailCoreBillId);
        }
        Map<String, DetailGroupData> detailGroupDataMap = this.groupDetailEntryByDimension();
        return this.splitGroupDataByCondition(detailGroupDataMap);
    }

    private Map<String, DetailGroupData> groupDetailEntryByDimension() {
        logger.info("PlanSplitService.groupDetailEntryByDimension start ");
        LinkedHashMap<String, DetailGroupData> detailGroupDataMap = new LinkedHashMap<String, DetailGroupData>(8);
        DynamicObjectCollection detailEntries = this.needGroupDetailEntries == null ? this.finBill.getDynamicObjectCollection(this.detailEntryName) : this.needGroupDetailEntries;
        ArrayList<DimensionValue> dimensionValues = new ArrayList<DimensionValue>(this.dimensions.size());
        int splitDimensionIndex = 0;
        int detailEntryCount = 0;
        for (DynamicObject detailEntry : detailEntries) {
            for (String string : this.dimensions) {
                Object value = detailEntry.get(string);
                dimensionValues.add(new DimensionValue(string, value));
            }
            StringBuilder keySb = new StringBuilder(DIMENSIONKEY_PREIX);
            for (DimensionValue dimensionValue : dimensionValues) {
                Object value = dimensionValue.getDimensionValue();
                if (value instanceof DynamicObject) {
                    keySb.append(((DynamicObject)value).getLong("id"));
                    continue;
                }
                if (value instanceof String) {
                    keySb.append(value);
                    continue;
                }
                keySb.append(value);
            }
            String string = keySb.toString();
            DetailGroupData detailGroupData = (DetailGroupData)detailGroupDataMap.get(string);
            if (detailGroupData == null) {
                DetailGroupData groupData = new DetailGroupData();
                groupData.setSplitDimensionId(splitDimensionIndex);
                ArrayList<Integer> detailEntryIndexs = new ArrayList<Integer>(1);
                detailEntryIndexs.add(detailEntryCount);
                groupData.setDetailEntryIndexs(detailEntryIndexs);
                groupData.setDimensionMap(dimensionValues);
                groupData.setPriceTaxTotal(detailEntry.getBigDecimal(this.detailPriceTaxTotalName));
                groupData.setPriceTaxTotalLocal(detailEntry.getBigDecimal(this.detailPriceTaxTotalLocalName));
                detailGroupDataMap.put(string, groupData);
                ++splitDimensionIndex;
            } else {
                detailGroupData.getDetailEntryIndexs().add(detailEntryCount);
                detailGroupData.setPriceTaxTotal(detailGroupData.getPriceTaxTotal().add(detailEntry.getBigDecimal(this.detailPriceTaxTotalName)));
                detailGroupData.setPriceTaxTotalLocal(detailGroupData.getPriceTaxTotalLocal().add(detailEntry.getBigDecimal(this.detailPriceTaxTotalLocalName)));
            }
            dimensionValues.clear();
            ++detailEntryCount;
        }
        logger.info("PlanSplitService.groupDetailEntryByDimension end");
        return detailGroupDataMap;
    }

    private List<PlanRowData> splitGroupDataByCondition(Map<String, DetailGroupData> detailGroupDataMap) {
        logger.info("PlanSplitService.splitGroupDataByCondition start ");
        DynamicObject condition = this.finBill.getDynamicObject(this.paycondName);
        ArrayList<PlanRowData> result = new ArrayList<PlanRowData>(detailGroupDataMap.size());
        if (condition == null) {
            Date basicDate = this.getBasicDate();
            logger.info("PlanSplitService.splitGroupDataByCondition condition is null ");
            if (PlanSplitServiceHelper.isLoadOrderPlanInfo()) {
                logger.info("PlanSplitService.splitGroupDataByCondition isLoadOrderPlanInfo is true ");
                Map<Long, List<ConditionInfo>> coreBillToConditionInfos = this.loadCoreBillConditionInfos();
                if (coreBillToConditionInfos == null || coreBillToConditionInfos.size() == 0) {
                    logger.info("PlanSplitService.splitGroupDataByCondition coreBillToConditionInfos is null or size=0 ");
                    for (Map.Entry<String, DetailGroupData> detailGroupDataEntry : detailGroupDataMap.entrySet()) {
                        PlanRowData planRowData = new PlanRowData(detailGroupDataEntry.getValue(), basicDate);
                        result.add(planRowData);
                    }
                } else {
                    logger.info("PlanSplitService.splitGroupDataByCondition by coreBillToConditionInfos execute split");
                    int precision = this.getPrecision(this.finBill);
                    int basePrecision = this.getBasePrecision(this.finBill);
                    String quotation = this.getQuotation();
                    BigDecimal exchange = this.getExchange();
                    if (exchange != null && exchange.compareTo(BigDecimal.ZERO) == 0) {
                        exchange = new BigDecimal(1);
                    }
                    BigDecimal hundred = new BigDecimal(100);
                    for (Map.Entry<String, DetailGroupData> detailGroupDataEntry : detailGroupDataMap.entrySet()) {
                        DetailGroupData detailGroupData = detailGroupDataEntry.getValue();
                        Object coreBillId = detailGroupData.getDimensionMap().get(this.detailCoreBillId);
                        if (coreBillId != null && (Long)coreBillId != 0L) {
                            List<ConditionInfo> conditionInfos = coreBillToConditionInfos.get(coreBillId);
                            if (conditionInfos == null) {
                                PlanRowData planRowData = new PlanRowData(detailGroupDataEntry.getValue(), basicDate);
                                result.add(planRowData);
                                continue;
                            }
                            BigDecimal priceTaxTotal = detailGroupData.getPriceTaxTotal();
                            BigDecimal priceTaxTotalLocal = detailGroupData.getPriceTaxTotalLocal();
                            int count = 0;
                            BigDecimal remainAmount = BigDecimal.ZERO;
                            BigDecimal remainAmountLocal = BigDecimal.ZERO;
                            for (ConditionInfo conditionInfo : conditionInfos) {
                                ++count;
                                BigDecimal rate = conditionInfo.getRate();
                                DetailGroupData groupData = new DetailGroupData();
                                groupData.setDimensionMap(detailGroupData.getDimensionMap());
                                groupData.setDetailEntryIndexs(detailGroupData.getDetailEntryIndexs());
                                groupData.setSplitDimensionId(detailGroupData.getSplitDimensionId());
                                if (count == conditionInfos.size()) {
                                    groupData.setPriceTaxTotal(priceTaxTotal.subtract(remainAmount));
                                    groupData.setPriceTaxTotalLocal(priceTaxTotalLocal.subtract(remainAmountLocal));
                                } else {
                                    BigDecimal dimensionPriceTaxTotal = priceTaxTotal.multiply(rate).divide(hundred, precision, RoundingMode.HALF_UP);
                                    BigDecimal dimensionPriceTaxTotalLocal = this.getLocalAmt(dimensionPriceTaxTotal, quotation, exchange, basePrecision);
                                    remainAmount = remainAmount.add(dimensionPriceTaxTotal);
                                    remainAmountLocal = remainAmountLocal.add(dimensionPriceTaxTotalLocal);
                                    groupData.setPriceTaxTotal(dimensionPriceTaxTotal);
                                    groupData.setPriceTaxTotalLocal(dimensionPriceTaxTotalLocal);
                                }
                                Date dueDate = conditionInfo.getDueDate();
                                if (dueDate == null) {
                                    dueDate = basicDate;
                                }
                                PlanRowData planRowData = new PlanRowData(groupData, rate, dueDate);
                                result.add(planRowData);
                            }
                            continue;
                        }
                        PlanRowData planRowData = new PlanRowData(detailGroupDataEntry.getValue(), basicDate);
                        result.add(planRowData);
                    }
                }
            } else {
                logger.info("PlanSplitService.splitGroupDataByCondition isLoadOrderPlanInfo is false ");
                for (Map.Entry<String, DetailGroupData> detailGroupDataEntry : detailGroupDataMap.entrySet()) {
                    PlanRowData planRowData = new PlanRowData(detailGroupDataEntry.getValue(), basicDate);
                    result.add(planRowData);
                }
            }
        } else {
            logger.info("PlanSplitService.splitGroupDataByCondition condition is not null ");
            condition = BusinessDataServiceHelper.loadSingleFromCache((Object)condition.getLong("id"), (String)condition.getDynamicObjectType().getName());
            int precision = this.getPrecision(this.finBill);
            int basePrecision = this.getBasePrecision(this.finBill);
            String quotation = this.getQuotation();
            BigDecimal exchange = this.getExchange();
            if (exchange != null && exchange.compareTo(BigDecimal.ZERO) == 0) {
                exchange = new BigDecimal(1);
            }
            Date basicDate = this.getBasicDate();
            List<ConditionInfo> conditionInfos = ConditionServiceHelper.loadConditionInfo(condition, basicDate);
            BigDecimal hundred = new BigDecimal(100);
            for (Map.Entry<String, DetailGroupData> detailGroupDataEntry : detailGroupDataMap.entrySet()) {
                DetailGroupData detailGroupData = detailGroupDataEntry.getValue();
                BigDecimal priceTaxTotal = detailGroupData.getPriceTaxTotal();
                BigDecimal priceTaxTotalLocal = detailGroupData.getPriceTaxTotalLocal();
                int count = 0;
                BigDecimal remainAmount = BigDecimal.ZERO;
                BigDecimal remainAmountLocal = BigDecimal.ZERO;
                for (ConditionInfo conditionInfo : conditionInfos) {
                    ++count;
                    BigDecimal rate = conditionInfo.getRate();
                    DetailGroupData groupData = new DetailGroupData();
                    groupData.setDimensionMap(detailGroupData.getDimensionMap());
                    groupData.setDetailEntryIndexs(detailGroupData.getDetailEntryIndexs());
                    groupData.setSplitDimensionId(detailGroupData.getSplitDimensionId());
                    if (count == conditionInfos.size()) {
                        groupData.setPriceTaxTotal(priceTaxTotal.subtract(remainAmount));
                        groupData.setPriceTaxTotalLocal(priceTaxTotalLocal.subtract(remainAmountLocal));
                    } else {
                        BigDecimal dimensionPriceTaxTotal = priceTaxTotal.multiply(rate).divide(hundred, precision, RoundingMode.HALF_UP);
                        BigDecimal dimensionPriceTaxTotalLocal = this.getLocalAmt(dimensionPriceTaxTotal, quotation, exchange, basePrecision);
                        remainAmount = remainAmount.add(dimensionPriceTaxTotal);
                        remainAmountLocal = remainAmountLocal.add(dimensionPriceTaxTotalLocal);
                        groupData.setPriceTaxTotal(dimensionPriceTaxTotal);
                        groupData.setPriceTaxTotalLocal(dimensionPriceTaxTotalLocal);
                    }
                    Date dueDate = conditionInfo.getDueDate();
                    PlanRowData planRowData = new PlanRowData(groupData, rate, dueDate);
                    result.add(planRowData);
                }
            }
        }
        logger.info("PlanSplitService.splitGroupDataByCondition end");
        return result;
    }

    private Date getBasicDate() {
        Date basicDate = null;
        if ("ap_finapbill".equals(this.entityName)) {
            basicDate = this.finBill.getDate("termsdate");
        }
        if (basicDate == null) {
            basicDate = ConditionServiceHelper.getBasicDate(this.finBill);
        }
        if (basicDate == null) {
            logger.info("basicDate is null, set Current Date");
            basicDate = new Date();
        }
        return basicDate;
    }

    private Map<Long, List<ConditionInfo>> loadCoreBillConditionInfos() {
        logger.info("PlanSplitService.loadCoreBillConditionInfos start");
        DynamicObjectCollection detailEntries = this.needGroupDetailEntries == null ? this.finBill.getDynamicObjectCollection(this.detailEntryName) : this.needGroupDetailEntries;
        HashSet<Long> coreBillIds = new HashSet<Long>(8);
        for (DynamicObject detailEntry : detailEntries) {
            long coreBillId;
            String coreBillType = detailEntry.getString(this.detailCoreBillTypeName);
            if (!this.detailCoreBillTypeValue.equals(coreBillType) || (coreBillId = detailEntry.getLong(this.detailCoreBillId)) == 0L) continue;
            coreBillIds.add(coreBillId);
        }
        if (coreBillIds.size() == 0) {
            return null;
        }
        ICoreBillLoader coreBillLoader = "sm_salorder".equals(this.detailCoreBillTypeValue) ? new SmSalOrderLoader() : new PmPurOrderLoader();
        Map<Long, List<ConditionInfo>> result = coreBillLoader.load(coreBillIds);
        logger.info("PlanSplitService.loadCoreBillConditionInfos end");
        return result;
    }

    private int getPrecision(DynamicObject finBill) {
        int precision = 2;
        DynamicObject currency = finBill.getDynamicObject("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        return precision;
    }

    private int getBasePrecision(DynamicObject finBill) {
        int basePrecision = 2;
        DynamicObject basecurrency = finBill.getDynamicObject("basecurrency");
        if (!ObjectUtils.isEmpty((Object)basecurrency)) {
            basePrecision = basecurrency.getInt("amtprecision");
        }
        return basePrecision;
    }

    private String getQuotation() {
        return this.finBill.getString("quotation");
    }

    private BigDecimal getExchange() {
        return this.finBill.getBigDecimal("exchangerate");
    }

    private BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchange, int precision) {
        if ("1".equals(quotation)) {
            return amount.divide(exchange, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchange).setScale(precision, RoundingMode.HALF_UP);
    }
}

