/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert.Plan;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ConditionInfo;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ICoreBillLoader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SmSalOrderLoader
implements ICoreBillLoader {
    @Override
    public Map<Long, List<ConditionInfo>> load(Set<Long> coreBillIds) {
        DynamicObject[] orderBills = BusinessDataServiceHelper.load((String)"sm_salorder", (String)"r_duedate,r_recadvancerate", (QFilter[])new QFilter[]{new QFilter("id", "in", coreBillIds)});
        BigDecimal hundred = new BigDecimal("100.00");
        HashMap<Long, List<ConditionInfo>> result = new HashMap<Long, List<ConditionInfo>>(orderBills.length);
        for (DynamicObject orderBill : orderBills) {
            DynamicObjectCollection planEntries = orderBill.getDynamicObjectCollection("recplanentry");
            BigDecimal remainRate = BigDecimal.ZERO;
            for (DynamicObject planEntry : planEntries) {
                remainRate = remainRate.add(planEntry.getBigDecimal("r_recadvancerate"));
            }
            if (remainRate.compareTo(hundred) != 0) continue;
            ArrayList<ConditionInfo> conditionInfos = new ArrayList<ConditionInfo>(planEntries.size());
            for (DynamicObject planEntry : planEntries) {
                BigDecimal rate = planEntry.getBigDecimal("r_recadvancerate");
                Date dueDate = planEntry.getDate("r_duedate");
                ConditionInfo info = new ConditionInfo(rate, dueDate);
                conditionInfos.add(info);
            }
            result.put(orderBill.getLong("id"), conditionInfos);
        }
        return result;
    }
}

