/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.plugin.ArApConvert.taxc.TaxAmountLineVo;
import kd.bos.ext.fi.plugin.ArApConvert.taxc.TaxAmountMaterialLineVo;
import kd.bos.ext.fi.plugin.ArApConvert.taxc.TaxLineVo;
import kd.bos.ext.fi.plugin.ArApConvert.taxc.TaxMaterialLineVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaxCodeConvertHelper {
    private static Log logger = LogFactory.getLog(TaxCodeConvertHelper.class);
    private static Map<String, String> billDetailEntryNameMap = new HashMap<String, String>(16);

    private static String getBillDetailEntryName(String entityName) {
        if (billDetailEntryNameMap.size() == 0) {
            billDetailEntryNameMap.put("ap_finapbill", "detailentry");
            billDetailEntryNameMap.put("hihn_ap_finapbill_virtual", "detailentry");
            billDetailEntryNameMap.put("ar_finarbill", "entry");
        }
        return billDetailEntryNameMap.getOrDefault(entityName, "entry");
    }

    private static List<TaxMaterialLineVo> listTaxCode(DynamicObject entity) {
        if (entity.getLong("id") == 0L) {
            entity.set("id", (Object)DBServiceHelper.genGlobalLongId());
        }
        try {
            List result = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ITaxCodeService", (String)"listTaxCode", (Object[])new Object[]{entity});
            if (CollectionUtils.isEmpty((Collection)result)) {
                return Collections.emptyList();
            }
            return JSON.parseArray((String)JSON.toJSONString((Object)result), TaxMaterialLineVo.class);
        }
        catch (Exception e) {
            logger.error("list tax code error : " + e);
            return Collections.emptyList();
        }
    }

    private static List<TaxAmountMaterialLineVo> listAllTaxLine(DynamicObject entity) {
        try {
            List result = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ITaxCodeService", (String)"listAllTaxLine", (Object[])new Object[]{entity});
            if (CollectionUtils.isEmpty((Collection)result)) {
                return Collections.emptyList();
            }
            return JSON.parseArray((String)JSON.toJSONString((Object)result), TaxAmountMaterialLineVo.class);
        }
        catch (Exception e) {
            logger.error("list all tax line error : " + e);
            return Collections.emptyList();
        }
    }

    public static boolean isNeedTax(long orgId, boolean isAr) {
        try {
            return (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ITaxCodeService", (String)"isNeedTax", (Object[])new Object[]{orgId, isAr});
        }
        catch (Exception e) {
            logger.error("need tax error : " + e);
            return false;
        }
    }

    private static Map<Long, DynamicObject> getTaxCodeIdMap(List<TaxMaterialLineVo> materialLineList) {
        ArrayList taxCodeIds = new ArrayList(100);
        for (TaxMaterialLineVo materialLine : materialLineList) {
            if (materialLine == null) continue;
            materialLine.getTaxLineVos().forEach(taxLine -> taxCodeIds.add(taxLine.getTaxCode()));
        }
        List ids = taxCodeIds.stream().distinct().collect(Collectors.toList());
        DynamicObject[] results = BusinessDataServiceHelper.load((String)"bastax_taxcode", (String)"id,number", (QFilter[])new QFilter("id", "in", ids).toArray());
        return Arrays.stream(results).collect(Collectors.toMap(result -> result.getLong("id"), Function.identity()));
    }

    public static Map<Long, DynamicObject> getTaxCategoryIdMap(List<TaxMaterialLineVo> materialLineList) {
        ArrayList taxCodeIds = new ArrayList(100);
        for (TaxMaterialLineVo materialLine : materialLineList) {
            if (materialLine == null) continue;
            materialLine.getTaxLineVos().forEach(taxLine -> taxCodeIds.add(taxLine.getTaxType()));
        }
        List ids = taxCodeIds.stream().distinct().collect(Collectors.toList());
        DynamicObject[] results = BusinessDataServiceHelper.load((String)"bd_taxcategory", (String)"id,number,simplecode", (QFilter[])new QFilter("id", "in", ids).toArray());
        return Arrays.stream(results).collect(Collectors.toMap(result -> result.getLong("id"), Function.identity()));
    }

    private static Map<Long, DynamicObject> getTaxRateIdMap(List<TaxMaterialLineVo> materialLineList) {
        ArrayList taxCodeIds = new ArrayList(100);
        for (TaxMaterialLineVo materialLine : materialLineList) {
            if (materialLine == null) continue;
            materialLine.getTaxLineVos().forEach(taxLine -> taxCodeIds.add(taxLine.getTaxRate()));
        }
        List ids = taxCodeIds.stream().distinct().collect(Collectors.toList());
        DynamicObject[] results = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"id,number,taxrate", (QFilter[])new QFilter("id", "in", ids).toArray());
        return Arrays.stream(results).collect(Collectors.toMap(result -> result.getLong("id"), Function.identity()));
    }

    public static void setDetailEntryTaxCode(DynamicObject entity) {
        String entryName = TaxCodeConvertHelper.getBillDetailEntryName(entity.getDataEntityType().getName());
        DynamicObjectCollection detailEntryCollection = entity.getDynamicObjectCollection(entryName);
        String entityName = entity.getDataEntityType().getName();
        List<TaxMaterialLineVo> materialLineList = TaxCodeConvertHelper.listTaxCode(entity);
        logger.info("TaxCodeConvertPlugin \u7a0e\u7801\u67e5\u8be2\u4fe1\u606f:" + materialLineList);
        if (CollectionUtils.isEmpty(materialLineList)) {
            return;
        }
        Map<Long, DynamicObject> taxCodeIdMap = TaxCodeConvertHelper.getTaxCodeIdMap(materialLineList);
        Map<Long, DynamicObject> taxCategoryIdMap = TaxCodeConvertHelper.getTaxCategoryIdMap(materialLineList);
        Map<Long, DynamicObject> taxRateIdMap = TaxCodeConvertHelper.getTaxRateIdMap(materialLineList);
        logger.info("TaxCodeConvertPlugin taxCodeIdMap:" + taxCodeIdMap);
        logger.info("TaxCodeConvertPlugin taxCategoryIdMap:" + taxCategoryIdMap);
        logger.info("TaxCodeConvertPlugin taxRateIdMap:" + taxRateIdMap);
        for (int i = 0; i < materialLineList.size(); ++i) {
            DynamicObject detailEntryRow = (DynamicObject)detailEntryCollection.get(i);
            TaxCodeConvertHelper.setDetailEntryRowTax(entityName, detailEntryRow, materialLineList.get(i).getTaxLineVos(), taxCodeIdMap, taxRateIdMap);
            TaxCodeConvertHelper.setTaxDetailEntryTax(detailEntryRow, materialLineList.get(i).getTaxLineVos(), taxCodeIdMap, taxCategoryIdMap, taxRateIdMap);
        }
    }

    public static void setDetailEntryTax(DynamicObject entity) {
        String entityName = entity.getDataEntityType().getName();
        String entryName = TaxCodeConvertHelper.getBillDetailEntryName(entityName);
        DynamicObjectCollection detailEntryCollection = entity.getDynamicObjectCollection(entryName);
        List<TaxAmountMaterialLineVo> taxLineList = TaxCodeConvertHelper.listAllTaxLine(entity);
        logger.info("TaxCodeConvertPlugin \u7a0e\u989d\u67e5\u8be2\u4fe1\u606f:" + taxLineList);
        if (CollectionUtils.isEmpty(taxLineList)) {
            return;
        }
        for (int i = 0; i < taxLineList.size(); ++i) {
            DynamicObject detailEntryRow = (DynamicObject)detailEntryCollection.get(i);
            TaxCodeConvertHelper.setTaxDetailEntryTaxAmt(detailEntryRow, taxLineList.get(i).getTaxAmountLineVo());
            logger.info("entry line : " + i + " set adjustAmt");
            if (!"ar_finarbill".equals(entityName) && !"ap_finapbill".equals(entityName)) continue;
            TaxCodeConvertHelper.setDetailEntryRowAdjustAmt(entity, detailEntryRow);
        }
    }

    private static void setDetailEntryRowAdjustAmt(DynamicObject entity, DynamicObject detailEntryRow) {
        List taxDetailEntryCollection = detailEntryRow.getDynamicObjectCollection("subentryentity").stream().filter(entryRow -> entryRow.getBoolean("s_isoffset")).collect(Collectors.toList());
        BigDecimal offSetAmt = taxDetailEntryCollection.stream().map(entryRow -> entryRow.getBigDecimal("s_tax")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exchangeRate = entity.getBigDecimal("exchangerate");
        logger.info("e_adjustamount : " + offSetAmt.negate());
        int basePrecision = entity.getInt("basecurrency.amtprecision");
        detailEntryRow.set("e_adjustamount", (Object)offSetAmt.negate().setScale(basePrecision, RoundingMode.HALF_UP));
        detailEntryRow.set("e_adjustlocalamt", (Object)offSetAmt.negate().multiply(exchangeRate).setScale(basePrecision, RoundingMode.HALF_UP));
    }

    private static void setTaxDetailEntryTaxAmt(DynamicObject detailEntryRow, List<TaxAmountLineVo> taxAmountLineVo) {
        DynamicObjectCollection taxDetailEntryCollection = detailEntryRow.getDynamicObjectCollection("subentryentity");
        for (int i = 0; i < taxAmountLineVo.size(); ++i) {
            DynamicObject taxDetailEntryRow = (DynamicObject)taxDetailEntryCollection.get(i);
            if (taxAmountLineVo.get(i) == null) continue;
            taxDetailEntryRow.set("s_tax", (Object)taxAmountLineVo.get(i).getTaxAmount());
        }
    }

    private static void setTaxDetailEntryTax(DynamicObject detailEntryRow, List<TaxLineVo> taxLineList, Map<Long, DynamicObject> taxCodeIdMap, Map<Long, DynamicObject> taxCategoryIdMap, Map<Long, DynamicObject> taxRateIdMap) {
        DynamicObjectCollection taxDetailEntryCollection = detailEntryRow.getDynamicObjectCollection("subentryentity");
        taxDetailEntryCollection.clear();
        for (TaxLineVo taxLine : taxLineList) {
            if (taxLine == null) continue;
            DynamicObject taxDetailEntryRow = taxDetailEntryCollection.addNew();
            taxDetailEntryRow.set("s_taxcode", (Object)taxCodeIdMap.get(taxLine.getTaxCode()));
            taxDetailEntryRow.set("s_taxcategory", (Object)taxCategoryIdMap.get(taxLine.getTaxType()));
            taxDetailEntryRow.set("s_taxrateid", (Object)taxRateIdMap.get(taxLine.getTaxRate()));
            taxDetailEntryRow.set("s_taxrate", (Object)taxLine.getTaxRatePercent());
            taxDetailEntryRow.set("s_isoffset", (Object)Boolean.valueOf(taxLine.getOffsetLogo()));
            taxDetailEntryRow.set("s_priority", (Object)taxLine.getOrder());
        }
    }

    private static void setDetailEntryRowTax(String entityName, DynamicObject detailEntryRow, List<TaxLineVo> taxLineList, Map<Long, DynamicObject> taxCodeIdMap, Map<Long, DynamicObject> taxRateIdMap) {
        if (CollectionUtils.isEmpty(taxLineList)) {
            return;
        }
        Optional<TaxLineVo> taxLine = taxLineList.stream().filter(line -> line.getDefaultTaxCode().compareTo(1) == 0).findAny();
        if (!taxLine.isPresent()) {
            return;
        }
        if (taxCodeIdMap.containsKey(taxLine.get().getTaxCode())) {
            detailEntryRow.set("e_taxcode", (Object)taxCodeIdMap.get(taxLine.get().getTaxCode()));
        }
        if (taxRateIdMap.containsKey(taxLine.get().getTaxRate())) {
            detailEntryRow.set("taxrateid", (Object)taxRateIdMap.get(taxLine.get().getTaxRate()));
        }
        String taxRateName = "ap_finapbill".equals(entityName) ? "taxrate" : "e_taxrate";
        detailEntryRow.set(taxRateName, (Object)taxLine.get().getTaxRatePercent());
        logger.info("TaxCodeConvertPlugin detailEntryRowTax:" + taxLine.get());
    }
}

