/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.util.price;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.ext.fi.util.price.AbstractPriceCalculator;
import kd.bos.ext.fi.util.price.IPriceCalculate;

public class PriceLocalCalculator
implements IPriceCalculate {
    protected AbstractPriceCalculator calculator = null;
    private BigDecimal discountamountlocal = BigDecimal.ZERO;
    private BigDecimal amountlocal = BigDecimal.ZERO;
    private BigDecimal taxlocal = BigDecimal.ZERO;
    private BigDecimal pricetaxtotallocal = BigDecimal.ZERO;
    private BigDecimal adjustamtlocal = BigDecimal.ZERO;
    private BigDecimal exchangerate = BigDecimal.ZERO;
    private int localCurrencyPrecison = 0;
    private String quotation;

    @Deprecated
    public PriceLocalCalculator(IPriceCalculate calculator, BigDecimal exchangerate, int localCurrencyPrecison) {
        this(calculator, exchangerate, localCurrencyPrecison, "0");
    }

    public PriceLocalCalculator(IPriceCalculate calculator, BigDecimal exchangerate, int localCurrencyPrecison, String quotation) {
        this.calculator = (AbstractPriceCalculator)calculator;
        this.exchangerate = exchangerate;
        this.localCurrencyPrecison = localCurrencyPrecison;
        this.quotation = quotation;
    }

    @Override
    public void calculate() {
        this.calculator.calculate();
        if (this.calculator.isTax()) {
            if ("0".equals(this.quotation)) {
                this.pricetaxtotallocal = this.calculator.getPricetaxtotal().multiply(this.exchangerate).setScale(this.localCurrencyPrecison, RoundingMode.HALF_UP);
                this.taxlocal = this.calculator.getTax().multiply(this.exchangerate).setScale(this.localCurrencyPrecison, RoundingMode.HALF_UP);
                this.adjustamtlocal = this.calculator.getAdjustamt().multiply(this.exchangerate).setScale(this.localCurrencyPrecison, RoundingMode.HALF_UP);
                this.amountlocal = this.pricetaxtotallocal.subtract(this.taxlocal).subtract(this.adjustamtlocal).setScale(this.localCurrencyPrecison, RoundingMode.HALF_UP);
                this.discountamountlocal = this.calculator.getDiscountamount().multiply(this.exchangerate).setScale(this.localCurrencyPrecison, RoundingMode.HALF_UP);
            } else if ("1".equals(this.quotation)) {
                this.pricetaxtotallocal = this.calculator.getPricetaxtotal().divide(this.exchangerate, this.localCurrencyPrecison, RoundingMode.HALF_UP);
                this.taxlocal = this.calculator.getTax().divide(this.exchangerate, this.localCurrencyPrecison, RoundingMode.HALF_UP);
                this.adjustamtlocal = this.calculator.getAdjustamt().divide(this.exchangerate, this.localCurrencyPrecison, RoundingMode.HALF_UP);
                this.amountlocal = this.pricetaxtotallocal.subtract(this.taxlocal).subtract(this.adjustamtlocal).setScale(this.localCurrencyPrecison, RoundingMode.HALF_UP);
                this.discountamountlocal = this.calculator.getDiscountamount().divide(this.exchangerate, this.localCurrencyPrecison, RoundingMode.HALF_UP);
            }
        } else if ("0".equals(this.quotation)) {
            this.taxlocal = this.calculator.getTax().multiply(this.exchangerate).setScale(this.localCurrencyPrecison, RoundingMode.HALF_UP);
            this.amountlocal = this.calculator.getAmount().multiply(this.exchangerate).setScale(this.localCurrencyPrecison, RoundingMode.HALF_UP);
            this.adjustamtlocal = this.calculator.getAdjustamt().multiply(this.exchangerate).setScale(this.localCurrencyPrecison, RoundingMode.HALF_UP);
            this.pricetaxtotallocal = this.amountlocal.add(this.taxlocal).add(this.adjustamtlocal).setScale(this.localCurrencyPrecison, RoundingMode.HALF_UP);
            this.discountamountlocal = this.calculator.getDiscountamount().multiply(this.exchangerate).setScale(this.localCurrencyPrecison, RoundingMode.HALF_UP);
        } else if ("1".equals(this.quotation)) {
            this.taxlocal = this.calculator.getTax().divide(this.exchangerate, this.localCurrencyPrecison, RoundingMode.HALF_UP);
            this.amountlocal = this.calculator.getAmount().divide(this.exchangerate, this.localCurrencyPrecison, RoundingMode.HALF_UP);
            this.adjustamtlocal = this.calculator.getAdjustamt().divide(this.exchangerate, this.localCurrencyPrecison, RoundingMode.HALF_UP);
            this.pricetaxtotallocal = this.amountlocal.add(this.taxlocal).add(this.adjustamtlocal).setScale(this.localCurrencyPrecison, RoundingMode.HALF_UP);
            this.discountamountlocal = this.calculator.getDiscountamount().divide(this.exchangerate, this.localCurrencyPrecison, RoundingMode.HALF_UP);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.calculator.toString());
        str.append("amountlocal = ").append(this.amountlocal).append(", ");
        str.append("taxlocal = ").append(this.taxlocal).append(", ");
        str.append("pricetaxtotallocal = ").append(this.pricetaxtotallocal).append(", ");
        str.append("discountamountlocal = ").append(this.discountamountlocal).append(", ");
        return str.toString();
    }

    public boolean isTax() {
        return this.calculator.isTax;
    }

    public BigDecimal getQuantity() {
        return this.calculator.quantity;
    }

    public BigDecimal getUnitprice() {
        return this.calculator.unitprice;
    }

    public BigDecimal getTaxunitprice() {
        return this.calculator.taxunitprice;
    }

    public BigDecimal getTaxrate() {
        return this.calculator.taxrate;
    }

    public String getDiscountmode() {
        return this.calculator.discountmode;
    }

    public BigDecimal getDiscountrate() {
        return this.calculator.discountrate;
    }

    public BigDecimal getActunitprice() {
        return this.calculator.actunitprice;
    }

    public BigDecimal getActtaxunitprice() {
        return this.calculator.acttaxunitprice;
    }

    public BigDecimal getDiscountamount() {
        return this.calculator.discountamount;
    }

    public BigDecimal getTax() {
        return this.calculator.tax;
    }

    public BigDecimal getAmount() {
        return this.calculator.amount;
    }

    public BigDecimal getPricetaxtotal() {
        return this.calculator.pricetaxtotal;
    }

    public int getCurrencyPrecision() {
        return this.calculator.currencyPrecision;
    }

    public BigDecimal getDiscountamountlocal() {
        return this.discountamountlocal;
    }

    public BigDecimal getAmountlocal() {
        return this.amountlocal;
    }

    public void setAmountlocal(BigDecimal amountlocal) {
        this.amountlocal = amountlocal;
    }

    public void setPricetaxtotallocal(BigDecimal pricetaxtotallocal) {
        this.pricetaxtotallocal = pricetaxtotallocal;
    }

    public BigDecimal getTaxlocal() {
        return this.taxlocal;
    }

    public BigDecimal getPricetaxtotallocal() {
        return this.pricetaxtotallocal;
    }

    public int getLocalCurrencyPrecison() {
        return this.localCurrencyPrecison;
    }

    public BigDecimal getAdjustamt() {
        return this.calculator.adjustamt;
    }

    public BigDecimal getAdjustamtlocal() {
        return this.adjustamtlocal;
    }
}

