/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.dap;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AccDateValidateUtil {
    public static final Map<String, String> accDateMap = new HashMap<String, String>(10);
    private static final String SELECTFIELDS = "id,b_entry.b_relatebook.fbasedataid.org org,b_entry.b_relatebook.fbasedataid.curperiod.begindate begindate,b_entry.b_relatebook.fbasedataid.accdatevalidate accdatevalidate,b_entry.b_relatebook.fbasedataid.depreuse.name name";

    public static void validateAccDateDelete(String billEntityNumber, Map<Long, Long> billToVch, Map<Long, String> resultMap) {
        HashSet<Long> voucherIds = new HashSet<Long>(billToVch.values());
        Set<Long> billIds = billToVch.keySet();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", voucherIds)};
        Map<Long, DynamicObject> vouchersMap = QueryServiceHelper.query((String)"gl_voucher", (String)"id,book,org,sourcebill", (QFilter[])qFilters).stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        String accDateName = accDateMap.get(billEntityNumber);
        String msg = ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f%s\u5df2\u7ed3\u8d26\uff0c\u7981\u6b62\u5220\u9664\u51ed\u8bc1\u3002", (String)"AccDateValidateUtil_1", (String)"bos-ext-fi", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)accDateName)) {
            return;
        }
        qFilters[0] = new QFilter("id", "in", billIds);
        Map<Long, DynamicObject> billMap = QueryServiceHelper.query((String)billEntityNumber, (String)("id,org," + accDateName), (QFilter[])qFilters).stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        Object[] acctBookIds = vouchersMap.values().stream().map(v -> v.getLong("book")).toArray();
        qFilters = new QFilter[]{new QFilter("id", "in", (Object)acctBookIds), new QFilter("b_entry.b_app.number", "=", (Object)"fa")};
        DynamicObjectCollection accountBooks = QueryServiceHelper.query((String)"gl_accountbook", (String)SELECTFIELDS, (QFilter[])qFilters);
        HashMap<Long, List> accBookMap = new HashMap<Long, List>(accountBooks.size());
        for (DynamicObject accountBook : accountBooks) {
            accBookMap.computeIfAbsent(accountBook.getLong("id"), v -> new ArrayList()).add(accountBook);
        }
        for (Map.Entry<Long, Long> entry : billToVch.entrySet()) {
            Date curBeingDate;
            Date accDate;
            DynamicObject bizBook;
            List curBizBooks;
            long bookId;
            List bizBooks;
            Long billId = entry.getKey();
            Long voucherId = entry.getValue();
            DynamicObject bill = billMap.get(billId);
            DynamicObject voucher = vouchersMap.get(voucherId);
            if (bill == null || voucher == null || (bizBooks = (List)accBookMap.get(bookId = voucher.getLong("book"))) == null || bizBooks.isEmpty() || (curBizBooks = bizBooks.stream().filter(v -> voucher.getLong("org") == v.getLong("org")).collect(Collectors.toList())).isEmpty() || (bizBook = (DynamicObject)curBizBooks.get(0)) == null || !Boolean.TRUE.equals(bizBook.getBoolean("accdatevalidate")) || !(accDate = bill.getDate(accDateName)).before(curBeingDate = bizBook.getDate("begindate"))) continue;
            resultMap.put(voucherId, String.format(msg, bizBook.getString("name")));
        }
    }

    public static String validateAccDateCreate(String billEntityNumber, Long billId, Long acctBookId, Long orgId) {
        String accDateName = accDateMap.get(billEntityNumber);
        String result = ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f%s\u5df2\u7ed3\u8d26\uff0c\u7981\u6b62\u751f\u6210\u51ed\u8bc1\u3002", (String)"AccDateValidateUtil_0", (String)"bos-ext-fi", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)accDateName)) {
            Date curBeingDate;
            Date accDate;
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)billId)};
            DynamicObject bill = QueryServiceHelper.queryOne((String)billEntityNumber, (String)("id,org," + accDateName), (QFilter[])qFilters);
            if (bill == null) {
                return null;
            }
            qFilters = new QFilter[]{new QFilter("id", "=", (Object)acctBookId), new QFilter("b_entry.b_app.number", "=", (Object)"fa"), new QFilter("b_entry.b_relatebook.fbasedataid.org", "=", (Object)orgId)};
            DynamicObject bizBook = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)SELECTFIELDS, (QFilter[])qFilters);
            if (bizBook != null && Boolean.TRUE.equals(bizBook.getBoolean("accdatevalidate")) && (accDate = bill.getDate(accDateName)).before(curBeingDate = bizBook.getDate("begindate"))) {
                return String.format(result, bizBook.getString("name"));
            }
        }
        return null;
    }

    static {
        accDateMap.put("fa_card_fin", "finaccountdate");
        accDateMap.put("fa_change_dept", "changedate");
        accDateMap.put("fa_clearbill", "cleardate");
        accDateMap.put("fa_assetsplitbill", "splitdate");
        accDateMap.put("fa_mergebill", "mergedate");
        accDateMap.put("fa_disposal", "bizdate");
        accDateMap.put("fa_asset_devalue", "businessdate");
        accDateMap.put("fa_lease_rent_settle", "settledate");
        accDateMap.put("fa_depre_sum", "bizdate");
        accDateMap.put("fa_restartrealbill", "restartdate");
    }
}

