/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.iep.enums.ExecuteType;
import kd.fi.iep.info.IntellExceOperInfo;
import kd.fi.iep.info.IntellSchemeExecInfo;

public class IntellAccountSchemaExecLogDao {
    private static final Log logger = LogFactory.getLog((String)"IntellAccountSchemaExecLogDao");
    private static final String updateSumLogSql = "update t_gl_intellschemasumlog set fexecenddate = ?,fquantity = fquantity + ?, fexecstatus = (case fexecstatus when  '3' then '3' else ? end),fexecutedetails = ?  where fid = ?;";
    private static final String update2SumLogSql = "update t_gl_intellschemasumlog set fexecenddate = ?,fquantity = fquantity + ?,ffailsumquantity = ffailsumquantity + ?,fexecutedetails = ?, fexecstatus = ? where fid = ?;";
    private static final String update4SumLogSql = "update t_gl_intellschemasumlog set ffailsumquantity = ffailsumquantity + ?  where fexecstartdate > ? and fexecstartdate < ? and fintelschemaId = ? and ? > 0 and fquantity = 0;";
    private static final String updateIntelSchemaSumLog2 = "update t_gl_intellschemasumlog set ffailsumquantity = 0 where fid = ?;";
    private static final String selectIntelSchemaSumLog2 = "select top 1 fid from t_gl_intellschemasumlog where fintelschemaid = ? and fid not in (?) order by fexecstartdate desc;";
    private static final String updateOperSumLogExecResultSql = "update t_gl_intellopersumlog set fexecenddate = ?,fexecstatus = (case fexecstatus when '3' then '3' else ? end) ,fexecdetail = ? where fid = ?;";
    private static final String update2OperSumLogExecResultSql = "update t_gl_intellopersumlog set fexecenddate = ?,fexecstatus = ? ,fexecdetail = ?, fsuccessbillqty = fsuccessbillqty + ?, ffailbillqty = ffailbillqty + ?, fbillqty = ? where fid = ?;";
    private static final String update2OperSumLogHistorySql = "update t_gl_intellopersumlog set fsuccessbillqty = fsuccessbillqty + ?, ffailbillqty = (case when ffailbillqty > ? then ffailbillqty - ? else 0 end) where fid = ?;";

    public static void updateExecSumLog(long id, String execstatus, Date execEnddate) {
        IntellAccountSchemaExecLogDao.updateExecSumLog(id, 0, execstatus, execEnddate);
    }

    public static void stopExecuteSchema(IntellSchemeExecInfo schemeExecInfo) {
        String sumStatus = "4";
        int successBillSumQty = schemeExecInfo.getRecordTSC();
        int failBillSumQty = schemeExecInfo.getRecordTFC();
        int billSumQty = schemeExecInfo.getRecordTC();
        int failSumPkIdSize = schemeExecInfo.getRecordTFSC();
        String executeDetails = null;
        IntellExceOperInfo exceOperInfo = schemeExecInfo.getExceOperInfo();
        if (ExecuteType.AUTO == exceOperInfo.getExecuteType()) {
            executeDetails = String.format(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5230\u8fbe\u8bbe\u7f6e\u7684\u3010\u4e2d\u6b62\u6267\u884c\u65f6\u95f4\u3011\uff0c\u5df2\u4e2d\u6b62\u6267\u884c\u3002\u672c\u6b21\u65b9\u6848\u6267\u884c\u5171\u83b7\u53d6\u3010%1$s\u3011\u6761\u6570\u636e\uff0c\u6210\u529f\u3010%2$s\u3011\u6761\uff0c\u9519\u8bef\u3010%3$s\u3011\u6761\u3002", (String)"IntellAccountSchemaExecLogDao_2", (String)"bos-ext-fi", (Object[])new Object[0]), billSumQty, successBillSumQty, failBillSumQty);
        }
        if (ExecuteType.MANUAL == exceOperInfo.getExecuteType()) {
            executeDetails = String.format(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u624b\u52a8\u4e2d\u6b62\u6267\u884c\u3002\u672c\u6b21\u65b9\u6848\u6267\u884c\u5171\u83b7\u53d6\u3010%1$s\u3011\u6761\u6570\u636e\uff0c\u6210\u529f\u3010%2$s\u3011\u6761\uff0c\u9519\u8bef\u3010%3$s\u3011\u6761\u3002", (String)"IntellAccountSchemaExecLogDao_3", (String)"bos-ext-fi", (Object[])new Object[0]), billSumQty, successBillSumQty, failBillSumQty);
        }
        IntellAccountSchemaExecLogDao.update2ExecuteSumLog(exceOperInfo.getSumLogId(), 0, sumStatus, new Date(), 0, executeDetails);
    }

    public static void update2SchemaSumLog(long sumLogId, int quantity, String execStatus, Date date, int failSumPkIdSize, int successBillSumQty, int failBillSumQty, ExecuteType execType) {
        String executeDetails = quantity == 0 ? ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u4e0d\u5b58\u5728\u53ef\u6267\u884c\u6570\u636e\u3002", (String)"IntellAccountSchemaExecLogDao_7", (String)"bos-ext-fi", (Object[])new Object[0]) : (execStatus.equals("4") ? (execType == ExecuteType.AUTO ? String.format(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5230\u8fbe\u8bbe\u7f6e\u7684\u3010\u4e2d\u6b62\u6267\u884c\u65f6\u95f4\u3011\uff0c\u5df2\u4e2d\u6b62\u6267\u884c\u3002\u672c\u6b21\u65b9\u6848\u6267\u884c\u5171\u83b7\u53d6\u3010%1$s\u3011\u6761\u6570\u636e\uff0c\u6210\u529f\u3010%2$s\u3011\u6761\uff0c\u9519\u8bef\u3010%3$s\u3011\u6761\u3002", (String)"IntellAccountSchemaExecLogDao_2", (String)"bos-ext-fi", (Object[])new Object[0]), quantity, successBillSumQty, failBillSumQty) : String.format(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u624b\u52a8\u4e2d\u6b62\u6267\u884c\u3002\u672c\u6b21\u65b9\u6848\u6267\u884c\u5171\u83b7\u53d6\u3010%s\u3011\u6761\u6570\u636e\uff0c\u6210\u529f\u3010%s\u3011\u6761\uff0c\u9519\u8bef\u3010%s\u3011\u6761\u3002", (String)"IntellAccountSchemaExecLogDao_3", (String)"bos-ext-fi", (Object[])new Object[0]), quantity, successBillSumQty, failBillSumQty)) : String.format(ResManager.loadKDString((String)"\u672c\u6b21\u65b9\u6848\u6267\u884c\u5171\u83b7\u53d6\u3010%s\u3011\u6761\u6570\u636e\uff0c\u6210\u529f\u3010%s\u3011\u6761\uff0c\u9519\u8bef\u3010%s\u3011\u6761\u3002", (String)"IntellAccountSchemaExecLogDao_4", (String)"bos-ext-fi", (Object[])new Object[0]), quantity, successBillSumQty, failBillSumQty));
        IntellAccountSchemaExecLogDao.update2ExecuteSumLog(sumLogId, quantity, execStatus, date, failSumPkIdSize, executeDetails);
    }

    public static void updateIntelSchemaSumLog(long intelschemaId, long id) {
        ArrayList<Long> paramsList = new ArrayList<Long>(2);
        paramsList.add(intelschemaId);
        paramsList.add(id);
        ArrayList latestfids = new ArrayList(1);
        DB.query((DBRoute)DBRoute.of((String)"gl"), (String)selectIntelSchemaSumLog2, (Object[])paramsList.toArray(), rs -> {
            while (rs.next()) {
                latestfids.add(rs.getLong("fid"));
            }
            return null;
        });
        if (latestfids.size() > 0) {
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)updateIntelSchemaSumLog2, (Object[])new Object[]{latestfids.get(0)});
        }
    }

    public static void updateExecSumLog(long id, Integer quantity, String execstatus, Date execEnddate) {
        IntellAccountSchemaExecLogDao.updateExecSumLog(id, quantity, execstatus, execEnddate, "");
    }

    public static void updateExecSumLog(long id, Integer quantity, String execstatus, Date execEnddate, String executedetails) {
        ArrayList<Object> paramsLst = new ArrayList<Object>(4);
        paramsLst.add(execEnddate);
        paramsLst.add(quantity);
        paramsLst.add(execstatus);
        paramsLst.add(executedetails);
        paramsLst.add(id);
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)updateSumLogSql, (Object[])paramsLst.toArray());
    }

    private static void updateExecSumLog(List<Object[]> params) {
        if (params.size() == 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)updateSumLogSql, params);
    }

    public static void update2ExecuteSumLog(long id, Integer quantity, String execstatus, Date execEnddate, Integer failSumPkIdSize, String executeDetails) {
        ArrayList<Object> paramsList = new ArrayList<Object>(6);
        paramsList.add(execEnddate);
        paramsList.add(quantity);
        paramsList.add(failSumPkIdSize);
        paramsList.add(executeDetails);
        paramsList.add(execstatus);
        paramsList.add(id);
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)update2SumLogSql, (Object[])paramsList.toArray());
    }

    public static void update4SchemaSumLog(long schemaId, Integer quantity, Date execStartdateFrom, Date execStartdateTo, Integer failSumPkIdSize) {
        IntellAccountSchemaExecLogDao.update4ExecuteSumLog(schemaId, quantity, execStartdateFrom, execStartdateTo, failSumPkIdSize);
    }

    public static void update4ExecuteSumLog(long schemaId, Integer quantity, Date execStartdateFrom, Date execStartdateTo, Integer failSumPkIdSize) {
        ArrayList<Comparable<Integer>> paramsList = new ArrayList<Comparable<Integer>>(6);
        paramsList.add(failSumPkIdSize);
        paramsList.add(execStartdateFrom);
        paramsList.add(execStartdateTo);
        paramsList.add(Long.valueOf(schemaId));
        paramsList.add(quantity);
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)update4SumLogSql, (Object[])paramsList.toArray());
    }

    public static void uptateSchemaSumLog(Map<String, Object> processMap) {
        int billqty = Integer.parseInt(processMap.get("billqty").toString());
        int successBillSumQty = Integer.parseInt(processMap.get("successbillqty").toString());
        int failBillSumQty = Integer.parseInt(processMap.get("failbillqty").toString());
        int count = successBillSumQty + failBillSumQty;
        Long id = (Long)processMap.get("schemasumlogid");
        String executeDetails = String.format(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u624b\u52a8\u4e2d\u6b62\u6267\u884c\u3002\u672c\u6b21\u65b9\u6848\u6267\u884c\u5171\u83b7\u53d6\u3010%1$s\u3011\u6761\u6570\u636e\uff0c\u6210\u529f\u3010%2$s\u3011\u6761\uff0c\u9519\u8bef\u3010%3$s\u3011\u6761\u3002", (String)"IntellAccountSchemaExecLogDao_5", (String)"bos-ext-fi", (Object[])new Object[0]), billqty, successBillSumQty, failBillSumQty);
        String execStatus = "4";
        IntellAccountSchemaExecLogDao.update2ExecuteSumLog(id, count, execStatus, new Date(), 0, executeDetails);
    }

    public static long insertExceSumLog(Long intelschemaId, Date execstartdate, String taskId, ExecuteType type) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"gl_intelschemasumlog");
        String tableName = obj.getDataEntityType().getAlias();
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
        long id = ids[0];
        obj.set("id", (Object)id);
        obj.set("intelschemaId", (Object)intelschemaId);
        obj.set("execstartdate", (Object)execstartdate);
        obj.set("execstatus", (Object)"1");
        obj.set("taskid", (Object)taskId);
        obj.set("type", (Object)type.getValue());
        obj.set("date", (Object)0);
        ArrayList<Long> paramList = new ArrayList<Long>(1);
        paramList.add(intelschemaId);
        ArrayList latestfids = new ArrayList(1);
        DB.query((DBRoute)DBRoute.of((String)"fi"), (String)"select top 1 ffailsumquantity from t_gl_intellschemasumlog where fintelschemaid = ? and fquantity > 0 order by fexecstartdate desc;", (Object[])paramList.toArray(), rs -> {
            while (rs.next()) {
                latestfids.add(new Object[]{rs.getInt("ffailsumquantity")});
            }
            return null;
        });
        obj.set("failsumquantity", (Object)(latestfids.size() == 0 ? Integer.valueOf(0) : latestfids.get(0)));
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)" update t_gl_intellschemasumlog set fexecenddate = ? where fid = ?", (Object[])new Object[]{null, id});
        return id;
    }

    public static long insertOperSumLog(Long intelschemaId, Long schemasumlogid, Date execstartdate, IntellExceOperInfo src, Integer billQty, String execdetail) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"gl_intellopersumlog");
        String tableName = obj.getDataEntityType().getAlias();
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
        long id = ids[0];
        obj.set("id", (Object)id);
        obj.set("intelschemaid", (Object)intelschemaId);
        obj.set("bizapp", (Object)src.getAppId());
        obj.set("bussiness", (Object)src.getBussiness());
        obj.set("oper", (Object)src.getOper());
        obj.set("schemasumlogid", (Object)schemasumlogid);
        if (execstartdate == null) {
            execstartdate = new Date();
        }
        obj.set("execstartdate", (Object)execstartdate);
        obj.set("execstatus", (Object)"1");
        obj.set("billqty", (Object)billQty);
        obj.set("execdetail", (Object)execdetail);
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return id;
    }

    public static void updateOperSumLog(long id, String execstatus, Date execEnddate, String errorMsg, int qty) {
        ArrayList<Object> paramsLst = new ArrayList<Object>(3);
        paramsLst.add(execEnddate);
        paramsLst.add(execstatus);
        paramsLst.add(errorMsg);
        paramsLst.add(id);
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)updateOperSumLogExecResultSql, (Object[])paramsLst.toArray());
    }

    private static void updateOperSumLog(List<Object[]> params) {
        if (params.size() == 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)updateOperSumLogExecResultSql, params);
    }

    public static void update2OperSumLog(long id, String execstatus, Date execEnddate, String errorMsg, int qty, int successBillQty, int failBillQty) {
        ArrayList<Object> paramsList = new ArrayList<Object>(3);
        paramsList.add(execEnddate);
        paramsList.add(execstatus);
        paramsList.add(errorMsg);
        paramsList.add(successBillQty);
        paramsList.add(failBillQty);
        paramsList.add(qty);
        paramsList.add(id);
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)update2OperSumLogExecResultSql, (Object[])paramsList.toArray());
    }

    public static void update2OperSumLogHistory(long id, int size) {
        ArrayList<Number> paramsList = new ArrayList<Number>(3);
        paramsList.add(size);
        paramsList.add(size);
        paramsList.add(size);
        paramsList.add(id);
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)update2OperSumLogHistorySql, (Object[])paramsList.toArray());
    }

    public static void update2OperSumLogHistory(List<Object[]> params) {
        if (params.size() == 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)update2OperSumLogHistorySql, params);
    }

    public static boolean containsProperty(MainEntityType type, String key) {
        return type.getAllFields().containsKey(key);
    }

    public static void batchInsertExceLog(IntellExceOperInfo exceOperInfo, Date execstartdate, Object[] sucessList, String status, String msg, String traceId) {
        if (sucessList == null || sucessList.length == 0 || IntellAccountSchemaExecLogDao.isDeleteOpe(exceOperInfo)) {
            logger.info("\u667a\u80fd\u6838\u7b97\u540e\u53f0\u4e8b\u52a1\u65e5\u5fd7\uff0c\u63d2\u5165\u65e5\u5fd7\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)exceOperInfo.getBussiness());
        String numberProp = null;
        int numberType = 0;
        if (IntellAccountSchemaExecLogDao.containsProperty(type, "billno") && !type.getName().equalsIgnoreCase("ai_buildreport")) {
            numberProp = "billno";
            numberType = 1;
        } else if (IntellAccountSchemaExecLogDao.containsProperty(type, "number")) {
            numberProp = "number";
            numberType = 2;
        }
        StringBuilder sel = new StringBuilder("id");
        if (Objects.nonNull(type.getMainOrg())) {
            sel.append(",").append(type.getMainOrg());
        }
        if (Objects.nonNull(numberProp)) {
            sel.append(",").append(numberProp);
        }
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DynamicObjectCollection coll = QueryServiceHelper.query((String)exceOperInfo.getBussiness(), (String)sel.toString(), (QFilter[])new QFilter("id", "in", (Object)sucessList).toArray());
            DynamicObject[] exeLogArray = new DynamicObject[coll.size()];
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"gl_intellexecdetaillog");
                IntellAccountSchemaExecLogDao.createExeLog(exceOperInfo, execstartdate, logObj, (DynamicObject)coll.get(i), status, exceOperInfo.getOperLogId(), numberType, msg, type.getMainOrg(), traceId);
                exeLogArray[i] = logObj;
            }
            if (exeLogArray.length == 0) {
                return;
            }
            try {
                SaveServiceHelper.save((DynamicObject[])exeLogArray);
            }
            catch (Throwable e) {
                h.markRollback();
                logger.error("\u667a\u80fd\u6838\u7b97\u540e\u53f0\u4e8b\u52a1\u65e5\u5fd7\uff0c\u6267\u884c\u6210\u529f\u7684\u5355\u636e\uff0c\u63d2\u5165\u65e5\u5fd7\u6570\u636e\u53d1\u751f\u62a5\u9519:" + e);
                throw e;
            }
        }
    }

    public static void batchInsertExceLog(IntellExceOperInfo exceOperInfo, Date execstartdate, Object[] srcbillObjs, String status, Map<Object, String> pkErrorMap, String traceId) {
        if (srcbillObjs == null || srcbillObjs.length <= 0) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)exceOperInfo.getBussiness());
        String numberProp = null;
        int numberType = 0;
        if (IntellAccountSchemaExecLogDao.containsProperty(type, "billno")) {
            numberProp = "billno";
            numberType = 1;
        } else if (IntellAccountSchemaExecLogDao.containsProperty(type, "number")) {
            numberProp = "number";
            numberType = 2;
        }
        StringBuilder sel = new StringBuilder("id");
        if (Objects.nonNull(type.getMainOrg())) {
            sel.append(",").append(type.getMainOrg());
        }
        if (Objects.nonNull(numberProp)) {
            sel.append(",").append(numberProp);
        }
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DynamicObjectCollection coll = QueryServiceHelper.query((String)exceOperInfo.getBussiness(), (String)sel.toString(), (QFilter[])new QFilter("id", "in", (Object)srcbillObjs).toArray());
            DynamicObject[] exeLogArray = new DynamicObject[coll.size()];
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"gl_intellexecdetaillog");
                IntellAccountSchemaExecLogDao.createExeLog(exceOperInfo, execstartdate, logObj, (DynamicObject)coll.get(i), status, exceOperInfo.getOperLogId(), numberType, pkErrorMap.get(((DynamicObject)coll.get(i)).get("id")), type.getMainOrg(), traceId);
                exeLogArray[i] = logObj;
            }
            if (exeLogArray.length == 0) {
                return;
            }
            try {
                SaveServiceHelper.save((DynamicObject[])exeLogArray);
            }
            catch (Throwable e) {
                h.markRollback();
                logger.error("\u667a\u80fd\u6838\u7b97\u540e\u53f0\u4e8b\u52a1\u65e5\u5fd7\uff0c\u6267\u884c\u5931\u8d25\u7684\u5355\u636e\uff0c\u63d2\u5165\u65e5\u5fd7\u6570\u636e\u53d1\u751f\u62a5\u9519:" + e);
                throw e;
            }
        }
    }

    public static void createExeLog(IntellExceOperInfo exceOperInfo, Date execstartdate, DynamicObject logObj, DynamicObject srcbillObj, String status, long operlogId, int numberType, String msg, String mainOrg, String traceId) {
        logObj.set("intelschemaid_id", (Object)exceOperInfo.getSchemaId());
        logObj.set("bizapp_id", (Object)exceOperInfo.getAppId());
        logObj.set("bussiness", (Object)exceOperInfo.getBussiness());
        logObj.set("oper", (Object)exceOperInfo.getOper());
        logObj.set("opersumlogid", (Object)operlogId);
        logObj.set("creator_id", (Object)exceOperInfo.getCreatorId());
        logObj.set("execstatus", (Object)status);
        logObj.set("execnumber", (Object)0);
        if (null != msg && msg.length() > 500) {
            msg = String.format("TraceId:%s  %s...", traceId, msg.substring(0, 500));
        }
        logObj.set("execdetail", (Object)msg);
        if (srcbillObj != null) {
            if (StringUtils.isNotBlank((CharSequence)mainOrg)) {
                logObj.set("sourceorgid", srcbillObj.get(mainOrg));
            }
            if (numberType == 1) {
                logObj.set("srcbillnumber", srcbillObj.get("billno"));
            } else if (numberType == 2) {
                logObj.set("srcbillnumber", srcbillObj.get("number"));
            }
            logObj.set("srcbillid", (Object)srcbillObj.getLong("id"));
        }
        if (execstartdate == null) {
            execstartdate = new Date();
        }
        logObj.set("createtime", (Object)execstartdate);
        logObj.set("lastexectime", (Object)execstartdate);
    }

    public static void updateAllProcessingSchemaFail(Long intelschemaId, Long sumLogId) {
        IntellAccountSchemaExecLogDao.updateAllProcessingSchemaFail(Collections.singletonList(intelschemaId), sumLogId);
    }

    public static void updateAllProcessingSchemaFail(List<Long> intelschemaIds, Long sumLogId) {
        DynamicObjectCollection isExistProcessingOperData;
        Date nowDate = new Date();
        QFilter schemaIdFilter = new QFilter("intelschemaid", "in", intelschemaIds);
        QFilter execstatusFilter = new QFilter("execstatus", "=", (Object)"1");
        QFilter sumLogIdFilter = new QFilter("id", "!=", (Object)sumLogId);
        String errMsg = ResManager.loadKDString((String)"\u8d85\u65f6\u81ea\u52a8\u9000\u51fa", (String)"IntellAccountingExecPlan_0", (String)"fi-iep-formplugin", (Object[])new Object[0]);
        DynamicObjectCollection isExistProcessingData = QueryServiceHelper.query((String)"gl_intelschemasumlog", (String)"id,quantity", (QFilter[])new QFilter[]{execstatusFilter, schemaIdFilter, sumLogIdFilter});
        if (isExistProcessingData != null) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(isExistProcessingData.size());
            for (DynamicObject singleDb : isExistProcessingData) {
                params.add(new Object[]{nowDate, 0, "3", errMsg, singleDb.getLong("id")});
            }
            IntellAccountSchemaExecLogDao.updateExecSumLog(params);
        }
        if ((isExistProcessingOperData = QueryServiceHelper.query((String)"gl_intellopersumlog", (String)"id,billqty", (QFilter[])new QFilter[]{execstatusFilter, schemaIdFilter})) != null) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(isExistProcessingOperData.size());
            for (DynamicObject singleDb : isExistProcessingOperData) {
                long operLogId = singleDb.getLong("id");
                params.add(new Object[]{nowDate, "3", errMsg, operLogId});
            }
            IntellAccountSchemaExecLogDao.updateOperSumLog(params);
        }
    }

    private static boolean isDeleteOpe(IntellExceOperInfo operInfo) {
        String bussiness = operInfo.getBussiness();
        String operationName = operInfo.getOper();
        List ops = EntityMetadataCache.getDataEntityOperate((String)bussiness);
        for (Map each : ops) {
            String operationkey = String.valueOf(each.get("key"));
            String type = String.valueOf(each.get("type"));
            if (!Objects.nonNull(operationkey) || !operationkey.equals(operationName)) continue;
            return "delete".equals(type);
        }
        return false;
    }
}

