/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.info;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.iep.enums.ExecuteStatus;
import kd.fi.iep.info.IntellExceOperInfo;
import kd.fi.iep.util.DateUtil;
import kd.fi.iep.util.IntellCacheHelper;

public class IntellSchemeExecInfo
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(IntellSchemeExecInfo.class);
    private long schemaId;
    private ExecuteStatus executeStatus;
    private boolean isProgress;
    private int percent;
    private int operTC;
    private int operTCC;
    private int recordTC;
    private int recordTSC;
    private int recordTFC;
    private int recordTFSC;
    private String execDetails;
    private IntellExceOperInfo exceOperInfo;
    private Date lastUpdateDate;
    private Date execStartDate;

    public IntellSchemeExecInfo() {
    }

    public IntellSchemeExecInfo(long schemaId) {
        this.schemaId = schemaId;
        this.isProgress = false;
        this.lastUpdateDate = new Date();
    }

    public static IntellSchemeExecInfo getInstance(long schemaId) {
        String intellExecInfoStr = IntellCacheHelper.getDistributeCache().get(IntellSchemeExecInfo.getCacheKey(schemaId));
        if (Objects.isNull(intellExecInfoStr)) {
            return null;
        }
        try {
            IntellSchemeExecInfo intelSchemelExecInfo = (IntellSchemeExecInfo)SerializationUtils.fromJsonString((String)intellExecInfoStr, IntellSchemeExecInfo.class);
            if (DateUtil.isSameDay(intelSchemelExecInfo.getLastUpdateDate(), new Date())) {
                return intelSchemelExecInfo;
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return null;
        }
        return null;
    }

    public static void execInfoWriteCache(IntellSchemeExecInfo schemeInfo) {
        String executeDetails;
        IntellExceOperInfo exceOperInfo = schemeInfo.getExceOperInfo();
        if (exceOperInfo.getOperRTC() == 0) {
            executeDetails = String.format(ResManager.loadKDString((String)"\u51c6\u5907\u6267\u884c\u3010%1$s\u3011\u64cd\u4f5c,\u6570\u636e\u51c6\u5907\u4e2d...", (String)"IntellAccountSchemaExecLogDao_6", (String)"fi-iep-formplugin", (Object[])new Object[0]), exceOperInfo.getOperName());
        } else {
            int totalCount = Math.max(exceOperInfo.getOperRTC(), exceOperInfo.getOperRTSC() + exceOperInfo.getOperRTFC());
            executeDetails = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u3010%1$s\u3011\u64cd\u4f5c,\u5171\u83b7\u53d6\u3010%2$s\u3011\u6761\u6570\u636e\uff0c\u76ee\u524d\u6210\u529f\u3010%3$s\u3011\u6761\uff0c\u5931\u8d25\u3010%4$s\u3011\u6761; ", (String)"IntellAccountSchemaExecLogDao_1", (String)"fi-iep-formplugin", (Object[])new Object[0]), exceOperInfo.getOperName(), totalCount, exceOperInfo.getOperRTSC(), exceOperInfo.getOperRTFC());
        }
        schemeInfo.setExecDetails(executeDetails);
        if (schemeInfo.getSchemaId() > 0L) {
            try {
                IntellCacheHelper.getDistributeCache().put(IntellSchemeExecInfo.getCacheKey(schemeInfo.getSchemaId()), SerializationUtils.toJsonString((Object)schemeInfo));
            }
            catch (Exception e) {
                LOGGER.info("schemeInfo: {}", (Object)schemeInfo);
                LOGGER.error((Throwable)e);
            }
        }
    }

    public static void removeIntellExecInfo(long schemaId) {
        IntellCacheHelper.getDistributeCache().remove(IntellSchemeExecInfo.getCacheKey(schemaId));
    }

    public static String getCacheKey(long schemaId) {
        return "iep_intell_" + schemaId;
    }

    public long getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(long schemaId) {
        this.schemaId = schemaId;
    }

    public ExecuteStatus getExecuteStatus() {
        return this.executeStatus;
    }

    public void setExecuteStatus(ExecuteStatus executeStatus) {
        if (ExecuteStatus.STOP == executeStatus) {
            this.executeStatus = executeStatus;
            return;
        }
        if (ExecuteStatus.PROCESSING == this.executeStatus) {
            this.executeStatus = executeStatus;
            return;
        }
        this.executeStatus = executeStatus;
    }

    public boolean isProgress() {
        return this.isProgress;
    }

    public void setProgress(boolean progress) {
        this.isProgress = progress;
    }

    public int getPercent() {
        IntellExceOperInfo operInfo = this.exceOperInfo;
        if (this.getOperTC() != 0 && operInfo.getOperRTC() != 0 && this.getOperTC() != 0) {
            int operPercent = this.getOperTCC() * 100 / this.getOperTC();
            int curOperPercent = (int)((double)(operInfo.getOperRTSC() + operInfo.getOperRTFC()) * 100.0 / (double)operInfo.getOperRTC() / (double)this.getOperTC());
            this.percent = operPercent + curOperPercent;
        }
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public int getRecordTC() {
        return this.recordTC;
    }

    public void appendRecordTC(int recordTC) {
        this.recordTC += recordTC;
        this.exceOperInfo.setOperRTC(recordTC);
    }

    public int getRecordTSC() {
        return this.recordTSC;
    }

    public int getRecordTFC() {
        return this.recordTFC;
    }

    public int getRecordTFSC() {
        return this.recordTFSC;
    }

    public void appendExecRecord(int successCount, int failCount, int failCountSum) {
        this.recordTSC += successCount;
        this.recordTFC += failCount;
        this.recordTFSC += failCountSum;
        this.exceOperInfo.setOperRTSC(successCount);
        this.exceOperInfo.setOperRTFC(failCount);
    }

    public String getExecDetails() {
        return this.execDetails;
    }

    public void setExecDetails(String execDetails) {
        this.execDetails = execDetails;
    }

    public IntellExceOperInfo getExceOperInfo() {
        return this.exceOperInfo;
    }

    public void setExceOperInfo(IntellExceOperInfo exceOperInfo) {
        this.exceOperInfo = exceOperInfo;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateTime) {
        this.lastUpdateDate = lastUpdateTime;
    }

    public Date getExecStartDate() {
        return this.execStartDate;
    }

    public void setExecStartDate(Date execStartDate) {
        this.execStartDate = execStartDate;
    }

    public int getOperTC() {
        return this.operTC;
    }

    public void setOperTC(int operTC) {
        this.operTC = operTC;
    }

    public int getOperTCC() {
        return this.operTCC;
    }

    public void setOperTCC() {
        ++this.operTCC;
    }

    public String toString() {
        return "IntellExecInfo{schemaId=" + this.schemaId + ", isProgress=" + this.isProgress + ", operTotC=" + this.operTC + ", operComC=" + this.operTCC + ", percent=" + this.percent + ", recordTotC=" + this.recordTC + ", recordSucC=" + this.recordTSC + ", recordFaiC=" + this.recordTFC + ", recordFaiSC=" + this.recordTFSC + ", execDetails='" + this.execDetails + '\'' + ", lastUpdateDate=" + this.lastUpdateDate + ", execStartDate=" + this.execStartDate + '}';
    }
}

