/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.task.impl;

import java.util.Date;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.iep.dao.IntellAccountSchemaExecLogDao;
import kd.fi.iep.enums.ExecuteStatus;
import kd.fi.iep.info.IntellExceOperInfo;
import kd.fi.iep.info.IntellSchemeExecInfo;
import kd.fi.iep.task.AbstractExecute;
import kd.fi.iep.task.IntellExecuteContext;

public class InternalTradeExecute
extends AbstractExecute {
    public InternalTradeExecute(IntellExecuteContext ctx) {
        super(ctx);
    }

    @Override
    public void doExecute() {
        this.excePullData(this.ctx.getSchemeExecInfo());
    }

    @Override
    protected OperationResult invokeOperation(Object[] ids, OperateOption option) {
        return null;
    }

    private void excePullData(IntellSchemeExecInfo schemeExecInfo) {
        IntellExceOperInfo exceOperInfo = schemeExecInfo.getExceOperInfo();
        long operSumLog = IntellAccountSchemaExecLogDao.insertOperSumLog(schemeExecInfo.getSchemaId(), this.ctx.getSumLogId(), new Date(), exceOperInfo, 1, "");
        exceOperInfo.setOperLogId(operSumLog);
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(RequestContext.get().getUserId()), (String)"ict", (String)"ict_relacctrecord", (String)"47150e89000000ac");
        if (permOrgRs.getHasPermOrgs().size() == 0) {
            return;
        }
        QFilter[] qFilters = new QFilter("org", "=", permOrgRs.getHasPermOrgs().get(0)).toArray();
        DynamicObject dyn = QueryServiceHelper.queryOne((String)exceOperInfo.getBussiness(), (String)"id", (QFilter[])qFilters);
        if (Objects.isNull(dyn)) {
            return;
        }
        Object[] obs = new Object[]{dyn.getLong("id")};
        OperateOption option = OperateOption.create();
        option.setVariableValue("gl_intellexecschema", String.valueOf(exceOperInfo.getSchemaId()));
        OperationResult result = OperationServiceHelper.executeOperate((String)exceOperInfo.getOper(), (String)exceOperInfo.getBussiness(), (Object[])obs, (OperateOption)option);
        try (TXHandle tx = TX.requiresNew();){
            ExecuteStatus execstatus = result.isSuccess() ? ExecuteStatus.FINISH : ExecuteStatus.FAIL;
            String execdetail = result.isSuccess() ? ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"IntellAccountingExecPlan_1", (String)"fi-iep-formplugin", (Object[])new Object[0]) : result.getMessage();
            exceOperInfo.setExecuteStatus(execstatus);
            exceOperInfo.setExecDetails(execdetail);
        }
    }
}

