package kd.bos.ext.imc.common.util;

import java.math.BigDecimal;

/**
 * @author jimmy_zhu
 * @Description: 数字计算处理工具
 * @date 2020/5/15 11:00
 */
public class MathUtils {

    /**
     * @param obj 传入的小数
     * @return 格式化数据
     * @desc 1.0~1之间的BigDecimal小数，格式化后失去前面的0,则前面直接加上0。
     * 2.传入的参数等于0，则直接返回字符串"0.00"
     * 3.大于1的小数，直接格式化返回字符串
     */
    public static String formatToNumber(BigDecimal obj) {
        if (obj == null) {
            return "0.00";
        }
        return obj.setScale(2, BigDecimal.ROUND_HALF_UP).toPlainString();
    }

    public static boolean isNotZero(BigDecimal sourceBigDecimal){
        return !isZero(sourceBigDecimal);
    }

    public static boolean isZero(BigDecimal sourceBigDecimal) {
        if (sourceBigDecimal == null) {
            return true;
        }
        return sourceBigDecimal.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean isNullOrZero(BigDecimal sourceBigDecimal) {
        return sourceBigDecimal == null || isZero(sourceBigDecimal);
    }

    public static int getNumberOfDecimalPlace(BigDecimal bigDecimal) {
        final String s = bigDecimal.toPlainString();
        final int index = s.indexOf('.');
        if (index < 0) {
            return 0;
        }
        return s.length() - 1 - index;
    }

    /**
     * @Description: BigDecimal 是否为整数
     * @Author: jimmy_zhu
     * @Date: 2022/3/3 15:58
     **/
    public static boolean bigDecimalIsIntegerValue(BigDecimal value) {
        return value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0;
    }

    /**
     * @Description: BigDecimal 是否为负数
     * @Author: jimmy_zhu
     * @Date: 2022/4/26 15:01
     */
    public static boolean bigDecimalIsNegativeValue(BigDecimal value) {
        return value.signum() == -1;
    }

    /***
     * @Description: 不含税转含税
     * @param: notIncludeTaxAmount 不含税金额
     * @param: taxRateBigDecimal 税率
     * @return: java.math.BigDecimal
     * @Author: jimmy_zhu
     * @Date: 2022/5/17 15:19
     */
    public static BigDecimal notIncludeTaxConvertToHs(BigDecimal notIncludeTaxAmount, BigDecimal taxRateBigDecimal) {
        // 含税 = 不含税*(1+税率)
        return notIncludeTaxAmount.multiply(BigDecimal.ONE.add(taxRateBigDecimal));
    }

    /*
     * @Description: 含税转不含税
     * @param: includeTaxAmount 不含税金额
     * @param: taxRateBigDecimal 税率
     * @return: java.math.BigDecimal
     * @Author: jimmy_zhu
     * @Date: 2022/5/17 15:19
     */
//    public static BigDecimal includeTaxConvertToBHs(BigDecimal includeTaxAmount, BigDecimal taxRateBigDecimal) {
//        // 不含税 = 含税/(1+税率)
//        return includeTaxAmount.divide(BigDecimal.ONE.add(taxRateBigDecimal), 15, RoundingMode.HALF_UP);
//    }
}
