package kd.bos.ext.imc.formplugin.operation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.imc.common.opration.OpConfigParam;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.operation.CustOperationParameter;

public class InvoiceOPUtils {
	
	/**
	 * 	操作配置页面获取当前单据页面的所有字段
	 * @author rd_yuqiu_he 
	 * @date 2022-6-20 
	 * @param view
	 * @return
	 */
	public static JSONArray getBillFields(IFormView view) {
		Map<String,Object> param = view.getFormShowParameter().getCustomParams();
		Object metaContext = param.get(OpConfigParam.PARAM_METACONTEXT);
		if(metaContext != null) {
			return (JSONArray)((JSONArray)metaContext).get(0);
		}
		return null;
	}
	
	/**
	 * 	操作配置界面获取当前单据页面的所有字段并分类
	 * @author rd_yuqiu_he 
	 * @date 2022-6-20 
	 * @param view
	 * @return
	 */
	public static JSONObject getBillTypeFields(IFormView view) {
		JSONObject result = new JSONObject();
		JSONArray fields = getBillFields(view);
		if(fields == null) {
			return null;
		}
		//分录分类
		JSONObject entryTypeInfo = new JSONObject();
		result.put(OpConfigParam.CONFIG_ENTRY, entryTypeInfo);
		//字段分类
		JSONObject fieldTypeInfo = new JSONObject();
		result.put(OpConfigParam.CONFIG_FIELD, fieldTypeInfo);
		//分录标识
		JSONObject entryInfo = new JSONObject();
		result.put(OpConfigParam.CONFIG_ENTRY_ID, entryInfo);
		for (int i = 0; i < fields.size(); i++) {
			JSONObject field = fields.getJSONObject(i);
			String type = field.getString(OpConfigParam.PARAM__TYPE_);
			//是否有父分录
			String parentId = field.getString(OpConfigParam.PARAM_PARENTID);
			if(StringUtils.isNotBlank(parentId)) {
				JSONArray entryFieldInfo = entryTypeInfo.getJSONArray(parentId);
				if(entryFieldInfo == null) {
					entryFieldInfo = new JSONArray();
				}
				entryFieldInfo.add(field);
				entryTypeInfo.put(parentId, entryFieldInfo);
			}
			
			if(StringUtils.equals(type, OpConfigParam.PARAM_ENTRYENTITY)) {
				//分录
				String id = field.getString(OpConfigParam.PARAM_ID);
				JSONArray entryFieldInfo = entryTypeInfo.getJSONArray(id);
				if(entryFieldInfo == null) {
					entryFieldInfo = new JSONArray();
				}
				entryFieldInfo.add(field);
				entryTypeInfo.put(id, entryFieldInfo);
				
				entryInfo.put(field.getString(OpConfigParam.PARAM_KEY), id);
			}
			
			JSONArray fieldInfo = fieldTypeInfo.getJSONArray(type);
			if(fieldInfo == null) {
				fieldInfo = new JSONArray();
			}
			fieldInfo.add(field);
			fieldTypeInfo.put(type, fieldInfo);
		}
		return result;
	}
	
	/**
	 * 	获取type类型字段合集
	 * @author rd_yuqiu_he 
	 * @date 2022-6-22 
	 * @param type
	 * @param billTypeFields
	 * @return
	 */
	public static JSONArray getFields(String type, JSONObject billTypeFields) {
		JSONObject fieldTypeInfo = billTypeFields.getJSONObject(OpConfigParam.CONFIG_FIELD);
		JSONArray typeField = fieldTypeInfo.getJSONArray(type);
		if(typeField == null) {
			typeField = new JSONArray();
		}
		return typeField;
	}

	public static List<ComboItem> getComboListOfTypeNoEntry(IFormView view, String... types){
		return getComboListOfTypeNoEntry(getBillTypeFields(view), types);
	}
	/**
	 * 	根据所需types类型获取下拉集合（不包含分录）
	 * @author rd_yuqiu_he 
	 * @date 2022-6-21 
	 * @param billTypeFields
	 * @param types
	 * @return
	 */
	public static List<ComboItem> getComboListOfTypeNoEntry(JSONObject billTypeFields, String... types){
		JSONObject fieldTypeInfo = billTypeFields.getJSONObject(OpConfigParam.CONFIG_FIELD);
		List<ComboItem> reuslt = Lists.newArrayListWithExpectedSize(fieldTypeInfo.size());
		for (int i = 0; i < types.length; i++) {
			JSONArray typeFields = fieldTypeInfo.getJSONArray(types[i]);
			if(typeFields != null) {
				reuslt.addAll(convertComboItemNoEntry(typeFields));
			}
		}
		return reuslt;
	}
	
	public static List<ComboItem> getComboListOfTypeAll(IFormView view, String... types){
		return getComboListOfTypeAll(getBillTypeFields(view), types);
	}
	
	/**
	 * 	根据所需types类型获取下拉集合（包含分录）
	 * @author rd_yuqiu_he 
	 * @date 2022-6-21 
	 * @param billTypeFields
	 * @param types
	 * @return
	 */
	public static List<ComboItem> getComboListOfTypeAll(JSONObject billTypeFields, String... types){
		if(billTypeFields == null) {
			return Lists.newArrayListWithExpectedSize(0);
		}
		JSONObject fieldTypeInfo = billTypeFields.getJSONObject(OpConfigParam.CONFIG_FIELD);
		List<ComboItem> reuslt = Lists.newArrayListWithExpectedSize(fieldTypeInfo.size());
		for (int i = 0; i < types.length; i++) {
			JSONArray typeFields = fieldTypeInfo.getJSONArray(types[i]);
			if(typeFields != null) {
				reuslt.addAll(convertComboItemAll(typeFields));
			}
		}
		return reuslt;
	}
	
	/**
	 * 	设置
	 * @author rd_yuqiu_he 
	 * @date 2022-6-20 
	 * @param invoiceEntryItems
	 * @param entryKeyCombo
	 * @param view
	 */
	public static void billInfo(List<ComboItem> invoiceEntryItems, JSONObject entryKeyCombo, IFormView view) {
		JSONArray fields = getBillFields(view);
		if(fields == null) {
			return;
		}
		JSONArray head = new JSONArray();
		for (Object obj : fields) {
			if(!(obj instanceof JSONObject)) {
				continue;
			}
			JSONObject json = ((JSONObject)obj);
			String type = json.getString(OpConfigParam.PARAM__TYPE_);
			if(StringUtils.equals(type, OpConfigParam.PARAM_ENTRYENTITY)) {
				invoiceEntryItems.add(creatComboItem(json));
			}else if(json.getString(OpConfigParam.PARAM_PARENTID) != null && StringUtils.equals(type, OpConfigParam.PARAM_TEXTFIELD)) {
				//分录分组
				String parentId = json.getString(OpConfigParam.PARAM_PARENTID);
				JSONArray entryFieldsCombo = entryKeyCombo.getJSONArray(parentId);
				if(entryFieldsCombo == null) {
					entryFieldsCombo = new JSONArray();
					entryKeyCombo.put(parentId, entryFieldsCombo);
				}
				entryFieldsCombo.add(json);
			}else {
				if(StringUtils.endsWith(type, "Entity")) {
					entryKeyCombo.put(json.getString(OpConfigParam.PARAM_ID), head);
					invoiceEntryItems.add(creatComboItem(json));
				}else{
					//单头分组
					head.add(json);
				}
			}
		}
	}
	
	public static List<ComboItem> convertComboItemAll(JSONArray fieldArr){
		return convertComboItem(fieldArr, false);
	}
	
	public static List<ComboItem> convertComboItemNoEntry(JSONArray fieldArr){
		return convertComboItem(fieldArr, true);
	}
	
	private static List<ComboItem> convertComboItem(JSONArray fieldArr, boolean excludeEntry){
		List<ComboItem> items = Lists.newArrayListWithExpectedSize(fieldArr.size());
		for (int i = 0; i < fieldArr.size(); i++) {
			JSONObject field = fieldArr.getJSONObject(i);
			String parentId = field.getString(OpConfigParam.PARAM_PARENTID);
			if(StringUtils.isNotBlank(parentId) && excludeEntry) {
				continue;
			}
			ComboItem item = creatComboItemKeyNoId(field);
			items.add(item);
		}
		return items;
	}
	
	private static ComboItem creatComboItem(JSONObject json) {
		String key = json.getString(OpConfigParam.PARAM_KEY);
		String name = json.getString(OpConfigParam.PARAM_NAME);
		String id = json.getString(OpConfigParam.PARAM_ID);
		ComboItem item = new ComboItem();
		item.setValue(key+"_"+id);
		item.setCaption(new LocaleString(name+"("+key+")"));
		return item;
	}
	
	private static ComboItem creatComboItemKeyNoId(JSONObject json) {
		String key = json.getString(OpConfigParam.PARAM_KEY);
		String name = json.getString(OpConfigParam.PARAM_NAME);
		ComboItem item = new ComboItem();
		item.setValue(key);
		item.setCaption(new LocaleString(name+"("+key+")"));
		return item;
	}
	
	/**
	 * 	将分录entryentity刷新成单据页面的entryComboValue分录的的字段
	 * @author rd_yuqiu_he 
	 * @date 2022-6-20 
	 * @param view
	 * @param entryComboValue	单据页面的分录值
	 */
	public static void refreshKeyEntry(IFormView view, String entryComboValue) {
		IDataModel model = view.getModel();
		IPageCache cache = view.getPageCache();
		model.deleteEntryData(OpConfigParam.CONFIG_ENTRY_ENTRYENTITY);
		String pId = entryComboValue.substring(entryComboValue.lastIndexOf("_")+1);
		String cacheEntry = cache.get(OpConfigParam.CONFIG_ENTRY_ENTRYKEY_CACHE);
		JSONObject entryKeyCombo = JSONObject.parseObject(cacheEntry);
		JSONArray entryFieldsCombo = entryKeyCombo.getJSONArray(pId);
		if(entryFieldsCombo != null && !entryFieldsCombo.isEmpty()) {
			EntryGrid entryentity = view.getControl(OpConfigParam.CONFIG_ENTRY_ENTRYENTITY);
			List<FieldEdit> fieldLists = entryentity.getFieldEdits();
			Optional<FieldEdit> op = fieldLists.stream().filter(v -> StringUtils.equals(OpConfigParam.CONFIG_ENTRY_ENTRYKEY, v.getKey())).findFirst();
			if(op.isPresent()) {
				ComboEdit combo = (ComboEdit)op.get();
				List<ComboItem> items = Lists.newArrayList();
				for (Object json : entryFieldsCombo) {
					String key = ((JSONObject)json).getString(OpConfigParam.PARAM_KEY);
					String name = ((JSONObject)json).getString(OpConfigParam.PARAM_NAME);
					ComboItem item = new ComboItem();
					item.setValue(key);
					item.setCaption(new LocaleString(name+"("+key+")"));
					items.add(item);
				}
				combo.setComboItems(items);
			}
		}
	}
	
	public static void refreshFiled(IFormView view, String value) {
		if(StringUtils.isBlank(value)) {
			return;
		}
		IDataModel model = view.getModel();
		IPageCache cache = view.getPageCache();
		model.setValue(OpConfigParam.CONFIG_SERIAL, " ");
		String pId = value.substring(value.lastIndexOf("_")+1);
		String cacheEntry = cache.get(OpConfigParam.CONFIG_ENTRY_ENTRYKEY_CACHE);
		if(cacheEntry == null) {
			return;
		}
		JSONObject entryKeyCombo = JSONObject.parseObject(cacheEntry);
		JSONArray entryFieldsCombo = entryKeyCombo.getJSONArray(pId);
		if(entryFieldsCombo != null) {
			ComboEdit combo = view.getControl(OpConfigParam.CONFIG_SERIAL);
			List<ComboItem> items = Lists.newArrayList();
			for (Object json : entryFieldsCombo) {
				String id = ((JSONObject)json).getString("Key");
				String name = ((JSONObject)json).getString("Name");
				ComboItem item = new ComboItem();
				item.setValue(id);
				item.setCaption(new LocaleString(name+"("+id+")"));
				items.add(item);
			}
			combo.setComboItems(items);
		}
	}
	
	public static void initShow(IDataModel model, List<String> fields, CustOperationParameter v) {
		JSONObject param = JSONObject.parseObject(v.getParameter());
		if(param == null) {
			return;
		}
		for (String fieldKey : fields) {
			String value = param.getString(fieldKey);
			if(StringUtils.isNotBlank(value)) {
				model.setValue(fieldKey, param.get(fieldKey));
			}
		}
		DynamicObject entity = model.getDataEntity(true);
		//处理发票头映射分录
		if(entity.getDynamicObjectType().getProperty(OpConfigParam.CONFIG_ENTRY_ENTRYENTITY) != null) {
			JSONArray jsonArr = param.getJSONArray(OpConfigParam.CONFIG_ENTRY_ENTRYENTITY);
			if(jsonArr != null && !jsonArr.isEmpty()) {
				model.batchCreateNewEntryRow(OpConfigParam.CONFIG_ENTRY_ENTRYENTITY, jsonArr.size());
				for (int i = 0; i < jsonArr.size(); i++) {
					JSONObject entryInfo = (JSONObject)jsonArr.get(i);
					model.setValue(OpConfigParam.CONFIG_ENTRY_ENTRYKEY, entryInfo.get(OpConfigParam.CONFIG_ENTRY_ENTRYKEY), entryInfo.getIntValue("index"));
					
					model.setValue(OpConfigParam.CONFIG_ENTRY_MULINVOICEKEY,convertStrToLong( entryInfo.getString(OpConfigParam.CONFIG_ENTRY_MULINVOICEKEY)), entryInfo.getIntValue("index"));
				}
			}
		}
		//处理发票明细映射分录
		if(entity.getDynamicObjectType().getProperty(OpConfigParam.CONFIG_ENTRY_ITEM_ENTRYENTITY) != null) {
			JSONArray jsonArr = param.getJSONArray(OpConfigParam.CONFIG_ENTRY_ITEM_ENTRYENTITY);
			if(jsonArr != null && !jsonArr.isEmpty()) {
				model.batchCreateNewEntryRow(OpConfigParam.CONFIG_ENTRY_ITEM_ENTRYENTITY, jsonArr.size());
				for (int i = 0; i < jsonArr.size(); i++) {
					JSONObject entryInfo = (JSONObject)jsonArr.get(i);
					model.setValue(OpConfigParam.CONFIG_ENTRY_ITEMENTYFIELDKEY, entryInfo.get(OpConfigParam.CONFIG_ENTRY_ITEMENTYFIELDKEY), entryInfo.getIntValue("index"));
					model.setValue(OpConfigParam.CONFIG_ENTRY_MULINVOICEITEMFIELDKEY, convertStrToLong(entryInfo.getString(OpConfigParam.CONFIG_ENTRY_MULINVOICEITEMFIELDKEY)), entryInfo.getIntValue("index"));
				}
			}
		}
	}
	
	private static Object[] convertStrToLong(String value) {
		return Arrays.asList(value.split(",")).stream().map(item -> Long.parseLong(item)).collect(Collectors.toList()).toArray();
	}
	
	public static void saveConfig(IDataModel model, List<String> fields, CustOperationParameter v) {
		DynamicObject entity = model.getDataEntity(true);
		JSONObject param = new JSONObject();
		for (String fieldKey : fields) {
			Object modelValue = entity.get(fieldKey);
			if(modelValue == null) {
				continue;
			}
			if(modelValue instanceof DynamicObject) {
				param.put(fieldKey, ((DynamicObject) modelValue).getLong("id"));
			}else if(modelValue instanceof String) {
				if(StringUtils.isNotBlank(modelValue)) {
					param.put(fieldKey, modelValue);
				}
			}else if(modelValue instanceof Boolean) {
				param.put(fieldKey, modelValue);
			}
		}
		
		//发票头映射分录
		if(entity.getDynamicObjectType().getProperty(OpConfigParam.CONFIG_ENTRY_ENTRYENTITY) != null) {
			DynamicObjectCollection entryKeyColl = entity.getDynamicObjectCollection(OpConfigParam.CONFIG_ENTRY_ENTRYENTITY);
			JSONArray relectInfo = new JSONArray();
			for (int i = 0; i < entryKeyColl.size(); i++) {
				DynamicObject entry = entryKeyColl.get(i);
				DynamicObjectCollection coll = entry.getDynamicObjectCollection(OpConfigParam.CONFIG_ENTRY_MULINVOICEKEY);
				if(coll != null && !coll.isEmpty()) {
					JSONObject info = new JSONObject();
					relectInfo.add(info);
					info.put(OpConfigParam.CONFIG_ENTRY_ENTRYKEY, entry.get(OpConfigParam.CONFIG_ENTRY_ENTRYKEY));
					String mulinvoicekey = coll.stream().map(item -> String.valueOf(item.getLong("fbasedataid_id"))).collect(Collectors.joining(","));
					info.put(OpConfigParam.CONFIG_ENTRY_MULINVOICEKEY,mulinvoicekey);
					String invoiceKeys = coll.stream().map(item -> item.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.joining(","));
					info.put(OpConfigParam.CONFIG_ENTRY_INVOICEKEYS,invoiceKeys);
					info.put("index", i);
				}
			}
			if(!relectInfo.isEmpty()) {
				param.put(OpConfigParam.CONFIG_ENTRY_ENTRYENTITY, relectInfo);
			}
		}
		
		//发票明细映射分录
		if(entity.getDynamicObjectType().getProperty(OpConfigParam.CONFIG_ENTRY_ITEM_ENTRYENTITY) != null) {
			DynamicObjectCollection entryKeyColl = entity.getDynamicObjectCollection(OpConfigParam.CONFIG_ENTRY_ITEM_ENTRYENTITY);
			JSONArray relectInfo = new JSONArray();
			for (int i = 0; i < entryKeyColl.size(); i++) {
				DynamicObject entry = entryKeyColl.get(i);
				DynamicObjectCollection coll = entry.getDynamicObjectCollection(OpConfigParam.CONFIG_ENTRY_MULINVOICEITEMFIELDKEY);
				if(coll != null && !coll.isEmpty()) {
					JSONObject info = new JSONObject();
					relectInfo.add(info);
					info.put(OpConfigParam.CONFIG_ENTRY_ITEMENTYFIELDKEY, entry.get(OpConfigParam.CONFIG_ENTRY_ITEMENTYFIELDKEY));
					String mulinvoiceitemfieldkey = coll.stream().map(item -> String.valueOf(item.getLong("fbasedataid_id"))).collect(Collectors.joining(","));
					info.put(OpConfigParam.CONFIG_ENTRY_MULINVOICEITEMFIELDKEY, mulinvoiceitemfieldkey);
					String invoiceKeys = coll.stream().map(item -> item.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.joining(","));
					info.put(OpConfigParam.CONFIG_ENTRY_INVOICEITEMKEYS,invoiceKeys);
					info.put("index", i);
				}
			}
			if(!relectInfo.isEmpty()) {
				param.put(OpConfigParam.CONFIG_ENTRY_ITEM_ENTRYENTITY, relectInfo);
			}
		}
		v.setParameter(JSONObject.toJSONString(param));
	}
}
