package kd.bos.ext.imc.formplugin.operation;

import java.util.EventObject;
import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.imc.common.opration.OpConfigParam;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.operation.CustOpParameterPlugin;
import kd.bos.metadata.entity.operation.CustOperationParameter;

public class ShowConfigParamPlugin extends CustOpParameterPlugin {
	
	@Override
	public void afterCreateNewData(EventObject e) {
		ComboEdit combo = getControl(OpConfigParam.CONFIG_INVOICEENTRY);
		List<ComboItem> items = Lists.newArrayList();
		JSONObject entryKeyCombo = new JSONObject();
		InvoiceOPUtils.billInfo(items, entryKeyCombo, getView());
		if(items.isEmpty() || items.size() == 1) {
			this.getView().setVisible(Boolean.FALSE, OpConfigParam.CONFIG_INVOICEENTRY);
		}
		combo.setComboItems(items);
		if(items.size() == 1) {
			this.getModel().setValue(OpConfigParam.CONFIG_INVOICEENTRY, items.get(0).getValue());
		}
		this.getPageCache().put(OpConfigParam.CONFIG_ENTRY_ENTRYKEY_CACHE, entryKeyCombo.toJSONString());
		MetadataDao.readMeta(MetadataDao.getIdByNumber("rim_invoice", MetaCategory.Entity), MetaCategory.Entity);
		super.afterCreateNewData(e);
	}
	
	@Override
	public void propertyChanged(PropertyChangedArgs e) {
		String key = e.getProperty().getName();
		switch (key) {
		case OpConfigParam.CONFIG_INVOICEENTRY:
			String value = (String)e.getChangeSet()[0].getNewValue();
			InvoiceOPUtils.refreshFiled(getView(), value);
			break;
		default:
			break;
		}
	}
	
	@Override
	protected void showParameter(CustOperationParameter v) {
 		JSONObject param = JSONObject.parseObject(v.getParameter());
		if(param == null) {
			return;
		}
		if(StringUtils.isNotBlank(param.getString(OpConfigParam.CONFIG_ENTITYID))){
			getModel().setValue(OpConfigParam.CONFIG_ENTITYID, param.get(OpConfigParam.CONFIG_ENTITYID));
		}
		if(StringUtils.isNotBlank(param.getString(OpConfigParam.CONFIG_BILLID))){
			getModel().setValue(OpConfigParam.CONFIG_BILLID, param.getString(OpConfigParam.CONFIG_BILLID));
		}

		if(StringUtils.isNotBlank(param.getString(OpConfigParam.CONFIG_SRC_FLAG)) && StringUtils.equals(param.getString(OpConfigParam.CONFIG_SRC_FLAG),"1")){
			getModel().setValue(OpConfigParam.CONFIG_SRC_FLAG, "1");
		}else{
			getModel().setValue(OpConfigParam.CONFIG_SRC_FLAG, "0");
		}
		if(StringUtils.isNotBlank(param.getString(OpConfigParam.CONFIG_TAR_FLAG)) && StringUtils.equals(param.getString(OpConfigParam.CONFIG_TAR_FLAG),"1")){
			getModel().setValue(OpConfigParam.CONFIG_TAR_FLAG, "1");
		}else{
			getModel().setValue(OpConfigParam.CONFIG_TAR_FLAG, "0");
		}
		if(StringUtils.isNotBlank(param.getString(OpConfigParam.CONFIG_TARGET_ENTITY_ID))){
			getModel().setValue(OpConfigParam.CONFIG_TARGET_ENTITY_ID, param.getString(OpConfigParam.CONFIG_TARGET_ENTITY_ID));
		}

		if(StringUtils.isNotBlank(param.getString(OpConfigParam.CONFIG_SERIAL))){
			String fieldKey = param.getString(OpConfigParam.CONFIG_SERIAL);
			String pId = param.getString(OpConfigParam.CONFIG_PID);
			String entryKey = fieldKey.substring(0,fieldKey.lastIndexOf("."));
			String realFieldKey = fieldKey.substring(fieldKey.lastIndexOf(".")+1);
			getModel().setValue(OpConfigParam.CONFIG_INVOICEENTRY, entryKey+"_"+pId);
			InvoiceOPUtils.refreshFiled(getView(), entryKey+"_"+pId);
			getModel().setValue(OpConfigParam.CONFIG_SERIAL, realFieldKey);
		}else {
			InvoiceOPUtils.refreshFiled(getView(), (String)this.getModel().getValue(OpConfigParam.CONFIG_INVOICEENTRY));
		}
	}
	
	@Override
	protected void returnParameter(CustOperationParameter v) {
		DynamicObject entity = this.getModel().getDataEntity();
		JSONObject param = new JSONObject();
		if(StringUtils.isNotBlank(entity.getString(OpConfigParam.CONFIG_ENTITYID))) {
			param.put(OpConfigParam.CONFIG_ENTITYID, entity.getString(OpConfigParam.CONFIG_ENTITYID));
		}
		if(StringUtils.isNotBlank(entity.getString(OpConfigParam.CONFIG_BILLID))) {
			param.put(OpConfigParam.CONFIG_BILLID, entity.getString(OpConfigParam.CONFIG_BILLID));
		}

		if(entity.getBoolean(OpConfigParam.CONFIG_SRC_FLAG)) {
			param.put(OpConfigParam.CONFIG_SRC_FLAG, "1");
		}else{
			param.put(OpConfigParam.CONFIG_SRC_FLAG, "0");
		}
		if(entity.getBoolean(OpConfigParam.CONFIG_TAR_FLAG)) {
			param.put(OpConfigParam.CONFIG_TAR_FLAG, "1");
		}else{
			param.put(OpConfigParam.CONFIG_TAR_FLAG, "0");
		}
		if(StringUtils.isNotBlank(entity.getString(OpConfigParam.CONFIG_TARGET_ENTITY_ID))) {
			param.put(OpConfigParam.CONFIG_TARGET_ENTITY_ID, entity.getString(OpConfigParam.CONFIG_TARGET_ENTITY_ID));
		}

		//先获取发票流水号的映射信息
		if(StringUtils.isNotBlank(entity.getString(OpConfigParam.CONFIG_SERIAL))) {
			String fieldKey = entity.getString(OpConfigParam.CONFIG_SERIAL);
			String key = entity.getString(OpConfigParam.CONFIG_INVOICEENTRY);
			String pId = key.substring(key.lastIndexOf("_")+1);
			String entryKey = key.substring(0,key.lastIndexOf("_"));
			param.put(OpConfigParam.CONFIG_SERIAL, entryKey+"."+fieldKey);
			param.put(OpConfigParam.CONFIG_PID, pId);
		}
		v.setParameter(JSONObject.toJSONString(param));
	}
}
