package kd.bos.ext.imc.operation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.imc.operation.contant.InvoiceOpParamContant;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public abstract class AbstractInvoiceFormOperate extends FormOperate {
	
	private static final String PARAMETER = "parameter";
	private static final String BILL_MODELTPE = "bill";
	
	
	private static Log logger = LogFactory.getLog(AbstractInvoiceFormOperate.class);
	
	@Override
	protected OperationResult invokeOperation() {
		OperationResult result = super.invokeOperation();
		try {
			Map<String, Object> parameter = this.getParameter();
			Object paramObj = parameter.get(PARAMETER);
			if(paramObj != null) {
				JSONObject param = JSONObject.parseObject(paramObj.toString());
				Map<String, Object> configParam = initParams(param);
				judgeCutomeParam(configParam, result);
				logger.info("【发票操作】传入参数：{}，配置信息：{}",configParam,param);
				excuteService(configParam,result);
			}
		} catch (Exception e) {
			logger.error("【发票操作】，报错信息：",e);
			throw new KDBizException("操作过程中出现错误，请联系管理员处理。"+e.getMessage());
		}
		//业务操作
		return result;
	}

	/**
	 * 	初始化操作传进来的参数以及获取页面配置的参数信息
	 * @author 何雨秋 
	 * @date 2022-3-30 
	 * @param param
	 * @param result
	 * @return
	 */
	protected Map<String, Object> initParams(JSONObject param){
		IDataModel model = this.getView().getModel();
		String modelTpe = this.getView().getFormShowParameter().getFormConfig().getModelType();
		
		//获取初始化参数信息
		Map<String, Object> configParam = Maps.newHashMapWithExpectedSize(8);
		
		//首先检查是否在操作中传递参数
		Map<String, String> opVariables = this.getOption().getVariables();
		logger.info("【发票操作】传入参数：{}",opVariables);
		//挑选出参数中未传递的数据
		List<String> noneParam = Lists.newArrayListWithExpectedSize(getCustomConfigParam().size());
		for (String key : getCustomConfigParam()) {
			String value = opVariables.get(key);
			if(value != null) {
				//判断Value的值类型，进行转换
				configParam.put(key, value);
			}else {
				noneParam.add(key);
			}
		}
		//将页面参数格式转换成接口参数格式
		Map<String, String> paraMapKey = param.keySet().stream().collect(Collectors.toMap(v -> exChange(v), v -> v));
		//根据配置补全参数
		for (String noneKey : noneParam) {
			String configValue = param.getString(paraMapKey.get(noneKey));
			if(StringUtils.equals(noneKey, InvoiceOpParamContant.BILLID)) {
				if(Arrays.asList(BILL_MODELTPE,"mobilebill").contains(modelTpe)
						&& StringUtils.equals(configValue, "id")) {
					//获取单据id,没有id则创建一个id
					Object billid = model.getDataEntity(true).getPkValue();
					if (billid == null || Objects.equals(billid, 0L)) {
						billid = ORM.create().genLongId(model.getDataEntityType());
						model.setValue("id", billid);
					}
					configParam.put(noneKey, billid.toString());
				}else {
					if(model.getDataEntityType().getProperty(configValue) != null) {
						configParam.put(noneKey, model.getValue(configValue).toString());
					}
				}
			}else if(StringUtils.equals(noneKey, InvoiceOpParamContant.BILLNO)) {
				//判断字段是否存在于当前页面
				if(model.getDataEntityType().getProperty(configValue) != null) {
					configParam.put(noneKey, model.getValue(configValue));
				}
			}else if(StringUtils.equals(noneKey, InvoiceOpParamContant.BILLTYPE)) {
				if (StringUtils.isNotBlank(configValue)) {
					DynamicObject billTypeDobj= BusinessDataServiceHelper.loadSingle(configValue, InvoiceOpParamContant.RIM_EXPENSE_TYPE, "number");
					if(billTypeDobj != null) {
						configValue = billTypeDobj.getString("number");
					}
				}
				//单据类型是基础资料
				configParam.put(noneKey, configValue);
			}else if(StringUtils.equals(noneKey, InvoiceOpParamContant.ORGID)){
				if(model.getDataEntityType().getProperty(configValue) != null) {
					configParam.put(noneKey, getDynamicObjectLongValue(model.getValue(configValue)));
				}
			}else {
				if(configValue != null) {
					configParam.put(noneKey, configValue);
				}
			}
		}
		extConfig(configParam, param);
		return configParam;
	}
	
	abstract List<String> getCustomConfigParam();
	
	/**
	 * 	打开采集发票页面
	 * @author 何雨秋 
	 * @date 2022-3-30 
	 * @param configParam
	 * @param result
	 */
	protected void excuteService(Map<String, Object> configParam, OperationResult result) {
		if(!result.isSuccess()) {
			return;
		}
		FormShowParameter param = new FormShowParameter();
		Map<String, Object> customParams = Maps.newHashMapWithExpectedSize(configParam.size());

		//单据id
		if(configParam.get(InvoiceOpParamContant.BILLID) != null) {
			customParams.put(InvoiceOpParamContant.BILLID, configParam.get(InvoiceOpParamContant.BILLID));
		}
		//单据标识
		if(configParam.get(InvoiceOpParamContant.ENTITYID) != null) {
			customParams.put(InvoiceOpParamContant.ENTITYID, configParam.get(InvoiceOpParamContant.ENTITYID));
		}
		//单据类型
		if(configParam.get(InvoiceOpParamContant.BILLTYPE) != null) {
			customParams.put(InvoiceOpParamContant.BILLTYPE, configParam.get(InvoiceOpParamContant.BILLTYPE));
		}
		//单据编码
		if(configParam.get(InvoiceOpParamContant.BILLNO) != null) {
			customParams.put(InvoiceOpParamContant.BILLNO, configParam.get(InvoiceOpParamContant.BILLNO));
		}
		//组织id
		if(configParam.get(InvoiceOpParamContant.ORGID) != null) {
			customParams.put(InvoiceOpParamContant.ORGID, configParam.get(InvoiceOpParamContant.ORGID));
		}
		//传入从操作打开标识
		customParams.put(InvoiceOpParamContant.ISOPERATION, Boolean.TRUE);
		
		//特殊字段
		Map<String, String> opVariables = this.getOption().getVariables();
		String delete = opVariables.get("delete");
		if(StringUtils.isNotBlank(delete)) {
			customParams.put("delete",  delete);
		}
		String resource= opVariables.get("resource");
		if(StringUtils.isNotBlank(resource)) {
			customParams.put("resource",  resource);
		}
		String sourceSys= opVariables.get("sourceSys");
		if(StringUtils.isNotBlank(sourceSys)) {
			customParams.put("sourceSys",  sourceSys);
		}
		
		extCustom(customParams, configParam);
		param.setCustomParams(customParams);
		setPageInfo(param);
		
		// 设置回调函数
		if(configParam.get(InvoiceOpParamContant.CALLBACKPLUGIN) != null) {
			if(configParam.get(InvoiceOpParamContant.CALLBACKPLUGIN) != null) {
				CloseCallBack closeCallBack = new CloseCallBack(configParam.get(InvoiceOpParamContant.CALLBACKPLUGIN).toString()
						, configParam.get(InvoiceOpParamContant.CALLBACK).toString());
				param.setCloseCallBack(closeCallBack);
			}else {
				result.setSuccess(false);
				this.getView().showTipNotification(this.getOperateName().getLocaleValue()+"失败，未获取到回调标识，请联系管理员");
			}
		}
		logger.info("【发票操作】请求参数：{}",JSONObject.toJSONString(customParams));
		this.getView().showForm(param);
	}
	
	protected void judgeCutomeParam(Map<String, Object> configParam, OperationResult result) {
		if(configParam.get(InvoiceOpParamContant.BILLID) == null) {
			this.getView().showTipNotification(this.getOperateName().getLocaleValue()+"失败，未获取到单据id，请联系管理员");
		}
		if(configParam.get(InvoiceOpParamContant.ENTITYID) == null){
			this.getView().showTipNotification(this.getOperateName().getLocaleValue()+"失败，未获取到单据实体id，请联系管理员");
		}
	}
	
	abstract void setPageInfo(FormShowParameter param);
	
	protected void extCustom(Map<String, Object> customParams, Map<String, Object> configParam) {
		
	}
	
	protected void extConfig(Map<String, Object> configParam, JSONObject param) {
		
	}
	
	private long getDynamicObjectLongValue(Object value) {
		try {
			if (value instanceof DynamicObject) {
				return Long.parseLong(((DynamicObject) value).getPkValue().toString());
			} else {
				return Long.parseLong(value.toString());
			}
		} catch (Exception e) {
			return 0L;
		}
	}
	
	private String exChange(String key) {
		String[] strArr = key.split("_");
		StringBuilder sb = new StringBuilder();
		sb.append(strArr[0]);
		for (int i = 1; i < strArr.length; i++) {
			String start = strArr[i].substring(0,1);
			String end = strArr[i].substring(1);
			start = start.toUpperCase();
			strArr[i] = start+end;
			sb.append(strArr[i]);
		}
		return sb.toString();
	}
}
