package kd.bos.ext.imc.operation.bizrule;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.imc.operation.contant.SaveImageConstant;
import kd.bos.ext.imc.operation.exception.ImcRimInvoiceBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

import java.util.Map;

/**
 * @ClassName DeleteImageAction
 * @Description TODO
 * @Author yuqiu_he
 * @Date 2023/9/27 18:58
 * @Version 1.0
 */
public class DeleteImageAction  extends AbstractOpBizRuleAction {
    private static Log logger = LogFactory.getLog(SaveInvoiceAction.class);

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String errorInfoFormat = ResManager.loadKDString("执行失败，原因：%s", "DelInvoiceAction_0", "bos-ext-imc");
        for (DynamicObject dataEntity : dataEntities) {
            try {
                executeService(dataEntity);
            }catch(Exception e2) {
                String errorInfo = String.format(errorInfoFormat, e.getOperationKey(), e2.getMessage());
                logger.error(errorInfo, e2);
                throw new KDBizException(e2, new ErrorCode("SaveInvoiceAction,afterExecuteOperationTransaction", errorInfo));
            }
        }
    }

    private void executeService(DynamicObject dataEntity) throws ImcRimInvoiceBizException {
        if(dataEntity.getPkValue() == null) {
            return;
        }
        //首先检查是否在操作中传递参数
        Map<String, String> opVariables = this.getOption().getVariables();
        logger.info("【发票操作】传入参数：{}",opVariables);
        String entryId = opVariables.get(SaveImageConstant.PARAM_KEY_BILL_TYPE);
        if(entryId == null) {
            entryId = dataEntity.getDynamicObjectType().getName();
        }
        String billId = opVariables.get(SaveImageConstant.PARAM_KEY_BILL_ID);
        if(billId == null) {
            billId = dataEntity.getPkValue().toString();
        }
        //获取初始化参数信息
        Map<String, Object> param = Maps.newHashMapWithExpectedSize(8);
        param.put(SaveImageConstant.PARAM_KEY_BILL_TYPE, entryId);
        param.put(SaveImageConstant.PARAM_KEY_BILL_ID, billId);
        logger.info("【发票云服务】保存服务，删除影像，请求参数：{}", JSON.toJSONString(param));
        Map<String, Object> rawResult = DispatchServiceHelper.invokeBizService("imc", "bds", "YXZSService", "deleteImage", new Object[]{param});
        logger.info("【发票云服务】保存服务，删除影像， 返回结果：{}", JSON.toJSONString(rawResult));
        if(!StringUtils.equals((String)rawResult.get("errcode"), "0000")) {
            throw new ImcRimInvoiceBizException("删除影像失败，"+rawResult.get("description")+"，请联系管理员");
        }
    }
}
