package kd.bos.ext.imc.operation.bizrule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.imc.operation.contant.SaveImageConstant;
import kd.bos.ext.imc.operation.exception.ImcRimInvoiceBizException;
import kd.bos.ext.imc.operation.util.CoverUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.ORM;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ClassName SaveImageAction
 * @Description TODO
 * @Author yuqiu_he
 * @Date 2023/9/21 16:38
 * @Version 1.0
 */
public class SaveImageAction extends AbstractOpBizRuleAction {

    private static Log logger = LogFactory.getLog(SaveImageAction.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        JSONObject config = JSONObject.parseObject(this.getBizRule().getParameter());
        List<String> paramKey = Lists.newArrayList("bill_no" ,"bill_id" ,"bill_user" ,"bill_company" ,"bill_image_no");
        e.getFieldKeys().addAll(paramKey.stream().map(v -> config.getString(v)).filter(v -> v != null).collect(Collectors.toList()));
    }

    @Override
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List<String> imgNoList = Lists.newArrayList();
        DynamicObject[] dataEntities = e.getDataEntities();
        //先保存影像编码
        JSONObject param = JSONObject.parseObject(this.getBizRule().getParameter());
        for (DynamicObject dataEntity : dataEntities) {
            long billid = (long)dataEntity.getPkValue();
            if(billid == 0L) {
                billid = ORM.create().genLongId(dataEntity.getDataEntityType());
                dataEntity.set("id", billid);
            }
            //没有创建的要先创建
            String imageNumber = getImageNumber(dataEntity.getDynamicObjectType().getName(), (long)dataEntity.getPkValue());
            //如果查询为空，则说明是新创建的
            if(StringUtils.isBlank(imageNumber)) {
                imageNumber = createImageNumber(e.getOperationKey(),dataEntity, param);
                imgNoList.add(imageNumber);
            }
        }
        if(!imgNoList.isEmpty()) {
            param.put("newImgNo", imgNoList);
            this.getBizRule().setParameter(param.toJSONString());
        }
    }

    @Override
    public void rollbackOperation(RollbackOperationArgs e) {
        JSONObject param = JSONObject.parseObject(this.getBizRule().getParameter());
        JSONArray imgNoList = param.getJSONArray("newImgNo");
        if(imgNoList != null) {
            for (int i = 0; i < imgNoList.size(); i++) {
                String imgNo = imgNoList.getString(i);
                delImgNo(imgNo);
            }
            param.remove("newImgNo");
            this.getBizRule().setParameter(param.toJSONString());
        }
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        JSONObject param = JSONObject.parseObject(this.getBizRule().getParameter());
        Map<String, String> paraMapKey = param.keySet().stream().collect(Collectors.toMap(v -> exChange(v), v -> v));
        DynamicObject[] dataEntities = evt.getDataEntities();
        List<DynamicObject> successList = Lists.newArrayListWithExpectedSize(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            try {
                excuteService(param, dataEntity, paraMapKey);
                successList.add(dataEntity);
            }catch (Exception e) {
                logger.info("【发票云服务】保存服务，错误日志：{}", e);
            }
        }
        evt.setDataEntities(successList.toArray(new DynamicObject[successList.size()]));
    }

    /**
     * 	执行保存发票服务
     * @author 何雨秋
     * @date 2022-4-11
     * @param param
     * @param dataEntity
     * @param paraMapKey
     * @throws ImcRimInvoiceBizException
     * @throws Exception
     */
    private void excuteService(JSONObject param, DynamicObject dataEntity, Map<String, String> paraMapKey) throws ImcRimInvoiceBizException,Exception{
        //将页面配置构造成参数
        Map<String, Object> configMap = initConfigParam(param, dataEntity, paraMapKey, true);
        logger.info("【发票云服务】保存影像服务，转换后的参数：{}",configMap);
        //调用发票云的保存服务
        saveInvoiceAndBill(configMap);
    }

    /**
     * 	执行保存发票服务
     * @author 何雨秋
     * @date 2022-4-11
     * @param configMap
     * @throws ImcRimInvoiceBizException
     * @throws Exception
     */
    private void saveInvoiceAndBill(Map<String, Object> configMap) throws ImcRimInvoiceBizException,Exception {
        Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(11);
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_TYPE, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_TYPE,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_NO, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_NO,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_ID, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_ID,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_USER, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_USER,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_COMPANY, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_COMPANY,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_IMAGE_NO, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_IMAGE_NO,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_RESOURCE, SaveImageConstant.PARAM_KEY_RESOURCE_SERVICE);
        paramMap.put(SaveImageConstant.PARAM_KEY_COVER_BASE64, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_COVER_BASE64,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_COVER_PATH, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_COVER_PATH,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_COVER_TYPE, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_COVER_TYPE,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_ATTACH_LIST, configMap.get(SaveImageConstant.PARAM_KEY_ATTACH_LIST));
        //附件面板
        paramMap.put(SaveImageConstant.PARAM_KEY_ATTACH_PANEL_KEY, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_ATTACH_PANEL_KEY,""));
        //影像模板
        paramMap.put(SaveImageConstant.PARAM_KEY_PRINT, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_PRINT,""));
        //表单
        paramMap.put(SaveImageConstant.PARAM_KEY_FORM_ID, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_FORM_ID,""));

        //同步AWS
        paramMap.put(SaveImageConstant.PARAM_KEY_SYNC_AWS, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_SYNC_AWS,SaveImageConstant.PARAM_KEY_SYNC_AWS_NO));

        if(configMap.get(SaveImageConstant.PARAM_KEY_ATTACH_LIST) == null) {
            paramMap.put(SaveImageConstant.PARAM_KEY_ATTACH_LIST, new JSONArray());
        }
        logger.info("【发票云服务】保存服务，推送影像，请求参数：{}", JSON.toJSONString(paramMap));
        Map<String, Object> rawResult = DispatchServiceHelper.invokeBizService("imc", "bds", "YXZSService", "saveImage", new Object[]{paramMap});
        logger.info("【发票云服务】保存服务，推送影像， 返回结果：{}", JSON.toJSONString(rawResult));
        if(!StringUtils.equals((String)rawResult.get("errcode"), "0000")) {
            throw new ImcRimInvoiceBizException("推送影像失败，"+rawResult.get("description")+"，请联系管理员");
        }
    }

    /**
     * 	操作传递进来的参数或单据页面获取对应的构造保存发票服务的参数
     * 	优先使用调用操作传递进来的参数
     * @author 何雨秋
     * @date 2022-4-11
     * @param param
     * @param dataEntity
     * @param paraMapKey
     * @return
     */
    private Map<String, Object> initConfigParam(JSONObject param, DynamicObject dataEntity, Map<String, String> paraMapKey, boolean createPdf) {
        //获取初始化参数信息
        Map<String, Object> configParam = Maps.newHashMapWithExpectedSize(8);

        //首先检查是否在操作中传递参数
        Map<String, String> opVariables = this.getOption().getVariables();
        logger.info("【发票云服务】保存服务，传入参数：{}",opVariables);
        logger.info("【发票云服务】保存服务，配置参数：{}",param.toJSONString());
        //挑选出参数中未传递的数据
        List<String> noneParam = Lists.newArrayListWithExpectedSize(getCustomConfigParam().size());
        for (String key : getCustomConfigParam()) {
            String value = opVariables.get(key);
            if(value != null) {
                configParam.put(key, value);
            }else {
                noneParam.add(key);
            }
        }

        //根据配置补全参数
        for (String noneKey : noneParam) {
            String configValue = param.getString(paraMapKey.get(noneKey));
            if(StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_ID)) {
                if(StringUtils.equals(configValue, "id")) {
                    //获取单据id
                    configParam.put(noneKey, dataEntity.getPkValue().toString());
                }else {
                    if(dataEntity.getDynamicObjectType().getProperty(configValue) != null) {
                        configParam.put(noneKey, dataEntity.get(configValue));
                    }
                }
            }else if(StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_IMAGE_NO)){
                if(dataEntity.getDynamicObjectType().getProperty(configValue) != null) {
                    String imageNumber = getImageNumber(dataEntity.getDynamicObjectType().getName(), (long)dataEntity.getPkValue());
                    dataEntity.set(configValue,imageNumber);
                    configParam.put(noneKey, imageNumber);
                }
            }else if(StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_NO)){
                //判断字段是否存在于当前页面
                if(dataEntity.getDynamicObjectType().getProperty(configValue) != null) {
                    configParam.put(noneKey, dataEntity.get(configValue));
                }
            }else if(StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_TYPE)) {
                if (StringUtils.isNotBlank(configValue)) {
                    DynamicObject billTypeDobj= BusinessDataServiceHelper.loadSingle(configValue, "rim_expense_type", "number");
                    configValue = billTypeDobj.getString("number");
                }
                //单据类型是基础资料
                configParam.put(noneKey, configValue);
            }else if(StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_USER)
                    || StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_COMPANY)){
                if(dataEntity.getDynamicObjectType().getProperty(configValue) != null) {
                    configParam.put(noneKey, getDynamicObjectLongValue(dataEntity.getDynamicObject(configValue)));
                }
            }else if(configValue != null) {
                configParam.put(noneKey, configValue);
            }
        }
        //影像模板不为空，则生成封面
        if(StringUtils.isNotBlank(param.getString(SaveImageConstant.PARAM_KEY_PRINT))) {
            createPdf(param, dataEntity, configParam);
        }
        //附件面板标识不为空，则生成附件
        if(StringUtils.isNotBlank(configParam.get(SaveImageConstant.PARAM_KEY_ATTACH_PANEL_KEY))) {
            getAttachment(param, dataEntity, configParam);
        }
        //是否自动获取附件信息
        return configParam;
    }

    private void getAttachment(JSONObject param, DynamicObject dataEntity,Map<String, Object> configParam){
        JSONArray attachArr = new JSONArray();
        String attachPanelKey =  (String)configParam.get(SaveImageConstant.PARAM_KEY_ATTACH_PANEL_KEY);
        String formId = dataEntity.getDynamicObjectType().getName();
        List<Map<String, Object>> attachList = AttachmentServiceHelper.getAttachments(formId, dataEntity.getPkValue(), attachPanelKey);
        for (Map<String, Object> attach : attachList) {
            JSONObject attachInfo = new JSONObject();
            String url = (String)attach.get("relativeUrl");
            if(StringUtils.isBlank(url)){
                url = (String)attach.get("url");
            }
            attachInfo.put(SaveImageConstant.PARAM_KEY_FILE_PATH, url);//文件服务器path
            attachInfo.put(SaveImageConstant.PARAM_KEY_FILE_NAME,attach.get("name"));//文件名
            attachInfo.put(SaveImageConstant.PARAM_KEY_FILE_EXT,attach.get("type"));//扩展名
            attachArr.add(attachInfo);
        }
        configParam.put(SaveImageConstant.PARAM_KEY_ATTACH_PANEL_KEY, attachPanelKey);
        configParam.put(SaveImageConstant.PARAM_KEY_ATTACH_LIST, attachArr);
        configParam.put(SaveImageConstant.PARAM_KEY_FORM_ID, formId);
    }
    private void createPdf(JSONObject param, DynamicObject dataEntity,Map<String, Object> configParam) {
        //判断是否需要生成封面
        if(!needCreatePdf(param)) {
            logger.info("【发票云服务】保存服务，无需生成封面");
            return;
        }
        //获取影像封面，暂不支持自定义的封面模板
        String templateFormId = param.getString(SaveImageConstant.PARAM_KEY_PRINT);
        if(StringUtils.isNotBlank(templateFormId)) {
            String formId = dataEntity.getDynamicObjectType().getName();
            String imageNumber = getImageNumber(formId, (long)dataEntity.getPkValue());
            //先判断是否创建影像编号
            if(StringUtils.isNotBlank(imageNumber)){
                byte[] imagePdf = CoverUtils.createSinglePdf("", templateFormId, formId, dataEntity.getPkValue());
                if(imagePdf != null && imagePdf.length > 0) {
                    String base64Str = new String( Base64.getEncoder().encode(imagePdf));
                    configParam.put(SaveImageConstant.PARAM_KEY_COVER_BASE64, base64Str);
                    configParam.put(SaveImageConstant.PARAM_KEY_COVER_TYPE, "pdf");
                    configParam.put(SaveImageConstant.PARAM_KEY_PRINT, templateFormId);
                } else {
                    logger.info("【发票云服务】保存服务，未获取到pdf文件流");
                }
            }else{
                logger.info("【发票云服务】保存服务，未获取到影像编号");
            }
        }
    }

    private boolean needCreatePdf(JSONObject param) {
        return StringUtils.isNotBlank(param.getString("print"));
    }




    /**
     * 获取单据对应的影像编码
     */
    private String getImageNumber(String entityName, Long billId) {
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setBillId(String.valueOf(billId));
        imageInfo.setBilltype(entityName);

        logger.info("getImageNumber param: " + entityName + ", " + billId);
        ImageInfo result = kd.bos.servicehelper.image.ImageServiceHelper.getImageInfoInside(imageInfo);
        if(result == null) {
            logger.info("【发票云服务】保存服务，影像编码未查询到");
            return "";
        }
        logger.info("【发票云服务】保存服务，影像编码: {}", result.getImageNo());
        return result.getImageNo();
    }

    private String createImageNumber(String opKey, DynamicObject dataEntity, JSONObject param) {
        String imageNum = "";
        try {
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setBillId(dataEntity.getPkValue().toString());//单据id
            imageInfo.setBillNo(dataEntity.getString(param.getString("bill_no")));//单据编码
            imageInfo.setCreator(""+getDynamicObjectLongValue(dataEntity.getDynamicObject(param.getString("bill_user"))));//提单人id
            imageInfo.setBilltype(dataEntity.getDynamicObjectType().getName());//表单标识
            imageInfo.setOrgId(""+getDynamicObjectLongValue(dataEntity.getDynamicObject(param.getString("bill_company"))));//提单人所在组织
            imageNum = ImageServiceHelper.createImageInfo(imageInfo);
            logger.info("【发票云服务】保存服务，推送发票影像数据前创建影像编码成功：{}", imageNum);
        }catch (Exception e){
            showKDBizException(opKey, e);
            logger.info("【发票云服务】保存服务，推送发票影像数据前创建影像编码失败,异常类型：{}", e);
        }
        if(StringUtils.isNotBlank(param.getString("bill_image_no"))
                && dataEntity.getDynamicObjectType().getProperty(param.getString("bill_image_no")) != null) {
            dataEntity.set(param.getString("bill_image_no"), imageNum);
        }
        return imageNum;
    }

    /**
     * 	获取基础资料主键id
     * @author 何雨秋
     * @date 2022-4-11
     * @param value
     * @return
     */
    private long getDynamicObjectLongValue(Object value) {
        try {
            if (value instanceof DynamicObject) {
                return Long.parseLong(((DynamicObject) value).getPkValue().toString());
            } else {
                return Long.parseLong(value.toString());
            }
        } catch (Exception e) {
            return 0L;
        }
    }
    /**
     * 	获取接口参数
     * @author rd_yuqiu_he
     * @date 2022-4-8
     * @return
     */
    private List<String> getCustomConfigParam() {
        return Lists.newArrayList(SaveImageConstant.PARAM_KEY_BILL_TYPE, SaveImageConstant.PARAM_KEY_BILL_NO, SaveImageConstant.PARAM_KEY_BILL_ID,
                SaveImageConstant.PARAM_KEY_BILL_USER, SaveImageConstant.PARAM_KEY_BILL_COMPANY, SaveImageConstant.PARAM_KEY_BILL_IMAGE_NO,
                SaveImageConstant.PARAM_KEY_COVER_BASE64, SaveImageConstant.PARAM_KEY_COVER_PATH, SaveImageConstant.PARAM_KEY_COVER_TYPE,
                SaveImageConstant.PARAM_KEY_ATTACH_PANEL_KEY,SaveImageConstant.PARAM_KEY_ATTACH_LIST, SaveImageConstant.PARAM_KEY_NEED_COVER,
                SaveImageConstant.PARAM_KEY_NEED_ATTACH, SaveImageConstant.PARAM_KEY_SYNC_AWS);
    }

    /**
     * 	包装KDEX的错误信息
     * @author 何雨秋
     * @date 2022-4-11
     * @param opKey
     * @param e
     */
    private void showKDBizException(String opKey, Exception e) {
        logger.error("【发票云服务】保存服务，错误日志：", e);
        String errorInfoFormat = ResManager.loadKDString("执行%s失败，原因：%s", "SaveInvoiceAction_2", "bos-ext-imc");
        String errorInfo = String.format(errorInfoFormat, getServiceName(opKey), e.getMessage());
        throw new KDBizException(e, new ErrorCode("SaveInvoiceAction,afterExecuteOperationTransaction", errorInfo));
    }

    /**
     * 	获取当前操作的多语言文字
     * @author 何雨秋
     * @date 2022-4-11
     * @param opKey
     * @return
     */
    private String getServiceName(String opKey){
        String serviceName = opKey;
        if(this.operateMeta.get("name") != null && this.operateMeta.get("name") instanceof Map) {
            serviceName = LocaleString.fromMap((Map)this.operateMeta.get("name")).getLocaleValue();
        }
        return serviceName;
    }

    /**
     * 	因页面无法写成大写，则在多单词之间增加下划线_，在此进行转换
     * 	例：bill_id = billId
     * @author 何雨秋
     * @date 2022-4-11
     * @param key
     * @return
     */
    private String exChange(String key) {
        String[] strArr = key.split("_");
        StringBuilder sb = new StringBuilder();
        sb.append(strArr[0]);
        for (int i = 1; i < strArr.length; i++) {
            String start = strArr[i].substring(0,1);
            String end = strArr[i].substring(1);
            start = start.toUpperCase();
            strArr[i] = start+end;
            sb.append(strArr[i]);
        }
        return sb.toString();
    }

    private void delImgNo(String imageNo) {
        try (TXHandle h = TX.requiresNew()) {
            try {
                String userName = RequestContext.get().getUserName();
                ImageServiceHelper.deleteImage(imageNo, userName, null);
            } catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }
}
