/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.nocode.model;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.permission.nocode.model.DataRuleTypeEnum;
import kd.bos.permission.nocode.model.PermResult;

public class DataRule
extends PermResult {
    private long id;
    private String noCodeRule;
    private DataRuleTypeEnum type = DataRuleTypeEnum.ALL;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getNoCodeRule() {
        return this.noCodeRule;
    }

    public void setNoCodeRule(String noCodeRule) {
        this.noCodeRule = noCodeRule;
    }

    public DataRuleTypeEnum getType() {
        return this.type;
    }

    public void setType(@NotNull DataRuleTypeEnum type) {
        this.type = type;
    }

    public String toNoCodeRuleField() {
        HashMap<String, String> ruleMap = new HashMap<String, String>(2);
        if (this.type == DataRuleTypeEnum.ALL || StringUtils.isBlank((CharSequence)this.noCodeRule)) {
            ruleMap.put("rule", "");
        } else {
            ruleMap.put("rule", this.noCodeRule);
        }
        ruleMap.put("type", this.type.getValue());
        return SerializationUtils.toJsonString(ruleMap);
    }

    public void parseNoCodeRule(String noCodeRuleValue) {
        DataRule.parseNoCodeRule(noCodeRuleValue, this);
    }

    public static DataRule toDataRule(String noCodeRuleValue) {
        DataRule dataRule = new DataRule();
        DataRule.parseNoCodeRule(noCodeRuleValue, dataRule);
        return dataRule;
    }

    private static void parseNoCodeRule(String noCodeRuleValue, DataRule dataRule) {
        Map ruleMap;
        if (StringUtils.isBlank((CharSequence)noCodeRuleValue)) {
            dataRule.setNoCodeRule("");
            dataRule.setType(DataRuleTypeEnum.ALL);
            return;
        }
        try {
            ruleMap = (Map)SerializationUtils.fromJsonString((String)noCodeRuleValue, Map.class);
        }
        catch (Exception e) {
            return;
        }
        dataRule.setNoCodeRule((String)ruleMap.get("rule"));
        dataRule.setType(DataRuleTypeEnum.of((String)ruleMap.get("type")));
    }

    public String toString() {
        return "DataRule{id=" + this.id + ", noCodeRule='" + this.noCodeRule + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }
}

