/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.workflow.engine.task.OperateResult;
import kd.bos.workflow.engine.task.TaskOperateResult;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang.StringUtils;

@KSObject
@SdkPublic
public class BatchOperateResult
implements Serializable,
TaskOperateResult {
    private static final long serialVersionUID = -3164829046442403417L;
    private String validateMsg;
    private int sucessCount;
    private int failedCount;
    private List<OperateResult> operateResults = new ArrayList<OperateResult>();

    public BatchOperateResult() {
    }

    public BatchOperateResult(String validateMsg, int sucessCount, int failedCount, List<OperateResult> operateResults) {
        this.validateMsg = validateMsg;
        this.sucessCount = sucessCount;
        this.failedCount = failedCount;
        this.operateResults = operateResults;
    }

    @KSMethod
    public boolean isSuccess() {
        return this.failedCount == 0;
    }

    @KSMethod
    public int getSucessCount() {
        return this.sucessCount;
    }

    @KSMethod
    public void setSucessCount(int sucessCount) {
        this.sucessCount = sucessCount;
    }

    @KSMethod
    public int getFailedCount() {
        return this.failedCount;
    }

    @KSMethod
    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    @KSMethod
    public List<OperateResult> getOperateResults() {
        return this.operateResults;
    }

    @KSMethod
    public void setOperateResults(List<OperateResult> operateResults) {
        this.operateResults = operateResults;
    }

    @KSMethod
    public String getValidateMsg() {
        return this.validateMsg;
    }

    @KSMethod
    public void setValidateMsg(String validateMsg) {
        this.validateMsg = validateMsg;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        if (StringUtils.isNotEmpty((String)String.valueOf(this.sucessCount))) {
            info.append("success: ").append(this.sucessCount).append(", ");
        }
        if (StringUtils.isNotEmpty((String)String.valueOf(this.failedCount))) {
            info.append("failed: ").append(this.failedCount).append(", ");
        }
        if (StringUtils.isNotEmpty((String)this.validateMsg)) {
            info.append("message: ").append(this.validateMsg).append(", ");
        }
        StringBuilder detailsInfo = new StringBuilder();
        for (int i = 0; i < this.operateResults.size(); ++i) {
            detailsInfo.append("{").append(this.operateResults.get(i).toString()).append("}");
            if (i >= this.operateResults.size() - 1) continue;
            detailsInfo.append(", ");
        }
        if (StringUtils.isNotEmpty((String)detailsInfo.toString())) {
            info.append("detailsInfo:[").append((CharSequence)detailsInfo).append("]").append(", ");
        }
        return info.substring(0, info.length() - 2);
    }
}

