/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.facade.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BaseFacade {
    private static Map<String, List<String>> facadeImplClass = new HashMap<String, List<String>>();
    private static Log log = LogFactory.getLog(BaseFacade.class);
    private static final String osName = "os.name";
    private static final String classPath = "java.class.path";

    protected List<String> getRegisterClassByExpenPoint(String classExt) {
        log.debug("facadeImplClass size :" + facadeImplClass.size());
        return facadeImplClass.get(classExt);
    }

    public static boolean isLinux() {
        return System.getProperty(osName).toLowerCase().contains("linux");
    }

    private static void initFacadeImpl() {
        ArrayList<String> entityClass = new ArrayList<String>();
        entityClass.add("kd.bos.service.botp.facade.OperateBfFacade");
        entityClass.add("kd.bos.service.ctbotp.facade.OperateSyncFacade");
        entityClass.add("kd.bos.ca.operate.SignEntityOperateFacade");
        entityClass.add("kd.bos.permission.domainsplit.entity.PermEntityFacadeImpl");
        entityClass.add("kd.bos.workflow.facade.EntityFacadeForWorkflowImpl");
        facadeImplClass.put("EntityOperateService", entityClass);
        ArrayList<String> formClass = new ArrayList<String>();
        formClass.add("kd.bos.ca.operate.SignFormOperateFacade");
        formClass.add("kd.bos.permission.domainsplit.form.PermFormFacadeImpl");
        formClass.add("kd.bos.login.auth.OpSecondConfirmFacade");
        facadeImplClass.put("FormOperateService", formClass);
        ArrayList<String> metaDataClass = new ArrayList<String>();
        metaDataClass.add("kd.bos.workflow.facade.MetadataWriterFacadeForWorkflowImpl");
        facadeImplClass.put("MetadataWriterService", metaDataClass);
    }

    public static void registerFacadeImpl(String classfly, List<String> impls) {
        List<String> result = facadeImplClass.get(classfly);
        if (result == null && impls != null && impls.size() > 0) {
            facadeImplClass.put(classfly, impls);
            log.info("facade addFacadeImpl null:" + classfly);
        } else if (result != null) {
            for (String impl : impls) {
                if (result.contains(impl)) continue;
                result.add(impl);
                log.info("facade addFacadeImpl put:" + impl);
            }
        } else {
            log.info("facade addFacadeImpl error!");
        }
    }

    public static InputStream loadResourceFromJarFile(String jarPath, String resPath) {
        if (!jarPath.endsWith(".jar")) {
            return null;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarPath);
            JarEntry jarEntry = jarFile.getJarEntry(resPath);
            if (jarEntry == null) {
                return null;
            }
            return jarFile.getInputStream(jarEntry);
        }
        catch (IOException e) {
            log.error("loadResourceFromJarFile " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        BaseFacade.initFacadeImpl();
        String splitChar = ":";
        splitChar = BaseFacade.isLinux() ? ":" : ";";
        String[] cps = System.getProperty(classPath).split(splitChar);
        if (cps == null) {
            log.info("facade java.class.path is null");
        } else {
            log.info("facade java.class.path :" + cps.length);
        }
        String resourcePath = "bos-facade.properties";
        try {
            for (String cp : cps) {
                if (!cp.endsWith(".jar")) {
                    log.info("facade java.class.path endsWith:" + cp);
                    continue;
                }
                InputStream in = BaseFacade.loadResourceFromJarFile(cp, resourcePath);
                if (in == null) continue;
                try {
                    log.info("facade loadResourceFromJarFile has info:" + cp);
                    Properties prop = new Properties();
                    prop.load(new InputStreamReader(in, "utf-8"));
                    Enumeration<?> enums = prop.propertyNames();
                    while (enums.hasMoreElements()) {
                        String val;
                        String key = (String)enums.nextElement();
                        if (key.indexOf("_") < 0) continue;
                        String subKey = key.split("_")[0];
                        List<String> result = facadeImplClass.get(subKey);
                        if (result == null) {
                            result = new ArrayList<String>();
                            facadeImplClass.put(subKey, result);
                        }
                        if (result.contains(val = prop.getProperty(key))) continue;
                        result.add(val);
                        log.info("facade facadeImplClass put:" + val);
                    }
                }
                finally {
                    in.close();
                }
            }
        }
        catch (Exception e) {
            log.error("load jar error! " + e.getMessage());
        }
    }
}

