/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.api.bean;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.license.api.bean.CloudUserBaseInfo;
import kd.bos.license.api.bean.ProductGroup;

public class CloudUserInfo
extends CloudUserBaseInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8965060269444555124L;
    private String productInstanceID = null;
    private String department;
    private String prod_group = "";
    private Map<String, ProductGroup> mpGroups = new HashMap<String, ProductGroup>();
    private List<Map<String, String>> inst_detail;

    public String getProductInstanceID() {
        return this.productInstanceID;
    }

    public void setProductInstanceID(String productInstanceID) {
        this.productInstanceID = productInstanceID;
    }

    public Map<String, ProductGroup> getMpGroups() {
        return this.mpGroups;
    }

    public void setMpGroups(Map<String, ProductGroup> mpGroups) {
        this.mpGroups = mpGroups;
        if (mpGroups == null) {
            this.prod_group = "";
        } else {
            for (String group : mpGroups.keySet()) {
                if (StringUtils.isEmpty((CharSequence)group)) continue;
                if (StringUtils.isEmpty((CharSequence)this.prod_group)) {
                    this.prod_group = group;
                    continue;
                }
                if (this.prod_group.contains(group)) continue;
                this.prod_group = this.prod_group + ";" + group;
            }
        }
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getProd_group() {
        return this.prod_group;
    }

    public void setProd_group(String prod_group) {
        this.prod_group = prod_group;
        if (prod_group == null || prod_group.trim().length() == 0) {
            this.mpGroups.clear();
            return;
        }
        for (String groupnumber : prod_group.split(";")) {
            ProductGroup pgroup = this.mpGroups.get(groupnumber);
            if (pgroup != null) continue;
            pgroup = new ProductGroup(groupnumber);
            this.mpGroups.put(groupnumber, pgroup);
        }
    }

    public String mergeGroupName(CloudUserInfo cui) {
        if (cui == null) {
            return this.prod_group;
        }
        return this.mergeGroupName(cui.getProd_group());
    }

    public String mergeGroupName(String groupName2) {
        if (groupName2 == null) {
            return this.prod_group;
        }
        String groupName1 = this.getProd_group();
        if (groupName1 == null) {
            this.prod_group = groupName2;
            return this.prod_group;
        }
        String[] spGroup2 = groupName2.split(";");
        for (int i = 0; i < spGroup2.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)groupName1)) {
                groupName1 = spGroup2[i];
                continue;
            }
            if (groupName1.indexOf(spGroup2[i]) >= 0) continue;
            groupName1 = groupName1 + ";" + spGroup2[i];
        }
        this.prod_group = groupName1;
        return this.prod_group;
    }

    public void setInstDetail(List<Map<String, String>> inst_detail) {
        this.inst_detail = inst_detail;
    }

    public List<Map<String, String>> getInstDetail() {
        return this.inst_detail;
    }
}

