/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;

public abstract class AbstractWebApi
implements IBillWebApiPlugin {
    private static final String PARAM_KEY_NUMBERS = "numbers";
    private static final String API_URL_PREFIX = "kapi";
    protected static final String SYSTEM_TYPE = "bos-base-webapi";

    protected Map<String, Long> getNumber2IdMapping(String entity, Set<String> numbers) {
        if (CollectionUtils.isEmpty(numbers)) {
            return Collections.emptyMap();
        }
        QFilter filter = new QFilter("number", "in", numbers);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entity, (String)"id,number", (QFilter[])new QFilter[]{filter});
        if (null == dynamicObjects || dynamicObjects.length <= 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> result = new HashMap<String, Long>(numbers.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            result.put(dynamicObject.getString("number"), dynamicObject.getLong("id"));
        }
        return result;
    }

    protected Map<Long, String> generateId2NumberMapping(Set<Long> ids, String entity) {
        HashMap<Long, String> idToNumberMap = new HashMap<Long, String>(ids.size());
        if (!ids.isEmpty()) {
            DynamicObjectCollection collection = QueryServiceHelper.query((String)entity, (String)"id,number", (QFilter[])new QFilter("id", "in", ids).toArray());
            collection.forEach(data -> idToNumberMap.put(data.getLong("id"), data.getString("number")));
        }
        return idToNumberMap;
    }

    protected Set<String> getNumbersFromRequestParam(Map<String, Object> params) {
        Object numberParams = params.get(PARAM_KEY_NUMBERS);
        if (Objects.isNull(numberParams)) {
            return Collections.emptySet();
        }
        List list = (List)numberParams;
        return list.stream().map(Object::toString).collect(Collectors.toCollection(() -> new HashSet(list.size())));
    }

    protected Set<Object> getIdsFromRequestParam(Map<String, Object> params, String paramKey) {
        Object orgIdParams = params.get(paramKey);
        if (Objects.isNull(orgIdParams)) {
            return Collections.emptySet();
        }
        return new HashSet<Object>((ArrayList)orgIdParams);
    }

    protected List<String> validateNumbers(Map<String, Object> params) throws IOException {
        Object param = params.get(PARAM_KEY_NUMBERS);
        if (Objects.isNull(param)) {
            throw new InvalidParameterException(ResManager.loadKDString((String)"\u53c2\u6570numbers\u4e0d\u5b58\u5728\u3002", (String)"AbstractWebApi_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        List numbers = (List)JSONUtils.cast((String)param.toString(), List.class, (Class[])new Class[]{String.class});
        if (CollectionUtils.isEmpty((Collection)numbers)) {
            throw new InvalidParameterException(ResManager.loadKDString((String)"\u53c2\u6570numbers\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"AbstractWebApi_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        return numbers;
    }

    protected String getRequestUrl() {
        RequestContext context = RequestContext.get();
        String clientUrl = context.getClientUrl();
        return StringUtils.substringAfterLast((String)clientUrl, (String)API_URL_PREFIX);
    }
}

