/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.org;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.base.AbstractWebApi;
import kd.bos.base.org.pojo.FailData;
import kd.bos.base.org.pojo.FullNameOrgResult;
import kd.bos.base.org.pojo.OrgApiResult;
import kd.bos.base.org.pojo.OrgMultiView;
import kd.bos.base.org.pojo.OrgResponseData;
import kd.bos.base.org.pojo.Organization;
import kd.bos.base.org.pojo.Region;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.CompanyParam;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class OrgApi
extends AbstractWebApi {
    private static final Log LOGGER = LogFactory.getLog(OrgApi.class);
    private static final String API_URL_ORGS_QUERY_BY_NUMBERS = "/app/base/org_query";
    private static final String API_URL_ORGS_ADD_BY_FULL_NAME = "/app/base/orgs";
    private static final String API_URL_ORGS_FREEZE = "/app/base/org_freeze";
    private static final String API_URL_ORGS_UN_FREEZE = "/app/base/org_unfreeze";
    private static final String API_URL_ORGS_ADD = "/app/base/org_add";
    private static final String API_URL_ORGS_UPDATE = "/app/base/org_update";
    private static final String API_URL_ORGS_QUERY_BY_BIZ = "/app/base/org_query_biz";
    private static final String API_URL_ORG_DELETE_BIZ = "/app/base/org_biz_delete";
    private static final String API_URL_ORG_ADD_BIZ = "/app/base/org_biz_add";
    private static final String PARAM_KEY_ORG = "orgs";
    private static final String PARAM_KEY_ORG_IDS = "orgIds";
    private static final String PARAM_KEY_BIZ_ID = "bizId";
    private static final String PARAM_KEY_BIZ_NUMBER = "bizNumber";
    private static final String PARAM_KEY_ORG_FREEZE = "freeze";
    private static final String ENTITY_KEY_BOS_ORG = "bos_adminorg";
    private static final String ENTITY_KEY_BOS_ORG_STRUCTURE = "bos_adminorg_structure";
    private static final String ENTITY_KEY_BOS_ORG_PATTERN = "bos_org_pattern";
    private static final String ENTITY_KEY_BD_TIMEZONE = "inte_timezone";
    private static final String ENTITY_KEY_BD_ADMIN_DIVISION = "bd_admindivision";
    private static final String ENTITY_KEY_BD_COUNTRY = "bd_country";
    private static final String FILED_COUNTRY = "country";
    private static final String ENTITY_KEY_OPEN_API_SERVICE_NEW = "open_apiservice_new";
    private static final String ORG_AUTHOR_FILTER = "org_author_filter";
    private static final String APP_ID = "base";

    public ApiResult doCustomService(Map<String, Object> params) {
        String apiUrl;
        switch (apiUrl = this.getRequestUrl()) {
            case "/app/base/org_add": {
                return this.batchAddOrganizations(params);
            }
            case "/app/base/org_update": {
                return this.batchUpdateOrganizations(params);
            }
            case "/app/base/org_query": {
                return this.queryOrgsBaseInfoByNumbers(params);
            }
            case "/app/base/orgs": {
                return this.addOrgsByFullName(params);
            }
            case "/app/base/org_freeze": {
                return this.freezeOrganizations(params);
            }
            case "/app/base/org_unfreeze": {
                return this.unfreezeOrganizations(params);
            }
            case "/app/base/org_biz_delete": {
                return this.deleteOrgBiz(params);
            }
            case "/app/base/org_biz_add": {
                return this.batchAddOrgBiz(params);
            }
            case "/app/base/org_query_biz": {
                return this.queryOrganizationByOrgBiz(params);
            }
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5b58\u5728", (String)"OrgApi_0", (String)"bos-base-webapi", (Object[])new Object[0]), (String)"404");
    }

    private ApiResult batchAddOrganizations(Map<String, Object> params) {
        String checkOpenApiPermissionResult = this.checkOpenApiPermission("org_add", null);
        if (StringUtils.isNotEmpty((String)checkOpenApiPermissionResult)) {
            return ApiResult.fail((String)checkOpenApiPermissionResult);
        }
        try {
            ArrayList<OrgParam> validateFailOrgs = new ArrayList<OrgParam>(10);
            List<OrgParam> organizations = this.packAddOrUpdateOrgParams(params, validateFailOrgs);
            OrgApiResult response = new OrgApiResult();
            this.packResponse(validateFailOrgs, response);
            if (!organizations.isEmpty()) {
                OrgUnitServiceHelper.add(organizations);
                this.packResponse(organizations, response);
            }
            return ApiResult.success((Object)response);
        }
        catch (Exception e) {
            LOGGER.warn(String.format(ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"OrgApi_2", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"OrgApi_2", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private ApiResult batchUpdateOrganizations(Map<String, Object> params) {
        String checkOpenApiPermissionResult = this.checkOpenApiPermission("org_update", null);
        if (StringUtils.isNotEmpty((String)checkOpenApiPermissionResult)) {
            return ApiResult.fail((String)checkOpenApiPermissionResult);
        }
        try {
            ArrayList<OrgParam> validateFails = new ArrayList<OrgParam>(10);
            List<OrgParam> organizations = this.packAddOrUpdateOrgParams(params, validateFails);
            OrgApiResult response = new OrgApiResult();
            this.packResponse(validateFails, response);
            if (!organizations.isEmpty()) {
                OrgUnitServiceHelper.update(organizations);
                this.packResponse(organizations, response);
            }
            return ApiResult.success((Object)response);
        }
        catch (Exception e) {
            LOGGER.warn(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"OrgApi_4", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4fee\u6539\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"OrgApi_4", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private ApiResult batchAddOrgBiz(Map<String, Object> params) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.addDuty(null);
        return null;
    }

    private ApiResult deleteOrgBiz(Map<String, Object> params) {
        return null;
    }

    private ApiResult unfreezeOrganizations(Map<String, Object> params) {
        String checkOpenApiPermissionResult = this.checkOpenApiPermission("org_unfreeze", null);
        if (StringUtils.isNotEmpty((String)checkOpenApiPermissionResult)) {
            return ApiResult.fail((String)checkOpenApiPermissionResult);
        }
        try {
            OrgApiResult response = new OrgApiResult();
            ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(10);
            boolean existOrgIds = this.validateOrgIdFromRequestParam(params, paramList, response);
            boolean existOrgNumbers = this.validateOrgNumberFromRequestParam(params, paramList, response);
            if (!existOrgIds && !existOrgNumbers) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u7ec4\u7ec7id\u548c\u7f16\u7801\u90fd\u4e0d\u5b58\u5728\uff0c\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u89e3\u5c01\u7ec4\u7ec7\u6267\u884c\u5931\u8d25\u3002", (String)"OrgApi_5", (String)"bos-base-webapi", (Object[])new Object[0]), (String)"501");
            }
            if (paramList.isEmpty()) {
                return ApiResult.success((Object)response);
            }
            OrgUnitServiceHelper.unFreeze(paramList);
            this.packResponse(paramList, response);
            return ApiResult.success((Object)response);
        }
        catch (Exception e) {
            LOGGER.warn(String.format(ResManager.loadKDString((String)"\u89e3\u5c01\u7ec4\u7ec7\u5931\u8d25\uff1a%s", (String)"OrgApi_7", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u89e3\u5c01\u7ec4\u7ec7\u5931\u8d25\uff1a%s", (String)"OrgApi_7", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private ApiResult freezeOrganizations(Map<String, Object> params) {
        String checkOpenApiPermissionResult = this.checkOpenApiPermission("org_freeze", null);
        if (StringUtils.isNotEmpty((String)checkOpenApiPermissionResult)) {
            return ApiResult.fail((String)checkOpenApiPermissionResult);
        }
        try {
            OrgApiResult response = new OrgApiResult();
            ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(10);
            boolean existOrgIds = this.validateOrgIdFromRequestParam(params, paramList, response);
            boolean existOrgNumbers = this.validateOrgNumberFromRequestParam(params, paramList, response);
            if (!existOrgIds && !existOrgNumbers) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u7ec4\u7ec7id\u548c\u7f16\u7801\u90fd\u4e0d\u5b58\u5728\uff0c\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u5c01\u5b58\u7ec4\u7ec7\u6267\u884c\u5931\u8d25\u3002", (String)"OrgApi_8", (String)"bos-base-webapi", (Object[])new Object[0]), (String)"501");
            }
            if (paramList.isEmpty()) {
                return ApiResult.success((Object)response);
            }
            OrgUnitServiceHelper.freeze(paramList);
            this.packResponse(paramList, response);
            return ApiResult.success((Object)response);
        }
        catch (Exception e) {
            LOGGER.warn(String.format(ResManager.loadKDString((String)"\u5c01\u5b58\u7ec4\u7ec7\u5931\u8d25\uff1a%s", (String)"OrgApi_10", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u5c01\u5b58\u7ec4\u7ec7\u5931\u8d25\uff1a%s", (String)"OrgApi_10", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private boolean validateOrgIdFromRequestParam(Map<String, Object> params, List<OrgParam> paramList, OrgApiResult response) {
        Set<Object> ids = this.getIdsFromRequestParam(params, PARAM_KEY_ORG_IDS);
        if (CollectionUtils.isEmpty(ids)) {
            return false;
        }
        for (Object id : ids) {
            try {
                OrgParam org = new OrgParam();
                org.setId(Long.parseLong(id.toString()));
                paramList.add(org);
            }
            catch (Exception e) {
                LOGGER.warn(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7ID\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a%s", (String)"OrgApi_11", (String)"bos-base-webapi", (Object[])new Object[0]), id), (Throwable)e);
                OrgResponseData failData = new OrgResponseData();
                failData.setId(id);
                failData.setReason(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7ID\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a%s", (String)"OrgApi_11", (String)"bos-base-webapi", (Object[])new Object[0]), id));
                response.addFailData(failData);
            }
        }
        return true;
    }

    private boolean validateOrgNumberFromRequestParam(Map<String, Object> params, List<OrgParam> paramList, OrgApiResult response) {
        Set<String> numbers = this.getNumbersFromRequestParam(params);
        if (CollectionUtils.isEmpty(numbers)) {
            return false;
        }
        QFilter filter = new QFilter("number", "in", numbers);
        DynamicObjectCollection organizations = QueryServiceHelper.query((String)ENTITY_KEY_BOS_ORG, (String)"id,number", (QFilter[])filter.toArray());
        for (DynamicObject org : organizations) {
            String number = org.getString("number");
            OrgParam param = new OrgParam();
            param.setId(org.getLong("id"));
            param.setNumber(number);
            paramList.add(param);
            numbers.remove(number);
        }
        if (!numbers.isEmpty()) {
            for (String number : numbers) {
                OrgResponseData failData = new OrgResponseData();
                failData.setNumber(number);
                failData.setReason(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a%s\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_12", (String)"bos-base-webapi", (Object[])new Object[0]), number));
                response.addFailData(failData);
            }
        }
        return true;
    }

    private ApiResult queryOrgsBaseInfoByNumbers(Map<String, Object> params) {
        try {
            List<String> numbers = this.validateNumbers(params);
            QFilter filter = new QFilter("number", "in", numbers);
            String checkOpenApiPermissionResult = this.checkOpenApiPermission("org_query", filter);
            if (StringUtils.isNotEmpty((String)checkOpenApiPermissionResult)) {
                return ApiResult.fail((String)checkOpenApiPermissionResult);
            }
            DynamicObject[] organizations = BusinessDataServiceHelper.load((String)ENTITY_KEY_BOS_ORG, (String)"", (QFilter[])filter.toArray());
            if (organizations == null || organizations.length <= 0) {
                return ApiResult.success(Collections.emptyList());
            }
            ArrayList<OrgResponseData> result = new ArrayList<OrgResponseData>(organizations.length);
            for (DynamicObject orgDO : organizations) {
                OrgResponseData orgDTO = new OrgResponseData();
                orgDTO.setId(Long.valueOf(orgDO.getPkValue().toString()));
                orgDTO.setNumber(orgDO.getString("number"));
                orgDTO.setName(orgDO.getString("name"));
                result.add(orgDTO);
            }
            return ApiResult.success(result);
        }
        catch (Exception e) {
            LOGGER.warn(String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801\u67e5\u8be2\u7ec4\u7ec7\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"OrgApi_14", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801\u67e5\u8be2\u7ec4\u7ec7\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"OrgApi_14", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private ApiResult queryOrganizationByOrgBiz(Map<String, Object> params) {
        try {
            DynamicObject[] structures;
            String proName = this.getOrgBizPropertyName(params);
            QFilter orgFilter = new QFilter(proName, "=", (Object)Boolean.TRUE);
            String checkOpenApiPermissionResult = this.checkOpenApiPermission("org_query_biz", orgFilter);
            if (StringUtils.isNotEmpty((String)checkOpenApiPermissionResult)) {
                return ApiResult.fail((String)checkOpenApiPermissionResult);
            }
            DynamicObject[] organizations = BusinessDataServiceHelper.load((String)ENTITY_KEY_BOS_ORG, (String)"", (QFilter[])orgFilter.toArray());
            if (organizations == null || organizations.length <= 0) {
                return ApiResult.success(Collections.emptyList());
            }
            Map orgId2DataMap = Arrays.stream(organizations).collect(Collectors.toMap(orgDO -> orgDO.getLong("id"), orgDO -> orgDO, (a, b) -> b, () -> new HashMap(organizations.length)));
            QFilter orgStructureFilter = new QFilter("org", "in", orgId2DataMap.keySet());
            Object freeze = params.get(PARAM_KEY_ORG_FREEZE);
            if (!Objects.isNull(freeze)) {
                orgStructureFilter.and("isfreeze", "=", (Object)Boolean.valueOf(freeze.toString()));
            }
            if ((structures = BusinessDataServiceHelper.load((String)ENTITY_KEY_BOS_ORG_STRUCTURE, (String)"org", (QFilter[])orgStructureFilter.toArray())) == null || structures.length <= 0) {
                return ApiResult.success(Collections.emptyList());
            }
            ArrayList<OrgResponseData> result = new ArrayList<OrgResponseData>(organizations.length);
            for (DynamicObject structure : structures) {
                DynamicObject orgDO2;
                DynamicObject structureOrg = structure.getDynamicObject("org");
                if (null == structureOrg || null == (orgDO2 = (DynamicObject)orgId2DataMap.remove(structureOrg.getLong("id")))) continue;
                OrgResponseData orgDTO = new OrgResponseData();
                orgDTO.setId(Long.valueOf(orgDO2.getPkValue().toString()));
                orgDTO.setNumber(orgDO2.getString("number"));
                orgDTO.setName(orgDO2.getString("name"));
                result.add(orgDTO);
            }
            return ApiResult.success(result);
        }
        catch (Exception e) {
            LOGGER.warn(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7279\u5b9a\u804c\u80fd\u4e0b\u7684\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"OrgApi_40", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7279\u5b9a\u804c\u80fd\u4e0b\u7684\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"OrgApi_40", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private String getOrgBizPropertyName(Map<String, Object> params) {
        Object bizId = params.get(PARAM_KEY_BIZ_ID);
        Object bizNumber = params.get(PARAM_KEY_BIZ_NUMBER);
        if (Objects.isNull(bizId) && Objects.isNull(bizNumber)) {
            throw new InvalidParameterException(ResManager.loadKDString((String)"\u804c\u80fd\u53c2\u6570\u4e0d\u5b58\u5728\uff0c\u8bf7\u5f55\u5165\u804c\u80fdid\u6216\u8005\u7f16\u7801\u3002", (String)"OrgApi_15", (String)"bos-base-webapi", (Object[])new Object[0]));
        }
        QFilter bizFilter = null;
        if (!Objects.isNull(bizId) && StringUtils.isNotEmpty((String)bizId.toString())) {
            Long id = Long.valueOf(bizId.toString());
            bizFilter = new QFilter("id", "=", (Object)id);
        } else if (!Objects.isNull(bizNumber) && StringUtils.isNotEmpty((String)bizNumber.toString())) {
            String number = bizNumber.toString();
            bizFilter = new QFilter("fnumber", "=", (Object)number);
        }
        if (null == bizFilter) {
            throw new InvalidParameterException(ResManager.loadKDString((String)"\u804c\u80fd\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u804c\u80fdid\u6216\u8005\u7f16\u7801\u3002", (String)"OrgApi_16", (String)"bos-base-webapi", (Object[])new Object[0]));
        }
        bizFilter.and("enable", "=", (Object)Boolean.TRUE);
        bizFilter.and("visiable", "=", (Object)Boolean.TRUE);
        DynamicObject bizObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_biz", (String)"propertyname", (QFilter[])bizFilter.toArray());
        if (bizObj == null) {
            throw new InvalidParameterException(ResManager.loadKDString((String)"\u804c\u80fd\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_17", (String)"bos-base-webapi", (Object[])new Object[0]));
        }
        String proName = bizObj.getString("propertyname");
        if (StringUtils.isEmpty((String)proName)) {
            throw new InvalidParameterException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u804c\u80fd\u5c5e\u6027\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_18", (String)"bos-base-webapi", (Object[])new Object[0]));
        }
        return proName;
    }

    private ApiResult addOrgsByFullName(Map<String, Object> params) {
        String checkOpenApiPermissionResult = this.checkOpenApiPermission(PARAM_KEY_ORG, null);
        if (StringUtils.isNotEmpty((String)checkOpenApiPermissionResult)) {
            return ApiResult.fail((String)checkOpenApiPermissionResult);
        }
        try {
            Object orgs = params.get(PARAM_KEY_ORG);
            ArrayList orgParams = (ArrayList)JSONUtils.cast((String)JSONUtils.toString((Object)orgs), ArrayList.class, (Class[])new Class[]{OrgParam.class});
            IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
            orgService.addByFullname((List)orgParams);
            FullNameOrgResult apiResult = new FullNameOrgResult();
            for (OrgParam result : orgParams) {
                if (result.isSuccess()) {
                    apiResult.addSuccessData(result.getFullname());
                    continue;
                }
                FailData failData = new FailData();
                failData.setFullName(result.getFullname());
                failData.setReason(result.getMsg());
                apiResult.addFailData(failData);
            }
            return ApiResult.success((Object)apiResult);
        }
        catch (Exception e) {
            LOGGER.warn(ResManager.loadKDString((String)"\u6839\u636e\u7ec4\u7ec7\u957f\u540d\u79f0\u65b0\u589e\u5931\u8d25\u3002", (String)"OrgApi_20", (String)"bos-base-webapi", (Object[])new Object[0]), (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u6839\u636e\u7ec4\u7ec7\u957f\u540d\u79f0\u65b0\u589e\u5931\u8d25\uff1a%s\u3002", (String)"OrgApi_21", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private List<OrgParam> packAddOrUpdateOrgParams(Map<String, Object> params, List<OrgParam> validateFails) throws IOException {
        Object orgObjs = params.get(PARAM_KEY_ORG);
        if (Objects.isNull(orgObjs)) {
            throw new InvalidParameterException(ResManager.loadKDString((String)"\u53c2\u6570orgs\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_22", (String)"bos-base-webapi", (Object[])new Object[0]));
        }
        List organizations = (List)JSONUtils.cast((String)JSONUtils.toString((Object)orgObjs), List.class, (Class[])new Class[]{Organization.class});
        if (CollectionUtils.isEmpty((Collection)organizations)) {
            throw new InvalidParameterException(ResManager.loadKDString((String)"orgs\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"OrgApi_23", (String)"bos-base-webapi", (Object[])new Object[0]));
        }
        this.fillOrgPropertiesIdAndNumber(organizations);
        ArrayList<OrgParam> result = new ArrayList<OrgParam>(organizations.size());
        for (Organization organization : organizations) {
            String number;
            String name;
            HashMap<String, Object> properties = new HashMap<String, Object>(16);
            OrgParam param = new OrgParam();
            param.setPropertyMap(properties);
            Map<String, Object> extProperties = organization.getExtProperties();
            if (!Objects.isNull(extProperties)) {
                properties.putAll(extProperties);
            }
            if (StringUtils.isNotEmpty((String)(name = organization.getName()))) {
                param.setName(name);
            }
            if (StringUtils.isNotEmpty((String)(number = organization.getNumber()))) {
                param.setNumber(number);
            }
            if (!this.orgValidity(param, organization)) {
                Long id = organization.getId();
                if (null != id) {
                    param.setId(id.longValue());
                    param.setCustomOrgId(id.longValue());
                }
                param.setSuccess(false);
                validateFails.add(param);
                continue;
            }
            this.fillOrganizationParam(param, organization);
            result.add(param);
        }
        return result;
    }

    private void fillOrganizationParam(OrgParam param, Organization organization) {
        String simpleName;
        Long parentId;
        Long orgPatternId;
        Long id = organization.getId();
        String clientUrl = RequestContext.get().getClientUrl();
        if (clientUrl.contains(API_URL_ORGS_UPDATE)) {
            param.setId(id.longValue());
        }
        if (clientUrl.contains(API_URL_ORGS_ADD) && id != null) {
            param.setCustomOrgId(id.longValue());
        }
        if (!Objects.isNull(orgPatternId = organization.getOrgPatternId())) {
            param.setOrgPatternId(orgPatternId.longValue());
        }
        if (!Objects.isNull(parentId = organization.getParentId())) {
            param.setParentId(parentId.longValue());
        }
        Map properties = param.getPropertyMap();
        String comment = organization.getComment();
        if (StringUtils.isNotEmpty((String)comment)) {
            properties.put("fcomment", comment);
        }
        if (StringUtils.isNotEmpty((String)(simpleName = organization.getSimpleName()))) {
            properties.put("simplename", simpleName);
        }
        this.setOrgRegionInfo(properties, organization);
        this.setOrgCompanyInfo(properties, organization);
        this.setOrgMultiViews(param, organization);
    }

    private boolean orgValidity(OrgParam param, Organization organization) {
        Long parentId = organization.getParentId();
        String parentNumber = organization.getParentNumber();
        if (parentId == null && StringUtils.isNotEmpty((String)parentNumber)) {
            param.setMsg(String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u7f16\u7801\u4e3a%s\u7684\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_24", (String)"bos-base-webapi", (Object[])new Object[0]), parentNumber));
            return false;
        }
        if (parentId != null && StringUtils.isEmpty((String)parentNumber)) {
            param.setMsg(String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7ID\u4e3a%s\u7684\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_25", (String)"bos-base-webapi", (Object[])new Object[0]), parentId));
            return false;
        }
        String clientUrl = RequestContext.get().getClientUrl();
        boolean isAddOrg = clientUrl.contains(API_URL_ORGS_ADD);
        if (isAddOrg && parentId == null && StringUtils.isEmpty((String)parentNumber)) {
            param.setMsg(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e0a\u7ea7\u7ec4\u7ec7\u76f8\u5173\u4fe1\u606f\u3002", (String)"OrgApi_26", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        if (isAddOrg && StringUtils.isEmpty((String)organization.getName())) {
            param.setMsg(ResManager.loadKDString((String)"\u540d\u79f0\u672a\u586b\u5199", (String)"OrgApi_27", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        String orgPatternNumber = organization.getOrgPatternNumber();
        if (organization.getOrgPatternId() == null && StringUtils.isNotEmpty((String)orgPatternNumber)) {
            param.setMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5f62\u6001\u7f16\u7801\u4e3a%s\u7684\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_28", (String)"bos-base-webapi", (Object[])new Object[0]), orgPatternNumber));
            return false;
        }
        if (organization.getOrgPatternId() != null && StringUtils.isEmpty((String)orgPatternNumber)) {
            param.setMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5f62\u6001ID\u4e3a%s\u7684\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_29", (String)"bos-base-webapi", (Object[])new Object[0]), organization.getOrgPatternId()));
            return false;
        }
        if (clientUrl.contains(API_URL_ORGS_UPDATE) && organization.getId() == null) {
            param.setMsg(ResManager.loadKDString((String)"\u4fee\u6539\u7ec4\u7ec7\u4fe1\u606f\u65f6\u7ec4\u7ec7id\u5b57\u6bb5\u5fc5\u4f20\u3002", (String)"OrgApi_30", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        if (!this.orgRegionValidity(param, organization)) {
            return false;
        }
        if (!this.orgCompanyValidity(param, organization)) {
            return false;
        }
        return this.orgMultiViewValidity(param, organization);
    }

    private boolean orgMultiViewValidity(OrgParam param, Organization organization) {
        List<OrgMultiView> multiViews = organization.getMultiViews();
        if (multiViews.isEmpty()) {
            return true;
        }
        for (OrgMultiView multiView : multiViews) {
            String superOrgNumber = multiView.getSuperOrgNumber();
            Long superOrgId = multiView.getSuperOrgId();
            if (superOrgId == null && StringUtils.isEmpty((String)superOrgNumber)) {
                param.setMsg(ResManager.loadKDString((String)"\u591a\u7ec4\u7ec7\u804c\u80fd\u4e2d\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_41", (String)"bos-base-webapi", (Object[])new Object[0]));
                return false;
            }
            if (superOrgId == null && StringUtils.isNotEmpty((String)superOrgNumber)) {
                param.setMsg(String.format(ResManager.loadKDString((String)"\u591a\u7ec4\u7ec7\u804c\u80fd\u4e2d\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u7f16\u7801\u4e3a%s\u7684\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_31", (String)"bos-base-webapi", (Object[])new Object[0]), superOrgNumber));
                return false;
            }
            if (superOrgId != null && StringUtils.isEmpty((String)superOrgNumber)) {
                param.setMsg(String.format(ResManager.loadKDString((String)"\u591a\u7ec4\u7ec7\u804c\u80fd\u4e2d\u7684\u4e0a\u7ea7\u7ec4\u7ec7ID\u4e3a%s\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_32", (String)"bos-base-webapi", (Object[])new Object[0]), superOrgId));
                return false;
            }
            if (!StringUtils.isEmpty((String)multiView.getViewNumber())) continue;
            param.setMsg(ResManager.loadKDString((String)"\u804c\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgApi_42", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean orgCompanyValidity(OrgParam param, Organization organization) {
        CompanyParam company = organization.getCompany();
        if (company == null) {
            return true;
        }
        Date establishmentDate = company.getEstablishmentDate();
        Date businessTerm = company.getBusinessTerm();
        if (establishmentDate != null && null != businessTerm && businessTerm.before(establishmentDate)) {
            param.setMsg(ResManager.loadKDString((String)"\u8425\u4e1a\u671f\u9650\u5fc5\u987b\u665a\u4e8e\u6210\u7acb\u65e5\u671f\u3002", (String)"OrgApi_33", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean orgRegionValidity(OrgParam param, Organization organization) {
        Region region = organization.getRegion();
        if (Objects.isNull(region)) {
            return true;
        }
        String countryNumber = region.getCountryNumber();
        Long countryId = region.getCountryId();
        String cityNumber = region.getCityNumber();
        Long cityId = region.getCityId();
        String timezoneNumber = region.getTimezoneNumber();
        Long timezoneId = region.getTimezoneId();
        if (countryId != null && StringUtils.isEmpty((String)countryNumber)) {
            param.setMsg(String.format(ResManager.loadKDString((String)"\u56fd\u5bb6ID\u4e3a%s\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_34", (String)"bos-base-webapi", (Object[])new Object[0]), countryId));
            return false;
        }
        if (countryId == null && StringUtils.isNotEmpty((String)countryNumber)) {
            param.setMsg(String.format(ResManager.loadKDString((String)"\u56fd\u5bb6\u7f16\u7801\u4e3a%s\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_35", (String)"bos-base-webapi", (Object[])new Object[0]), countryNumber));
            return false;
        }
        if (countryId != null && cityId == null && StringUtils.isNotEmpty((String)cityNumber)) {
            param.setMsg(String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u56fd\u5bb6\u4e0b\u57ce\u5e02\u7f16\u7801\u4e3a%s\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_36", (String)"bos-base-webapi", (Object[])new Object[0]), cityNumber));
            return false;
        }
        if (countryId != null && cityId != null && StringUtils.isEmpty((String)cityNumber)) {
            param.setMsg(String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u56fd\u5bb6\u4e0b\u57ce\u5e02ID\u4e3a%s\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_37", (String)"bos-base-webapi", (Object[])new Object[0]), cityId));
            return false;
        }
        if (timezoneId == null && StringUtils.isNotEmpty((String)timezoneNumber)) {
            param.setMsg(String.format(ResManager.loadKDString((String)"\u65f6\u533a\u7f16\u7801\u4e3a%s\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_38", (String)"bos-base-webapi", (Object[])new Object[0]), timezoneNumber));
            return false;
        }
        if (timezoneId != null && StringUtils.isEmpty((String)timezoneNumber)) {
            param.setMsg(String.format(ResManager.loadKDString((String)"\u65f6\u533aID\u4e3a%s\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"OrgApi_39", (String)"bos-base-webapi", (Object[])new Object[0]), timezoneId));
            return false;
        }
        return true;
    }

    private void setOrgRegionInfo(Map<String, Object> property, Organization organization) {
        Long timezoneId;
        String tel;
        String postcode;
        String address;
        Long cityId;
        Region region = organization.getRegion();
        if (Objects.isNull(region)) {
            return;
        }
        Long countryId = region.getCountryId();
        if (!Objects.isNull(countryId)) {
            property.put(FILED_COUNTRY, countryId);
        }
        if (!Objects.isNull(cityId = region.getCityId())) {
            property.put("city", cityId);
        }
        if (StringUtils.isNotEmpty((String)(address = region.getAddress()))) {
            property.put("contactaddress", address);
        }
        if (StringUtils.isNotEmpty((String)(postcode = region.getPostcode()))) {
            property.put("postcode", postcode);
        }
        if (StringUtils.isNotEmpty((String)(tel = region.getTel()))) {
            property.put("contactphone", tel);
        }
        if (!Objects.isNull(timezoneId = region.getTimezoneId())) {
            property.put("timezone", timezoneId);
        }
    }

    private void setOrgCompanyInfo(Map<String, Object> property, Organization organization) {
        String bizScope;
        String depositBank;
        String phone;
        String taxRegNum;
        Date businessTerm;
        String address;
        String representative;
        String type;
        String name;
        String bankAccount;
        CompanyParam company = organization.getCompany();
        if (Objects.isNull(company)) {
            return;
        }
        String uniformSocialCreditCode = company.getUniformSocialCreditCode();
        if (StringUtils.isNotEmpty((String)uniformSocialCreditCode)) {
            property.put("uniformsocialcreditcode", uniformSocialCreditCode);
        }
        if (StringUtils.isNotEmpty((String)(bankAccount = company.getBankAccount()))) {
            property.put("bankaccount", bankAccount);
        }
        if (StringUtils.isNotEmpty((String)(name = company.getName()))) {
            property.put("ffirmname", name);
        }
        if (StringUtils.isNotEmpty((String)(type = company.getType()))) {
            property.put("ffirmtype", type);
        }
        if (StringUtils.isNotEmpty((String)(representative = company.getRepresentative()))) {
            property.put("frepresentative", representative);
        }
        if (StringUtils.isNotEmpty((String)(address = company.getAddress()))) {
            property.put("faddress", address);
        }
        property.put("registeredcapital", company.getRegisteredCapital());
        Date establishmentDate = company.getEstablishmentDate();
        if (!Objects.isNull(establishmentDate)) {
            property.put("establishmentdate", establishmentDate);
        }
        if (!Objects.isNull(businessTerm = company.getBusinessTerm())) {
            property.put("businessterm", businessTerm);
        }
        if (StringUtils.isNotEmpty((String)(taxRegNum = company.getTaxRegNum()))) {
            property.put("ftaxregnum", taxRegNum);
        }
        if (StringUtils.isNotEmpty((String)(phone = company.getPhone()))) {
            property.put("phone", phone);
        }
        if (StringUtils.isNotEmpty((String)(depositBank = company.getDepositBank()))) {
            property.put("depositbank", depositBank);
        }
        if (StringUtils.isNotEmpty((String)(bizScope = company.getBizScope()))) {
            property.put("fbizscope", bizScope);
        }
    }

    private void setOrgMultiViews(OrgParam param, Organization organization) {
        List<OrgMultiView> multiViews = organization.getMultiViews();
        if (CollectionUtils.isEmpty(multiViews)) {
            return;
        }
        TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
        for (OrgMultiView multiView : multiViews) {
            OrgDutyView view = new OrgDutyView();
            view.setParentId(multiView.getSuperOrgId().longValue());
            multiViewMap.put(multiView.getViewNumber(), view);
        }
        param.setMultiViewMap(multiViewMap);
    }

    private void fillOrgPropertiesIdAndNumber(List<Organization> organizations) {
        ArrayList<OrgMultiView> multiViews = new ArrayList<OrgMultiView>(10);
        HashSet<Long> parentIds = new HashSet<Long>(organizations.size());
        HashSet<String> parentNumbers = new HashSet<String>(organizations.size());
        HashSet<String> orgPatternNumbers = new HashSet<String>(organizations.size());
        HashSet<Long> orgPatIds = new HashSet<Long>(organizations.size());
        ArrayList<Region> regions = new ArrayList<Region>(organizations.size());
        for (Organization organization2 : organizations) {
            Region region;
            List<OrgMultiView> mvs;
            if (StringUtils.isNotEmpty((String)organization2.getParentNumber())) {
                parentNumbers.add(organization2.getParentNumber());
            }
            if (organization2.getParentId() != null) {
                parentIds.add(organization2.getParentId());
            }
            if (StringUtils.isNotEmpty((String)organization2.getOrgPatternNumber())) {
                orgPatternNumbers.add(organization2.getOrgPatternNumber());
            }
            if (null != organization2.getOrgPatternId()) {
                orgPatIds.add(organization2.getOrgPatternId());
            }
            if (!CollectionUtils.isEmpty(mvs = organization2.getMultiViews())) {
                multiViews.addAll(mvs);
            }
            if (Objects.isNull(region = organization2.getRegion())) continue;
            regions.add(region);
        }
        for (OrgMultiView multiView2 : multiViews) {
            String superOrgNumber;
            Long superOrgId = multiView2.getSuperOrgId();
            if (null != superOrgId) {
                parentIds.add(superOrgId);
            }
            if (!StringUtils.isNotEmpty((String)(superOrgNumber = multiView2.getSuperOrgNumber()))) continue;
            parentNumbers.add(superOrgNumber);
        }
        Map<String, Long> orgNum2IdMap = this.getNumber2IdMapping(ENTITY_KEY_BOS_ORG, parentNumbers);
        Map<Long, String> orgId2NumMap = this.generateId2NumberMapping(parentIds, ENTITY_KEY_BOS_ORG);
        Map<String, Long> patternNum2IdMap = this.getNumber2IdMapping(ENTITY_KEY_BOS_ORG_PATTERN, orgPatternNumbers);
        Map<Long, String> patId2NumMap = this.generateId2NumberMapping(orgPatIds, ENTITY_KEY_BOS_ORG_PATTERN);
        organizations.forEach(organization -> {
            this.fillOrgSuperInfo(orgNum2IdMap, orgId2NumMap, (Organization)organization);
            this.fillOrgPatternInfo(patternNum2IdMap, patId2NumMap, (Organization)organization);
        });
        this.fillOrgRegionInfo(regions);
        multiViews.forEach(multiView -> this.fillOrgMultiViewInfo(orgNum2IdMap, orgId2NumMap, (OrgMultiView)multiView));
    }

    private void fillOrgRegionInfo(List<Region> regions) {
        if (CollectionUtils.isEmpty(regions)) {
            return;
        }
        HashSet<String> countryNumbers = new HashSet<String>(regions.size());
        HashSet<Long> countryIds = new HashSet<Long>(regions.size());
        HashSet<String> timezoneNumbers = new HashSet<String>(regions.size());
        HashSet<Long> timezoneIds = new HashSet<Long>(regions.size());
        ArrayList<QFilter> cityFilters = new ArrayList<QFilter>(regions.size());
        for (Region region2 : regions) {
            QFilter cityFilter;
            Long countryId = region2.getCountryId();
            String countryNumber = region2.getCountryNumber();
            if (StringUtils.isNotEmpty((String)countryNumber)) {
                countryNumbers.add(countryNumber);
            }
            if (null != countryId) {
                countryIds.add(countryId);
            }
            if (StringUtils.isNotEmpty((String)region2.getTimezoneNumber())) {
                timezoneNumbers.add(region2.getTimezoneNumber());
            }
            if (region2.getTimezoneId() != null) {
                timezoneIds.add(region2.getTimezoneId());
            }
            if (Objects.isNull(cityFilter = this.getCityFilter(region2, countryId, countryNumber))) continue;
            cityFilters.add(cityFilter.and(new QFilter("iscity", "=", (Object)1)));
        }
        Map<Long, String> countryId2NumMap = this.generateId2NumberMapping(countryIds, ENTITY_KEY_BD_COUNTRY);
        Map<String, Long> countryNum2IdMap = this.getNumber2IdMapping(ENTITY_KEY_BD_COUNTRY, countryNumbers);
        Map<Long, String> timezoneId2NumMap = this.generateId2NumberMapping(timezoneIds, ENTITY_KEY_BD_TIMEZONE);
        Map<String, Long> tzNum2IdMap = this.getNumber2IdMapping(ENTITY_KEY_BD_TIMEZONE, timezoneNumbers);
        HashMap cityNum2IdMap = new HashMap(0);
        HashMap cityId2NumMap = new HashMap(0);
        if (!cityFilters.isEmpty()) {
            QFilter filter = (QFilter)cityFilters.get(0);
            for (int i = 1; i < cityFilters.size(); ++i) {
                filter.or((QFilter)cityFilters.get(i));
            }
            DynamicObjectCollection cities = QueryServiceHelper.query((String)ENTITY_KEY_BD_ADMIN_DIVISION, (String)"id,number", (QFilter[])filter.toArray());
            cities.forEach(city -> {
                Long id = city.getLong("id");
                String number = city.getString("number");
                cityId2NumMap.put(id, number);
                cityNum2IdMap.put(number, id);
            });
        }
        regions.forEach(region -> {
            this.fillRegionCountryInfo(countryId2NumMap, countryNum2IdMap, (Region)region);
            this.fillRegionTimezoneInfo(timezoneId2NumMap, tzNum2IdMap, (Region)region);
            this.fillRegionCityInfo(cityNum2IdMap, cityId2NumMap, (Region)region);
        });
    }

    private void fillRegionCityInfo(Map<String, Long> cityNum2IdMap, Map<Long, String> cityId2NumMap, Region region) {
        Long paramId = region.getCityId();
        String dbNumber = cityId2NumMap.get(paramId);
        Long dbCityId = cityNum2IdMap.get(region.getCityNumber());
        if (paramId != null && StringUtils.isEmpty((String)dbNumber)) {
            region.setCityNumber(null);
        } else if (null != paramId) {
            region.setCityNumber(dbNumber);
        } else if (null != dbCityId) {
            region.setCityId(dbCityId);
        }
    }

    private void fillRegionTimezoneInfo(Map<Long, String> timezoneId2NumMap, Map<String, Long> tzNum2IdMap, Region region) {
        Long paramId = region.getTimezoneId();
        String dbNumber = timezoneId2NumMap.get(paramId);
        Long dbTimezoneId = tzNum2IdMap.get(region.getTimezoneNumber());
        if (paramId != null && StringUtils.isEmpty((String)dbNumber)) {
            region.setTimezoneNumber(null);
        } else if (null != paramId) {
            region.setTimezoneNumber(dbNumber);
        } else if (null != dbTimezoneId) {
            region.setTimezoneId(dbTimezoneId);
        }
    }

    private void fillRegionCountryInfo(Map<Long, String> countryId2NumMap, Map<String, Long> countryNum2IdMap, Region region) {
        Long paramId = region.getCountryId();
        String number = countryId2NumMap.get(paramId);
        Long countryId = countryNum2IdMap.get(region.getCountryNumber());
        if (paramId != null && StringUtils.isEmpty((String)number)) {
            region.setCountryNumber(null);
        } else if (null != paramId) {
            region.setCountryNumber(number);
        } else if (null != countryId) {
            region.setCountryId(countryId);
        }
    }

    private void fillOrgSuperInfo(Map<String, Long> orgNum2IdMap, Map<Long, String> orgId2NumMap, Organization organization) {
        Long paramId = organization.getParentId();
        String dbNumber = orgId2NumMap.get(paramId);
        Long dbSuperOrgId = orgNum2IdMap.get(organization.getParentNumber());
        if (paramId != null && StringUtils.isEmpty((String)dbNumber)) {
            organization.setParentNumber(null);
        } else if (null != paramId) {
            organization.setParentNumber(dbNumber);
        } else if (null != dbSuperOrgId) {
            organization.setParentId(dbSuperOrgId);
        }
    }

    private void fillOrgPatternInfo(Map<String, Long> patternNum2IdMap, Map<Long, String> patId2NumMap, Organization organization) {
        Long paramId = organization.getOrgPatternId();
        String dbNumber = patId2NumMap.get(paramId);
        Long dbPatId = patternNum2IdMap.get(organization.getOrgPatternNumber());
        if (paramId != null && StringUtils.isEmpty((String)dbNumber)) {
            organization.setOrgPatternNumber(null);
        } else if (null != paramId) {
            organization.setOrgPatternNumber(dbNumber);
        } else if (null != dbPatId) {
            organization.setOrgPatternId(dbPatId);
        }
    }

    private void fillOrgMultiViewInfo(Map<String, Long> orgNum2IdMap, Map<Long, String> orgId2NumMap, OrgMultiView multiView) {
        Long paramId = multiView.getSuperOrgId();
        String dbNumber = orgId2NumMap.get(paramId);
        Long dbSuperOrgId = orgNum2IdMap.get(multiView.getSuperOrgNumber());
        if (paramId != null && StringUtils.isEmpty((String)dbNumber)) {
            multiView.setSuperOrgNumber(null);
        } else if (null != paramId) {
            multiView.setSuperOrgNumber(dbNumber);
        } else if (null != dbSuperOrgId) {
            multiView.setSuperOrgId(dbSuperOrgId);
        }
    }

    private QFilter getCityFilter(Region region, Long countryId, String countryNumber) {
        String cityNumber = region.getCityNumber();
        Long cityId = region.getCityId();
        if (countryId != null && cityId != null) {
            return new QFilter("id", "=", (Object)cityId).and(FILED_COUNTRY, "=", (Object)countryId);
        }
        if (countryId != null && StringUtils.isNotEmpty((String)cityNumber)) {
            return new QFilter("number", "=", (Object)cityNumber).and(FILED_COUNTRY, "=", (Object)countryId);
        }
        if (countryId == null && StringUtils.isNotEmpty((String)countryNumber) && cityId != null) {
            return new QFilter("id", "=", (Object)cityId).and("country.number", "=", (Object)countryNumber);
        }
        if (countryId == null && StringUtils.isNotEmpty((String)countryNumber) && cityId == null && StringUtils.isNotEmpty((String)cityNumber)) {
            return new QFilter("number", "=", (Object)cityNumber).and("country.number", "=", (Object)countryNumber);
        }
        return null;
    }

    private void packResponse(List<OrgParam> organizations, OrgApiResult response) {
        if (CollectionUtils.isEmpty(organizations)) {
            return;
        }
        for (OrgParam organization : organizations) {
            OrgResponseData data = new OrgResponseData();
            long id = organization.getId();
            if (0L != id) {
                data.setId(id);
            }
            data.setName(organization.getName());
            data.setNumber(organization.getNumber());
            if (organization.isSuccess()) {
                response.addSuccessData(data);
                continue;
            }
            data.setReason(organization.getMsg());
            response.addFailData(data);
        }
    }

    private String checkOpenApiPermission(String apiNumber, QFilter filter) {
        DynamicObject openApiServiceBizObj = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_KEY_OPEN_API_SERVICE_NEW, (String)ORG_AUTHOR_FILTER, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)apiNumber)});
        boolean isOrgAuthorFilter = false;
        try {
            if (openApiServiceBizObj != null && openApiServiceBizObj.get(ORG_AUTHOR_FILTER) != null) {
                isOrgAuthorFilter = openApiServiceBizObj.getBoolean(ORG_AUTHOR_FILTER);
            }
        }
        catch (Exception e) {
            isOrgAuthorFilter = false;
        }
        if (isOrgAuthorFilter) {
            QFilter dataPermissionFilter;
            if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)APP_ID, (String)ENTITY_KEY_BOS_ORG, (String)"47150e89000000ac")) {
                return ResManager.loadKDString((String)"\u6ca1\u6709\u7ec4\u7ec7\u63a5\u53e3\u6743\u9650\u3002", (String)"OrgApi_43", (String)"bos-base-webapi", (Object[])new Object[0]);
            }
            if (filter != null && (dataPermissionFilter = ((PermissionService)ServiceFactory.getService(PermissionService.class)).getDataRuleWithoutDim(RequestContext.get().getCurrUserId(), APP_ID, ENTITY_KEY_BOS_ORG, "47150e89000000ac", null)) != null) {
                filter.and(dataPermissionFilter);
            }
        }
        return null;
    }
}

