/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.user;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.AbstractWebApi;
import kd.bos.base.user.pojo.ResponseData;
import kd.bos.base.user.pojo.UserApiCheckResult;
import kd.bos.base.user.pojo.UserApiSecurity;
import kd.bos.base.user.pojo.UserBaseInfo;
import kd.bos.base.user.pojo.UserContact;
import kd.bos.base.user.pojo.UserDepartment;
import kd.bos.base.user.pojo.UserInfo;
import kd.bos.base.user.pojo.UserResult;
import kd.bos.base.user.pojo.UserType;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.IUserService;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.UserParam;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.JSONUtils;

public class UserApi
extends AbstractWebApi {
    private static final Log log = LogFactory.getLog(UserApi.class);
    private static final String API_URL_ADD_OR_UPDATE = "/app/base/users";
    private static final String API_URL_QUERY_USER = "/app/base/getUser";
    private static final String API_URL_QUERY_USERS_BY_NUMBERS = "/app/base/user_query";
    private static final String API_URL_ENABLE_USER = "/app/base/user_enable";
    private static final String API_URL_DISABLE_USER = "/app/base/user_disable";
    private static final String API_URL_DELETE_USER = "/app/base/user_delete";
    private static final String API_URL_ADD_USERS = "/app/base/user_add";
    private static final String API_URL_UPDATE_USERS = "/app/base/user_update";
    private static final String ENTITY_KEY_BOS_USER = "bos_user";
    private static final String ENTITY_KEY_BOS_USER_TYPE = "bos_usertype";
    private static final String ENTITY_KEY_BOS_ADMIN_ORG = "bos_adminorg";
    private static final String ENTITY_KEY_BOS_CONSTANT = "bos_user_contacttype";
    private static final String PARAM_KEY_USER = "users";
    private static final String PARAM_KEY_USER_IDS = "userIds";
    private static final String ENTITY_KEY_OPEN_API_SERVICE_NEW = "open_apiservice_new";
    private static final String ORG_AUTHOR_FILTER = "org_author_filter";

    public ApiResult doCustomService(Map<String, Object> params) {
        String apiUrl;
        switch (apiUrl = this.getRequestUrl()) {
            case "/app/base/users": {
                return this.addOrUpdateUser(params);
            }
            case "/app/base/user_add": {
                return this.batchAddUsers(params);
            }
            case "/app/base/user_update": {
                return this.batchUpdateUsers(params);
            }
            case "/app/base/user_delete": {
                return this.deleteUsers(params);
            }
            case "/app/base/user_disable": {
                return this.disableUsers(params);
            }
            case "/app/base/user_enable": {
                return this.enableUsers(params);
            }
            case "/app/base/user_query": {
                return this.queryUserBaseInfoByNumbers(params);
            }
            case "/app/base/getUser": {
                return this.queryUserByUserId(params);
            }
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5b58\u5728", (String)"UserApi_0", (String)"bos-base-webapi", (Object[])new Object[0]), (String)"404");
    }

    private ApiResult batchAddUsers(Map<String, Object> params) {
        try {
            UserApiCheckResult userApiCheckResult = UserApiSecurity.checkPermission(this.getRequestUrl(), params);
            if (!userApiCheckResult.hasRight()) {
                return ApiResult.fail((String)userApiCheckResult.getMsg());
            }
            ArrayList<UserParam> validateFailUsers = new ArrayList<UserParam>(10);
            List<UserParam> users = this.packAddOrUpdateUserParams(params, validateFailUsers);
            UserResult response = new UserResult();
            this.packResponse(validateFailUsers, response);
            if (!users.isEmpty()) {
                UserServiceHelper.add(users);
                this.packResponse(users, response);
            }
            return ApiResult.success((Object)response);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u6dfb\u52a0\u4eba\u5458\u4fe1\u606f\u5931\u8d25: %s", (String)"UserApi_2", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private ApiResult batchUpdateUsers(Map<String, Object> params) {
        try {
            UserApiCheckResult userApiCheckResult = UserApiSecurity.checkPermission(this.getRequestUrl(), params);
            if (!userApiCheckResult.hasRight()) {
                return ApiResult.fail((String)userApiCheckResult.getMsg());
            }
            ArrayList<UserParam> validateFailUsers = new ArrayList<UserParam>(10);
            List<UserParam> users = this.packAddOrUpdateUserParams(params, validateFailUsers);
            UserApiSecurity.checkDataPermission(validateFailUsers, users, userApiCheckResult);
            UserResult response = new UserResult();
            if (!users.isEmpty()) {
                UserServiceHelper.update(users);
                this.packResponse(users, response);
            }
            this.packResponse(validateFailUsers, response);
            return ApiResult.success((Object)response);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4fee\u6539\u4eba\u5458\u4fe1\u606f\u5931\u8d25: %s", (String)"UserApi_4", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private ApiResult queryUserByUserId(Map<String, Object> params) {
        try {
            UserApiCheckResult userApiCheckResult = UserApiSecurity.checkPermission(this.getRequestUrl(), params);
            if (!userApiCheckResult.hasRight()) {
                return ApiResult.fail((String)userApiCheckResult.getMsg());
            }
            Object userId = params.get("userId");
            if (Objects.isNull(userId)) {
                throw new InvalidParameterException(ResManager.loadKDString((String)"\u53c2\u6570userIds\u4e3a\u7a7a\u3002", (String)"UserApi_5", (String)"bos-base-webapi", (Object[])new Object[0]));
            }
            List<Long> ids = Collections.singletonList(Long.valueOf(userId.toString()));
            UserApiSecurity.checkDataPermission(ids, userApiCheckResult);
            return ApiResult.success((Object)UserServiceHelper.get(ids));
        }
        catch (Exception e) {
            log.warn(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"UserApi_6", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"UserApi_6", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private ApiResult addOrUpdateUser(Map<String, Object> params) {
        String paramsString = null;
        try {
            paramsString = JSONUtils.toString(params);
            Object users = params.get(PARAM_KEY_USER);
            ArrayList userList = (ArrayList)JSONUtils.cast((String)JSONUtils.toString((Object)users), ArrayList.class, (Class[])new Class[]{UserParam.class});
            UserResult userResult = new UserResult();
            UserApiSecurity.checkPermissionForAddOrUpdateUser(userList, userResult, this.getRequestUrl());
            IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
            userService.addOrUpdate((List)userList);
            for (UserParam userParam : userList) {
                ResponseData responseData = new ResponseData();
                responseData.setId(String.valueOf(userParam.getId()));
                Object name = userParam.getDataMap().get("name");
                if (!Objects.isNull(name)) {
                    responseData.setName(name.toString());
                }
                if (userParam.isSuccess()) {
                    userResult.addSuccessData(responseData);
                    continue;
                }
                responseData.setReason(userParam.getMsg());
                userResult.addFailData(responseData);
            }
            return ApiResult.success((Object)userResult);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u6216\u8005\u6dfb\u52a0\u4eba\u5458\u4fe1\u606f\u5931\u8d25: %s", (String)"UserApi_9", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private ApiResult queryUserBaseInfoByNumbers(Map<String, Object> params) {
        try {
            String selectFields;
            DynamicObjectCollection userDos;
            List<String> numbers = this.validateNumbers(params);
            QFilter filter = new QFilter("number", "in", numbers);
            DynamicObject openApiServiceBizObj = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_KEY_OPEN_API_SERVICE_NEW, (String)ORG_AUTHOR_FILTER, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"user_query")});
            boolean isOrgAuthorFilter = false;
            try {
                if (openApiServiceBizObj != null && openApiServiceBizObj.get(ORG_AUTHOR_FILTER) != null) {
                    isOrgAuthorFilter = openApiServiceBizObj.getBoolean(ORG_AUTHOR_FILTER);
                }
            }
            catch (Exception e) {
                isOrgAuthorFilter = false;
            }
            if (isOrgAuthorFilter) {
                long userId = RequestContext.get().getCurrUserId();
                String appId = "base";
                if (!PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)ENTITY_KEY_BOS_USER, (String)"47150e89000000ac")) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"UserApi_47", (String)"bos-base-webapi", (Object[])new Object[0]));
                }
                QFilter dataPermissionFilter = ((PermissionService)ServiceFactory.getService(PermissionService.class)).getDataRuleWithoutDim(userId, appId, ENTITY_KEY_BOS_USER, "47150e89000000ac", null);
                if (dataPermissionFilter != null) {
                    filter.and(dataPermissionFilter);
                }
            }
            if (CollectionUtils.isEmpty((Collection)(userDos = QueryServiceHelper.query((String)ENTITY_KEY_BOS_USER, (String)(selectFields = "id,name,number,email,phone,gender"), (QFilter[])filter.toArray())))) {
                ApiResult.success(Collections.emptyList());
            }
            ArrayList<UserBaseInfo> result = new ArrayList<UserBaseInfo>(userDos.size());
            for (DynamicObject userDo : userDos) {
                UserBaseInfo userDTO = new UserBaseInfo();
                userDTO.setId(userDo.getLong("id"));
                userDTO.setNumber(userDo.getString("number"));
                userDTO.setName(userDo.getString("name"));
                userDTO.setEmail(userDo.getString("email"));
                userDTO.setPhone(userDo.getString("phone"));
                userDTO.setGender(userDo.getInt("gender"));
                result.add(userDTO);
            }
            return ApiResult.success(result);
        }
        catch (Exception e) {
            log.warn(String.format(ResManager.loadKDString((String)"\u6839\u636e\u4eba\u5458\u5de5\u53f7\u67e5\u8be2\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"UserApi_10", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u6839\u636e\u4eba\u5458\u5de5\u53f7\u67e5\u8be2\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"UserApi_10", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private ApiResult disableUsers(Map<String, Object> params) {
        try {
            UserApiCheckResult userApiCheckResult = UserApiSecurity.checkPermission(this.getRequestUrl(), params);
            if (!userApiCheckResult.hasRight()) {
                return ApiResult.fail((String)userApiCheckResult.getMsg());
            }
            UserResult response = new UserResult();
            ArrayList<UserParam> paramList = new ArrayList<UserParam>(10);
            boolean existUserIds = this.validateUserIdFromRequestParam(params, paramList, response);
            boolean existUserNumbers = this.validateUserNumberFromRequestParam(params, paramList, response);
            if (!existUserIds && !existUserNumbers) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u4eba\u5458id\u548c\u5de5\u53f7\u90fd\u4e0d\u5b58\u5728\uff0c\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u4eba\u5458\u7981\u7528\u6267\u884c\u5931\u8d25\u3002", (String)"UserApi_11", (String)"bos-base-webapi", (Object[])new Object[0]), (String)"501");
            }
            UserApiSecurity.checkDataPermission(response, paramList, userApiCheckResult);
            if (paramList.isEmpty()) {
                return ApiResult.success((Object)response);
            }
            UserServiceHelper.disable(paramList);
            this.packResponse(paramList, response);
            return ApiResult.success((Object)response);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u7981\u7528\u4eba\u5458\u5931\u8d25\uff1a%s", (String)"UserApi_13", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private ApiResult enableUsers(Map<String, Object> params) {
        try {
            UserApiCheckResult userApiCheckResult = UserApiSecurity.checkPermission(this.getRequestUrl(), params);
            if (!userApiCheckResult.hasRight()) {
                return ApiResult.fail((String)userApiCheckResult.getMsg());
            }
            UserResult response = new UserResult();
            ArrayList<UserParam> paramList = new ArrayList<UserParam>(10);
            boolean existUserIds = this.validateUserIdFromRequestParam(params, paramList, response);
            boolean existUserNumbers = this.validateUserNumberFromRequestParam(params, paramList, response);
            if (!existUserIds && !existUserNumbers) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u4eba\u5458id\u548c\u5de5\u53f7\u90fd\u4e0d\u5b58\u5728\uff0c\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u4eba\u5458\u542f\u7528\u6267\u884c\u5931\u8d25\u3002", (String)"UserApi_14", (String)"bos-base-webapi", (Object[])new Object[0]), (String)"501");
            }
            UserApiSecurity.checkDataPermission(response, paramList, userApiCheckResult);
            if (paramList.isEmpty()) {
                return ApiResult.success((Object)response);
            }
            UserServiceHelper.enable(paramList);
            this.packResponse(paramList, response);
            return ApiResult.success((Object)response);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u542f\u7528\u4eba\u5458\u5931\u8d25\uff1a%s", (String)"UserApi_16", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private ApiResult deleteUsers(Map<String, Object> params) {
        try {
            UserApiCheckResult userApiCheckResult = UserApiSecurity.checkPermission(this.getRequestUrl(), params);
            if (!userApiCheckResult.hasRight()) {
                return ApiResult.fail((String)userApiCheckResult.getMsg());
            }
            UserResult response = new UserResult();
            ArrayList<UserParam> paramList = new ArrayList<UserParam>(10);
            boolean existUserIds = this.validateUserIdFromRequestParam(params, paramList, response);
            boolean existUserNumbers = this.validateUserNumberFromRequestParam(params, paramList, response);
            if (!existUserIds && !existUserNumbers) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u4eba\u5458id\u548c\u5de5\u53f7\u90fd\u4e0d\u5b58\u5728\uff0c\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u4eba\u5458\u5220\u9664\u6267\u884c\u5931\u8d25\u3002", (String)"UserApi_17", (String)"bos-base-webapi", (Object[])new Object[0]), (String)"501");
            }
            UserApiSecurity.checkDataPermission(response, paramList, userApiCheckResult);
            if (paramList.isEmpty()) {
                return ApiResult.success((Object)response);
            }
            UserServiceHelper.delete(paramList);
            this.packResponse(paramList, response);
            return ApiResult.success((Object)response);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u5220\u9664\u4eba\u5458\u5931\u8d25\uff1a%s", (String)"UserApi_19", (String)"bos-base-webapi", (Object[])new Object[0]), e.getMessage()), (String)"500");
        }
    }

    private boolean userValidity(UserParam param, UserInfo userInfo) {
        String clientUrl = RequestContext.get().getClientUrl();
        boolean isAddUser = clientUrl.contains(API_URL_ADD_USERS);
        String name = userInfo.getName();
        if (isAddUser && StringUtils.isEmpty((Object)name)) {
            param.setMsg(ResManager.loadKDString((String)"\u65b0\u589e\u7528\u6237\u59d3\u540d\u5fc5\u586b\u3002", (String)"UserApi_20", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        String number = userInfo.getNumber();
        if (isAddUser && StringUtils.isEmpty((Object)number)) {
            param.setMsg(ResManager.loadKDString((String)"\u65b0\u589e\u7528\u6237\u5de5\u53f7\u5fc5\u586b\u3002", (String)"UserApi_21", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        String phone = userInfo.getPhone();
        String email = userInfo.getEmail();
        if (isAddUser && StringUtils.isEmpty((Object)phone) && StringUtils.isEmpty((Object)email)) {
            param.setMsg(ResManager.loadKDString((String)"\u65b0\u589e\u7528\u6237\u65f6\uff0c\u624b\u673a\u548c\u90ae\u7bb1\u4e0d\u80fd\u90fd\u4e3a\u7a7a\u3002", (String)"UserApi_22", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        boolean isUpdateUser = clientUrl.contains(API_URL_UPDATE_USERS);
        if (isUpdateUser && Objects.isNull(userInfo.getId())) {
            param.setMsg(ResManager.loadKDString((String)"\u4fee\u6539\u4eba\u5458\u4fe1\u606f\u65f6ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserApi_23", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        if (isUpdateUser && userInfo.getId().equals(0L)) {
            param.setMsg(ResManager.loadKDString((String)"\u4fee\u6539\u4eba\u5458\u4fe1\u606f\u65f6\uff0cID\u4e3a0\u7684\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"UserApi_46", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        if (!this.userTypeValidity(param, userInfo)) {
            return false;
        }
        if (!this.departmentValidity(param, userInfo)) {
            return false;
        }
        return this.contactValidity(param, userInfo);
    }

    private boolean userTypeValidity(UserParam param, UserInfo userInfo) {
        boolean existContact;
        boolean existDepartment;
        List<UserType> userTypes = userInfo.getUserTypes();
        if (CollectionUtils.isEmpty(userTypes)) {
            return true;
        }
        HashSet<String> correctTypeIds = new HashSet<String>(userTypes.size());
        HashSet<String> errorIds = new HashSet<String>(userTypes.size());
        HashSet<String> errorNumbers = new HashSet<String>(userTypes.size());
        Iterator<UserType> iterator = userTypes.iterator();
        while (iterator.hasNext()) {
            UserType type = iterator.next();
            Long typeId = type.getUserTypeId();
            if (null != typeId && "7".equals(typeId.toString())) {
                param.setMsg(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7c7b\u578b\u7981\u6b62\u6dfb\u52a0", (String)"UserApi_26", (String)"bos-base-webapi", (Object[])new Object[0]));
                return false;
            }
            String typeNumber = type.getUserTypeNumber();
            if (null != typeId && StringUtils.isEmpty((Object)typeNumber)) {
                errorIds.add(typeId.toString());
                iterator.remove();
                continue;
            }
            if (null == typeId && !StringUtils.isEmpty((Object)typeNumber)) {
                errorNumbers.add(typeNumber);
                iterator.remove();
                continue;
            }
            if (typeId == null) continue;
            correctTypeIds.add(typeId.toString());
        }
        if (correctTypeIds.isEmpty()) {
            String message = !errorIds.isEmpty() && !errorNumbers.isEmpty() ? String.format(ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578bID\u4e3a\uff1a%1$s\uff0c\u7c7b\u578b\u7f16\u7801\u4e3a\uff1a%2$s\u7684\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"UserApi_24", (String)"bos-base-webapi", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", errorIds), String.join((CharSequence)"\uff0c", errorNumbers)) : (!errorIds.isEmpty() ? String.format(ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578bID\u4e3a\uff1a%s\u7684\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"UserApi_25", (String)"bos-base-webapi", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", errorIds)) : (!errorNumbers.isEmpty() ? String.format(ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578b\u7f16\u7801\u4e3a\uff1a%s\u7684\u6570\u636e\u4e0d\u5b58\u5728", (String)"UserApi_40", (String)"bos-base-webapi", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", errorNumbers)) : ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578b\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"UserApi_41", (String)"bos-base-webapi", (Object[])new Object[0])));
            param.setMsg(message);
            return false;
        }
        boolean isStaff = correctTypeIds.contains("1");
        if (correctTypeIds.size() > 1 && isStaff) {
            param.setMsg(ResManager.loadKDString((String)"\u591a\u7528\u6237\u7c7b\u578b\u4e2d\u5305\u542b\u804c\u5458\uff0c\u7981\u6b62\u6dfb\u52a0\uff0c\u804c\u5458\u7c7b\u578b\u4e0d\u80fd\u4e0e\u5176\u5b83\u7c7b\u578b\u540c\u65f6\u5b58\u5728\u3002", (String)"UserApi_42", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        boolean isRobot = correctTypeIds.contains("6");
        if (correctTypeIds.size() > 1 && isRobot) {
            param.setMsg(ResManager.loadKDString((String)"\u591a\u7528\u6237\u7c7b\u578b\u4e2d\u5305\u542b\u673a\u5668\u4eba\uff0c\u7981\u6b62\u6dfb\u52a0\uff0c\u673a\u5668\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e0e\u5176\u5b83\u7c7b\u578b\u540c\u65f6\u5b58\u5728\u3002", (String)"UserApi_43", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        boolean bl = existDepartment = !CollectionUtils.isEmpty(userInfo.getDepartments());
        if (!isStaff && existDepartment) {
            param.setMsg(ResManager.loadKDString((String)"\u53ea\u6709\u804c\u5458\u7c7b\u578b\u7528\u6237\u624d\u53ef\u4ee5\u8bbe\u7f6e\u90e8\u95e8\u4fe1\u606f\u3002", (String)"UserApi_44", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        boolean bl2 = existContact = !CollectionUtils.isEmpty(userInfo.getContactInfos());
        if (!isStaff && existContact) {
            param.setMsg(ResManager.loadKDString((String)"\u53ea\u6709\u804c\u5458\u7c7b\u578b\u7528\u6237\u624d\u53ef\u4ee5\u8bbe\u7f6e\u8054\u7cfb\u4fe1\u606f\u3002", (String)"UserApi_45", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean departmentValidity(UserParam param, UserInfo userInfo) {
        List<UserDepartment> departments = userInfo.getDepartments();
        if (CollectionUtils.isEmpty(departments)) {
            return true;
        }
        for (UserDepartment department : departments) {
            Long departmentId = department.getId();
            String dptNumber = department.getDptNumber();
            if (null == departmentId && StringUtils.isEmpty((Object)dptNumber)) {
                param.setMsg(ResManager.loadKDString((String)"\u90e8\u95e8\u4fe1\u606f\u4e3a\u7a7a", (String)"UserApi_26", (String)"bos-base-webapi", (Object[])new Object[0]));
                return false;
            }
            if (null == departmentId && !StringUtils.isEmpty((Object)dptNumber)) {
                param.setMsg(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7ec4\u7ec7\u90e8\u95e8\u4e0d\u5b58\u5728\u3002", (String)"UserApi_27", (String)"bos-base-webapi", (Object[])new Object[0]), dptNumber));
                return false;
            }
            if (null != departmentId && StringUtils.isEmpty((Object)dptNumber)) {
                param.setMsg(String.format(ResManager.loadKDString((String)"\u90e8\u95e8ID\u4e3a%s\u7684\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"UserApi_28", (String)"bos-base-webapi", (Object[])new Object[0]), departmentId));
                return false;
            }
            if (StringUtils.isEmpty((Object)department.getPosition())) {
                param.setMsg(ResManager.loadKDString((String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserApi_29", (String)"bos-base-webapi", (Object[])new Object[0]));
                return false;
            }
            Long superiorId = department.getSuperiorId();
            if (superiorId == null && !StringUtils.isEmpty((Object)department.getSuperiorNumber())) {
                param.setMsg(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u4e0a\u7ea7\u4eba\u5458\u4e0d\u5b58\u5728\u3002", (String)"UserApi_30", (String)"bos-base-webapi", (Object[])new Object[0]), department.getSuperiorNumber()));
                return false;
            }
            if (superiorId == null || !StringUtils.isEmpty((Object)department.getSuperiorNumber())) continue;
            param.setMsg(String.format(ResManager.loadKDString((String)"ID\u4e3a%s\u7684\u4e0a\u7ea7\u4eba\u5458\u4e0d\u5b58\u5728\u3002", (String)"UserApi_31", (String)"bos-base-webapi", (Object[])new Object[0]), superiorId));
            return false;
        }
        return true;
    }

    private boolean contactValidity(UserParam param, UserInfo userInfo) {
        List<UserContact> contactInfos = userInfo.getContactInfos();
        if (CollectionUtils.isEmpty(contactInfos)) {
            return true;
        }
        for (UserContact contactInfo : contactInfos) {
            Long contactTypeId = contactInfo.getContactTypeId();
            String contactTypeNumber = contactInfo.getContactTypeNumber();
            if (contactTypeId == null && StringUtils.isEmpty((Object)contactTypeNumber)) {
                param.setMsg(ResManager.loadKDString((String)"\u8054\u7cfb\u65b9\u5f0f\u4e0d\u5b58\u5728\u3002", (String)"UserApi_32", (String)"bos-base-webapi", (Object[])new Object[0]));
                return false;
            }
            if (contactTypeId == null && !StringUtils.isEmpty((Object)contactTypeNumber)) {
                param.setMsg(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8054\u7cfb\u65b9\u5f0f\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"UserApi_33", (String)"bos-base-webapi", (Object[])new Object[0]), contactTypeNumber));
                return false;
            }
            if (contactTypeId != null && StringUtils.isEmpty((Object)contactTypeNumber)) {
                param.setMsg(String.format(ResManager.loadKDString((String)"ID\u4e3a%s\u7684\u8054\u7cfb\u65b9\u5f0f\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"UserApi_34", (String)"bos-base-webapi", (Object[])new Object[0]), contactTypeId));
                return false;
            }
            if (!StringUtils.isEmpty((Object)contactInfo.getContact())) continue;
            param.setMsg(ResManager.loadKDString((String)"\u8054\u7cfb\u65b9\u5f0f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserApi_35", (String)"bos-base-webapi", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setUserBaseInfo(UserInfo userInfo, UserParam param, Map<String, Object> properties) {
        List<UserType> userTypes;
        Long id = userInfo.getId();
        String clientUrl = RequestContext.get().getClientUrl();
        if (!Objects.isNull(id) && clientUrl.contains(API_URL_ADD_USERS)) {
            param.setCustomUserId(id.longValue());
        }
        if (clientUrl.contains(API_URL_UPDATE_USERS)) {
            param.setId(id.longValue());
        }
        if (!(userTypes = userInfo.getUserTypes()).isEmpty()) {
            HashSet<String> types = new HashSet<String>(userTypes.size());
            for (UserType userType : userTypes) {
                types.add(userType.getUserTypeId().toString());
            }
            properties.put("usertype", String.join((CharSequence)",", types));
        }
        if (null != userInfo.getUserName()) {
            properties.put("username", userInfo.getUserName());
        }
        if (null != userInfo.getIdCard()) {
            properties.put("idcard", userInfo.getIdCard());
        }
        if (null != userInfo.getBirthday()) {
            properties.put("birthday", userInfo.getBirthday());
        }
        if (null != userInfo.getGender()) {
            properties.put("gender", userInfo.getGender());
        }
        if (null != userInfo.getSimpleSpell()) {
            properties.put("simplepinyin", userInfo.getSimpleSpell());
        }
        if (null != userInfo.getFullSpell()) {
            properties.put("fullpinyin", userInfo.getFullSpell());
        }
    }

    private void setUserDepInfo(UserInfo userInfo, UserParam param) {
        List<UserDepartment> departments = userInfo.getDepartments();
        if (departments.isEmpty()) {
            return;
        }
        ArrayList deps = new ArrayList(departments.size());
        param.getDataMap().put("entryentity", deps);
        for (UserDepartment department : departments) {
            HashMap<String, Object> dep = new HashMap<String, Object>(5);
            Long departmentId = department.getId();
            Long superiorId = department.getSuperiorId();
            dep.put("dpt", departmentId);
            dep.put("superior", superiorId);
            dep.put("position", department.getPosition());
            dep.put("isincharge", department.getInCharge());
            dep.put("ispartjob", department.getPartTimeJob());
            deps.add(dep);
        }
    }

    private void setUserContactInfo(UserInfo userInfo, UserParam param) {
        List<UserContact> contactInfos = userInfo.getContactInfos();
        if (contactInfos.isEmpty()) {
            return;
        }
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_BOS_USER);
        DynamicObjectCollection contactEntities = user.getDynamicObjectCollection("contactentity");
        for (UserContact contactInfo : contactInfos) {
            Long contactTypeId = contactInfo.getContactTypeId();
            String contactTypeNumber = contactInfo.getContactTypeNumber();
            DynamicObject contactEntity = new DynamicObject(contactEntities.getDynamicObjectType());
            DynamicObject contactType = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_BOS_CONSTANT);
            contactType.set("id", (Object)contactTypeId);
            contactType.set("number", (Object)contactTypeNumber);
            contactEntity.set("isdefault", (Object)contactInfo.getDefaultContact());
            contactEntity.set("contacttype", (Object)contactType);
            contactEntity.set("contact", (Object)contactInfo.getContact());
            contactEntities.add((Object)contactEntity);
        }
        param.getDataMap().put("contactentity", contactEntities);
    }

    private boolean validateUserIdFromRequestParam(Map<String, Object> params, List<UserParam> paramList, UserResult response) {
        Set<Object> ids = this.getIdsFromRequestParam(params, PARAM_KEY_USER_IDS);
        if (CollectionUtils.isEmpty(ids)) {
            return false;
        }
        for (Object id : ids) {
            try {
                UserParam user = new UserParam();
                user.setId(Long.parseLong(id.toString()));
                paramList.add(user);
            }
            catch (Exception e) {
                log.warn(String.format(ResManager.loadKDString((String)"\u4eba\u5458ID\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a%s", (String)"UserApi_36", (String)"bos-base-webapi", (Object[])new Object[0]), id), (Throwable)e);
                ResponseData failData = new ResponseData();
                failData.setId(id);
                failData.setReason(String.format(ResManager.loadKDString((String)"\u4eba\u5458ID\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a%s", (String)"UserApi_36", (String)"bos-base-webapi", (Object[])new Object[0]), id));
                response.addFailData(failData);
            }
        }
        return true;
    }

    private boolean validateUserNumberFromRequestParam(Map<String, Object> params, List<UserParam> paramList, UserResult response) {
        Set<String> numbers = this.getNumbersFromRequestParam(params);
        if (CollectionUtils.isEmpty(numbers)) {
            return false;
        }
        QFilter filter = new QFilter("number", "in", numbers);
        DynamicObject[] users = BusinessDataServiceHelper.load((String)ENTITY_KEY_BOS_USER, (String)"", (QFilter[])filter.toArray());
        if (users != null && users.length > 0) {
            for (DynamicObject user : users) {
                String number = user.getString("number");
                HashMap<String, String> dataMap = new HashMap<String, String>(1);
                dataMap.put("number", number);
                UserParam param = new UserParam();
                param.setId(user.getLong("id"));
                param.setDataMap(dataMap);
                paramList.add(param);
                numbers.remove(number);
            }
        }
        if (!numbers.isEmpty()) {
            for (String number : numbers) {
                ResponseData failData = new ResponseData();
                failData.setNumber(number);
                failData.setReason(String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u4e3a%s\u7684\u4eba\u5458\u4e0d\u5b58\u5728\u3002", (String)"UserApi_37", (String)"bos-base-webapi", (Object[])new Object[0]), number));
                response.addFailData(failData);
            }
        }
        return true;
    }

    private List<UserParam> packAddOrUpdateUserParams(Map<String, Object> params, List<UserParam> validateFailUsers) throws IOException {
        Object userObjs = params.get(PARAM_KEY_USER);
        if (Objects.isNull(userObjs)) {
            throw new InvalidParameterException(ResManager.loadKDString((String)"\u53c2\u6570users\u4e0d\u5b58\u5728\u3002", (String)"UserApi_38", (String)"bos-base-webapi", (Object[])new Object[0]));
        }
        List userInfos = (List)JSONUtils.cast((String)JSONUtils.toString((Object)userObjs), List.class, (Class[])new Class[]{UserInfo.class});
        if (CollectionUtils.isEmpty((Collection)userInfos)) {
            throw new InvalidParameterException(ResManager.loadKDString((String)"users\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"UserApi_39", (String)"bos-base-webapi", (Object[])new Object[0]));
        }
        this.fillUserPropertiesIdAndNumber(userInfos);
        ArrayList<UserParam> result = new ArrayList<UserParam>(userInfos.size());
        for (UserInfo userInfo : userInfos) {
            UserParam param = new UserParam();
            HashMap<String, Object> properties = new HashMap<String, Object>(16);
            param.setDataMap(properties);
            properties.putAll(userInfo.getExtProperties());
            if (!StringUtils.isEmpty((Object)userInfo.getName())) {
                properties.put("name", userInfo.getName());
            }
            if (!StringUtils.isEmpty((Object)userInfo.getNumber())) {
                properties.put("number", userInfo.getNumber());
            }
            if (!StringUtils.isEmpty((Object)userInfo.getPhone())) {
                properties.put("phone", userInfo.getPhone());
            }
            if (!StringUtils.isEmpty((Object)userInfo.getEmail())) {
                properties.put("email", userInfo.getEmail());
            }
            if (!this.userValidity(param, userInfo)) {
                Long id = userInfo.getId();
                if (null != id) {
                    param.setId(id.longValue());
                    param.setCustomUserId(id.longValue());
                }
                param.setSuccess(false);
                validateFailUsers.add(param);
                continue;
            }
            this.setUserBaseInfo(userInfo, param, properties);
            this.setUserDepInfo(userInfo, param);
            this.setUserContactInfo(userInfo, param);
            result.add(param);
        }
        return result;
    }

    private void fillUserPropertiesIdAndNumber(List<UserInfo> userInfos) {
        ArrayList<UserDepartment> departments = new ArrayList<UserDepartment>(10);
        ArrayList<UserContact> contacts = new ArrayList<UserContact>(10);
        ArrayList<UserType> userTypes = new ArrayList<UserType>(10);
        for (UserInfo userInfo : userInfos) {
            List<UserContact> contactInfos;
            List<UserDepartment> deps;
            List<UserType> types = userInfo.getUserTypes();
            if (!CollectionUtils.isEmpty(types)) {
                userTypes.addAll(types);
            }
            if (!CollectionUtils.isEmpty(deps = userInfo.getDepartments())) {
                departments.addAll(deps);
            }
            if (CollectionUtils.isEmpty(contactInfos = userInfo.getContactInfos())) continue;
            contacts.addAll(contactInfos);
        }
        this.fillUserTypeInfo(userTypes);
        this.fillContactInfo(contacts);
        this.fillDepartmentInfo(departments);
    }

    private void fillUserTypeInfo(List<UserType> userTypes) {
        if (userTypes.isEmpty()) {
            return;
        }
        HashSet<String> numbers = new HashSet<String>(userTypes.size());
        HashSet<Long> ids = new HashSet<Long>(userTypes.size());
        userTypes.forEach(userType -> {
            String userTypeNumber;
            Long userTypeId = userType.getUserTypeId();
            if (!Objects.isNull(userTypeId)) {
                ids.add(userTypeId);
            }
            if (!StringUtils.isEmpty((Object)(userTypeNumber = userType.getUserTypeNumber()))) {
                numbers.add(userTypeNumber);
            }
        });
        Map<String, Long> typeNum2IdMap = this.getNumber2IdMapping(ENTITY_KEY_BOS_USER_TYPE, numbers);
        Map<Long, String> id2NumMap = this.generateId2NumberMapping(ids, ENTITY_KEY_BOS_USER_TYPE);
        for (UserType userType2 : userTypes) {
            Long paramId = userType2.getUserTypeId();
            String number = id2NumMap.get(paramId);
            Long userTypeId = typeNum2IdMap.get(userType2.getUserTypeNumber());
            if (null != paramId && null == number) {
                userType2.setUserTypeNumber(null);
                continue;
            }
            if (null != paramId) {
                userType2.setUserTypeNumber(number);
                continue;
            }
            if (null == userTypeId) continue;
            userType2.setUserTypeId(userTypeId);
        }
    }

    private void fillContactInfo(List<UserContact> contacts) {
        if (contacts.isEmpty()) {
            return;
        }
        HashSet<String> numbers = new HashSet<String>(contacts.size());
        HashSet<Long> ids = new HashSet<Long>(contacts.size());
        contacts.forEach(contact -> {
            String contactTypeNumber;
            Long contactTypeId = contact.getContactTypeId();
            if (!Objects.isNull(contactTypeId)) {
                ids.add(contactTypeId);
            }
            if (!StringUtils.isEmpty((Object)(contactTypeNumber = contact.getContactTypeNumber()))) {
                numbers.add(contactTypeNumber);
            }
        });
        Map<String, Long> contactNum2IdMap = this.getNumber2IdMapping(ENTITY_KEY_BOS_CONSTANT, numbers);
        Map<Long, String> id2NumMap = this.generateId2NumberMapping(ids, ENTITY_KEY_BOS_CONSTANT);
        for (UserContact contact2 : contacts) {
            Long paramId = contact2.getContactTypeId();
            String number = id2NumMap.get(paramId);
            Long contactTypeId = contactNum2IdMap.get(contact2.getContactTypeNumber());
            if (null != paramId && null == number) {
                contact2.setContactTypeNumber(null);
                continue;
            }
            if (null != paramId) {
                contact2.setContactTypeNumber(number);
                continue;
            }
            if (null == contactTypeId) continue;
            contact2.setContactTypeId(contactTypeId);
        }
    }

    private void fillDepartmentInfo(List<UserDepartment> departments) {
        if (departments.isEmpty()) {
            return;
        }
        HashSet<String> deptNumbers = new HashSet<String>(departments.size());
        HashSet<Long> deptIds = new HashSet<Long>(departments.size());
        HashSet<String> userNumbers = new HashSet<String>(deptNumbers.size());
        HashSet<Long> userIds = new HashSet<Long>(departments.size());
        departments.forEach(department -> {
            String dptNumber;
            Long id;
            String userNumber;
            Long userId = department.getSuperiorId();
            if (!Objects.isNull(userId)) {
                userIds.add(userId);
            }
            if (!StringUtils.isEmpty((Object)(userNumber = department.getSuperiorNumber()))) {
                userNumbers.add(userNumber);
            }
            if (!Objects.isNull(id = department.getId())) {
                deptIds.add(id);
            }
            if (!StringUtils.isEmpty((Object)(dptNumber = department.getDptNumber()))) {
                deptNumbers.add(dptNumber);
            }
        });
        Map<String, Long> depNumToIdMap = this.getNumber2IdMapping(ENTITY_KEY_BOS_ADMIN_ORG, deptNumbers);
        Map<Long, String> deptId2NumMap = this.generateId2NumberMapping(deptIds, ENTITY_KEY_BOS_ADMIN_ORG);
        Map<String, Long> userNumToIdMap = this.getNumber2IdMapping(ENTITY_KEY_BOS_USER, userNumbers);
        Map<Long, String> userId2NumMap = this.generateId2NumberMapping(userIds, ENTITY_KEY_BOS_USER);
        departments.forEach(department -> {
            this.fillDepartmentUserInfo(userNumToIdMap, userId2NumMap, (UserDepartment)department);
            this.fillDepartmentInfo(depNumToIdMap, deptId2NumMap, (UserDepartment)department);
        });
    }

    private void fillDepartmentUserInfo(Map<String, Long> userNumToIdMap, Map<Long, String> userId2NumMap, UserDepartment department) {
        Long paramId = department.getSuperiorId();
        String dbUserNum = userId2NumMap.get(paramId);
        Long dbUserId = userNumToIdMap.get(department.getSuperiorNumber());
        if (null != paramId && StringUtils.isEmpty((Object)dbUserNum)) {
            department.setSuperiorNumber(null);
        } else if (null != paramId) {
            department.setSuperiorNumber(dbUserNum);
        } else if (null != dbUserId) {
            department.setSuperiorId(dbUserId);
        }
    }

    private void fillDepartmentInfo(Map<String, Long> depNumToIdMap, Map<Long, String> deptId2NumMap, UserDepartment department) {
        Long paramId = department.getId();
        String dbNumber = deptId2NumMap.get(paramId);
        Long dbId = depNumToIdMap.get(department.getDptNumber());
        if (null != paramId && StringUtils.isEmpty((Object)dbNumber)) {
            department.setDptNumber(null);
        } else if (null != paramId) {
            department.setDptNumber(dbNumber);
        } else if (null != dbId) {
            department.setId(dbId);
        }
    }

    private void packResponse(List<UserParam> paramList, UserResult response) {
        if (CollectionUtils.isEmpty(paramList)) {
            return;
        }
        for (UserParam userParam : paramList) {
            Map dataMap;
            ResponseData data = new ResponseData();
            long id = userParam.getId();
            if (0L != id) {
                data.setId(String.valueOf(id));
            }
            if (null != (dataMap = userParam.getDataMap())) {
                Object email;
                Object phone;
                Object name;
                Object number = dataMap.get("number");
                if (!Objects.isNull(number)) {
                    data.setNumber(number.toString());
                }
                if (!Objects.isNull(name = dataMap.get("name"))) {
                    data.setName(name.toString());
                }
                if (!Objects.isNull(phone = dataMap.get("phone"))) {
                    data.setPhone(phone.toString());
                }
                if (!Objects.isNull(email = dataMap.get("email"))) {
                    data.setEmail(email.toString());
                }
            }
            if (userParam.isSuccess()) {
                response.addSuccessData(data);
                continue;
            }
            data.setReason(userParam.getMsg());
            response.addFailData(data);
        }
    }
}

