/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.user.pojo;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.user.pojo.ResponseData;
import kd.bos.base.user.pojo.UserApiCheckResult;
import kd.bos.base.user.pojo.UserApiInfo;
import kd.bos.base.user.pojo.UserResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.UserParam;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class UserApiSecurity {
    private static final String API_URL_ADD_OR_UPDATE = "/app/base/users";
    private static final String API_URL_QUERY_USER = "/app/base/getUser";
    private static final String API_URL_QUERY_USERS_BY_NUMBERS = "/app/base/user_query";
    private static final String API_URL_ENABLE_USER = "/app/base/user_enable";
    private static final String API_URL_DISABLE_USER = "/app/base/user_disable";
    private static final String API_URL_DELETE_USER = "/app/base/user_delete";
    private static final String API_URL_ADD_USERS = "/app/base/user_add";
    private static final String API_URL_UPDATE_USERS = "/app/base/user_update";
    private static final String ENTITY_KEY_OPEN_API_SERVICE_NEW = "open_apiservice_new";
    private static final String PRO_ORG_AUTHOR_FILTER = "org_author_filter";
    protected static final String SYSTEM_TYPE = "bos-base-webapi";
    public static Map<String, UserApiInfo> url2ApiInfoMap = new HashMap<String, UserApiInfo>();
    private static PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);

    private static String getApiNumber(String url) {
        if (UserApiSecurity.getApiInfo(url) == null) {
            return "";
        }
        return UserApiSecurity.getApiInfo(url).getNumber();
    }

    private static String getApiPermItemId(String url) {
        return UserApiSecurity.getApiInfo(url).getPermItemId();
    }

    private static String getFunPermMsg(String url) {
        return UserApiSecurity.getApiInfo(url).getFunPermMsg();
    }

    private static String getDataPermMsg(String url) {
        return UserApiSecurity.getApiInfo(url).getDataPermMsg();
    }

    private static UserApiInfo getApiInfo(String url) {
        return url2ApiInfoMap.get(url);
    }

    private static boolean isCheckDatePermission(String url) {
        return UserApiSecurity.getApiInfo(url).isCheckDatePermission();
    }

    public static UserApiCheckResult checkPermission(String apiUrl, Map<String, Object> params) {
        if (UserApiSecurity.getApiInfo(apiUrl) == null) {
            return UserApiCheckResult.success();
        }
        DynamicObject openApiServiceBizObj = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_KEY_OPEN_API_SERVICE_NEW, (String)PRO_ORG_AUTHOR_FILTER, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)UserApiSecurity.getApiNumber(apiUrl))});
        boolean isOrgAuthorFilter = false;
        try {
            if (openApiServiceBizObj != null) {
                isOrgAuthorFilter = openApiServiceBizObj.getBoolean(PRO_ORG_AUTHOR_FILTER);
            }
        }
        catch (Exception e) {
            isOrgAuthorFilter = false;
        }
        if (isOrgAuthorFilter) {
            QFilter dataPermissionFilter;
            long userId = RequestContext.get().getCurrUserId();
            String appId = "base";
            if (!PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)"bos_user", (String)UserApiSecurity.getApiPermItemId(apiUrl))) {
                return UserApiCheckResult.fail(UserApiSecurity.getFunPermMsg(apiUrl));
            }
            if (UserApiSecurity.isCheckDatePermission(apiUrl) && (dataPermissionFilter = permissionService.getDataRuleWithoutDim(userId, appId, "bos_user", UserApiSecurity.getApiPermItemId(apiUrl), null)) != null) {
                return UserApiCheckResult.success(dataPermissionFilter, UserApiSecurity.getDataPermMsg(apiUrl));
            }
        }
        return UserApiCheckResult.success();
    }

    public static void checkDataPermission(List<UserParam> validateFailUsers, List<UserParam> userParams, UserApiCheckResult userApiCheckResult) throws IOException {
        if (userApiCheckResult.getFilter() == null) {
            return;
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{userApiCheckResult.getFilter()});
        Set ids = doc.stream().map(object -> object.getLong("id")).collect(Collectors.toSet());
        Iterator<UserParam> iterator = userParams.iterator();
        while (iterator.hasNext()) {
            UserParam userParam = iterator.next();
            long userId = userParam.getId();
            if (!userParam.isSuccess() || ids.contains(userId)) continue;
            UserParam param = new UserParam();
            param.setId(userId);
            param.setSuccess(false);
            param.setMsg(userApiCheckResult.getMsg());
            validateFailUsers.add(param);
            iterator.remove();
        }
    }

    public static void checkDataPermission(UserResult response, List<UserParam> userParams, UserApiCheckResult userApiCheckResult) {
        if (userApiCheckResult.getFilter() == null) {
            return;
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{userApiCheckResult.getFilter()});
        Set ids = doc.stream().map(object -> object.getLong("id")).collect(Collectors.toSet());
        Iterator<UserParam> iterator = userParams.iterator();
        while (iterator.hasNext()) {
            UserParam userParam = iterator.next();
            long userId = userParam.getId();
            if (!userParam.isSuccess() || ids.contains(userId)) continue;
            UserApiSecurity.addFailDataToUserResult(userParam, response, userApiCheckResult.getMsg());
            iterator.remove();
        }
    }

    public static void checkDataPermission(List<Long> ids, UserApiCheckResult userApiCheckResult) {
        if (userApiCheckResult.getFilter() == null) {
            return;
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{userApiCheckResult.getFilter()});
        Set hasPermissionIds = doc.stream().map(object -> object.getLong("id")).collect(Collectors.toSet());
        Iterator<Long> iterator = ids.iterator();
        while (iterator.hasNext()) {
            Long userId = iterator.next();
            if (hasPermissionIds.contains(userId)) continue;
            iterator.remove();
        }
    }

    public static void checkPermissionForAddOrUpdateUser(List<UserParam> userList, UserResult userResult, String apiUrl) {
        DynamicObject openApiServiceBizObj = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_KEY_OPEN_API_SERVICE_NEW, (String)PRO_ORG_AUTHOR_FILTER, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)UserApiSecurity.getApiNumber(apiUrl))});
        boolean isOrgAuthorFilter = false;
        try {
            if (openApiServiceBizObj != null) {
                isOrgAuthorFilter = openApiServiceBizObj.getBoolean(PRO_ORG_AUTHOR_FILTER);
            }
        }
        catch (Exception e) {
            isOrgAuthorFilter = false;
        }
        if (!isOrgAuthorFilter) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        String appId = "base";
        boolean hasNewPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)appId, (String)"bos_user", (String)"47156aff000000ac");
        boolean hasModifyPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)appId, (String)"bos_user", (String)"4715a0df000000ac");
        QFilter qFilter = permissionService.getDataRuleWithoutDim(currUserId, appId, "bos_user", "4715a0df000000ac", null);
        Set<Object> hasDataPermIds = new HashSet();
        if (qFilter != null) {
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{qFilter});
            hasDataPermIds = doc.stream().map(object -> object.getLong("id")).collect(Collectors.toSet());
        }
        Iterator<UserParam> iterator = userList.iterator();
        while (iterator.hasNext()) {
            boolean isAdd;
            UserParam userParam = iterator.next();
            boolean bl = isAdd = userParam.getId() == 0L;
            if (isAdd) {
                if (hasNewPerm) continue;
                UserApiSecurity.addFailDataToUserResult(userParam, userResult, ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                iterator.remove();
                continue;
            }
            Long userId = userParam.getId();
            if (!hasModifyPerm) {
                UserApiSecurity.addFailDataToUserResult(userParam, userResult, UserApiSecurity.getFunPermMsg(apiUrl));
                iterator.remove();
                continue;
            }
            if (qFilter == null || hasDataPermIds.contains(userId)) continue;
            UserApiSecurity.addFailDataToUserResult(userParam, userResult, UserApiSecurity.getDataPermMsg(apiUrl));
            iterator.remove();
        }
    }

    private static void addFailDataToUserResult(UserParam userParam, UserResult userResult, String msg) {
        ResponseData data = new ResponseData();
        long id = userParam.getId();
        if (0L != id) {
            data.setId(String.valueOf(id));
        }
        data.setReason(msg);
        Map dataMap = userParam.getDataMap();
        if (null != dataMap) {
            Object email;
            Object phone;
            Object name;
            Object number = dataMap.get("number");
            if (!Objects.isNull(number)) {
                data.setNumber(number.toString());
            }
            if (!Objects.isNull(name = dataMap.get("name"))) {
                data.setName(name.toString());
            }
            if (!Objects.isNull(phone = dataMap.get("phone"))) {
                data.setPhone(phone.toString());
            }
            if (!Objects.isNull(email = dataMap.get("email"))) {
                data.setEmail(email.toString());
            }
        }
        userResult.addFailData(data);
    }

    static {
        url2ApiInfoMap.put(API_URL_ADD_OR_UPDATE, new UserApiInfo(API_URL_ADD_OR_UPDATE, "users", "47150e89000000ac", true, ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u6570\u636e\u89c4\u5219\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_10", (String)SYSTEM_TYPE, (Object[])new Object[0])));
        url2ApiInfoMap.put(API_URL_QUERY_USER, new UserApiInfo(API_URL_QUERY_USER, "getUser", "47150e89000000ac", true, ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u6570\u636e\u89c4\u5219\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_1", (String)SYSTEM_TYPE, (Object[])new Object[0])));
        url2ApiInfoMap.put(API_URL_ENABLE_USER, new UserApiInfo(API_URL_ENABLE_USER, "user_enable", "4730fc5d000000ac", true, ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u542f\u7528\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u6570\u636e\u89c4\u5219\u542f\u7528\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_3", (String)SYSTEM_TYPE, (Object[])new Object[0])));
        url2ApiInfoMap.put(API_URL_DISABLE_USER, new UserApiInfo(API_URL_DISABLE_USER, "user_disable", "47160c2b000000ac", true, ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u7981\u7528\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u6570\u636e\u89c4\u5219\u7981\u7528\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_5", (String)SYSTEM_TYPE, (Object[])new Object[0])));
        url2ApiInfoMap.put(API_URL_DELETE_USER, new UserApiInfo(API_URL_DELETE_USER, "user_delete", "4715e1f1000000ac", true, ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u5220\u9664\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u6570\u636e\u89c4\u5219\u5220\u9664\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_7", (String)SYSTEM_TYPE, (Object[])new Object[0])));
        url2ApiInfoMap.put(API_URL_ADD_USERS, new UserApiInfo(API_URL_ADD_USERS, "user_add", "47156aff000000ac", false, ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_8", (String)SYSTEM_TYPE, (Object[])new Object[0])));
        url2ApiInfoMap.put(API_URL_UPDATE_USERS, new UserApiInfo(API_URL_UPDATE_USERS, "user_update", "4715a0df000000ac", true, ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u201c\u6570\u636e\u89c4\u5219\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"UserApiSecurity_10", (String)SYSTEM_TYPE, (Object[])new Object[0])));
    }
}

