/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.bdversion;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.bdversion.BdVersionUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BdNameHistoryListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(BdNameHistoryListPlugin.class);
    private static final String SYSTEM_TYPE = "bos-base-formplugin";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        log.debug("\u57fa\u7840\u8d44\u6599\u66fe\u7528\u540d\u67e5\u8be2\u8868\u5355\u53c2\u6570\uff1a" + formShowParameter.getCustomParams());
        String entityNumber = (String)formShowParameter.getCustomParam("basedataentityid");
        Object id = BdVersionUtils.getBaseDataParameter(this.getView());
        if (entityNumber == null || id == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u53c2\u6570\u6307\u5b9a\u8981\u67e5\u8be2\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"BdNameHistoryListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        DynamicObject baseDataDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityNumber);
        if (baseDataDyn == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002", (String)"BdNameHistoryListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        DynamicProperty nameVersionEntryProp = baseDataDyn.getDynamicObjectType().getProperty("name$version");
        if (nameVersionEntryProp == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5143\u6570\u636e\u672a\u542f\u7528\u201c\u652f\u6301\u540d\u79f0\u7248\u672c\u5316\u201d\u7684\u914d\u7f6e\u3002", (String)"BdNameHistoryListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection nameVersionCol = baseDataDyn.getDynamicObjectCollection("name$version");
        if (nameVersionCol == null || nameVersionCol.isEmpty()) {
            return;
        }
        List sortedNameVersionCol = nameVersionCol.stream().sorted((o1, o2) -> {
            int compareResult = o2.getDate("name$version$startdate").compareTo(o1.getDate("name$version$startdate"));
            if (compareResult == 0) {
                compareResult = o2.getDate("name$version$createtime").compareTo(o1.getDate("name$version$createtime"));
            }
            return compareResult;
        }).collect(Collectors.toList());
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow("entryentity", sortedNameVersionCol.size());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < sortedNameVersionCol.size(); ++i) {
            DynamicObject nameHistoryObj = (DynamicObject)sortedNameVersionCol.get(i);
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            dynamicObject.set("name", nameHistoryObj.get("name$version$name"));
            dynamicObject.set("startdate", nameHistoryObj.get("name$version$startdate"));
            dynamicObject.set("enddate", nameHistoryObj.get("name$version$enddate"));
            dynamicObject.set("enable", (Object)(nameHistoryObj.getBoolean("name$version$enable") ? "1" : "0"));
            dynamicObject.set("creator", nameHistoryObj.get("name$version$creator"));
            dynamicObject.set("createtime", nameHistoryObj.get("name$version$createtime"));
            dynamicObject.set("modifier", nameHistoryObj.get("name$version$modifier"));
            dynamicObject.set("modifytime", nameHistoryObj.get("name$version$modifytime"));
        }
        this.getModel().endInit();
    }
}

