/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.bdversion;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.bdversion.BdVersionUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class BdRenameFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BdRenameFormPlugin.class);
    private static final String CONFIRM_CALLBACK_FOR_COVER = "confirmCallBackForCover";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        log.debug("\u57fa\u7840\u8d44\u6599\u6539\u540d\u8868\u5355\u53c2\u6570\uff1a" + formShowParameter.getCustomParams());
        Object baseDataEntityId = formShowParameter.getCustomParam("basedataentityid");
        if (StringUtils.isBlank((Object)baseDataEntityId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u7684\u6807\u8bc6\u3002", (String)"BdRenameFormPlugin_2", (String)"bos-base-formplugin", (Object[])new Object[0]));
            return;
        }
        Object baseDataId = BdVersionUtils.getBaseDataParameter(this.getView());
        if (StringUtils.isBlank((Object)baseDataId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u57fa\u7840\u8d44\u6599\u7684\u4e3b\u952e\u3002", (String)"BdRenameFormPlugin_3", (String)"bos-base-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject baseDataEntity = BusinessDataServiceHelper.loadSingleFromCache((Object)baseDataId, (String)baseDataEntityId.toString());
        if (baseDataEntity == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002", (String)"BdRenameFormPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectType dynamicObjectType = baseDataEntity.getDynamicObjectType();
        DynamicProperty nameVersionEntry = dynamicObjectType.getProperty("name$version");
        if (nameVersionEntry == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5143\u6570\u636e\u672a\u542f\u7528\u201c\u652f\u6301\u540d\u79f0\u7248\u672c\u5316\u201d\u7684\u914d\u7f6e\u3002", (String)"BdRenameFormPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
            return;
        }
        String nameFieldId = BdVersionUtils.getNameFieldId(baseDataEntity);
        if (StringUtils.isBlank((CharSequence)nameFieldId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u672a\u8bbe\u7f6e\u201c\u540d\u79f0\u5b57\u6bb5\u201d\u3002", (String)"BdRenameFormPlugin_4", (String)"bos-base-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("basedataentityid", baseDataEntityId);
        this.getModel().setValue("basedataid", baseDataId);
        String numberFieldId = BdVersionUtils.getNumberFieldId(baseDataEntity);
        if (StringUtils.isNotBlank((CharSequence)numberFieldId)) {
            this.getModel().setValue("number", baseDataEntity.get(numberFieldId));
        }
        Object name = baseDataEntity.get(nameFieldId);
        this.getModel().setValue("oldname", name);
        this.getModel().setValue("name", name);
        this.formatDate("startdate");
        DynamicObjectCollection historyObjCol = baseDataEntity.getDynamicObjectCollection("name$version");
        Date maxStartDate = null;
        for (DynamicObject historyObj : historyObjCol) {
            if (!historyObj.getBoolean("name$version$enable")) continue;
            Date startDate = historyObj.getDate("name$version$startdate");
            if (maxStartDate != null && maxStartDate.compareTo(startDate) >= 0) continue;
            maxStartDate = startDate;
        }
        if (maxStartDate != null && maxStartDate.compareTo(new Date()) > 0) {
            this.getModel().setValue("startdate", (Object)maxStartDate);
            this.getModel().setValue("oldstartdate", (Object)maxStartDate);
        }
        EntityMetadata entityMetadata = this.getEntityMetadata(dynamicObjectType.getName());
        this.updateNameEditFieldProp(entityMetadata, nameFieldId);
        this.lockNameEditField(baseDataEntity, dynamicObjectType, entityMetadata, nameFieldId);
    }

    public void beforeClick(BeforeClickEvent evt) {
        evt.getSource();
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            evt.setCancel(this.cancelForCoverConfirm());
        }
    }

    private boolean cancelForCoverConfirm() {
        Date oldStartDate = this.getModel().getDataEntity().getDate("oldstartdate");
        if (oldStartDate == null || oldStartDate.compareTo(BdVersionUtils.getToday()) <= 0) {
            return false;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_CALLBACK_FOR_COVER, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u524d\u4e00\u6b21\u6539\u540d\u672a\u751f\u6548\u3002\u786e\u8ba4\u8986\u76d6\uff1f", (String)"BdRenameFormPlugin_10", (String)"bos-base-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Donothing saveOp;
        if (args.getSource() instanceof Donothing && "save".equals((saveOp = (Donothing)args.getSource()).getOperateKey())) {
            String nameVersionOptionVariables = (String)this.getView().getFormShowParameter().getCustomParam("nameVersionCustomOptionVariables");
            saveOp.getOption().setVariableValue("nameVersionCustomOptionVariables", nameVersionOptionVariables);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (CONFIRM_CALLBACK_FOR_COVER.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("save");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        if ("save".equals(eventArgs.getOperateKey())) {
            HashMap<String, String> result = new HashMap<String, String>(4);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            result.put("id", dataEntity.getString("basedataid"));
            result.put("number", dataEntity.getString("number"));
            result.put("name", dataEntity.getString("name"));
            result.put("oldName", dataEntity.getString("oldName"));
            this.getView().returnDataToParent(result);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.releaseMutexLock();
    }

    private void formatDate(String dateProp) {
        String dateFormat = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
        if (StringUtils.isNotBlank((CharSequence)dateFormat)) {
            HashMap<String, String> format = new HashMap<String, String>(4);
            format.put("mask", dateFormat);
            HashMap<String, HashMap<String, String>> itemMap = new HashMap<String, HashMap<String, String>>(4);
            itemMap.put("item", format);
            this.getView().updateControlMetadata(dateProp, itemMap);
        }
    }

    private EntityMetadata getEntityMetadata(String entityNumber) {
        QFilter numberFilter = new QFilter("number", "=", (Object)entityNumber);
        QFilter[] filters = new QFilter[]{numberFilter};
        DynamicObject entityObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"dentityid", (QFilter[])filters);
        if (entityObject == null) {
            return null;
        }
        String id = entityObject.getString("dentityid");
        return (EntityMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
    }

    private void updateNameEditFieldProp(EntityMetadata entityMetadata, String nameFieldId) {
        if (entityMetadata == null) {
            return;
        }
        Field nameField = entityMetadata.getFieldByKey(nameFieldId);
        if (!(nameField instanceof TextField)) {
            return;
        }
        TextField nameTextField = (TextField)nameField;
        HashMap<String, Integer> namePropMap = new HashMap<String, Integer>(2);
        namePropMap.put("maxlength", nameTextField.getMaxLength());
        namePropMap.put("minlength", nameTextField.getMinLength());
        HashMap<String, HashMap<String, Integer>> itemMap = new HashMap<String, HashMap<String, Integer>>(1);
        itemMap.put("item", namePropMap);
        this.getView().updateControlMetadata("name", itemMap);
        int oldNameMaxLength = 1024;
        if (nameTextField.getMaxLength() > oldNameMaxLength) {
            this.getView().updateControlMetadata("oldName", itemMap);
        }
    }

    private void lockNameEditField(DynamicObject baseDataEntity, DynamicObjectType dynamicObjectType, EntityMetadata entityMetadata, String nameFieldId) {
        if (this.lockNameEditFieldByParam()) {
            return;
        }
        this.lockNameEditFieldByStatus(baseDataEntity, dynamicObjectType, entityMetadata, nameFieldId);
    }

    private boolean lockNameEditFieldByParam() {
        String nameVersionOptionVariables = (String)this.getView().getFormShowParameter().getCustomParam("nameVersionCustomOptionVariables");
        if (StringUtils.isBlank((CharSequence)nameVersionOptionVariables)) {
            return false;
        }
        Map optionVariableMap = (Map)SerializationUtils.fromJsonString((String)nameVersionOptionVariables, Map.class);
        String lockNameHistoryField = (String)optionVariableMap.get("lockNameHistoryField");
        if (StringUtils.isBlank((CharSequence)lockNameHistoryField)) {
            return false;
        }
        boolean lock = Boolean.parseBoolean(lockNameHistoryField);
        if (lock) {
            String lockTips = ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5b57\u6bb5\u8bbe\u7f6e\u4e86\u9501\u5b9a\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"BdRenameFormPlugin_5", (String)"bos-base-formplugin", (Object[])new Object[0]);
            this.lockNameEditField(lockTips);
        }
        return lock;
    }

    private boolean lockNameEditFieldByStatus(DynamicObject baseDataEntity, DynamicObjectType dynamicObjectType, EntityMetadata entityMetadata, String nameFieldId) {
        if (entityMetadata == null || !(dynamicObjectType instanceof BasedataEntityType)) {
            return false;
        }
        Field nameField = entityMetadata.getFieldByKey(nameFieldId);
        if (nameField == null) {
            return false;
        }
        BasedataEntityType basedataEntityType = (BasedataEntityType)dynamicObjectType;
        String billStatus = basedataEntityType.getBillStatus();
        if (StringUtils.isBlank((CharSequence)billStatus)) {
            billStatus = "status";
        }
        if (basedataEntityType.getProperty(billStatus) == null) {
            return false;
        }
        String status = baseDataEntity.getString(billStatus);
        if (StringUtils.isBlank((CharSequence)status)) {
            return false;
        }
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityMetadata.getId(), (MetaCategory)MetaCategory.Form);
        if (formMetadata == null) {
            return false;
        }
        ControlAp nameItem = formMetadata.getItem(nameField.getId());
        if (nameItem == null) {
            return false;
        }
        String lock = nameItem.getLock();
        if (StringUtils.isBlank((CharSequence)lock)) {
            return false;
        }
        String[] lockArr = lock.split(",");
        String lockTips = null;
        for (String action : lockArr) {
            if ("new".equals(action)) {
                lockTips = ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5b57\u6bb5\u8bbe\u7f6e\u4e86\u201c\u65b0\u589e\u201d\u72b6\u6001\u65f6\u9501\u5b9a\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"BdRenameFormPlugin_6", (String)"bos-base-formplugin", (Object[])new Object[0]);
                break;
            }
            if ("edit".equals(action)) {
                lockTips = ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5b57\u6bb5\u8bbe\u7f6e\u4e86\u201c\u4fee\u6539\u201d\u72b6\u6001\u65f6\u9501\u5b9a\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"BdRenameFormPlugin_7", (String)"bos-base-formplugin", (Object[])new Object[0]);
                break;
            }
            if ("submit".equals(action)) {
                if (!"B".equalsIgnoreCase(status)) continue;
                lockTips = ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5b57\u6bb5\u8bbe\u7f6e\u4e86\u201c\u63d0\u4ea4\u201d\u72b6\u6001\u65f6\u9501\u5b9a\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"BdRenameFormPlugin_8", (String)"bos-base-formplugin", (Object[])new Object[0]);
                break;
            }
            if (!"audit".equals(action) || !"C".equalsIgnoreCase(status)) continue;
            lockTips = ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5b57\u6bb5\u8bbe\u7f6e\u4e86\u201c\u5df2\u5ba1\u6838\u201d\u72b6\u6001\u65f6\u9501\u5b9a\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"BdRenameFormPlugin_9", (String)"bos-base-formplugin", (Object[])new Object[0]);
            break;
        }
        return this.lockNameEditField(lockTips);
    }

    private boolean lockNameEditField(String lockTips) {
        if (lockTips == null) {
            return false;
        }
        ((Label)this.getControl("tipslabel")).setText(lockTips);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"contentpanel"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok"});
        return true;
    }

    private void releaseMutexLock() {
        Object baseDataEntityId = this.getView().getFormShowParameter().getCustomParam("basedataentityid");
        if (StringUtils.isBlank((Object)baseDataEntityId)) {
            return;
        }
        Object baseDataId = this.getView().getFormShowParameter().getCustomParam("basedataid");
        if (StringUtils.isBlank((Object)baseDataId)) {
            return;
        }
        MutexHelper.release((String)baseDataEntityId.toString(), (String)"modify", (String)baseDataId.toString());
    }
}

