/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.bdversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.bdversion.BdVersionUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class BdRenameSaveServicePlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BdRenameValidator());
    }

    static class BdRenameValidator
    extends AbstractValidator {
        BdRenameValidator() {
        }

        public void validate() {
            HashMap<String, ExtendedDataEntity> bdDataEntityMap = new HashMap<String, ExtendedDataEntity>(this.dataEntities.length);
            HashMap<String, List<String>> entityPkMap = new HashMap<String, List<String>>(this.dataEntities.length);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject renameObj = dataEntity.getDataEntity();
                String baseDataId = renameObj.getString("basedataid");
                bdDataEntityMap.put(baseDataId, dataEntity);
                String baseDataEntityId = renameObj.getString("basedataentityid");
                entityPkMap.computeIfAbsent(baseDataEntityId, v -> new ArrayList(this.dataEntities.length)).add(baseDataId);
            }
            this.invokeSaveOperation(bdDataEntityMap, entityPkMap);
        }

        private void invokeSaveOperation(Map<String, ExtendedDataEntity> bdDataEntityMap, Map<String, List<String>> entityPkMap) {
            for (Map.Entry<String, List<String>> entry : entityPkMap.entrySet()) {
                List<Object> pks = this.getObjectPks(entry.getValue(), entry.getKey());
                Map baseDataMap = BusinessDataServiceHelper.loadFromCache((Object[])pks.toArray(new Object[pks.size()]), (String)entry.getKey());
                if (baseDataMap == null || baseDataMap.isEmpty()) continue;
                String nameFieldId = null;
                HashMap<Object, Map<String, Object>> nameVersionParams = new HashMap<Object, Map<String, Object>>(baseDataMap.size());
                ArrayList<DynamicObject> baseDataObjList = new ArrayList<DynamicObject>(baseDataMap.size());
                for (Map.Entry bdEntry : baseDataMap.entrySet()) {
                    String pk = bdEntry.getKey().toString();
                    DynamicObject baseDataObj = (DynamicObject)bdEntry.getValue();
                    ExtendedDataEntity dataEntity = bdDataEntityMap.get(pk);
                    DynamicObject nameHistoryObj = dataEntity.getDataEntity();
                    String string = nameFieldId = nameFieldId == null ? BdVersionUtils.getNameFieldId(baseDataObj) : nameFieldId;
                    if (StringUtils.isBlank((CharSequence)nameFieldId)) {
                        this.addErrorMessage(bdDataEntityMap.get(pk), ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u672a\u8bbe\u7f6e\u201c\u540d\u79f0\u5b57\u6bb5\u201d\u3002", (String)"BdRenameSaveServicePlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    ILocaleString newName = nameHistoryObj.getLocaleString("name");
                    if (!BdVersionUtils.isNameChanged(baseDataObj.getLocaleString(nameFieldId), newName)) {
                        this.addErrorMessage(bdDataEntityMap.get(pk), ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u4e0d\u80fd\u4e0e\u201c\u539f\u540d\u79f0\u201d\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BdRenameSaveServicePlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    baseDataObj.set(nameFieldId, (Object)newName);
                    baseDataObjList.add(baseDataObj);
                    HashMap<String, Object> items = new HashMap<String, Object>(4);
                    items.put("name$version$startdate", nameHistoryObj.get("startdate"));
                    nameVersionParams.put(bdEntry.getKey(), items);
                }
                this.invokeSaveOperation(bdDataEntityMap, entry.getKey(), baseDataObjList, nameVersionParams);
            }
        }

        private List<Object> getObjectPks(List<String> strPks, String entityNumber) {
            ArrayList<Object> res = new ArrayList<Object>();
            ISimpleProperty primaryKey = EntityMetadataCache.getDataEntityType((String)entityNumber).getPrimaryKey();
            if (primaryKey instanceof LongProp) {
                strPks.stream().forEach(strId -> res.add(Long.valueOf(strId)));
            } else {
                strPks.stream().forEach(strId -> res.add(strId));
            }
            return res;
        }

        private void invokeSaveOperation(Map<String, ExtendedDataEntity> bdDataEntityMap, String baseDataEntityId, List<DynamicObject> baseDataObjLis, Map<Object, Map<String, Object>> nameVersionParams) {
            if (baseDataObjLis.isEmpty()) {
                return;
            }
            OperateOption operateOption = OperateOption.create();
            String saveOperateKey = null;
            String optionVariables = this.getOption().getVariableValue("nameVersionCustomOptionVariables", null);
            if (StringUtils.isNotBlank((CharSequence)optionVariables)) {
                Map nameVersionOptionVariableMap = (Map)SerializationUtils.fromJsonString((String)optionVariables, Map.class);
                saveOperateKey = (String)nameVersionOptionVariableMap.get("baseDataSaveOperateKey");
                for (Map.Entry paramEntry : nameVersionOptionVariableMap.entrySet()) {
                    operateOption.setVariableValue((String)paramEntry.getKey(), (String)paramEntry.getValue());
                }
            }
            saveOperateKey = StringUtils.isBlank(saveOperateKey) ? "save" : saveOperateKey;
            operateOption.setVariableValue("nameVersionParameters", SerializationUtils.toJsonString(nameVersionParams));
            OperationResult opResult = OperationServiceHelper.executeOperate((String)saveOperateKey, (String)baseDataEntityId, (DynamicObject[])baseDataObjLis.toArray(new DynamicObject[baseDataObjLis.size()]), (OperateOption)operateOption);
            List errorInfoList = opResult.getAllErrorOrValidateInfo();
            if (CollectionUtils.isEmpty((Collection)errorInfoList)) {
                return;
            }
            for (IOperateInfo info : errorInfoList) {
                Object pkValue = info.getPkValue();
                if (pkValue == null) {
                    throw new KDBizException(info.getMessage());
                }
                this.addErrorMessage(bdDataEntityMap.get(pkValue.toString()), info.getMessage());
            }
        }
    }
}

