/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.bdversion;

import kd.bos.base.bdversion.BdVersionUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;

public class BdVersionConfigOperatePlugin
extends AbstractOperationServicePlugIn {
    private static final String SYSTEM_TYPE = "bos-base-formplugin";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("basedataid");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("name");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BdVersionConfigEnableValidator());
    }

    private static class BdVersionConfigEnableValidator
    extends AbstractValidator {
        private BdVersionConfigEnableValidator() {
        }

        public void validate() {
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                DynamicObject baseDataDyn = extendedDataEntity.getDataEntity().getDynamicObject("basedataid");
                if (baseDataDyn == null) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BdVersionConfigOperatePlugin_2", (String)BdVersionConfigOperatePlugin.SYSTEM_TYPE, (Object[])new Object[0]));
                    continue;
                }
                String numberFieldId = BdVersionUtils.getNumberFieldId(baseDataDyn);
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseDataDyn.getString(numberFieldId));
                if (!(dataEntityType instanceof BasedataEntityType) || !((BasedataEntityType)dataEntityType).isEnableNameVersion()) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u201c%s\u201d\u672a\u542f\u7528\u201c\u652f\u6301\u540d\u79f0\u5386\u53f2\u201d\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BdVersionConfigOperatePlugin_0", (String)BdVersionConfigOperatePlugin.SYSTEM_TYPE, (Object[])new Object[0]), extendedDataEntity.getDataEntity().getString("name")));
                }
                if ("name".equals(BdVersionUtils.getDataEntityTypeNameFieldId((IDataEntityType)dataEntityType))) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u201c%s\u201d\u7684\u201c\u540d\u79f0\u5b57\u6bb5\u201d\u9700\u8981\u8bbe\u7f6e\u4e3a\u201c\u540d\u79f0\u201d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BdVersionConfigOperatePlugin_1", (String)BdVersionConfigOperatePlugin.SYSTEM_TYPE, (Object[])new Object[0]), extendedDataEntity.getDataEntity().getString("name")));
            }
        }
    }
}

