/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.bdversion;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ITreeListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BdVersionListPlugin
extends AbstractListPlugin {
    private static final String SYSTEM_TYPE = "bos-base-formplugin";
    private static final String TBL_NAMEHISTORY = "tblnamehistory";
    private static final String TBL_NAMEHISTORYVIEW = "tblnamehistoryview";
    private static final String OPERATE_NAMEHISTORY = "namehistory";
    private static final String OPERATE_NAMEHISTORYVIEW = "namehistoryview";
    private static final String CACHEKEY_CREATEORG = "createOrg";
    private static final String PRO_CREATEORG = "createorg";

    public void beforeBindData(EventObject e) {
        String entityNumber = ((ListView)this.getView()).getEntityTypeId();
        if (!BaseDataServiceHelper.isEnableNameVersion((String)entityNumber).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TBL_NAMEHISTORY, TBL_NAMEHISTORYVIEW});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        OperationResult operationResult = eventArgs.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        String operateKey = eventArgs.getOperateKey();
        if (OPERATE_NAMEHISTORY.equals(operateKey)) {
            this.showRenameForm(eventArgs);
        } else if (OPERATE_NAMEHISTORYVIEW.equals(operateKey)) {
            this.showNameHistoryForm();
        }
    }

    private void showRenameForm(AfterDoOperationEventArgs eventArgs) {
        ListView listView = (ListView)this.getView();
        String entityNumber = listView.getEntityTypeId();
        ListSelectedRowCollection rows = listView.getSelectedRows();
        Object primaryKeyValue = rows.get(0).getPrimaryKeyValue();
        StringBuilder failInfo = new StringBuilder();
        MutexLockInfo lockInfo = new MutexLockInfo(primaryKeyValue.toString(), "", null, entityNumber, "modify", false, "default");
        boolean isMutexLocked = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)failInfo);
        if (!isMutexLocked) {
            this.getView().showTipNotification(failInfo.toString());
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_bdrename");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("basedataid", primaryKeyValue);
        parameter.setCustomParam("basedataentityid", (Object)entityNumber);
        String nameVersionCustomVariables = ((DefaultEntityOperate)eventArgs.getSource()).getOption().getVariableValue("nameVersionCustomOptionVariables", null);
        parameter.setCustomParam("nameVersionCustomOptionVariables", (Object)nameVersionCustomVariables);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bos_bdrename"));
        this.getView().showForm(parameter);
    }

    private void showNameHistoryForm() {
        ListView listView = (ListView)this.getView();
        String entityNumber = listView.getEntityTypeId();
        ListSelectedRowCollection rows = listView.getSelectedRows();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_bdnamehistorylist");
        parameter.setCustomParam("basedataid", rows.get(0).getPrimaryKeyValue());
        parameter.setCustomParam("basedataentityid", (Object)entityNumber);
        this.getView().showForm(parameter);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        String itemKey = evt.getItemKey().toLowerCase();
        ListView listView = (ListView)this.getView();
        ListSelectedRowCollection rows = listView.getSelectedRows();
        if (TBL_NAMEHISTORY.equals(itemKey)) {
            if (rows.size() != 1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BdVersionListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            if (!this.orgHasRightRename().booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"BdVersionListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            this.checkCustomBaseData(evt, listView);
        } else if (TBL_NAMEHISTORYVIEW.equals(itemKey) && rows.size() != 1) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BdVersionListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
    }

    private Boolean orgHasRightRename() {
        String createOrg = this.getPageCache().get(CACHEKEY_CREATEORG);
        if (StringUtils.isEmpty((CharSequence)createOrg)) {
            return Boolean.TRUE;
        }
        ListView listView = (ListView)this.getView();
        String entityNumber = listView.getEntityTypeId();
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        if (!isBaseDataCtrl.booleanValue()) {
            return Boolean.TRUE;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (!dataEntityType.getProperties().containsKey((Object)PRO_CREATEORG)) {
            return Boolean.TRUE;
        }
        ListSelectedRowCollection rows = listView.getSelectedRows();
        Object primaryKeyValue = rows.get(0).getPrimaryKeyValue();
        DynamicObject obj = QueryServiceHelper.queryOne((String)entityNumber, (String)PRO_CREATEORG, (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
        if (obj.get(PRO_CREATEORG).toString().equals(createOrg)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void checkCustomBaseData(BeforeItemClickEvent evt, ListView listView) {
        String entityNumber = listView.getEntityTypeId();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityNumber);
        if (dataEntityType.getProperties().get((Object)masteridPropName) == null) {
            return;
        }
        Object id = listView.getSelectedRows().get(0).getPrimaryKeyValue();
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityNumber, (String)masteridPropName);
        if (dyn == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"BdVersionListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        if (!Objects.equals(id, dyn.get(masteridPropName))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u7684\u6570\u636e\u4e0d\u652f\u6301\u201c\u6539\u540d\u201d\u64cd\u4f5c\u3002", (String)"BdVersionListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (!"bos_bdrename".equals(event.getActionId())) {
            return;
        }
        Object returnData = event.getReturnData();
        if (!(returnData instanceof Map)) {
            return;
        }
        ListView listView = (ListView)this.getView();
        listView.refresh();
        ITreeListView treeListView = listView.getTreeListView();
        if (treeListView == null) {
            return;
        }
        TreeNode root = treeListView.getTreeModel().getRoot();
        if (root == null) {
            return;
        }
        Map result = (Map)returnData;
        TreeNode treeNode = root.getTreeNode(String.valueOf(result.get("id")));
        if (treeNode == null) {
            return;
        }
        if (treeNode.getText() == null) {
            treeNode.setText(String.valueOf(result.get("name")));
        } else {
            treeNode.setText(treeNode.getText().replace(String.valueOf(result.get("oldName")), String.valueOf(result.get("name"))));
        }
        treeListView.getTreeView().updateNode(treeNode);
        treeListView.getTreeModel().setRoot(root);
    }
}

