/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.bdversion;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.form.IFormView;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.org.utils.Utils;
import kd.bos.service.KDDateFormatUtils;

public class BdVersionUtils {
    public static final String BOS_BDRENAME = "bos_bdrename";
    public static final String BT_SAVE = "btnok";
    public static final String MUTEX_OPERATE_KEY = "modify";
    public static final String SAVE_OPERATE_KEY = "baseDataSaveOperateKey";
    public static final String LOCK_NAME_HISTORY_FIELD = "lockNameHistoryField";
    public static final String BASE_DATA_ID = "basedataid";
    public static final String BASE_DATA_ENTITY_ID = "basedataentityid";
    public static final String NAME_VERSION_PARAMETERS = "nameVersionParameters";
    public static final String NAME_VERSION_CUSTOM_OPTION_VARIABLES = "nameVersionCustomOptionVariables";
    public static final String OLD_NAME = "oldname";
    public static final String OLD_START_DATE = "oldstartdate";
    public static final String ENTRY_ENTITY = "name$version";
    public static final String NAME = "name$version$name";
    public static final String START_DATE = "name$version$startdate";
    public static final String END_DATE = "name$version$enddate";
    public static final String ENABLE = "name$version$enable";
    public static final String CREATOR = "name$version$creator";
    public static final String CREATE_TIME = "name$version$createtime";
    public static final String MODIFIER = "name$version$modifier";
    public static final String MODIFY_TIME = "name$version$modifytime";
    public static final String STATUS_ENABLE = "1";
    public static final String STATUS_DISABLE = "0";
    private static Date defaultStartDate = null;
    private static Date defaultEndDate = null;

    private BdVersionUtils() {
    }

    public static String getNumberFieldId(DynamicObject dataEntity) {
        DataEntityPropertyCollection properties;
        if (dataEntity == null) {
            return "";
        }
        String numberFieldId = null;
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        if (dataEntityType instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntityType;
            numberFieldId = basedataEntityType.getNumberProperty();
        } else if (dataEntityType instanceof BaseEntity) {
            BaseEntity baseEntity = (BaseEntity)dataEntity.getDataEntityType();
            numberFieldId = baseEntity.getNumberFieldId();
        }
        if (StringUtils.isBlank(numberFieldId)) {
            numberFieldId = "number";
        }
        if ((properties = dataEntity.getDynamicObjectType().getProperties()).containsKey((Object)numberFieldId)) {
            return numberFieldId;
        }
        return "";
    }

    public static String getNameFieldId(DynamicObject dataEntity) {
        if (dataEntity == null) {
            return "";
        }
        return BdVersionUtils.getDataEntityTypeNameFieldId(dataEntity.getDataEntityType());
    }

    public static String getDataEntityTypeNameFieldId(IDataEntityType dataEntityType) {
        DataEntityPropertyCollection properties;
        if (dataEntityType == null) {
            return "";
        }
        String nameFieldId = null;
        if (dataEntityType instanceof BasedataEntityType) {
            nameFieldId = ((BasedataEntityType)dataEntityType).getNameProperty();
        } else if (dataEntityType instanceof BaseEntity) {
            nameFieldId = ((BaseEntity)dataEntityType).getNameFieldId();
        }
        if (StringUtils.isBlank((CharSequence)nameFieldId)) {
            nameFieldId = "name";
        }
        if ((properties = dataEntityType.getProperties()).containsKey((Object)nameFieldId)) {
            return nameFieldId;
        }
        return "";
    }

    public static Date getToday() {
        Date today;
        DateFormat dateFormat = KDDateFormatUtils.getDateFormat();
        try {
            today = dateFormat.parse(dateFormat.format(new Date()));
        }
        catch (Exception e) {
            today = new Date();
        }
        return today;
    }

    public static Date getDefaultStartDate() {
        if (defaultStartDate == null) {
            try {
                defaultStartDate = KDDateFormatUtils.getDateTimeFormat().parse("1900-01-01 00:00:00");
            }
            catch (ParseException e) {
                return null;
            }
        }
        return defaultStartDate;
    }

    public static Date getDefaultEndDate() {
        if (defaultEndDate == null) {
            try {
                defaultEndDate = KDDateFormatUtils.getDateTimeFormat().parse("2999-12-31 23:59:59");
            }
            catch (ParseException e) {
                defaultEndDate = Utils.getEndDate();
            }
        }
        return defaultEndDate;
    }

    public static Date getEndDate(Date date, int addDays) {
        if (date == null) {
            return date;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
        cal.add(5, addDays);
        return cal.getTime();
    }

    public static boolean isNameChanged(ILocaleString oldName, ILocaleString newName) {
        if (oldName == null || newName == null) {
            return false;
        }
        Set nameEntries = newName.entrySet();
        for (Map.Entry nameEntry : nameEntries) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)nameEntry.getValue())) || ((String)nameEntry.getValue()).equals(oldName.get(nameEntry.getKey()))) continue;
            return true;
        }
        return false;
    }

    public static Object getBaseDataParameter(IFormView view) {
        Object baseDataId = view.getFormShowParameter().getCustomParam(BASE_DATA_ID);
        if (baseDataId instanceof Integer) {
            baseDataId = Long.valueOf(baseDataId.toString());
        }
        return baseDataId;
    }
}

