/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.ctsy.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.ctsy.utils.CtsyUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CtsyDistributSchemeFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
CellClickListener {
    private static final String ISC_DATA_ID = "iscdataid";
    private static final String MUL_TENANT_ID = "multenantid";
    private static final String TENANT_TYPE = "tenanttype";
    private static final String FILTER_ENTRIES = "filter_entries";
    private static final String FILTER_COLUMN = "filter_column";
    private static final String FILTER_LABEL = "filter_label";
    private static final String SOURCE_SCHEMA = "source_schema";
    private static final String SOURCE_SCHEMA_ID = "source_schema_id";
    private static final String INTERVAL = "interval";
    private static final String SCHEDULE = "schedule";
    private static final String VALIDATED_TIME = "validated_time";
    private static final String EXPIRED_TIME = "expired_time";
    private static final String SAVE = "save";
    private static final String SCHEDULE_SWITCH = "schedule_switch";
    private static final String SCHEDULE_PANEL = "schedule_panel";
    private static final String PARAMS_ENTRY_ENTITY = "params_entryentity";
    private static final String DIST_ID = "distid";
    private static final String TRIGGER_ID = "triggerid";
    private static final String TRIGGER_TYPE_EVENT = "event";
    private static final String TARGET_SCHEMA_NUMBER = "target_schema.number";
    private static final String TENANT_TYPE_MASTER = "0";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid filterEntries = (EntryGrid)this.getView().getControl(FILTER_ENTRIES);
        filterEntries.addCellClickListener((CellClickListener)this);
        TextEdit numberEdit = (TextEdit)this.getControl(FILTER_COLUMN);
        numberEdit.addButtonClickListener((ClickListener)this);
        BasedataEdit iscLink = (BasedataEdit)this.getView().getControl(ISC_DATA_ID);
        iscLink.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulTenant = (BasedataEdit)this.getView().getControl(MUL_TENANT_ID);
        mulTenant.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        DynamicObject distObject = this.getView().getModel().getDataEntity();
        if (distObject == null) {
            return;
        }
        if (SAVE.equalsIgnoreCase(operate.getOperateKey()) && distObject.getBoolean(SCHEDULE_SWITCH)) {
            if (StringUtils.isEmpty((CharSequence)distObject.getString(INTERVAL))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6267\u884c\u9891\u7387\u3002", (String)"CtsyDistributSchemeFormPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)distObject.getString(SCHEDULE))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6267\u884c\u8ba1\u5212\u89e6\u53d1\u95f4\u9694\u3002", (String)"CtsyDistributSchemeFormPlugin_7", (String)"bos-base-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)distObject.getString(VALIDATED_TIME)) || StringUtils.isEmpty((CharSequence)distObject.getString(EXPIRED_TIME))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u542f\u7528\u65f6\u95f4\u548c\u8fc7\u671f\u65f6\u95f4\u3002", (String)"CtsyDistributSchemeFormPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (distObject.getDate(EXPIRED_TIME).before(new Date())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u671f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"CtsyDistributSchemeFormPlugin_2", (String)"bos-base-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (distObject.getDate(EXPIRED_TIME).before(distObject.getDate(VALIDATED_TIME))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u65f6\u95f4\u5fc5\u987b\u5728\u8fc7\u671f\u65f6\u95f4\u4e4b\u524d\u3002", (String)"CtsyDistributSchemeFormPlugin_3", (String)"bos-base-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String property = event.getProperty().getName();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        if (ISC_DATA_ID.equalsIgnoreCase(property)) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue("group");
            if (dynamicObject == null) {
                return;
            }
            String entityId = dynamicObject.getString("number");
            qFilters.add(new QFilter(TARGET_SCHEMA_NUMBER, "=", (Object)entityId));
        } else if (MUL_TENANT_ID.equalsIgnoreCase(property)) {
            qFilters.add(new QFilter(TENANT_TYPE, "!=", (Object)TENANT_TYPE_MASTER));
        }
        event.setCustomQFilters(qFilters);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if (fieldKey.equals(FILTER_COLUMN)) {
            DynamicObject distObject = this.getView().getModel().getDataEntity();
            if (null == distObject.get(ISC_DATA_ID)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u96c6\u6210\u65b9\u6848\u3002", (String)"CtsyDistributSchemeFormPlugin_4", (String)"bos-base-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject iscObject = (DynamicObject)distObject.get(ISC_DATA_ID);
            if (null == iscObject) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848\u5f02\u5e38\u3002", (String)"CtsyDistributSchemeFormPlugin_5", (String)"bos-base-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dataCopy = BusinessDataServiceHelper.loadSingle((Object)iscObject.getLong("id"), (String)"isc_data_copy", (String)SOURCE_SCHEMA);
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("id", dataCopy.getLong(SOURCE_SCHEMA_ID));
            param.put("$row", cellClickEvent.getRow());
            this.showForm(param);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (FILTER_COLUMN.equalsIgnoreCase(key)) {
            DynamicObject distObject = this.getView().getModel().getDataEntity();
            if (null == distObject.get(ISC_DATA_ID)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u96c6\u6210\u65b9\u6848\u3002", (String)"CtsyDistributSchemeFormPlugin_4", (String)"bos-base-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject iscObject = (DynamicObject)distObject.get(ISC_DATA_ID);
            if (null == iscObject) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848\u5f02\u5e38\u3002", (String)"CtsyDistributSchemeFormPlugin_5", (String)"bos-base-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dataCopy = BusinessDataServiceHelper.loadSingle((Object)iscObject.getLong("id"), (String)"isc_data_copy", (String)SOURCE_SCHEMA);
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("id", dataCopy.getLong(SOURCE_SCHEMA_ID));
            EntryGrid filterEntries = (EntryGrid)this.getView().getControl(FILTER_ENTRIES);
            int[] rows = filterEntries.getSelectRows();
            param.put("$row", rows[0]);
            this.showForm(param);
        }
    }

    private void showForm(Map<String, Object> param) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("isc_meta_properties");
        showParameter.setCustomParams(param);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5\u5c5e\u6027", (String)"CtsyDistributSchemeFormPlugin_6", (String)"bos-base-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FILTER_COLUMN));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object data = evt.getReturnData();
        if (action.equals(FILTER_COLUMN) && data instanceof Map) {
            Map map = (Map)data;
            Object rowValue = map.get("$row");
            if (null == rowValue) {
                return;
            }
            int index = Integer.parseInt(rowValue.toString());
            DynamicObject row = this.getModel().getEntryRowEntity(FILTER_ENTRIES, index);
            row.set(FILTER_COLUMN, map.get("number"));
            row.set(FILTER_LABEL, map.get("name"));
            this.getView().updateView(FILTER_ENTRIES);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (INTERVAL.equalsIgnoreCase(name)) {
            String interval = this.getModel().getDataEntity().getString(INTERVAL);
            this.resetCronVal(interval);
        }
        if (SCHEDULE_SWITCH.equalsIgnoreCase(name)) {
            this.showSchedulePanel();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showSchedulePanel();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setISCTriggerParams();
    }

    private void setISCTriggerParams() {
        boolean isAdd;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean bl = isAdd = !dataEntity.getDataEntityState().getFromDatabase();
        if (isAdd) {
            return;
        }
        if (null == this.getModel().getValue(ISC_DATA_ID) || null == this.getModel().getValue(MUL_TENANT_ID)) {
            return;
        }
        Long distributeId = dataEntity.getLong("id");
        QFilter[] qFilters = new QFilter[]{new QFilter(DIST_ID, "=", (Object)distributeId), new QFilter("trigger_type", "=", (Object)TRIGGER_TYPE_EVENT)};
        DynamicObjectCollection distTriggerCol = QueryServiceHelper.query((String)"ctsy_dist_trigger", (String)TRIGGER_ID, (QFilter[])qFilters);
        if (distTriggerCol.isEmpty()) {
            return;
        }
        DynamicObject distributeTrigger = (DynamicObject)distTriggerCol.get(0);
        Long triggerId = distributeTrigger.getLong(TRIGGER_ID);
        DynamicObject iscTrigger = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_data_copy_trigger");
        DynamicObjectCollection iscParamsCol = (DynamicObjectCollection)iscTrigger.get(PARAMS_ENTRY_ENTITY);
        if (!iscParamsCol.isEmpty()) {
            DynamicObjectCollection paramDoc = this.getModel().getEntryEntity(PARAMS_ENTRY_ENTITY);
            this.getModel().deleteEntryData(PARAMS_ENTRY_ENTITY);
            this.getModel().batchCreateNewEntryRow(PARAMS_ENTRY_ENTITY, iscParamsCol.size());
            for (int i = 0; i < paramDoc.size(); ++i) {
                DynamicObject paramObject = (DynamicObject)paramDoc.get(i);
                paramObject.set("params_name", (Object)((DynamicObject)iscParamsCol.get(i)).getString("params_name"));
                paramObject.set("params_label", (Object)((DynamicObject)iscParamsCol.get(i)).getString("params_label"));
                paramObject.set("params_data_type", (Object)((DynamicObject)iscParamsCol.get(i)).getString("params_data_type"));
                paramObject.set("params_value", (Object)((DynamicObject)iscParamsCol.get(i)).getString("params_value"));
            }
            this.getView().sendFormAction(this.getView());
            this.getModel().setDataChanged(false);
        }
    }

    private void resetCronVal(String interval) {
        if (null == interval) {
            this.getModel().setValue(SCHEDULE, null);
        } else if (!TENANT_TYPE_MASTER.equals(interval)) {
            String scheduleVal = CtsyUtils.getCronVal(interval);
            this.getModel().setValue(SCHEDULE, (Object)scheduleVal);
        } else {
            this.getModel().setValue(SCHEDULE, null);
        }
    }

    private void showSchedulePanel() {
        boolean scheduleSwitch = this.getModel().getDataEntity().getBoolean(SCHEDULE_SWITCH);
        if (scheduleSwitch) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SCHEDULE_PANEL});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SCHEDULE_PANEL});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (SAVE.equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.setISCTriggerParams();
        }
    }
}

