/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.ctsy.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.ctsy.utils.CtsyUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class CtsyDistributSchemeListPlugin
extends AbstractListPlugin {
    private static final String TBLNEW = "tblnew";
    private static final String TBLCOPY = "tblcopy";
    private static final String TBLDEL = "tbldel";
    private static final String TBLDISABLE = "tbldisable";
    private static final String TBLENABLE = "tblenable";
    private static final String CTSY_DOMAIN = "ctsy_domain";
    private static final String EXECUTE = "execute";
    private static final String SHOW_EXECUTIONS = "show_executions";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String ISC_DATA_ID = "iscdataid";
    private static final String ISC_LINK_ID = "isclinkid";
    private static final String MANUAL = "manual";
    private static final String TEXT = "text";
    private static final String TRACE_ALL = "trace_all";
    private static final String ENABLE_TRIGGER = "enableTrigger";
    private static final String DISABLE_TRIGGER = "disableTrigger";
    private static final String NEW_TARGET_SYSTEM = "new_target_system";
    private static final String PARAMS_ENTRY_ENTITY = "params_entryentity";
    private static final String GROUP = "group";
    private static final String IS_HAS_RIGHT = "ishasright";
    private static final String IS_HAS_RIGHT_TRUE = "true";
    private static final String SAVE = "save";

    public void initialize() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        HashSet<String> itemKeys = new HashSet<String>(Arrays.asList(EXECUTE, SHOW_EXECUTIONS, TBLDEL, TBLDISABLE, TBLENABLE));
        if (itemKeys.contains(itemKey) && rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CtsyDistributSchemeListPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Map map = new HashMap(4);
        if (itemKeys.contains(itemKey) && !rows.isEmpty() && (map = BusinessDataServiceHelper.loadFromCache((Object[])rows.getPrimaryKeyValues(), (String)"ctsy_distribut_scheme")).size() != rows.getPrimaryKeyValues().length) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CtsyDistributSchemeListPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (TBLNEW.equals(itemKey.toLowerCase(Locale.ENGLISH)) || TBLCOPY.equals(itemKey.toLowerCase(Locale.ENGLISH))) {
            DynamicObject baseDataDyn;
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            Map focusNode = treeView.getTreeState().getFocusNode();
            if (CollectionUtils.isEmpty((Map)focusNode) || focusNode.get(TEXT).equals(ResManager.loadKDString((String)"\u5168\u90e8", (String)"CtsyDistributSchemeListPlugin_2", (String)"bos-base-formplugin", (Object[])new Object[0]))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u6570\u636e\u5206\u7ec4\u3002", (String)"CtsyDistributSchemeListPlugin_3", (String)"bos-base-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long entityId = 0L;
            if (focusNode.get("id") != null) {
                entityId = Long.parseLong(focusNode.get("id").toString());
            }
            if ((baseDataDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)entityId, (String)CTSY_DOMAIN)) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u6570\u636e\u5206\u7ec4\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002", (String)"CtsyDistributSchemeListPlugin_4", (String)"bos-base-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (EXECUTE.equals(itemKey.toLowerCase(Locale.ENGLISH))) {
            DynamicObject distObject;
            for (Map.Entry entry : map.entrySet()) {
                distObject = (DynamicObject)entry.getValue();
                if (distObject.getBoolean("enable")) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u53d1\u65b9\u6848\u672a\u542f\u7528\u3002", (String)"CtsyDistributSchemeListPlugin_5", (String)"bos-base-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                distObject = (DynamicObject)entry.getValue();
                this.checkIscDataTrigger(distObject, evt);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u53d1\u65b9\u6848\u6267\u884c\u6210\u529f\uff0c\u70b9\u51fb\u67e5\u770b\u6267\u884c\u7ed3\u679c\u65e5\u5fd7\u3002", (String)"CtsyDistributSchemeListPlugin_6", (String)"bos-base-formplugin", (Object[])new Object[0]));
        } else if (SHOW_EXECUTIONS.equals(itemKey.toLowerCase(Locale.ENGLISH))) {
            ArrayList<Long> iscIds = new ArrayList<Long>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                DynamicObject distObject = (DynamicObject)entry.getValue();
                DynamicObject iscObject = (DynamicObject)distObject.get(ISC_DATA_ID);
                iscIds.add(iscObject.getLong("id"));
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("isc_data_copy_execution");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            if (null == listFilterParameter) {
                listFilterParameter = new ListFilterParameter();
                showParameter.setListFilterParameter(listFilterParameter);
            }
            if (!CollectionUtils.isEmpty(iscIds)) {
                listFilterParameter.setFilter(new QFilter("data_copy_schama", "in", (Object)iscIds.toArray()));
            }
            showParameter.setListFilterParameter(listFilterParameter);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (TBLDEL.equals(itemKey.toLowerCase(Locale.ENGLISH)) || TBLDISABLE.equals(itemKey.toLowerCase(Locale.ENGLISH)) || TBLENABLE.equals(itemKey.toLowerCase(Locale.ENGLISH))) {
            for (Map.Entry entry : map.entrySet()) {
                DynamicObject distObject = (DynamicObject)entry.getValue();
                DynamicObject iscObject = (DynamicObject)distObject.get(ISC_DATA_ID);
                if (null == iscObject) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848\u5f02\u5e38\u3002", (String)"CtsyDistributSchemeListPlugin_7", (String)"bos-base-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List<Long> tenantIds = CtsyUtils.findTenantIds(distObject);
                if (CollectionUtils.isEmpty(tenantIds)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u53d1\u65b9\u6848\u7684\u76ee\u6807\u79df\u6237\u4e3a\u7a7a\u3002", (String)"CtsyDistributSchemeListPlugin_8", (String)"bos-base-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                for (Long tenantId : tenantIds) {
                    DynamicObject tenantObject;
                    if (null == tenantId || (tenantObject = BusinessDataServiceHelper.loadSingleFromCache((Object)tenantId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ctsy_tenant"))) == null) continue;
                    String iscLinkId = tenantObject.getString(ISC_LINK_ID);
                    if (StringUtils.isEmpty((CharSequence)iscLinkId)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79df\u6237\u8fde\u63a5\u6570\u636e\u6e90ID\u4e0d\u5b58\u5728\u3002", (String)"CtsyDistributSchemeListPlugin_9", (String)"bos-base-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    DynamicObject sourceObject = CtsyUtils.findLinkSource(Long.valueOf(iscLinkId));
                    if (sourceObject == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79df\u6237\u8fde\u63a5\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u3002", (String)"CtsyDistributSchemeListPlugin_10", (String)"bos-base-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    List<DynamicObject> triggerList = CtsyUtils.findTriggers(distObject.getLong("id"), tenantObject.getLong("id"), iscObject.getLong("id"));
                    if (CollectionUtils.isEmpty(triggerList)) continue;
                    for (DynamicObject triggerObject : triggerList) {
                        if (TBLDEL.equals(itemKey.toLowerCase(Locale.ENGLISH)) || TBLDISABLE.equals(itemKey.toLowerCase(Locale.ENGLISH))) {
                            CtsyUtils.triggerOperate(triggerObject, DISABLE_TRIGGER);
                            continue;
                        }
                        if (!TBLENABLE.equals(itemKey.toLowerCase(Locale.ENGLISH))) continue;
                        CtsyUtils.triggerOperate(triggerObject, ENABLE_TRIGGER);
                    }
                }
            }
        }
    }

    private void checkIscDataTrigger(DynamicObject distObject, BeforeItemClickEvent evt) {
        List<Long> tenantIds = CtsyUtils.findTenantIds(distObject);
        if (CollectionUtils.isEmpty(tenantIds)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u53d1\u65b9\u6848\u7684\u76ee\u6807\u79df\u6237\u4e3a\u7a7a\u3002", (String)"CtsyDistributSchemeListPlugin_8", (String)"bos-base-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject iscObject = (DynamicObject)distObject.get(ISC_DATA_ID);
        if (iscObject == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u53d1\u65b9\u6848\u7684\u96c6\u6210\u65b9\u6848\u5f02\u5e38\u3002", (String)"CtsyDistributSchemeListPlugin_11", (String)"bos-base-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        for (Long tenantId : tenantIds) {
            DynamicObject tenantObject;
            if (tenantId == null || (tenantObject = BusinessDataServiceHelper.loadSingleFromCache((Object)tenantId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ctsy_tenant"))) == null) continue;
            DynamicObject triggerObject = this.findIscDataTrigger(distObject, tenantObject);
            if (null == triggerObject) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u542f\u52a8\u65b9\u6848\u5931\u8d25\u3002", (String)"CtsyDistributSchemeListPlugin_12", (String)"bos-base-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            CtsyUtils.triggerOperate(triggerObject, DISABLE_TRIGGER);
            CtsyUtils.triggerOperate(triggerObject, ENABLE_TRIGGER);
            DynamicObjectCollection paramsEntry = triggerObject.getDynamicObjectCollection(PARAMS_ENTRY_ENTITY);
            HashMap<String, String> paramMap = new HashMap<String, String>(paramsEntry.size());
            if (!paramsEntry.isEmpty()) {
                for (DynamicObject paramEntry : paramsEntry) {
                    paramMap.put(paramEntry.getString("params_name"), paramEntry.getString("params_value"));
                }
            }
            DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"start", (Object[])new Object[]{triggerObject.getString("number"), paramMap, null});
        }
    }

    private DynamicObject findIscDataTrigger(DynamicObject distObject, DynamicObject tenantObject) {
        DynamicObject iscObject = (DynamicObject)distObject.get(ISC_DATA_ID);
        if (null == iscObject) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848\u5f02\u5e38\u3002", (String)"CtsyDistributSchemeListPlugin_7", (String)"bos-base-formplugin", (Object[])new Object[0]));
        }
        String iscLinkId = tenantObject.getString(ISC_LINK_ID);
        if (StringUtils.isEmpty((CharSequence)iscLinkId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79df\u6237\u8fde\u63a5\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u3002", (String)"CtsyDistributSchemeListPlugin_10", (String)"bos-base-formplugin", (Object[])new Object[0]));
        }
        DynamicObject sourceObject = CtsyUtils.findLinkSource(Long.valueOf(iscLinkId));
        if (sourceObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79df\u6237\u8fde\u63a5\u6570\u636e\u6e90\u5f02\u5e38\u3002", (String)"CtsyDistributSchemeListPlugin_13", (String)"bos-base-formplugin", (Object[])new Object[0]));
        }
        return this.updateIscDataTrigger(distObject, tenantObject, sourceObject.getLong("id"));
    }

    private DynamicObject updateIscDataTrigger(DynamicObject distObject, DynamicObject tenantObject, Long sourceId) {
        DynamicObject trigger;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"isc_data_copy_trigger");
        DynamicObject triggerObj = new DynamicObject((DynamicObjectType)dataEntityType);
        DynamicObject iscObject = (DynamicObject)distObject.get(ISC_DATA_ID);
        if (null == iscObject) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848\u5f02\u5e38\u3002", (String)"CtsyDistributSchemeListPlugin_7", (String)"bos-base-formplugin", (Object[])new Object[0]));
        }
        Long triggerId = CtsyUtils.findTriggerId(distObject.getLong("id"), tenantObject.getLong("id"), iscObject.getLong("id"), MANUAL);
        if (triggerId > 0L && (trigger = CtsyUtils.findTrigger(triggerId)) != null) {
            triggerObj = trigger;
            CtsyUtils.triggerOperate(triggerObj, DISABLE_TRIGGER);
        }
        triggerObj.set("trigger_type", (Object)MANUAL);
        triggerObj.set("data_copy", (Object)BusinessDataServiceHelper.loadSingle((Object)iscObject.getLong("id"), (String)"isc_data_copy"));
        if (StringUtils.isEmpty((CharSequence)triggerObj.getString("number"))) {
            triggerObj.set("number", (Object)CtsyUtils.getTriggerNumber(distObject, tenantObject, MANUAL));
        }
        if (StringUtils.isEmpty((CharSequence)triggerObj.getString("name"))) {
            triggerObj.set("name", (Object)CtsyUtils.getTriggerName(distObject, tenantObject, MANUAL));
        }
        triggerObj.set(TRACE_ALL, (Object)distObject.getString(TRACE_ALL));
        triggerObj.set("status", (Object)"C");
        triggerObj.set("enable", (Object)"1");
        triggerObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        triggerObj.set(NEW_TARGET_SYSTEM, (Object)sourceId);
        CtsyUtils.setFilters(distObject, triggerObj);
        Long distributeId = distObject.getLong("id");
        CtsyUtils.setParams(distributeId, triggerObj);
        OperateOption option = OperateOption.create();
        option.setVariableValue(IS_HAS_RIGHT, IS_HAS_RIGHT_TRUE);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)SAVE, (String)"isc_data_copy_trigger", (DynamicObject[])new DynamicObject[]{triggerObj}, (OperateOption)option);
        if (saveResult.isSuccess() && !saveResult.getSuccessPkIds().isEmpty()) {
            DynamicObject trigger2 = BusinessDataServiceHelper.loadSingle(saveResult.getSuccessPkIds().get(0), (String)"isc_data_copy_trigger");
            CtsyUtils.triggerOperate(trigger2, ENABLE_TRIGGER);
            if (triggerId <= 0L) {
                CtsyUtils.saveTrigger(distObject.getLong("id"), tenantObject.getLong("id"), iscObject.getLong("id"), MANUAL, trigger2.getLong("id"));
            }
            return trigger2;
        }
        return null;
    }
}

