/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.ctsy.formplugin;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Button;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class CtsyDistributeTenantListPlugin
extends AbstractListPlugin {
    private static final String BTN_OK = "distribute";
    private static final String DISTRIBUTE_CONFIG = "distributeconfig";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        if (BTN_OK.equals(button.getKey())) {
            MainEntityType dataEntityType;
            ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
            List distributeIds = (List)parameter.getCustomParam("distribute_id");
            List tenantIds = Optional.ofNullable(distributeIds).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", tenantIds)};
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"ctsy_tenant", (String)"id", (QFilter[])filters);
            Object[] dataIds = doc.isEmpty() ? new Object[]{} : doc.stream().map(tenant -> tenant.getLong("id")).toArray();
            DynamicObject[] dataEntities = BusinessDataServiceHelper.load((Object[])dataIds, (DynamicObjectType)(dataEntityType = EntityMetadataCache.getDataEntityType((String)"ctsy_tenant")));
            OperationResult result = OperationServiceHelper.executeOperate((String)DISTRIBUTE_CONFIG, (String)"ctsy_tenant", (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
            if (result.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u53d1\u6210\u529f\u3002", (String)"CtsyDistributeTenantListPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(result.getMessage());
            }
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        evt.setCancel(true);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        evt.setCancel(true);
    }
}

