/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.ctsy.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.base.ctsy.utils.CtsyUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CtsyTenantFormPlugin
extends AbstractFormPlugin {
    private static final String ISC_LINK_ID = "isclinkid";
    private static final String TENANT_TYPE = "tenanttype";
    private static final String TEST_CONNECTION = "testconnection";
    private static final String BAR_ACCOUNTS = "bar_accounts";
    private static final String STATE = "state";
    private static final String ACCOUNT_NUMBER = "accountnumber";
    private static final String ACCOUNT_ID = "accountid";
    private static final String SERVER_IP = "serverip";
    private static final String SERVER_PORT = "serverport";
    private static final String SAVE = "save";
    private static final String APP_SECRET = "appsecret";
    private static final String USER_PWD = CtsyUtils.getCipherKey();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getControl(BAR_ACCOUNTS);
        button.addClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (BAR_ACCOUNTS.equalsIgnoreCase(key)) {
            DynamicObject tenantObject = this.getView().getModel().getDataEntity();
            String serverIp = tenantObject.getString(SERVER_IP);
            String serverPort = tenantObject.getString(SERVER_PORT);
            if (StringUtils.isEmpty((CharSequence)serverIp)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bbf\u95ee\u5730\u5740\u3002", (String)"CtsyTenantFormPlugin_4", (String)"bos-base-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)serverPort)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bbf\u95ee\u7aef\u53e3\u3002", (String)"CtsyTenantFormPlugin_5", (String)"bos-base-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ComboEdit dbCombo = (ComboEdit)this.getView().getControl(ACCOUNT_NUMBER);
            ArrayList<ComboItem> items = CtsyUtils.getAccountItems(tenantObject);
            dbCombo.setComboItems(items);
            if (CollectionUtils.isEmpty(items)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u79df\u6237\u6570\u636e\u4e2d\u5fc3\u5f02\u5e38\u3002", (String)"CtsyTenantFormPlugin_6", (String)"bos-base-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79df\u6237\u6570\u636e\u4e2d\u5fc3\u83b7\u53d6\u6210\u529f\u3002", (String)"CtsyTenantFormPlugin_7", (String)"bos-base-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (ACCOUNT_NUMBER.equalsIgnoreCase(name)) {
            IDataModel model = this.getModel();
            String selectText = (String)model.getValue(ACCOUNT_NUMBER);
            this.getModel().setValue(ACCOUNT_ID, (Object)selectText);
        } else if (TENANT_TYPE.equalsIgnoreCase(name)) {
            DynamicObject tenantObject = this.getView().getModel().getDataEntity();
            String tenantType = tenantObject.getString(TENANT_TYPE);
            if (!"0".equals(tenantType)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{TEST_CONNECTION});
                return;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TEST_CONNECTION});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        DynamicObject tenantObject = this.getView().getModel().getDataEntity();
        if (tenantObject == null) {
            return;
        }
        if (TEST_CONNECTION.equalsIgnoreCase(operate.getOperateKey())) {
            String iscLinkId;
            if (this.getModel().getDataChanged()) {
                args.setCancel(true);
                args.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u79df\u6237\u914d\u7f6e\u3002", (String)"CtsyTenantFormPlugin_8", (String)"bos-base-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u79df\u6237\u914d\u7f6e\u3002", (String)"CtsyTenantFormPlugin_8", (String)"bos-base-formplugin", (Object[])new Object[0]));
                return;
            }
            String string = iscLinkId = StringUtils.isEmpty((CharSequence)tenantObject.getString(ISC_LINK_ID)) || 0L == tenantObject.getLong(ISC_LINK_ID) ? tenantObject.getString(ACCOUNT_ID) : tenantObject.getString(ISC_LINK_ID);
            if (StringUtils.isEmpty((CharSequence)iscLinkId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u79df\u6237\u6570\u636e\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"CtsyTenantFormPlugin_3", (String)"bos-base-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"isc_database_link");
            Map resultMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{iscLinkId}, (DynamicObjectType)dataEntityType);
            if (CollectionUtils.isEmpty((Map)resultMap)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u79df\u6237\u6570\u636e\u6e90\u8fde\u63a5\u4e0d\u5b58\u5728\u3002", (String)"CtsyTenantFormPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject linkObj = null;
            for (Map.Entry entry : resultMap.entrySet()) {
                DynamicObject obj = (DynamicObject)entry.getValue();
                if (null == obj) continue;
                linkObj = obj;
                break;
            }
            if (null == linkObj) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u79df\u6237\u6570\u636e\u6e90\u8fde\u63a5\u4e0d\u5b58\u5728\u3002", (String)"CtsyTenantFormPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.testConnection(tenantObject, linkObj);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        DynamicObject tenantObject = this.getView().getModel().getDataEntity();
        if (tenantObject == null) {
            return;
        }
        if (SAVE.equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.showTestConnectionBut();
            this.decode3thAppSecretAndUserPwd();
            this.getModel().setDataChanged(false);
            return;
        }
        if (TEST_CONNECTION.equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.encode3thAppSecretAndUserPwd(tenantObject);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantObject});
            this.decode3thAppSecretAndUserPwd();
            this.getModel().setDataChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection(DynamicObject tenantObject, DynamicObject linkObject) {
        Map resultMap;
        block7: {
            tenantObject.set(STATE, (Object)"F");
            resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"testConnection", (Object[])new Object[]{linkObject.getString("number")});
            if (!CollectionUtils.isEmpty((Map)resultMap)) break block7;
            this.encode3thAppSecretAndUserPwd(tenantObject);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantObject});
            this.decode3thAppSecretAndUserPwd();
            return;
        }
        try {
            if (Boolean.parseBoolean(String.valueOf(resultMap.get("success")))) {
                tenantObject.set(STATE, (Object)"S");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u6d4b\u8bd5\u6210\u529f\u3002", (String)"CtsyTenantFormPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8fde\u63a5\u6d4b\u8bd5\u5931\u8d25\u3002", (String)"CtsyTenantFormPlugin_2", (String)"bos-base-formplugin", (Object[])new Object[0]), String.valueOf(resultMap.get("message")), MessageTypes.Default);
            }
            this.encode3thAppSecretAndUserPwd(tenantObject);
        }
        catch (Exception e) {
            try {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8fde\u63a5\u6d4b\u8bd5\u5931\u8d25\u3002", (String)"CtsyTenantFormPlugin_2", (String)"bos-base-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
                this.encode3thAppSecretAndUserPwd(tenantObject);
            }
            catch (Throwable throwable) {
                this.encode3thAppSecretAndUserPwd(tenantObject);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantObject});
                this.decode3thAppSecretAndUserPwd();
                throw throwable;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantObject});
            this.decode3thAppSecretAndUserPwd();
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantObject});
        this.decode3thAppSecretAndUserPwd();
    }

    private void encode3thAppSecretAndUserPwd(DynamicObject tenantObject) {
        tenantObject.set(APP_SECRET, (Object)Encrypters.encode((String)tenantObject.getString(APP_SECRET)));
        tenantObject.set(USER_PWD, (Object)Encrypters.encode((String)tenantObject.getString(USER_PWD)));
    }

    public void afterBindData(EventObject e) {
        this.showTestConnectionBut();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initDataAccount();
        this.decode3thAppSecretAndUserPwd();
        this.getModel().setDataChanged(false);
    }

    private void decode3thAppSecretAndUserPwd() {
        if (null != this.getModel().getValue(APP_SECRET)) {
            this.getModel().setValue(APP_SECRET, (Object)Encrypters.decode((String)((String)this.getModel().getValue(APP_SECRET))));
        }
        if (null != this.getModel().getValue(USER_PWD)) {
            this.getModel().setValue(USER_PWD, (Object)Encrypters.decode((String)((String)this.getModel().getValue(USER_PWD))));
        }
    }

    private void showTestConnectionBut() {
        DynamicObject tenantObject = this.getView().getModel().getDataEntity();
        String tenantType = tenantObject.getString(TENANT_TYPE);
        if (!"0".equals(tenantType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TEST_CONNECTION});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TEST_CONNECTION});
    }

    private void initDataAccount() {
        DynamicObject tenantObject = this.getView().getModel().getDataEntity();
        if (!StringUtils.isEmpty((CharSequence)tenantObject.getString(ACCOUNT_ID)) && !StringUtils.isEmpty((CharSequence)tenantObject.getString(ACCOUNT_NUMBER))) {
            ComboEdit dbCombo = (ComboEdit)this.getView().getControl(ACCOUNT_NUMBER);
            ArrayList<ComboItem> items = CtsyUtils.getAccountItems(tenantObject);
            dbCombo.setComboItems(items);
            this.getModel().setValue(ACCOUNT_NUMBER, (Object)tenantObject.getString(ACCOUNT_ID));
            this.getModel().setDataChanged(false);
        }
    }
}

