/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.ctsy.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.ctsy.utils.CtsyUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;

public class CtsyTenantListPlugin
extends AbstractListPlugin {
    private static final String BILL_LIST_AP = "billlistap";
    private static final String REFRESH = "tblrefresh";
    private static final String TEST_CONNECTION = "testconnection";
    private static final String DEPLOY_CONNECTION = "deployconnection";
    private static final String TBL_CLOSE = "tblclose";
    private static final String BILLLISTAP = "billlistap";
    private static final String ISC_LINK_ID = "isclinkid";
    private static final String TBL_ENABLE = "tblenable";
    private static final String TENANT_TYPE = "tenanttype";
    private static final String DEPLOY_STATE = "deploy_state";
    private static final String STATE = "state";
    private static final String ISC_DATA_SOURCE = "isc_data_source";
    private static final String STATE_F = "F";
    private static final String STATE_S = "S";
    private static final String DISTRIBUTE_CONFIG = "distributeconfig";
    private static final String CONFIRM_DISTRIBUTE = "confirm_distribute";
    private static final String ACCOUNT_NUMBER = "accountnumber";
    private static final String ACCOUNT_ID = "accountid";

    public void afterCreateNewData(EventObject e) {
        this.getView().addClientCallBack(TEST_CONNECTION);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (!TEST_CONNECTION.equals(e.getName())) {
            return;
        }
        this.testConnection();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        HashSet<String> itemKeys = new HashSet<String>(Arrays.asList(TEST_CONNECTION, DEPLOY_CONNECTION));
        if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId()) && !TBL_CLOSE.equals(itemKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u7ba1\u7406\u5458\u624d\u53ef\u4ee5\u64cd\u4f5c\u79df\u6237\u3002", (String)"CtsyTenantListPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (REFRESH.equals(itemKey.toLowerCase(Locale.ENGLISH))) {
            this.getView().addClientCallBack(TEST_CONNECTION);
        }
        if (TBL_ENABLE.equals(itemKey.toLowerCase(Locale.ENGLISH)) || TEST_CONNECTION.equals(itemKey.toLowerCase(Locale.ENGLISH)) || DEPLOY_CONNECTION.equals(itemKey.toLowerCase(Locale.ENGLISH))) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CtsyTenantListPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (rows.size() > 1 && itemKeys.contains(itemKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u6d4b\u8bd5\u6216\u90e8\u7f72\u591a\u6761\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"CtsyTenantListPlugin_2", (String)"bos-base-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Map dataMap = BusinessDataServiceHelper.loadFromCache((Object[])rows.getPrimaryKeyValues(), (String)"ctsy_tenant");
            if (dataMap.size() != rows.getPrimaryKeyValues().length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CtsyTenantListPlugin_3", (String)"bos-base-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            for (Map.Entry entry : dataMap.entrySet()) {
                String iscLinkId;
                DynamicObject tenantObject = (DynamicObject)entry.getValue();
                String tenantType = tenantObject.getString(TENANT_TYPE);
                if ("0".equals(tenantType) && (TEST_CONNECTION.equals(itemKey.toLowerCase(Locale.ENGLISH)) || DEPLOY_CONNECTION.equals(itemKey.toLowerCase(Locale.ENGLISH)))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u96c6\u56e2\u79df\u6237\u4e0d\u9700\u8981\u8fde\u63a5\u6d4b\u8bd5\u6216\u90e8\u7f72\u3002", (String)"CtsyTenantListPlugin_4", (String)"bos-base-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if ("0".equals(tenantType)) continue;
                String string = iscLinkId = StringUtils.isEmpty((CharSequence)tenantObject.getString(ISC_LINK_ID)) || 0L == tenantObject.getLong(ISC_LINK_ID) ? tenantObject.getString(ACCOUNT_ID) : tenantObject.getString(ISC_LINK_ID);
                if (StringUtils.isEmpty((CharSequence)iscLinkId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u79df\u6237\u6570\u636e\u6e90\u8fde\u63a5\u4e0d\u5b58\u5728\u3002", (String)"CtsyTenantListPlugin_5", (String)"bos-base-formplugin", (Object[])new Object[0]));
                }
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"isc_database_link");
                DynamicObject linkObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(iscLinkId), (DynamicObjectType)dataEntityType);
                if (null == linkObj) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u79df\u6237\u6570\u636e\u6e90\u8fde\u63a5\u4e0d\u5b58\u5728\u3002", (String)"CtsyTenantListPlugin_5", (String)"bos-base-formplugin", (Object[])new Object[0]));
                }
                switch (itemKey.toLowerCase(Locale.ENGLISH)) {
                    case "testconnection": {
                        this.testConnection(tenantObject, linkObj);
                        break;
                    }
                    case "deployconnection": {
                        this.deployConnection(tenantObject, linkObj, evt);
                        break;
                    }
                    case "tblenable": {
                        if (!STATE_S.equals(tenantObject.getString(STATE))) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u72b6\u6001\u6b63\u5e38\u624d\u80fd\u542f\u7528\u3002", (String)"CtsyTenantListPlugin_7", (String)"bos-base-formplugin", (Object[])new Object[0]));
                            evt.setCancel(true);
                            return;
                        }
                        if (null != tenantObject.get(DEPLOY_STATE) && !"".equals(tenantObject.get(DEPLOY_STATE))) break;
                        this.deployConnection(tenantObject, linkObj, evt);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection(DynamicObject tenantObject, DynamicObject linkObject) {
        block5: {
            tenantObject.set(STATE, (Object)STATE_F);
            try {
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"testConnection", (Object[])new Object[]{linkObject.getString("number")});
                if (CollectionUtils.isEmpty((Map)resultMap)) break block5;
                if (Boolean.parseBoolean(String.valueOf(resultMap.get("success")))) {
                    tenantObject.set(STATE, (Object)STATE_S);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u6d4b\u8bd5\u6210\u529f\u3002", (String)"CtsyTenantListPlugin_8", (String)"bos-base-formplugin", (Object[])new Object[0]));
                    break block5;
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u8fde\u63a5\u6d4b\u8bd5\u5931\u8d25\u3002", (String)"CtsyTenantListPlugin_9", (String)"bos-base-formplugin", (Object[])new Object[0]), String.valueOf(resultMap.get("message")), MessageTypes.Default);
            }
            catch (Exception e) {
                try {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8fde\u63a5\u6d4b\u8bd5\u5931\u8d25\u3002", (String)"CtsyTenantListPlugin_9", (String)"bos-base-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
                }
                catch (Throwable throwable) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantObject});
                    this.refresh();
                    throw throwable;
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantObject});
                this.refresh();
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantObject});
        this.refresh();
    }

    private void refresh() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployConnection(DynamicObject tenantObject, DynamicObject linkObject, BeforeItemClickEvent evt) {
        block6: {
            String number = linkObject.getString("number");
            String localUrl = CtsyUtils.getLocalAddress();
            if (StringUtils.isEmpty((CharSequence)localUrl)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u7f72\u8fde\u63a5\u83b7\u53d6\u5931\u8d25\u3002", (String)"CtsyTenantListPlugin_10", (String)"bos-base-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String ierpUrl = UrlService.getDomainContextUrl().replace("localhost", localUrl);
            String appSecret = Encrypters.decode((String)tenantObject.getString("appsecret"));
            HashMap<String, String> requestMap = new HashMap<String, String>(4);
            requestMap.put("number", number);
            requestMap.put("ierpUrl", ierpUrl);
            requestMap.put("password", appSecret);
            requestMap.put("permissionMode", "PUBLIC");
            tenantObject.set(DEPLOY_STATE, (Object)"");
            try {
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"deployConnection", (Object[])new Object[]{requestMap});
                if (CollectionUtils.isEmpty((Map)resultMap) || resultMap.get("success") == null || !Boolean.parseBoolean(String.valueOf(resultMap.get("success")))) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u90e8\u7f72\u5931\u8d25\u3002", (String)"CtsyTenantListPlugin_11", (String)"bos-base-formplugin", (Object[])new Object[0]), String.valueOf(resultMap.get("message")), MessageTypes.Default);
                    evt.setCancel(true);
                    break block6;
                }
                tenantObject.set(DEPLOY_STATE, (Object)ResManager.loadKDString((String)"\u5df2\u90e8\u7f72", (String)"CtsyTenantListPlugin_12", (String)"bos-base-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                try {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u90e8\u7f72\u5931\u8d25\u3002", (String)"CtsyTenantListPlugin_11", (String)"bos-base-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
                    evt.setCancel(true);
                }
                catch (Throwable throwable) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantObject});
                    this.refresh();
                    throw throwable;
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantObject});
                this.refresh();
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantObject});
        this.refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("delete".equalsIgnoreCase(operate.getType())) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.isEmpty()) {
                return;
            }
            Map map = BusinessDataServiceHelper.loadFromCache((Object[])rows.getPrimaryKeyValues(), (String)"ctsy_tenant");
            if (map.size() != rows.getPrimaryKeyValues().length) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CtsyTenantListPlugin_3", (String)"bos-base-formplugin", (Object[])new Object[0]));
                args.cancel = true;
            }
            this.deleteIsvLink(map);
            return;
        }
        if (DISTRIBUTE_CONFIG.equals(operate.getOperateKey())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_DISTRIBUTE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5206\u53d1\u201c\u8fde\u63a5\u72b6\u6001\u201d\u4e3a\u201c\u6b63\u5e38\u201d\uff0c\u4e14\u201c\u90e8\u7f72\u72b6\u6001\u201d\u4e3a\u201c\u5df2\u90e8\u7f72\u201d\u7684\u914d\u7f6e\u4fe1\u606f\u3002\u786e\u5b9a\u6267\u884c\uff1f", (String)"CtsyTenantListPlugin_14", (String)"bos-base-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (CONFIRM_DISTRIBUTE.equals(event.getCallBackId()) && MessageBoxResult.Yes == event.getResult()) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"ctsy_tenant_distribute", (boolean)true);
            parameter.setBillFormId("ctsy_tenant_distribute");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setLookUp(true);
            parameter.setMustInput(false);
            List filters = parameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter(STATE, "=", (Object)STATE_S));
            filters.add(new QFilter(DEPLOY_STATE, "=", (Object)ResManager.loadKDString((String)"\u5df2\u90e8\u7f72", (String)"CtsyTenantListPlugin_12", (String)"bos-base-formplugin", (Object[])new Object[0])));
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"ctsy_tenant", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
            Object[] dataIds = doc.isEmpty() ? new Object[]{} : doc.stream().map(tenant -> tenant.getLong("id")).toArray();
            parameter.setCaption(ResManager.loadKDString((String)"\u76ee\u6807\u79df\u6237", (String)"CtsyTenantListPlugin_15", (String)"bos-base-formplugin", (Object[])new Object[0]));
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            parameter.setCustomParam("distribute_id", Arrays.stream(rows.getPrimaryKeyValues()).collect(Collectors.toList()));
            if (dataIds.length > 0) {
                parameter.setSelectedRows(dataIds);
            }
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void deleteIsvLink(Map<Object, DynamicObject> tenantMap) {
        ArrayList<Long> pks = new ArrayList<Long>(tenantMap.size());
        for (Map.Entry<Object, DynamicObject> entry : tenantMap.entrySet()) {
            long iscAccountLinkId;
            DynamicObject tenant = entry.getValue();
            long iscLinkId = tenant.getLong(ISC_LINK_ID);
            if (iscLinkId > 0L) {
                pks.add(iscLinkId);
                this.delLinkSource(iscLinkId);
            }
            if ((iscAccountLinkId = tenant.getLong(ACCOUNT_ID)) <= 0L) continue;
            pks.add(iscAccountLinkId);
            this.delLinkSource(iscAccountLinkId);
        }
        if (CollectionUtils.isEmpty(pks)) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"isc_database_link");
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])pks.toArray());
    }

    private void delLinkSource(Long linkId) {
        QFilter[] filters = new QFilter[]{new QFilter("dblink", "=", (Object)linkId)};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ISC_DATA_SOURCE, (QFilter[])filters);
        if (null == dynamicObject) {
            return;
        }
        Long sourceId = dynamicObject.getLong("id");
        if (sourceId <= 0L) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)ISC_DATA_SOURCE);
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])new Object[]{sourceId});
    }

    protected void testConnection() {
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)};
        Map tenantMap = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenant", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)tenantMap)) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"isc_database_link");
        List iscIERPLinkIds = tenantMap.values().stream().filter(tenantObject -> !StringUtils.isEmpty((CharSequence)tenantObject.getString(ISC_LINK_ID)) && !"0".equals(tenantObject.getString(TENANT_TYPE))).map(tenantObject -> tenantObject.getString(ISC_LINK_ID)).map(Long::valueOf).collect(Collectors.toList());
        List iscAPILinkIds = tenantMap.values().stream().map(tenantObject -> tenantObject.getLong(ACCOUNT_ID)).collect(Collectors.toList());
        iscIERPLinkIds.addAll(iscAPILinkIds);
        Map linkObjMap = CollectionUtils.isEmpty(iscIERPLinkIds) ? Collections.emptyMap() : BusinessDataServiceHelper.loadFromCache((Object[])iscIERPLinkIds.toArray(), (DynamicObjectType)dataEntityType);
        for (Map.Entry entry : tenantMap.entrySet()) {
            String result;
            String tenantType;
            DynamicObject tenantObject2 = (DynamicObject)entry.getValue();
            if (null == tenantObject2 || "0".equals(tenantType = tenantObject2.getString(TENANT_TYPE)) || (result = this.checkTenantStatus(tenantObject2, linkObjMap)).equals(tenantObject2.getString(STATE))) continue;
            tenantObject2.set(STATE, (Object)result);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantObject2});
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refresh();
    }

    private String checkTenantStatus(DynamicObject tenantObject, Map<Object, DynamicObject> linkObjMap) {
        long iscLinkId;
        long l = iscLinkId = 0L == tenantObject.getLong(ISC_LINK_ID) ? tenantObject.getLong(ACCOUNT_ID) : tenantObject.getLong(ISC_LINK_ID);
        if (0L == iscLinkId) {
            return STATE_F;
        }
        String tenantType = tenantObject.getString(TENANT_TYPE);
        if ("0".equals(tenantType)) {
            return STATE_S;
        }
        DynamicObject linkObj = linkObjMap.get(iscLinkId);
        if (null == linkObj) {
            return STATE_F;
        }
        return this.testConnection(linkObj);
    }

    private String testConnection(DynamicObject linkObject) {
        String result = STATE_F;
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"testConnection", (Object[])new Object[]{linkObject.getString("number")});
        if (!CollectionUtils.isEmpty((Map)resultMap) && Boolean.parseBoolean(String.valueOf(resultMap.get("success")))) {
            result = STATE_S;
        }
        return result;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                String accountNumber;
                DynamicObjectCollection dynamicObjects = super.getData(start, limit);
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    ArrayList<ComboItem> tempItems = CtsyUtils.getAccountItems(dynamicObject);
                    if (CollectionUtils.isEmpty(tempItems)) continue;
                    comboItems.addAll(tempItems);
                }
                HashMap<String, String> accountMap = new HashMap<String, String>(comboItems.size());
                for (ComboItem comboItem : comboItems) {
                    accountNumber = null != comboItem.getCaption() ? comboItem.getCaption().getLocaleValue() : null;
                    accountMap.put(comboItem.getValue(), accountNumber);
                }
                for (DynamicObject dynamicObject : dynamicObjects) {
                    accountNumber = (String)accountMap.get(dynamicObject.getString(CtsyTenantListPlugin.ACCOUNT_ID));
                    if (null == accountNumber) continue;
                    dynamicObject.set(CtsyTenantListPlugin.ACCOUNT_NUMBER, (Object)accountNumber);
                }
                return dynamicObjects;
            }
        });
    }
}

