/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.ctsy.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CtsyTenantOrgRelationFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener {
    private static final String TREE_VIEW = "treeview";
    private static final String ROOT_ID = "-1";
    private static final String ADVCONTOOLBARAP_ORG = "advcontoolbarap_org";
    private static final String TENANT_TYPE = "tenanttype";
    private static final String ORG_ENTITY = "orgentity";
    private static final String UNIT_ENTITY = "unitentity";
    private static final String KEY_TAP = "tabap";
    private static final String UNIT_TAB_PAGE_AP = "unittabpageap";
    private static final String TOOL_BAR_AP = "toolbarap";
    private static final String ADV_CON_BAR_ITEM_NEW = "advconbaritemnew";
    private static final String ADV_CON_BAR_ITEM_DEL = "advconbaritemdel";
    private static final String BOS_ADMIN_ORG = "bos_adminorg";
    private static final String BOS_ORG = "bos_org";
    private static final String ORG_RELATION_TYPE = "0";
    private static final String UNIT_RELATION_TYPE = "1";
    private static final String ORG_ID = "orgid";
    private static final String TENANT_ID = "tenantid";
    private static final String CREATOR = "creator";
    private static final String CREATE_TIME = "createtime";
    private static final String UNIT_ID = "unitid";
    private static final String UNIT_TENANT_ID = "unittenantid";
    private static final String UNIT_CREATOR = "unitcreator";
    private static final String UNIT_CREATE_TIME = "unitcreatetime";
    private static final String TBL_REFRESH = "tblrefresh";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP_ORG, TOOL_BAR_AP, KEY_TAP});
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Tab tab = (Tab)this.getControl(KEY_TAP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey = evt.getOperationKey();
        String entityType = ORG_ENTITY;
        if (UNIT_RELATION_TYPE.equals(this.selectTab())) {
            entityType = UNIT_ENTITY;
        }
        switch (operationKey) {
            case "tblrefresh": {
                this.refresh();
                break;
            }
            case "advconbaritemnew": {
                int rowNumber = this.getModel().getEntryRowCount(entityType);
                this.orgF7Select(rowNumber);
                break;
            }
            case "advconbaritemdel": {
                this.deleteOrg(entityType);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        this.loadAllTenantTree();
    }

    private void orgF7Select(int rowNumber) {
        Object[] orgList = new Long[rowNumber];
        String rowType = ORG_ID;
        if (UNIT_RELATION_TYPE.equals(this.selectTab())) {
            rowType = UNIT_ID;
        }
        for (int i = 0; i < orgList.length; ++i) {
            String strOrgId;
            DynamicObject orgObject = (DynamicObject)this.getModel().getValue(rowType, i);
            if (orgObject == null || orgObject.getPkValue() == null || !StringUtils.isNotEmpty((CharSequence)(strOrgId = String.valueOf(orgObject.getPkValue())))) continue;
            Long orgId = Long.valueOf(strOrgId);
            orgList[i] = orgId;
        }
        String tabType = this.selectTab();
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)BOS_ADMIN_ORG, (boolean)true);
        if (UNIT_RELATION_TYPE.equals(tabType)) {
            lsp = ShowFormHelper.createShowListForm((String)BOS_ORG, (boolean)true);
        }
        lsp.setSelectedRows(orgList);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADV_CON_BAR_ITEM_NEW));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void deleteOrg(String entityType) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entityType);
        int[] indexs = entryGrid.getEntryState().getSelectedRows();
        if (indexs.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5f85\u5220\u9664\u884c\u3002", (String)"CtsyTenantOrgRelationFormPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(indexs.length);
        String rowType = ORG_ID;
        if (UNIT_RELATION_TYPE.equals(this.selectTab())) {
            rowType = UNIT_ID;
        }
        for (int index : indexs) {
            DynamicObject orgObject;
            DynamicObject relationObject = (DynamicObject)this.getModel().getEntryEntity(entityType).get(index);
            if (null == relationObject || null == (orgObject = (DynamicObject)relationObject.get(rowType))) continue;
            orgIds.add(orgObject.getLong("id"));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter(ORG_ID, "in", (Object)orgIds.toArray()));
        qFilters.add(new QFilter(TENANT_ID, "=", (Object)Long.valueOf(this.getFocusNodeId())));
        qFilters.add(new QFilter("type", "=", (Object)this.selectTab()));
        DeleteServiceHelper.delete((String)"ctsy_tenantorgrelation", (QFilter[])qFilters.toArray(new QFilter[0]));
        this.getModel().deleteEntryRows(entityType, indexs);
        this.refresh();
    }

    private Set<String> loadAllTenantTree() {
        TreeNode rootNode = this.getRootNode();
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)UNIT_RELATION_TYPE)};
        Map tenantMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ctsy_tenant"), (QFilter[])filters);
        HashSet<String> tenantObjIds = new HashSet<String>(tenantMap.size());
        if (!CollectionUtils.isEmpty((Map)tenantMap)) {
            for (Map.Entry entry : tenantMap.entrySet()) {
                DynamicObject tenantObject = (DynamicObject)entry.getValue();
                String tenantObjId = String.valueOf(entry.getKey());
                String name = tenantObject.getString("name");
                if (!StringUtils.isEmpty((CharSequence)tenantObject.getString(TENANT_TYPE)) && ORG_RELATION_TYPE.equals(tenantObject.getString(TENANT_TYPE))) continue;
                TreeNode treeNode = new TreeNode();
                treeNode.setId(tenantObjId);
                treeNode.setText(name);
                treeNode.setParentid(rootNode.getId());
                rootNode.addChild(treeNode);
                tenantObjIds.add(tenantObjId);
            }
        }
        TreeView tv = (TreeView)this.getControl(TREE_VIEW);
        tv.addNode(rootNode);
        tv.expand(rootNode.getId());
        this.switchTenantById(rootNode.getId());
        return tenantObjIds;
    }

    private TreeNode getRootNode() {
        TreeNode rootNode = new TreeNode("", ROOT_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"CtsyTenantOrgRelationFormPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]), true);
        QFilter[] filters = new QFilter[]{new QFilter(TENANT_TYPE, "=", (Object)ORG_RELATION_TYPE)};
        Map tenantMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ctsy_tenant"), (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)tenantMap)) {
            return rootNode;
        }
        for (Map.Entry entry : tenantMap.entrySet()) {
            DynamicObject tenantObject = (DynamicObject)entry.getValue();
            if (StringUtils.isEmpty((CharSequence)tenantObject.getString(TENANT_TYPE)) || !ORG_RELATION_TYPE.equals(tenantObject.getString(TENANT_TYPE))) continue;
            rootNode = new TreeNode("", String.valueOf(entry.getKey()), tenantObject.getString("name"), true);
        }
        return rootNode;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = String.valueOf(evt.getNodeId());
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            return;
        }
        this.switchTenantById(nodeId);
    }

    private String selectTab() {
        String tabType = ORG_RELATION_TYPE;
        Tab tab = (Tab)this.getControl(KEY_TAP);
        String tabKey = tab.getCurrentTab();
        if (UNIT_TAB_PAGE_AP.equals(tabKey)) {
            tabType = UNIT_RELATION_TYPE;
        }
        return tabType;
    }

    private void switchTenantById(String nodeId) {
        this.showAdvconbar(nodeId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        String rootNodeId = this.getRootNode().getId();
        if (!StringUtils.isEmpty((CharSequence)nodeId) && !nodeId.equals(rootNodeId)) {
            qFilters.add(new QFilter(TENANT_ID, "=", (Object)Long.valueOf(nodeId)));
        }
        if (rootNodeId.equals(nodeId)) {
            QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)};
            DynamicObjectCollection tenantCol = QueryServiceHelper.query((String)"ctsy_tenant", (String)"id", (QFilter[])filters);
            Set tenantIds = tenantCol.stream().map(tenant -> tenant.getLong("id")).collect(Collectors.toSet());
            qFilters.add(new QFilter(TENANT_ID, "in", tenantIds));
        }
        qFilters.add(new QFilter("type", "=", (Object)this.selectTab()));
        Map tenantOrgRelationMap = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenantorgrelation", (QFilter[])qFilters.toArray(new QFilter[0]));
        String entityType = ORG_ENTITY;
        if (UNIT_RELATION_TYPE.equals(this.selectTab())) {
            entityType = UNIT_ENTITY;
        }
        this.getModel().deleteEntryData(entityType);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entityType);
        this.cleanAllEntry(entityType);
        if (CollectionUtils.isEmpty((Map)tenantOrgRelationMap)) {
            return;
        }
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)entityType);
        EntryType entryType = (EntryType)entryProp.getItemType();
        for (Map.Entry entry : tenantOrgRelationMap.entrySet()) {
            DynamicObject tenantObject = (DynamicObject)entry.getValue();
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            if (ORG_RELATION_TYPE.equals(this.selectTab())) {
                row.set(ORG_ID, tenantObject.get(ORG_ID));
                row.set(CREATE_TIME, tenantObject.get(CREATE_TIME));
                row.set(TENANT_ID, tenantObject.get(TENANT_ID));
                row.set(CREATOR, tenantObject.get(CREATOR));
            } else {
                row.set(UNIT_ID, tenantObject.get(ORG_ID));
                row.set(UNIT_CREATE_TIME, tenantObject.get(CREATE_TIME));
                row.set(UNIT_TENANT_ID, tenantObject.get(TENANT_ID));
                row.set(UNIT_CREATOR, tenantObject.get(CREATOR));
            }
            rows.add((Object)row);
        }
        this.getModel().updateEntryCache(rows);
        this.getView().updateView(entityType);
    }

    private void cleanAllEntry(String entityType) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entityType);
        if (!rows.isEmpty()) {
            this.getModel().deleteEntryData(entityType);
        }
    }

    public void tabSelected(TabSelectEvent event) {
        this.switchTenantById(this.getFocusNodeId());
    }

    private void refresh() {
        TreeNode treeNode;
        TreeView tv = (TreeView)this.getControl(TREE_VIEW);
        Map focusNode = tv.getTreeState().getFocusNode();
        Object focusNodeObjId = Optional.ofNullable(focusNode).orElseGet(Collections::emptyMap).get("id");
        String focusNodeId = null != focusNodeObjId ? focusNodeObjId.toString() : null;
        tv.deleteAllNodes();
        Set<String> tenantObjIds = this.loadAllTenantTree();
        if (!CollectionUtils.isEmpty((Map)focusNode) && tenantObjIds.contains(focusNodeId)) {
            focusNodeId = String.valueOf(focusNode.get("id"));
            String parentId = null != focusNode.get("parent") ? focusNode.get("parent").toString() : "";
            String text = null != focusNode.get("text") ? focusNode.get("text").toString() : "";
            treeNode = new TreeNode(parentId, focusNodeId, text);
        } else {
            treeNode = this.getRootNode();
            focusNodeId = treeNode.getId();
        }
        tv.focusNode(treeNode);
        this.switchTenantById(focusNodeId);
        this.getView().sendFormAction(tv.getView());
    }

    private String getFocusNodeId() {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        Map focusNode = treeView.getTreeState().getFocusNode();
        String nodeId = this.getRootNode().getId();
        if (!CollectionUtils.isEmpty((Map)focusNode)) {
            nodeId = String.valueOf(focusNode.get("id"));
        }
        return nodeId;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (ADV_CON_BAR_ITEM_NEW.equals(actionId)) {
            this.handleOrgSelect(e);
        }
    }

    private void handleOrgSelect(ClosedCallBackEvent e) {
        ListSelectedRowCollection col = (ListSelectedRowCollection)e.getReturnData();
        if (col == null || col.isEmpty()) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(col.size());
        for (ListSelectedRow row : col) {
            Long orgId = (Long)row.getPrimaryKeyValue();
            orgIds.add(orgId);
        }
        String entityType = ORG_ENTITY;
        if (UNIT_RELATION_TYPE.equals(this.selectTab())) {
            entityType = UNIT_ENTITY;
        }
        this.cleanAllEntry(entityType);
        this.updateRelation(orgIds, this.getFocusNodeId());
        this.switchTenantById(this.getFocusNodeId());
    }

    private void updateRelation(List<Long> orgIds, String tenantId) {
        HashMap<Long, Long> orgIdsMap = new HashMap<Long, Long>(orgIds.size());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter(ORG_ID, "in", (Object)orgIds.toArray()));
        qFilters.add(new QFilter(TENANT_ID, "=", (Object)Long.valueOf(tenantId)));
        qFilters.add(new QFilter("type", "=", (Object)this.selectTab()));
        Map tenantOrgRelationMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ctsy_tenantorgrelation"), (QFilter[])qFilters.toArray(new QFilter[0]));
        if (!CollectionUtils.isEmpty((Map)tenantOrgRelationMap)) {
            for (Map.Entry entry : tenantOrgRelationMap.entrySet()) {
                DynamicObject relationObj = (DynamicObject)entry.getValue();
                if (null == relationObj || null == relationObj.get(ORG_ID)) continue;
                DynamicObject orgObj = (DynamicObject)relationObj.get(ORG_ID);
                orgIdsMap.put(orgObj.getLong("id"), orgObj.getLong("id"));
            }
        }
        ArrayList<DynamicObject> saveEntryList = new ArrayList<DynamicObject>(orgIds.size());
        for (Long orgId : orgIds) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"ctsy_tenantorgrelation");
            DynamicObject relationObj = new DynamicObject((DynamicObjectType)dataEntityType);
            if (!CollectionUtils.isEmpty(orgIdsMap) && orgIdsMap.containsKey(orgId)) continue;
            relationObj.set(TENANT_ID, (Object)tenantId);
            relationObj.set(ORG_ID, (Object)orgId);
            relationObj.set("type", (Object)this.selectTab());
            relationObj.set(CREATOR, (Object)RequestContext.get().getCurrUserId());
            relationObj.set(CREATE_TIME, (Object)new Date());
            saveEntryList.add(relationObj);
        }
        SaveServiceHelper.save((DynamicObject[])saveEntryList.toArray(new DynamicObject[saveEntryList.size()]));
    }

    private void showAdvconbar(String nodeId) {
        boolean isVisible = false;
        if (!(StringUtils.isEmpty((CharSequence)nodeId) || nodeId.equals(ROOT_ID) || nodeId.equals(this.getRootNode().getId()))) {
            isVisible = true;
        }
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{ADV_CON_BAR_ITEM_NEW});
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{ADV_CON_BAR_ITEM_DEL});
    }
}

