/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.ctsy.opplugin;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.base.ctsy.utils.CtsyUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class CtsyDistributSchemeSavePlugin
extends AbstractOperationServicePlugIn {
    private static final String ISC_LINK_ID = "isclinkid";
    private static final String ISC_DATA_ID = "iscdataid";
    private static final String INTERVAL = "interval";
    private static final String SCHEDULE = "schedule";
    private static final String TRACE_ALL = "trace_all";
    private static final String TRIGGER_TYPE_AUTO = "auto";
    private static final String TRIGGER_TYPE_EVENT = "event";
    private static final String VALIDATED_TIME = "validated_time";
    private static final String EXPIRED_TIME = "expired_time";
    private static final String SAVE = "save";
    private static final String SCHEDULE_SWITCH = "schedule_switch";
    private static final String NEW_TARGET_SYSTEM = "new_target_system";
    private static final String ENABLE_TRIGGER = "enableTrigger";
    private static final String DISABLE_TRIGGER = "disableTrigger";
    private static final String BOS_USER = "bos_user";
    private static final String PARAMS_ENTRY_ENTITY = "params_entryentity";
    private static final String PARAMS_NAME = "params_name";
    private static final String FILTER_LONGNUMBER_BOS_USER = "filter_for_longNumber";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] objs = args.getDataEntities();
        if (objs == null) {
            return;
        }
        String operationKey = args.getOperationKey();
        if (SAVE.equalsIgnoreCase(operationKey)) {
            for (DynamicObject distObject : args.getDataEntities()) {
                if (null == distObject) continue;
                this.setParamIfIsBosUser(distObject);
                this.checkIscDataTrigger(distObject, args);
            }
        }
    }

    private void setIscParam(DynamicObject distObject, DynamicObject iscTrigger) {
        DynamicObjectCollection paramDoc = distObject.getDynamicObjectCollection(PARAMS_ENTRY_ENTITY);
        if (null == iscTrigger) {
            return;
        }
        DynamicObjectCollection iscDoc = iscTrigger.getDynamicObjectCollection(PARAMS_ENTRY_ENTITY);
        if (iscDoc.isEmpty() && paramDoc.isEmpty()) {
            return;
        }
        DynamicObject group = distObject.getDynamicObject("group");
        String entityId = group.getString("number");
        DynamicObject userLongNumberEntry = null;
        if (BOS_USER.equals(entityId)) {
            for (DynamicObject paramEntry : paramDoc) {
                if (!FILTER_LONGNUMBER_BOS_USER.equals(paramEntry.get(PARAMS_NAME))) continue;
                userLongNumberEntry = paramEntry;
            }
        }
        paramDoc.clear();
        if (null != userLongNumberEntry) {
            paramDoc.add(userLongNumberEntry);
        }
        if (!iscDoc.isEmpty()) {
            for (DynamicObject iscEntry : iscDoc) {
                if (FILTER_LONGNUMBER_BOS_USER.equals(iscEntry.get(PARAMS_NAME))) continue;
                paramDoc.add((Object)iscEntry);
            }
        }
    }

    private void setParamIfIsBosUser(DynamicObject distObject) {
        DynamicObject group = distObject.getDynamicObject("group");
        if (null == group) {
            return;
        }
        String entityId = group.getString("number");
        if (BOS_USER.equals(entityId)) {
            DynamicObjectCollection filterDoc = distObject.getDynamicObjectCollection("filter_entries");
            String longNumber = filterDoc.stream().filter(filterObj -> "entryentity.orgstructure.longnumber".equals(filterObj.getString("filter_column"))).findAny().map(filterObj -> filterObj.getString("filter_value_fixed")).orElse("");
            DynamicObjectCollection paramDoc = distObject.getDynamicObjectCollection(PARAMS_ENTRY_ENTITY);
            if (StringUtils.isNotEmpty((CharSequence)longNumber) && paramDoc.isEmpty()) {
                paramDoc.addNew();
                DynamicObject param = (DynamicObject)paramDoc.get(0);
                param.set(PARAMS_NAME, (Object)FILTER_LONGNUMBER_BOS_USER);
                param.set("params_label", (Object)ResManager.loadKDString((String)"\u90e8\u95e8\u5206\u5f55\u957f\u7f16\u7801", (String)"CtsyDistributSchemeSavePlugin_4", (String)"bos-base-formplugin", (Object[])new Object[0]));
                param.set("params_data_type", (Object)"string");
                param.set("params_value", (Object)longNumber);
            }
        }
    }

    private void checkIscDataTrigger(DynamicObject distObject, BeforeOperationArgs args) {
        List<DynamicObject> tenantList = CtsyUtils.findTenants(distObject);
        if (CollectionUtils.isEmpty(tenantList)) {
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u5206\u53d1\u65b9\u6848\u7684\u76ee\u6807\u79df\u6237\u4e3a\u7a7a\u3002", (String)"CtsyDistributSchemeSavePlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject iscObject = (DynamicObject)distObject.get(ISC_DATA_ID);
        if (null == iscObject) {
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848\u5f02\u5e38\u3002", (String)"CtsyDistributSchemeSavePlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateIscDataTrigger(DynamicObject distObject, DynamicObject tenantObject) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"isc_data_copy_trigger");
        DynamicObject triggerObj = new DynamicObject((DynamicObjectType)dataEntityType);
        String iscLinkId = tenantObject.getString(ISC_LINK_ID);
        if (StringUtils.isEmpty((CharSequence)iscLinkId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79df\u6237\u8fde\u63a5\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u3002", (String)"CtsyDistributSchemeSavePlugin_2", (String)"bos-base-formplugin", (Object[])new Object[0]));
        }
        DynamicObject sourceObject = CtsyUtils.findLinkSource(Long.valueOf(iscLinkId));
        if (null == sourceObject) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79df\u6237\u8fde\u63a5\u6570\u636e\u6e90\u5f02\u5e38\u3002", (String)"CtsyDistributSchemeSavePlugin_3", (String)"bos-base-formplugin", (Object[])new Object[0]));
        }
        DynamicObject iscObject = (DynamicObject)distObject.get(ISC_DATA_ID);
        if (null == iscObject) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848\u5f02\u5e38\u3002", (String)"CtsyDistributSchemeSavePlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
        }
        Long triggerId = CtsyUtils.findTriggerId(distObject.getLong("id"), tenantObject.getLong("id"), iscObject.getLong("id"), TRIGGER_TYPE_EVENT);
        DynamicObject iscTrigger = null;
        if (triggerId > 0L && null != (iscTrigger = CtsyUtils.findTrigger(triggerId))) {
            triggerObj = iscTrigger;
            CtsyUtils.triggerOperate(triggerObj, DISABLE_TRIGGER);
        }
        triggerObj.set("trigger_type", (Object)TRIGGER_TYPE_EVENT);
        triggerObj.set("data_copy", (Object)iscObject);
        if (StringUtils.isEmpty((CharSequence)triggerObj.getString("number"))) {
            triggerObj.set("number", (Object)CtsyUtils.getTriggerNumber(distObject, tenantObject, TRIGGER_TYPE_EVENT));
        }
        if (StringUtils.isEmpty((CharSequence)triggerObj.getString("name"))) {
            triggerObj.set("name", (Object)CtsyUtils.getTriggerName(distObject, tenantObject, TRIGGER_TYPE_EVENT));
        }
        triggerObj.set(TRACE_ALL, (Object)distObject.getString(TRACE_ALL));
        triggerObj.set("events", (Object)"save,audit,saveandnew");
        triggerObj.set("status", (Object)"C");
        triggerObj.set("enable", (Object)"1");
        triggerObj.set("creator", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getCurrUserId(), (String)BOS_USER));
        triggerObj.set(NEW_TARGET_SYSTEM, (Object)sourceObject);
        CtsyUtils.setFilters(distObject, triggerObj);
        if (distObject.getDataEntityState().getFromDatabase()) {
            this.setIscParam(distObject, iscTrigger);
        }
        CtsyUtils.saveParams(distObject, triggerObj);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)SAVE, (String)"isc_data_copy_trigger", (DynamicObject[])new DynamicObject[]{triggerObj}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess() && !operationResult.getSuccessPkIds().isEmpty()) {
            Long savedISCTriggerId = Long.valueOf(operationResult.getSuccessPkIds().get(0).toString());
            if (triggerId <= 0L) {
                CtsyUtils.saveTrigger(distObject.getLong("id"), tenantObject.getLong("id"), iscObject.getLong("id"), TRIGGER_TYPE_EVENT, savedISCTriggerId);
            }
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)savedISCTriggerId, (String)"isc_data_copy_trigger");
            CtsyUtils.triggerOperate(trigger, ENABLE_TRIGGER);
        }
        if (distObject.getBoolean(SCHEDULE_SWITCH)) {
            this.updateAutoTrigger(distObject, tenantObject, iscObject, sourceObject);
        } else {
            DynamicObject trigger;
            triggerId = CtsyUtils.findTriggerId(distObject.getLong("id"), tenantObject.getLong("id"), iscObject.getLong("id"), TRIGGER_TYPE_AUTO);
            if (triggerId > 0L && (trigger = CtsyUtils.findTrigger(triggerId)) != null) {
                CtsyUtils.triggerOperate(triggerObj, DISABLE_TRIGGER);
            }
        }
    }

    private void updateAutoTrigger(DynamicObject distObject, DynamicObject tenantObject, DynamicObject iscObject, DynamicObject sourceObject) {
        DynamicObject trigger;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"isc_data_copy_trigger");
        DynamicObject triggerObj = new DynamicObject((DynamicObjectType)dataEntityType);
        Long triggerId = CtsyUtils.findTriggerId(distObject.getLong("id"), tenantObject.getLong("id"), iscObject.getLong("id"), TRIGGER_TYPE_AUTO);
        if (triggerId > 0L && null != (trigger = CtsyUtils.findTrigger(triggerId))) {
            triggerObj = trigger;
            CtsyUtils.triggerOperate(triggerObj, DISABLE_TRIGGER);
        }
        triggerObj.set("trigger_type", (Object)TRIGGER_TYPE_AUTO);
        triggerObj.set("data_copy", (Object)iscObject);
        if (StringUtils.isEmpty((CharSequence)triggerObj.getString("number"))) {
            triggerObj.set("number", (Object)CtsyUtils.getTriggerNumber(distObject, tenantObject, TRIGGER_TYPE_AUTO));
        }
        if (StringUtils.isEmpty((CharSequence)triggerObj.getString("name"))) {
            triggerObj.set("name", (Object)CtsyUtils.getTriggerName(distObject, tenantObject, TRIGGER_TYPE_AUTO));
        }
        triggerObj.set(TRACE_ALL, (Object)distObject.getString(TRACE_ALL));
        triggerObj.set(INTERVAL, (Object)distObject.getString(INTERVAL));
        triggerObj.set(SCHEDULE, (Object)distObject.getString(SCHEDULE));
        if (distObject.get(VALIDATED_TIME) instanceof Timestamp) {
            triggerObj.set(VALIDATED_TIME, (Object)new Date(((Timestamp)distObject.get(VALIDATED_TIME)).getTime()));
        } else {
            triggerObj.set(VALIDATED_TIME, (Object)distObject.getString(VALIDATED_TIME));
        }
        if (distObject.get(EXPIRED_TIME) instanceof Timestamp) {
            triggerObj.set(EXPIRED_TIME, (Object)new Date(((Timestamp)distObject.get(EXPIRED_TIME)).getTime()));
        } else {
            triggerObj.set(EXPIRED_TIME, (Object)distObject.getString(EXPIRED_TIME));
        }
        triggerObj.set("status", (Object)"C");
        triggerObj.set("enable", (Object)"1");
        triggerObj.set("creator", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getCurrUserId(), (String)BOS_USER));
        triggerObj.set(NEW_TARGET_SYSTEM, (Object)sourceObject);
        CtsyUtils.setFilters(distObject, triggerObj);
        CtsyUtils.saveParams(distObject, triggerObj);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)SAVE, (String)"isc_data_copy_trigger", (DynamicObject[])new DynamicObject[]{triggerObj}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess() && !operationResult.getSuccessPkIds().isEmpty()) {
            Long savedTriggerId = Long.valueOf(operationResult.getSuccessPkIds().get(0).toString());
            DynamicObject trigger2 = BusinessDataServiceHelper.loadSingle((Object)savedTriggerId, (String)"isc_data_copy_trigger");
            if (triggerId <= 0L) {
                CtsyUtils.saveTrigger(distObject.getLong("id"), tenantObject.getLong("id"), iscObject.getLong("id"), TRIGGER_TYPE_AUTO, savedTriggerId);
            }
            CtsyUtils.triggerOperate(trigger2, ENABLE_TRIGGER);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        DynamicObject[] objs = args.getDataEntities();
        if (objs == null) {
            return;
        }
        String operationKey = args.getOperationKey();
        if (SAVE.equalsIgnoreCase(operationKey)) {
            for (DynamicObject distObject : args.getDataEntities()) {
                List<DynamicObject> tenantList;
                Object[] tenantIds;
                DynamicObject[] tenantArr;
                if (null == distObject || null == (tenantArr = BusinessDataServiceHelper.load((Object[])(tenantIds = (tenantList = CtsyUtils.findTenants(distObject)).stream().filter(Objects::nonNull).map(tenant -> tenant.getLong("id")).toArray()), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ctsy_tenant"))) || 0 == tenantArr.length) continue;
                for (DynamicObject tenantObject : tenantArr) {
                    this.updateIscDataTrigger(distObject, tenantObject);
                }
            }
        }
    }
}

