/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.ctsy.opplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.base.ctsy.utils.CtsyUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.HttpClientUtils;

public class CtsyDistributeConfigPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(CtsyDistributeConfigPlugin.class);
    private static final String ISC_LINK_ID = "isclinkid";
    private static final String TENANT_TYPE = "tenanttype";
    private static final String DEPLOY_STATE = "deploy_state";
    private static final String CTSY_TENANT_SYNC_API = "/kapi/v2/kingdee/ctsy/ctsy_tenant/ctsy_tenant_save";
    private static final String ACCOUNT_NUMBER = "accountnumber";
    private static final String ACCOUNT_ID = "accountid";
    private static final String SERVER_IP = "serverip";
    private static final String SERVER_PORT = "serverport";
    private static final String WEB_APP = "web_app";
    private static final String TENANT_ID = "tenantid";
    private static final String APP_SECRET = "appsecret";
    private static final String CONNECT_TYPE = "connecttype";
    private static final String PWD = CtsyUtils.getCipherKey();
    private static final String APP_ID = "appid";
    private static final String DATA = "data";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCESS_TOKEN = "accesstoken";
    private static final String APPLICATION_JSON = "application/json";
    private static final String STATE = "state";
    private static final String STATE_S = "S";
    public static final ThreadPool CSTY_BASE_THREAD_POOL = ThreadPools.newFixedThreadPool((String)"CSTY_BASE_THREAD_POOL_distributeConfig", (int)8);
    private static int default_connectionTimeout = Integer.getInteger("httpclient.connectionTimeout", 3000);
    private static int default_readTimeout = Integer.getInteger("httpclient.readTimeout", 30000);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List dataIds = Arrays.stream(e.getDataEntities()).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        if (dataIds.isEmpty()) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        Map tenantMap = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenant", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)tenantMap)) {
            return;
        }
        String selectProperties = "id,number,name,status,creatorid,modifierid,enable,createtime,modifytime,masterid,connecttype,serverip,serverport,accountid,tenantid,isclinkid,user,pwd,appid,appsecret,tenanttype,web_app,state,accountnumber,deploy_state";
        QFilter[] targetFilters = new QFilter[]{new QFilter(STATE, "=", (Object)STATE_S), new QFilter(DEPLOY_STATE, "=", (Object)ResManager.loadKDString((String)"\u5df2\u90e8\u7f72", (String)"CtsyDistributeConfigPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]))};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"ctsy_tenant", (String)"id", (QFilter[])targetFilters);
        Object[] targetDataIds = doc.isEmpty() ? new Object[]{} : doc.stream().map(tenant -> tenant.getLong("id")).toArray();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)targetDataIds)};
        DynamicObject[] targetTenants = BusinessDataServiceHelper.load((String)"ctsy_tenant", (String)selectProperties, (QFilter[])qFilters);
        if (targetTenants.length == 0) {
            return;
        }
        CtsyDistributeConfigPlugin.decodeAppSecretAndPWD(e);
        Long accountId = Long.valueOf(RequestContext.get().getAccountId());
        ArrayList<Future> futureList = new ArrayList<Future>(targetTenants.length);
        for (DynamicObject tarTenant : targetTenants) {
            if (tarTenant == null || accountId.equals(tarTenant.getLong(ACCOUNT_ID))) continue;
            Future future = CSTY_BASE_THREAD_POOL.submit(() -> this.syncTenant(tarTenant, e.getDataEntities()));
            futureList.add(future);
        }
        for (Future future : futureList) {
            String tenantId = null;
            try {
                Map callable = (Map)future.get();
                for (Map.Entry result : callable.entrySet()) {
                    tenantId = (String)result.getKey();
                    Integer failSize = (Integer)result.getValue();
                    if (null == failSize || failSize <= 0) continue;
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5206\u53d1\u7ed9\u79df\u6237\u201c%1$s\u201d\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"CtsyDistributeConfigPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]), tenantId, failSize));
                    return;
                }
            }
            catch (InterruptedException ex) {
                log.error("CtsyDistributeConfigPlugin InterruptedException ERROR:" + ex);
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5206\u53d1\u7ed9\u79df\u6237\u201c%1$s\u201d\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"CtsyDistributeConfigPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]), tenantId, targetTenants.length));
                Thread.currentThread().interrupt();
                return;
            }
            catch (ExecutionException ex) {
                log.error("CtsyDistributeConfigPlugin ExecutionException ERROR:" + ex);
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5206\u53d1\u7ed9\u79df\u6237\u201c%1$s\u201d\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"CtsyDistributeConfigPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]), tenantId, targetTenants.length));
                return;
            }
        }
    }

    private static void decodeAppSecretAndPWD(BeforeOperationArgs e) {
        DynamicObject[] tenants;
        for (DynamicObject tenant : tenants = e.getDataEntities()) {
            String appSecret = tenant.getString(APP_SECRET);
            String pwd = tenant.getString(PWD);
            if (!StringUtils.isEmpty((CharSequence)appSecret)) {
                tenant.set(APP_SECRET, (Object)Encrypters.decode((String)appSecret));
            }
            if (StringUtils.isEmpty((CharSequence)pwd)) continue;
            tenant.set(PWD, (Object)Encrypters.decode((String)pwd));
        }
    }

    private Map<String, Integer> syncTenant(DynamicObject tarTenant, DynamicObject[] tenants) {
        ConcurrentHashMap<String, Integer> resultMap = new ConcurrentHashMap<String, Integer>(1);
        try {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(tarTenant.getString(SERVER_IP));
            urlBuilder.append(":");
            urlBuilder.append(tarTenant.getString(SERVER_PORT));
            if (!StringUtils.isEmpty((CharSequence)tarTenant.getString(WEB_APP))) {
                urlBuilder.append(tarTenant.getString(WEB_APP));
            }
            String accessToken = CtsyUtils.getAccessToken(urlBuilder.toString(), tarTenant);
            HashMap<String, String> header = new HashMap<String, String>(2);
            ArrayList bodyList = new ArrayList(tenants.length);
            for (DynamicObject tenant : tenants) {
                HashMap<String, Object> body = new HashMap<String, Object>(20);
                header.put(CONTENT_TYPE, APPLICATION_JSON);
                header.put(ACCESS_TOKEN, accessToken);
                body.put("id", tenant.get("id"));
                body.put("number", tenant.getString("number"));
                body.put("name", tenant.getString("name"));
                body.put("status", tenant.getString("status"));
                body.put("enable", tenant.getString("enable"));
                body.put("createtime", tenant.get("createtime"));
                body.put("modifytime", tenant.get("modifytime"));
                body.put("masterid", tenant.get("masterid"));
                body.put(CONNECT_TYPE, tenant.getString(CONNECT_TYPE));
                body.put(SERVER_IP, tenant.getString(SERVER_IP));
                body.put(SERVER_PORT, tenant.getString(SERVER_PORT));
                body.put(WEB_APP, tenant.getString(WEB_APP));
                body.put(ACCOUNT_ID, tenant.getString(ACCOUNT_ID));
                body.put(TENANT_ID, tenant.getString(TENANT_ID));
                body.put(ISC_LINK_ID, tenant.getString(ISC_LINK_ID));
                body.put("user", tenant.get("user"));
                body.put(PWD, tenant.getString(PWD));
                body.put(APP_ID, tenant.getString(APP_ID));
                body.put(APP_SECRET, tenant.getString(APP_SECRET));
                body.put(ACCOUNT_NUMBER, tenant.getString(ACCOUNT_NUMBER));
                body.put(DEPLOY_STATE, tenant.getString(DEPLOY_STATE));
                body.put(TENANT_TYPE, tenant.getString(TENANT_TYPE));
                bodyList.add(body);
            }
            urlBuilder.append(CTSY_TENANT_SYNC_API);
            HashMap map = new HashMap(1);
            map.put(DATA, bodyList);
            log.info("ctsy tenant sync url " + urlBuilder + ", param " + JSON.toJSONString(map));
            String result = HttpClientUtils.postjson((String)urlBuilder.toString(), header, (String)JSON.toJSONString(map), (int)default_connectionTimeout, (int)default_readTimeout);
            log.info("ctsy tenant sync result " + result);
            JSONObject resultObj = JSON.parseObject((String)result);
            if (!"0".equals(resultObj.getString("errorCode"))) {
                resultMap.put(tarTenant.getString(TENANT_ID), tenants.length);
                return resultMap;
            }
            JSONObject dataObj = resultObj.getJSONObject(DATA);
            if (!"0".equals(dataObj.getString("failCount"))) {
                resultMap.put(tarTenant.getString(TENANT_ID), dataObj.getInteger("failCount"));
                return resultMap;
            }
        }
        catch (Exception e) {
            log.error("ctsy tenant sync error! ", (Throwable)e);
            resultMap.put(tarTenant.getString(TENANT_ID), tenants.length);
            return resultMap;
        }
        resultMap.put(tarTenant.getString(TENANT_ID), 0);
        return resultMap;
    }
}

