/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.ctsy.opplugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.ctsy.utils.CtsyUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.JSONUtils;

public class CtsyTenantSavePlugin
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(CtsyTenantSavePlugin.class);
    private static final String ISC_LINK_ID = "isclinkid";
    private static final String TENANT_TYPE = "tenanttype";
    private static final String TENANT_TYPE_COMPANY = "0";
    private static final String APPID = "appid";
    private static final String SAVE = "save";
    private static final String STATE = "state";
    private static final String ACCOUNT_NUMBER = "accountnumber";
    private static final String ACCOUNT_ID = "accountid";
    private static final String SERVER_IP = "serverip";
    private static final String SERVER_PORT = "serverport";
    private static final String WEB_APP = "web_app";
    private static final String TENANT_ID = "tenantid";
    private static final String APP_SECRET = "appsecret";
    private static final String HTTP_TEXT = "http://";
    private static final String HTTPS_TEXT = "https://";
    private static final int LINK_NUMBER_MAX_LENGTH = 30;
    private static final int LINK_NAME_MAX_LENGTH = 50;
    private static final String USER_PWD = CtsyUtils.getCipherKey();
    private static final String HTTP_PROTOCAL_TYPE = "http_protocal";
    private static final String PROTOCAL_HTTP = "http";
    private static final String PROTOCAL_HTTPS = "https";
    private static final String DATABASE_TYPE = "database_type";
    private static final String DATABASE_TYPE_IERP = "ierp";
    private static final String DATABASE_TYPE_API = "IERP-API2.0(AccessToken)";
    private static final String ISC_SERVER_IP = "server_ip";
    private static final String ISC_SERVER_PORT = "server_port";
    private static final String ISC_ACCOUNT = "account";
    private static final String ISC_TENANT = "tenant";
    private static final String ISC_APP_SECRET = "appsecret_new";
    private static final String ISC_PWD = CtsyTenantSavePlugin.getNewCipherKey();
    private static final String IERP_PROXY_USER = "ierp_proxy_user";
    private static final String BOS_USER = "bos_user";
    private static final String USERNAME = "username";
    private static final String CONNECT_TYPE = "connecttype";
    private static final String IS_HAS_RIGHT = "ishasright";
    private static final String IS_HAS_RIGHT_TRUE = "true";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        boolean existsMasterTenant;
        super.beforeExecuteOperationTransaction(args);
        Object[] dataEntities = args.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            args.setCancelMessage(ResManager.loadKDString((String)"\u53ea\u6709\u7ba1\u7406\u5458\u624d\u53ef\u4ee5\u64cd\u4f5c\u79df\u6237\u3002", (String)"CtsyTenantSavePlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String operationKey = args.getOperationKey();
        Map masterTenants = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenant", (String)"id", (QFilter[])new QFilter[]{new QFilter(TENANT_TYPE, "=", (Object)TENANT_TYPE_COMPANY)});
        Set masterTenantIds = masterTenants.keySet().stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toSet());
        Long masterTenantId = Arrays.stream(dataEntities).filter(tenant -> TENANT_TYPE_COMPANY.equals(tenant.getString(TENANT_TYPE))).map(tenant -> tenant.getLong("id")).findFirst().orElse(0L);
        boolean bl = existsMasterTenant = !masterTenantIds.isEmpty();
        if (!masterTenantId.equals(0L)) {
            masterTenantIds.add(masterTenantId);
        }
        boolean isMasterTenant = this.isMasterTenant();
        for (Object tenantObject : dataEntities) {
            if (null == tenantObject || !SAVE.equalsIgnoreCase(operationKey)) continue;
            if (TENANT_TYPE_COMPANY.equals(tenantObject.getString(TENANT_TYPE)) && existsMasterTenant && !masterTenantIds.contains(tenantObject.getLong("id"))) {
                args.setCancelMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u53ea\u80fd\u6709\u4e00\u4e2a\u79df\u6237\u4e3a\u96c6\u56e2\u79df\u6237\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u79df\u6237\u5c5e\u6027\u3002", (String)"CtsyTenantSavePlugin_2", (String)"bos-base-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.saveIsvLink((DynamicObject)tenantObject, isMasterTenant);
        }
    }

    private void saveIsvLink(DynamicObject tenantObject, boolean isMasterTenant) {
        String tenantType = tenantObject.getString(TENANT_TYPE);
        this.presetTenant(tenantObject);
        if (!TENANT_TYPE_COMPANY.equals(tenantType)) {
            this.updateIscApiLink(tenantObject);
            if (isMasterTenant) {
                this.updateIsvIerpLink(tenantObject);
            } else {
                tenantObject.set(CONNECT_TYPE, (Object)ResManager.loadKDString((String)"\u82cd\u7a79-API2.0(AccessToken\u8ba4\u8bc1)", (String)"CtsyTenantSavePlugin_4", (String)"bos-base-formplugin", (Object[])new Object[0]));
                tenantObject.set(ISC_LINK_ID, (Object)0L);
            }
        } else {
            if (!isMasterTenant) {
                this.updateIscApiLink(tenantObject);
            }
            tenantObject.set(STATE, (Object)"");
        }
    }

    private boolean isMasterTenant() {
        QFilter[] filters = new QFilter[]{new QFilter(TENANT_TYPE, "=", (Object)TENANT_TYPE_COMPANY), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        Map targetTenantMap = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenant", (QFilter[])filters);
        DynamicObject masterTenant = kd.bos.orm.util.CollectionUtils.isEmpty((Map)targetTenantMap) ? null : (DynamicObject)targetTenantMap.values().stream().findFirst().orElse(null);
        String currentAccountId = RequestContext.get().getAccountId();
        if (null != masterTenant && null != masterTenant.get(ACCOUNT_ID)) {
            return masterTenant.get(ACCOUNT_ID).equals(currentAccountId);
        }
        return false;
    }

    private void updateIscApiLink(DynamicObject tenantObject) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"isc_database_link");
        long iscLinkId = tenantObject.getLong(ACCOUNT_ID);
        DynamicObject[] linkObjArr = BusinessDataServiceHelper.load((Object[])new Object[]{iscLinkId}, (DynamicObjectType)dataEntityType);
        DynamicObject linkObj = linkObjArr.length == 0 ? new DynamicObject((DynamicObjectType)dataEntityType) : linkObjArr[0];
        linkObj.set("id", (Object)iscLinkId);
        ArrayList<ComboItem> comboItemList = CtsyUtils.getAccountItems(tenantObject);
        HashMap<String, String> accountId2NameMap = new HashMap<String, String>(comboItemList.size());
        for (ComboItem comboItem : comboItemList) {
            String accountId = comboItem.getValue();
            LocaleString nameLocale = comboItem.getCaption();
            String accountName = (String)nameLocale.get((Object)RequestContext.get().getLang().name());
            accountId2NameMap.put(accountId, accountName);
        }
        String linkNumber = "API_" + tenantObject.getString("number") + "_" + tenantObject.getString(ACCOUNT_ID);
        if (linkNumber.length() > 30) {
            linkNumber = linkNumber.substring(0, 29);
        }
        linkObj.set("number", (Object)linkNumber);
        String suffix = (String)accountId2NameMap.get(tenantObject.getString(ACCOUNT_ID));
        String linkName = String.format(ResManager.loadKDString((String)"\u8de8\u79df\u6237API\u8fde\u63a5_%1$s_%2$s", (String)"CtsyTenantSavePlugin_3", (String)"bos-base-formplugin", (Object[])new Object[0]), tenantObject.getString("name"), suffix);
        if (linkName.length() > 50) {
            linkName = linkName.substring(0, 49);
        }
        linkObj.set("name", (Object)linkName);
        linkObj.set(DATABASE_TYPE, (Object)DATABASE_TYPE_API);
        linkObj.set(ISC_SERVER_IP, (Object)this.handleServerIp(tenantObject.getString(SERVER_IP)));
        linkObj.set(ISC_SERVER_PORT, (Object)tenantObject.getString(SERVER_PORT));
        linkObj.set(ISC_ACCOUNT, (Object)tenantObject.getString(ACCOUNT_ID));
        linkObj.set(ISC_TENANT, (Object)tenantObject.getString(TENANT_ID));
        linkObj.set(WEB_APP, (Object)tenantObject.getString(WEB_APP));
        linkObj.set("status", (Object)"C");
        linkObj.set("enable", (Object)"1");
        linkObj.set(HTTP_PROTOCAL_TYPE, (Object)this.getProtocalType(tenantObject.getString(SERVER_IP)));
        linkObj.set(APPID, tenantObject.get(APPID));
        linkObj.set(ISC_APP_SECRET, (Object)Encrypters.decode((String)tenantObject.getString(APP_SECRET)));
        linkObj.set("user", tenantObject.get("user"));
        linkObj.set(ISC_PWD, (Object)Encrypters.decode((String)tenantObject.getString(USER_PWD)));
        QFilter[] qFilters = new QFilter[]{new QFilter(USERNAME, "=", tenantObject.get("user"))};
        DynamicObject user = QueryServiceHelper.queryOne((String)BOS_USER, (String)"id", (QFilter[])qFilters);
        if (null != user) {
            linkObj.set(IERP_PROXY_USER, (Object)user.getLong("id"));
        }
        linkObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        CtsyTenantSavePlugin.setISCLinkCustomParam(linkObj);
        OperateOption option = OperateOption.create();
        option.setVariableValue(IS_HAS_RIGHT, IS_HAS_RIGHT_TRUE);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)SAVE, (String)"isc_database_link", (DynamicObject[])new DynamicObject[]{linkObj}, (OperateOption)option);
        if (saveResult.isSuccess() && !saveResult.getSuccessPkIds().isEmpty()) {
            this.updateIscSource(linkObj, DATABASE_TYPE_API);
        }
    }

    private static void setISCLinkCustomParam(DynamicObject linkObj) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("accountId", linkObj.getString(ISC_ACCOUNT));
            paramMap.put(WEB_APP, linkObj.getString(WEB_APP));
            paramMap.put("appId", linkObj.getString(APPID));
            paramMap.put(TENANT_ID, linkObj.getString(ISC_TENANT));
            paramMap.put("usertype", "UserName");
            paramMap.put("appSecret", linkObj.getString(ISC_APP_SECRET));
            paramMap.put("language", RequestContext.get().getLang().getLocale().toLanguageTag());
            paramMap.put("user", linkObj.getString("user"));
            linkObj.set("attr_e1", (Object)("(" + JSONUtils.toString(paramMap) + ")"));
            linkObj.set("attr5", (Object)"@#is_custom_page");
        }
        catch (IOException e) {
            LOGGER.error("CtsyTenantSavePlugin setISCLinkCustomParam ERROR:" + e);
        }
    }

    private void updateIsvIerpLink(DynamicObject tenantObject) {
        DynamicObject linkObject;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"isc_database_link");
        DynamicObject linkObj = new DynamicObject((DynamicObjectType)dataEntityType);
        String iscLinkId = tenantObject.getString(ISC_LINK_ID);
        if (StringUtils.isNotEmpty((CharSequence)iscLinkId)) {
            Map resultMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{iscLinkId}, (DynamicObjectType)dataEntityType);
            linkObj = resultMap.values().stream().filter(Objects::nonNull).findFirst().orElseGet(() -> CtsyTenantSavePlugin.lambda$updateIsvIerpLink$2((DynamicObjectType)dataEntityType));
        }
        ArrayList<ComboItem> comboItemList = CtsyUtils.getAccountItems(tenantObject);
        HashMap<String, String> accountId2NameMap = new HashMap<String, String>(comboItemList.size());
        for (ComboItem comboItem : comboItemList) {
            String accountId = comboItem.getValue();
            LocaleString nameLocale = comboItem.getCaption();
            String accountName = (String)nameLocale.get((Object)RequestContext.get().getLang().name());
            accountId2NameMap.put(accountId, accountName);
        }
        String linkNumber = tenantObject.getString("number") + "_" + tenantObject.getString(ACCOUNT_ID);
        if (linkNumber.length() > 30) {
            linkNumber = linkNumber.substring(0, 29);
        }
        linkObj.set("number", (Object)linkNumber);
        String linkName = tenantObject.getString("name") + "_" + (String)accountId2NameMap.get(tenantObject.getString(ACCOUNT_ID));
        if (linkName.length() > 50) {
            linkName = linkName.substring(0, 49);
        }
        linkObj.set("name", (Object)linkName);
        linkObj.set(DATABASE_TYPE, (Object)DATABASE_TYPE_IERP);
        linkObj.set(ISC_SERVER_IP, (Object)this.handleServerIp(tenantObject.getString(SERVER_IP)));
        linkObj.set(ISC_SERVER_PORT, (Object)tenantObject.getString(SERVER_PORT));
        linkObj.set(ISC_ACCOUNT, (Object)tenantObject.getString(ACCOUNT_ID));
        linkObj.set(ISC_TENANT, (Object)tenantObject.getString(TENANT_ID));
        linkObj.set(WEB_APP, (Object)tenantObject.getString(WEB_APP));
        linkObj.set("status", (Object)"C");
        linkObj.set("enable", (Object)"1");
        linkObj.set(HTTP_PROTOCAL_TYPE, (Object)this.getProtocalType(tenantObject.getString(SERVER_IP)));
        linkObj.set(APPID, tenantObject.get(APPID));
        linkObj.set(ISC_APP_SECRET, (Object)Encrypters.decode((String)tenantObject.getString(APP_SECRET)));
        linkObj.set("user", tenantObject.get("user"));
        linkObj.set(ISC_PWD, (Object)Encrypters.decode((String)tenantObject.getString(USER_PWD)));
        QFilter[] qFilters = new QFilter[]{new QFilter(USERNAME, "=", tenantObject.get("user"))};
        DynamicObject user = QueryServiceHelper.queryOne((String)BOS_USER, (String)"id", (QFilter[])qFilters);
        if (null != user) {
            linkObj.set(IERP_PROXY_USER, (Object)user.getLong("id"));
        }
        linkObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        OperateOption option = OperateOption.create();
        option.setVariableValue(IS_HAS_RIGHT, IS_HAS_RIGHT_TRUE);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)SAVE, (String)"isc_database_link", (DynamicObject[])new DynamicObject[]{linkObj}, (OperateOption)option);
        if (saveResult.isSuccess() && !saveResult.getSuccessPkIds().isEmpty() && (linkObject = BusinessDataServiceHelper.loadSingle(saveResult.getSuccessPkIds().get(0), (String)"isc_database_link")) != null) {
            this.updateIscSource(linkObject, DATABASE_TYPE_IERP);
            long linkId = linkObject.getLong("id");
            if (linkId > 0L) {
                tenantObject.set(ISC_LINK_ID, (Object)linkId);
            }
        }
    }

    private String getProtocalType(String serverIp) {
        return StringUtils.isNotEmpty((CharSequence)(serverIp = serverIp.toLowerCase(Locale.ENGLISH))) && serverIp.startsWith(PROTOCAL_HTTPS) ? PROTOCAL_HTTPS : PROTOCAL_HTTP;
    }

    private void updateIscSource(DynamicObject linkObj, String connectionType) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"isc_data_source");
        DynamicObject iscDataSource = new DynamicObject((DynamicObjectType)dataEntityType);
        DynamicObject sourceObject = CtsyUtils.getLinkSource(linkObj.getLong("id"));
        if (null != sourceObject) {
            iscDataSource = sourceObject;
        }
        iscDataSource.set("dblink", (Object)linkObj.getLong("id"));
        iscDataSource.set("connection_type", (Object)connectionType);
        iscDataSource.set("number", (Object)linkObj.getString("number"));
        iscDataSource.set("name", (Object)linkObj.getString("name"));
        iscDataSource.set("creator", (Object)RequestContext.get().getCurrUserId());
        iscDataSource.set("status", (Object)"C");
        iscDataSource.set("enable", (Object)"1");
        OperateOption option = OperateOption.create();
        option.setVariableValue(IS_HAS_RIGHT, IS_HAS_RIGHT_TRUE);
        OperationServiceHelper.executeOperate((String)SAVE, (String)"isc_data_source", (DynamicObject[])new DynamicObject[]{iscDataSource}, (OperateOption)option);
    }

    private void presetTenant(DynamicObject tenantObject) {
        tenantObject.set(APP_SECRET, (Object)Encrypters.encode((String)tenantObject.getString(APP_SECRET)));
        tenantObject.set(USER_PWD, (Object)Encrypters.encode((String)tenantObject.getString(USER_PWD)));
        ArrayList<ComboItem> items = CtsyUtils.getAccountItems(tenantObject);
        if (!CollectionUtils.isEmpty(items) && !StringUtils.isEmpty((CharSequence)tenantObject.getString(ACCOUNT_NUMBER))) {
            String accountNumber = tenantObject.getString(ACCOUNT_NUMBER);
            for (ComboItem item : items) {
                if (!accountNumber.equals(item.getValue())) continue;
                accountNumber = item.getCaption().getLocaleValue();
                break;
            }
            tenantObject.set(ACCOUNT_NUMBER, (Object)accountNumber);
        }
    }

    private String handleServerIp(String serverIp) {
        if ((serverIp = serverIp.toLowerCase(Locale.ENGLISH)).contains(HTTP_TEXT)) {
            serverIp = serverIp.replace(HTTP_TEXT, "");
        }
        if (serverIp.contains(HTTPS_TEXT)) {
            serverIp = serverIp.replace(HTTPS_TEXT, "");
        }
        return serverIp;
    }

    private static String getNewCipherKey() {
        StringBuilder sbd = new StringBuilder();
        sbd.append("new").append("pw").append("d");
        return sbd.toString();
    }

    private static /* synthetic */ DynamicObject lambda$updateIsvIerpLink$2(DynamicObjectType dataEntityType) {
        return new DynamicObject(dataEntityType);
    }
}

