/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.ctsy.service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.ctsy.api.CtsyTenant;
import kd.bos.ctsy.api.ISCDataBaseLink;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.CtsyBaseServiceHelper;

@ApiController(value="CtsyBaseAPI", desc="MLang_bos-base-formplugin_AssignWebAPI_0")
public class CtsyBaseAPI
implements IBillWebApiPlugin {
    private static final String ORG_IDS = "orgIds";
    private static final String PARAM_ERROR_CODE = "400";
    private static final String TENANT_ID = "tenantId";
    private static final String ENTITYID_IDS = "entityIds";
    private static final String ACCOUNT_ID = "accountId";

    @ApiPostMapping(value="/getCtsyTenant", desc="MLang_bos-base-formplugin_AssignWebAPI_0")
    public CustomApiResult<Map<Long, CtsyTenant>> getCtsyTenant(@ApiParam(value="key is orgIds ", required=true) @ApiParam(value="key is orgIds ", required=true) Map<String, Object> paramMap) {
        if (CollectionUtils.isEmpty(paramMap)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"paramMap is empty.");
        }
        if (null == paramMap.get(ORG_IDS)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"orgIds is null.");
        }
        if (!(paramMap.get(ORG_IDS) instanceof List)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"orgIds isn't List.");
        }
        List orgIdObjList = (List)SerializationUtils.fromJsonString((String)paramMap.get(ORG_IDS).toString(), List.class);
        List orgIdList = orgIdObjList.stream().filter(Objects::nonNull).map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
        Map tenantMap = CtsyBaseServiceHelper.getCtsyTenant(orgIdList);
        return CustomApiResult.success((Object)tenantMap);
    }

    @ApiPostMapping(value="/getDistributionScheme", desc="MLang_bos-base-formplugin_AssignWebAPI_1")
    public CustomApiResult<Map<String, Boolean>> getDistributionScheme(@ApiParam(value="key is tenantId and entityIdList ", required=true) @ApiParam(value="key is tenantId and entityIdList ", required=true) Map<String, Object> paramMap) {
        if (CollectionUtils.isEmpty(paramMap)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"paramMap is empty.");
        }
        if (null == paramMap.get(TENANT_ID)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"tenantId is null.");
        }
        if (!(paramMap.get(ENTITYID_IDS) instanceof List)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"entityIds isn't List.");
        }
        String tenantId = paramMap.get(TENANT_ID).toString();
        List orgIdObjList = (List)SerializationUtils.fromJsonString((String)paramMap.get(ENTITYID_IDS).toString(), List.class);
        List entityIds = orgIdObjList.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        Map resultMap = CtsyBaseServiceHelper.hasDistributionScheme((String)tenantId, entityIds);
        return CustomApiResult.success((Object)resultMap);
    }

    @ApiPostMapping(value="/getISCDataBaseLink", desc="MLang_bos-base-formplugin_AssignWebAPI_2")
    public CustomApiResult<List<ISCDataBaseLink>> getISCDataBaseLink(@ApiParam(value="key is tenantId and accountId ", required=true) @ApiParam(value="key is tenantId and accountId ", required=true) Map<String, Object> paramMap) {
        if (CollectionUtils.isEmpty(paramMap)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"paramMap is empty.");
        }
        if (null == paramMap.get(TENANT_ID)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"tenantId is null.");
        }
        if (null == paramMap.get(ACCOUNT_ID)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"accountId is null.");
        }
        String tenantId = paramMap.get(TENANT_ID).toString();
        String accountId = paramMap.get(ACCOUNT_ID).toString();
        List result = CtsyBaseServiceHelper.getISCDataBaseLink((String)tenantId, (String)accountId);
        return CustomApiResult.success((Object)result);
    }
}

