/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.ctsy.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.ctsy.utils.CtsyUtils;
import kd.bos.context.RequestContext;
import kd.bos.ctsy.api.CtsyTenant;
import kd.bos.ctsy.api.ICtsyBaseService;
import kd.bos.ctsy.api.ISCDataBaseLink;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.HttpClientUtils;

public class CtsyBaseServiceImpl
implements ICtsyBaseService {
    private static final Log LOGGER = LogFactory.getLog(CtsyBaseServiceImpl.class);
    private static final String TENANT_ID = "tenantid";
    private static final String ORG_ID = "orgid";
    private static final String ORG_IDS = "orgIds";
    private static final String TYPE = "type";
    private static final String ACCOUNT_ID = "accountid";
    private static final String SERVER_IP = "serverip";
    private static final String SERVER_PORT = "serverport";
    private static final String WEB_APP = "web_app";
    private static final String GET_MASTER_CTSY_TENANT_API = "/kapi/v2/ctsy/getCtsyTenant";
    private static final String GET_DISTRIBUTION_SCHEME_API = "/kapi/v2/ctsy/getDistributionScheme";
    private static final String GET_ISCDATABASE_API = "/kapi/v2/ctsy/getISCDataBaseLink";
    private static final String ENABLE = "enable";
    private static final String TENANT_TYPE = "tenanttype";
    private static final String ISC_LINK_ID = "isclinkid";
    private static final String ISC_DATABASE_LINK = "isc_database_link";
    private static final String CURRENT_ACCOUNT = "current_account";
    private static final String ACCOUNT = "account";
    private static final String TENANT = "tenant";
    private static final String APP_ID = "appid";
    private static final String APPSECRET_NEW = "appsecret_new";
    private static final String USER = "user";
    private static final String IERP_PROXY_USER = "ierp_proxy_user";
    private static final String ISC_SERVER_IP = "server_ip";
    private static final String ISC_SERVER_PORT = "server_port";
    private static final String ISC_LINK_WEB_APP = "web_app";
    private static final String DATABASE_TYPE = "database_type";
    private static final String DUM_LINK = "dum_link";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCESS_TOKEN = "accesstoken";
    private static final String APPLICATION_JSON = "application/json";
    private static final String PARAM_MAP = "paramMap";

    public CtsyTenant getCtsyTenant(Long orgId) {
        boolean isMasterTenant;
        QFilter[] filters = new QFilter[]{new QFilter(TENANT_TYPE, "=", (Object)"0"), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        Map targetTenantMap = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenant", (QFilter[])filters);
        DynamicObject masterTenant = CollectionUtils.isEmpty((Map)targetTenantMap) ? null : (DynamicObject)targetTenantMap.values().stream().findFirst().orElse(null);
        String accountId = RequestContext.get().getAccountId();
        if (null != masterTenant && null != masterTenant.get(ACCOUNT_ID) && !(isMasterTenant = masterTenant.get(ACCOUNT_ID).equals(accountId))) {
            return this.getCtsyTenantFromMaster(masterTenant, Collections.singletonList(orgId)).get(orgId);
        }
        return this.getCtsyTenant(Collections.singletonList(orgId)).get(orgId);
    }

    private Map<Long, CtsyTenant> getCtsyTenantFromMaster(DynamicObject masterTenant, List<Long> orgIdList) {
        HashMap<Long, CtsyTenant> tenantMap = new HashMap<Long, CtsyTenant>(orgIdList.size());
        try {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(masterTenant.getString(SERVER_IP));
            urlBuilder.append(":");
            urlBuilder.append(masterTenant.getString(SERVER_PORT));
            if (!StringUtils.isEmpty((CharSequence)masterTenant.getString("web_app"))) {
                urlBuilder.append(masterTenant.getString("web_app"));
            }
            String accessToken = CtsyUtils.getAccessToken(urlBuilder.toString(), masterTenant);
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put(CONTENT_TYPE, APPLICATION_JSON);
            header.put(ACCESS_TOKEN, accessToken);
            urlBuilder.append(GET_MASTER_CTSY_TENANT_API);
            HashMap paramMap = new HashMap(1);
            HashMap<String, List<Long>> orgIdMap = new HashMap<String, List<Long>>(1);
            orgIdMap.put(ORG_IDS, orgIdList);
            paramMap.put(PARAM_MAP, orgIdMap);
            LOGGER.info("ctsy tenant getCtsyTenantFromMaster url " + urlBuilder + ", param " + JSON.toJSONString(paramMap));
            String result = HttpClientUtils.postjson((String)urlBuilder.toString(), header, (String)JSON.toJSONString(paramMap));
            LOGGER.info("getCtsyTenantFromMaster result " + result);
            if (null == result) {
                LOGGER.info("result of getCtsyTenantFromMaster is null");
                return tenantMap;
            }
            JSONObject resultObj = JSON.parseObject((String)result);
            if ("0".equals(resultObj.get((Object)"errorCode"))) {
                Map tenantData = (Map)JSON.parseObject((String)resultObj.get((Object)"data").toString(), Map.class);
                for (Map.Entry entry : tenantData.entrySet()) {
                    String orgId = (String)entry.getKey();
                    Map tenant = (Map)entry.getValue();
                    String tenantId = (String)tenant.get("tenantId");
                    String accountId = (String)tenant.get("accountId");
                    String tenantType = (String)tenant.get(TENANT_TYPE);
                    if (null == accountId || null == tenantId) continue;
                    CtsyTenant ctsyTenant = new CtsyTenant();
                    ctsyTenant.setTenantId(tenantId);
                    ctsyTenant.setAccountId(Long.valueOf(accountId));
                    ctsyTenant.setTenantType(tenantType);
                    tenantMap.put(Long.valueOf(orgId), ctsyTenant);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("getCtsyTenantFromMaster: ", (Throwable)e);
        }
        return tenantMap;
    }

    private List<String> getMasterTenants() {
        try {
            String mcTenantIds = System.getProperty("mc.tenant.ids");
            if (StringUtils.isEmpty((CharSequence)mcTenantIds)) {
                return Collections.emptyList();
            }
            List tenantList = (List)SerializationUtils.fromJsonString((String)mcTenantIds, List.class);
            return tenantList.stream().filter(jsonObj -> null != jsonObj && null != jsonObj.get("isMaster") && Boolean.TRUE.equals(Boolean.valueOf(jsonObj.get("isMaster").toString())) && null != jsonObj.get(TENANT_ID)).map(jsonObj -> jsonObj.get(TENANT_ID).toString()).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("CtsyTenantSavePlugin isMasterTenant error:", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Map<Long, CtsyTenant> getCtsyTenant(List<Long> orgIdList) {
        boolean isMasterTenant;
        QFilter[] filters = new QFilter[]{new QFilter(TENANT_TYPE, "=", (Object)"0"), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        Map targetTenantMap = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenant", (QFilter[])filters);
        DynamicObject masterTenant = CollectionUtils.isEmpty((Map)targetTenantMap) ? null : (DynamicObject)targetTenantMap.values().stream().findFirst().orElse(null);
        String accountId = RequestContext.get().getAccountId();
        if (null != masterTenant && null != masterTenant.get(ACCOUNT_ID) && !(isMasterTenant = masterTenant.get(ACCOUNT_ID).equals(accountId))) {
            return this.getCtsyTenantFromMaster(masterTenant, orgIdList);
        }
        QFilter orgFilter = new QFilter(ORG_ID, "in", orgIdList);
        QFilter typeFilter = new QFilter(TYPE, "=", (Object)Boolean.TRUE);
        QFilter[] orgFilters = new QFilter[]{orgFilter, typeFilter};
        DynamicObjectCollection tenantOrgCol = QueryServiceHelper.query((String)"ctsy_tenantorgrelation", (String)this.getSelectField(TENANT_ID, ORG_ID), (QFilter[])orgFilters);
        HashMap<Long, Long> org2TenantIdMap = new HashMap<Long, Long>(tenantOrgCol.size());
        for (DynamicObject tenant : tenantOrgCol) {
            org2TenantIdMap.put(tenant.getLong(ORG_ID), tenant.getLong(TENANT_ID));
        }
        if (org2TenantIdMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet tenantConfigIdList = new HashSet(org2TenantIdMap.values());
        String selectFields = this.getSelectField("id", TENANT_ID, ACCOUNT_ID, TENANT_TYPE);
        QFilter[] tenantFilters = new QFilter[]{new QFilter("id", "in", tenantConfigIdList)};
        DynamicObjectCollection tenantCol = QueryServiceHelper.query((String)"ctsy_tenant", (String)selectFields, (QFilter[])tenantFilters);
        HashMap<Long, CtsyTenant> tenantMap = new HashMap<Long, CtsyTenant>(tenantConfigIdList.size());
        for (DynamicObject tenantObj : tenantCol) {
            Long tenantConfigId = tenantObj.getLong("id");
            CtsyTenant ctsyTenant = new CtsyTenant();
            ctsyTenant.setTenantId(tenantObj.getString(TENANT_ID));
            ctsyTenant.setAccountId(Long.valueOf(tenantObj.getLong(ACCOUNT_ID)));
            ctsyTenant.setTenantType(tenantObj.getString(TENANT_TYPE));
            tenantMap.put(tenantConfigId, ctsyTenant);
        }
        HashMap<Long, CtsyTenant> org2TenantMap = new HashMap<Long, CtsyTenant>(orgIdList.size());
        for (Long orgId : orgIdList) {
            Long tempTenantId = (Long)org2TenantIdMap.get(orgId);
            if (null == tempTenantId) continue;
            org2TenantMap.put(orgId, (CtsyTenant)tenantMap.get(tempTenantId));
        }
        return org2TenantMap;
    }

    public Map<String, Boolean> hasDistributionScheme(String tenantId, List<String> entityIds) {
        boolean isMasterTenant;
        if (CollectionUtils.isEmpty(entityIds) || null == tenantId) {
            return Collections.emptyMap();
        }
        QFilter[] filters = new QFilter[]{new QFilter(TENANT_TYPE, "=", (Object)"0"), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        Map targetTenantMap = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenant", (QFilter[])filters);
        DynamicObject masterTenant = CollectionUtils.isEmpty((Map)targetTenantMap) ? null : (DynamicObject)targetTenantMap.values().stream().findFirst().orElse(null);
        String accountId = RequestContext.get().getAccountId();
        if (null != masterTenant && null != masterTenant.get(ACCOUNT_ID) && !(isMasterTenant = masterTenant.get(ACCOUNT_ID).equals(accountId))) {
            return this.getDistributionSchemeFromMaster(masterTenant, tenantId, entityIds);
        }
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("select ct.ftenantid,b.fbasedatafield from t_ctsy_distschemetenants t ", new Object[0]);
        sbd.append("inner join t_ctsy_distributscheme d on t.fid = d.fid ", new Object[0]);
        sbd.append("inner join t_ctsy_tenant ct on ct.fid = t.fbasedataid ", new Object[0]);
        sbd.append("inner join t_ctsy_basedata b on b.fid = d.fgroupid ", new Object[0]);
        sbd.append("where ", new Object[0]).appendIn("b.fbasedatafield", entityIds.toArray());
        sbd.append(" and ct.ftenantid = ", new Object[0]).append(String.format("'%s'", tenantId), new Object[0]);
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(entityIds.size());
        entityIds.forEach(entityId -> resultMap.put((String)entityId, Boolean.FALSE));
        try (DataSet dataSet = DB.queryDataSet((String)CtsyBaseServiceImpl.class.getName(), (DBRoute)DBRoute.base, (SqlBuilder)sbd);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String entityId2 = row.getString("fbasedatafield");
                resultMap.put(entityId2, Boolean.TRUE);
            }
        }
        return resultMap;
    }

    private Map<String, Boolean> getDistributionSchemeFromMaster(DynamicObject masterTenant, String tenantId, List<String> entityIds) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(entityIds.size());
        try {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(masterTenant.getString(SERVER_IP));
            urlBuilder.append(":");
            urlBuilder.append(masterTenant.getString(SERVER_PORT));
            if (!StringUtils.isEmpty((CharSequence)masterTenant.getString("web_app"))) {
                urlBuilder.append(masterTenant.getString("web_app"));
            }
            String accessToken = CtsyUtils.getAccessToken(urlBuilder.toString(), masterTenant);
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put(CONTENT_TYPE, APPLICATION_JSON);
            header.put(ACCESS_TOKEN, accessToken);
            urlBuilder.append(GET_DISTRIBUTION_SCHEME_API);
            HashMap paramMap = new HashMap(1);
            HashMap<String, Object> entityIdMap = new HashMap<String, Object>(1);
            entityIdMap.put("tenantId", tenantId);
            entityIdMap.put("entityIds", entityIds);
            paramMap.put(PARAM_MAP, entityIdMap);
            LOGGER.info("ctsy tenant getDistributionSchemeFromMaster url " + urlBuilder + ", param " + JSON.toJSONString(paramMap));
            String result = HttpClientUtils.postjson((String)urlBuilder.toString(), header, (String)JSON.toJSONString(paramMap));
            LOGGER.info("getDistributionSchemeFromMaster result " + result);
            if (null == result) {
                LOGGER.info("result of getDistributionSchemeFromMaster is null");
                return resultMap;
            }
            JSONObject resultObj = JSON.parseObject((String)result);
            if ("0".equals(resultObj.get((Object)"errorCode"))) {
                return (Map)JSON.parseObject((String)resultObj.get((Object)"data").toString(), Map.class);
            }
        }
        catch (Exception e) {
            LOGGER.error("getDistributionSchemeFromMaster ERROR: " + e);
        }
        return resultMap;
    }

    public List<ISCDataBaseLink> getISCDataBaseLink(String tenantId, String accountId) {
        ArrayList<ISCDataBaseLink> iscDataBaseLinks = new ArrayList<ISCDataBaseLink>(3);
        QFilter[] qFilters = new QFilter[]{new QFilter(TENANT_ID, "=", (Object)tenantId), new QFilter(ACCOUNT_ID, "=", (Object)accountId)};
        DynamicObjectCollection tenantCol = QueryServiceHelper.query((String)"ctsy_tenant", (String)this.getSelectField("id", ISC_LINK_ID), (QFilter[])qFilters);
        if (tenantCol.isEmpty()) {
            return Collections.emptyList();
        }
        Object[] iscLinkIds = tenantCol.stream().map(tenant -> tenant.getLong(ISC_LINK_ID)).toArray();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)ISC_DATABASE_LINK);
        Map resultMap = BusinessDataServiceHelper.loadFromCache((Object[])iscLinkIds, (DynamicObjectType)dataEntityType);
        DynamicObject apiLinkObj = this.getApiLink(accountId);
        Optional.ofNullable(apiLinkObj).ifPresent(apiLink -> resultMap.put(apiLink.get("id"), apiLink));
        for (Map.Entry iscLink : resultMap.entrySet()) {
            ISCDataBaseLink iscDataBaseLink = new ISCDataBaseLink();
            Long iscLinkId = null != iscLink.getKey() ? Long.parseLong(iscLink.getKey().toString()) : 0L;
            DynamicObject iscLinkObj = (DynamicObject)iscLink.getValue();
            iscDataBaseLink.setId(iscLinkId);
            iscDataBaseLink.setAccount(iscLinkObj.getString(ACCOUNT));
            iscDataBaseLink.setAppId(iscLinkObj.getString(APP_ID));
            iscDataBaseLink.setNumber(iscLinkObj.getString("number"));
            iscDataBaseLink.setName(iscLinkObj.getString("name"));
            iscDataBaseLink.setDatabaseType(iscLinkObj.getString(DATABASE_TYPE));
            iscDataBaseLink.setAppSecretNew(iscLinkObj.getString(APPSECRET_NEW));
            iscDataBaseLink.setCurrentAccount(iscLinkObj.getString(CURRENT_ACCOUNT));
            DynamicObject ierpProxyUser = iscLinkObj.getDynamicObject(IERP_PROXY_USER);
            if (null != ierpProxyUser) {
                iscDataBaseLink.setIerpProxyUser(ierpProxyUser.getString("id"));
            }
            iscDataBaseLink.setNewPwd(iscLinkObj.getString(this.getNewCipherKey()));
            iscDataBaseLink.setServerIp(iscLinkObj.getString(ISC_SERVER_IP));
            iscDataBaseLink.setServerPort(iscLinkObj.getString(ISC_SERVER_PORT));
            iscDataBaseLink.setWebApp(iscLinkObj.getString("web_app"));
            iscDataBaseLink.setTenant(iscLinkObj.getString(TENANT));
            iscDataBaseLink.setUser(iscLinkObj.getString(USER));
            iscDataBaseLinks.add(iscDataBaseLink);
        }
        return iscDataBaseLinks;
    }

    private String getNewCipherKey() {
        StringBuilder sbd = new StringBuilder();
        sbd.append("new").append("pw").append("d");
        return sbd.toString();
    }

    private DynamicObject getApiLink(String accountId) {
        if (null == accountId) {
            return null;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)ISC_DATABASE_LINK);
        Map resultMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{Long.valueOf(accountId)}, (DynamicObjectType)dataEntityType);
        return CollectionUtils.isEmpty(resultMap.values()) ? null : (DynamicObject)resultMap.values().iterator().next();
    }

    private List<ISCDataBaseLink> getISCDataBaseLinkFromMaster(DynamicObject masterTenant, String tenantId, String accountId) {
        try {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(masterTenant.getString(SERVER_IP));
            urlBuilder.append(":");
            urlBuilder.append(masterTenant.getString(SERVER_PORT));
            if (!StringUtils.isEmpty((CharSequence)masterTenant.getString("web_app"))) {
                urlBuilder.append(masterTenant.getString("web_app"));
            }
            String accessToken = CtsyUtils.getAccessToken(urlBuilder.toString(), masterTenant);
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put(CONTENT_TYPE, APPLICATION_JSON);
            header.put(ACCESS_TOKEN, accessToken);
            urlBuilder.append(GET_ISCDATABASE_API);
            HashMap paramMap = new HashMap(1);
            HashMap<String, String> entityIdMap = new HashMap<String, String>(1);
            entityIdMap.put("tenantId", tenantId);
            entityIdMap.put("accountId", accountId);
            paramMap.put(PARAM_MAP, entityIdMap);
            LOGGER.info("ctsy tenant getISCDataBaseLinkFromMaster url " + urlBuilder + ", param " + JSON.toJSONString(paramMap));
            String result = HttpClientUtils.postjson((String)urlBuilder.toString(), header, (String)JSON.toJSONString(paramMap));
            LOGGER.info("getISCDataBaseLinkFromMaster result " + result);
            if (null == result) {
                LOGGER.info("result of getISCDataBaseLinkFromMaster is null");
                return Collections.emptyList();
            }
            JSONObject resultObj = JSON.parseObject((String)result);
            if ("0".equals(resultObj.get((Object)"errorCode"))) {
                List iscLinkJsonObjects = (List)JSON.parseObject((String)resultObj.get((Object)"data").toString(), List.class);
                ArrayList<ISCDataBaseLink> iscLinks = new ArrayList<ISCDataBaseLink>(iscLinkJsonObjects.size());
                for (JSONObject iscLinkJsonObject : iscLinkJsonObjects) {
                    iscLinks.add((ISCDataBaseLink)JSON.parseObject((String)JSON.toJSONString((Object)iscLinkJsonObject), ISCDataBaseLink.class));
                }
                return iscLinks;
            }
        }
        catch (Exception e) {
            LOGGER.error("getISCDataBaseLinkFromMaster ERROR: " + e);
        }
        return Collections.emptyList();
    }

    private String getSelectField(String ... props) {
        if (null == props || props.length == 0) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(",");
        Stream.of(props).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }
}

