/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.ctsy.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.field.ComboItem;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.auditlog.LoginResult;
import kd.bos.mservice.form.auditlog.TokenResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.HttpClientUtils;

public class CtsyUtils {
    private static final Log log = LogFactory.getLog(CtsyUtils.class);
    private static final String CTSY_TENANT_CONFIG = "/resources/ctsy_tenant_config.txt";
    private static final String FILTER_ENTRIES = "filter_entries";
    private static final String TOKEN_URL = "/api/getAppToken.do";
    private static final String LOGIN_URL = "/api/login.do";
    private static final int TRIGGER_NUMBER_MAX_LENGTH = 60;
    private static final int TRIGGER_NAME_MAX_LENGTH = 50;
    private static final String SERVER_IP = "serverip";
    private static final String SERVER_PORT = "serverport";
    private static final String WEB_APP = "web_app";
    private static final String CTSY_TENANT_QUERY_URL = "/auth/getAllDatacenters.do";
    private static final String DIST_ID = "distid";
    private static final String TENANT_ID = "tenantid";
    private static final String ISC_DATA_ID = "iscdataid";
    private static final String TRIGGER_TYPE = "trigger_type";
    private static final String TRIGGER_ID = "triggerid";
    private static final String CREATOR = "creator";
    private static final String MUL_TENANT_ID = "multenantid";
    private static final String TRIGGER_TYPE_EVENT = "event";
    private static final String PARAMS_ENTRY_ENTITY = "params_entryentity";

    public static Map<String, String> getCtsyTenantConfig() {
        HashMap<String, String> configMap = new HashMap<String, String>(5);
        try (InputStream in = CtsyUtils.class.getResourceAsStream(CTSY_TENANT_CONFIG);
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                String name = line.split("-")[0];
                String value = line.split("-")[1];
                configMap.put(name, value);
            }
        }
        catch (Exception e) {
            return configMap;
        }
        return configMap;
    }

    public static DynamicObject getLinkSource(Long linkId) {
        QFilter[] filters = new QFilter[]{new QFilter("dblink", "=", (Object)linkId)};
        return BusinessDataServiceHelper.loadSingle((String)"isc_data_source", (QFilter[])filters);
    }

    public static DynamicObject findLinkSource(Long linkId) {
        QFilter[] filters = new QFilter[]{new QFilter("dblink", "=", (Object)linkId)};
        return BusinessDataServiceHelper.loadSingle((String)"isc_data_source", (QFilter[])filters);
    }

    public static DynamicObject findTrigger(Long triggerId) {
        return BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_data_copy_trigger");
    }

    public static List<Long> findTenantIds(DynamicObject distributObject) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fbasedataid from T_ctsy_distSchemeTenants where ", new Object[0]).append("fid = ?", new Object[]{distributObject.getLong("id")});
        return (List)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, rs -> {
            ArrayList<Long> result = new ArrayList<Long>(10);
            while (rs.next()) {
                result.add(rs.getLong("fbasedataid"));
            }
            return result;
        });
    }

    public static List<DynamicObject> findTenants(DynamicObject distObject) {
        DynamicObjectCollection collection = distObject.getDynamicObjectCollection(MUL_TENANT_ID);
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return new ArrayList<DynamicObject>(0);
        }
        ArrayList<DynamicObject> tenantList = new ArrayList<DynamicObject>(collection.size());
        for (DynamicObject mulObj : collection) {
            DynamicObject tenantObject = (DynamicObject)mulObj.get(1);
            if (null == tenantObject) continue;
            tenantList.add(tenantObject);
        }
        return tenantList;
    }

    public static Long findTriggerId(Long distId, Long tenantId, Long iscId, String triggerType) {
        QFilter[] filters = new QFilter[]{new QFilter(DIST_ID, "=", (Object)distId), new QFilter(TENANT_ID, "=", (Object)tenantId), new QFilter(ISC_DATA_ID, "=", (Object)iscId), new QFilter(TRIGGER_TYPE, "=", (Object)triggerType)};
        DynamicObject[] triggerMap = BusinessDataServiceHelper.load((String)"ctsy_dist_trigger", (String)CtsyUtils.getSelectField("id", TRIGGER_ID), (QFilter[])filters);
        if (null == triggerMap || triggerMap.length == 0) {
            return 0L;
        }
        for (DynamicObject object : triggerMap) {
            DynamicObject triggerObj = (DynamicObject)object.get(TRIGGER_ID);
            if (null == triggerObj) continue;
            return triggerObj.getLong("id");
        }
        return 0L;
    }

    public static List<DynamicObject> findTriggers(Long distId, Long tenantId, Long iscId) {
        ArrayList<DynamicObject> triggerList = new ArrayList<DynamicObject>(4);
        QFilter[] filters = new QFilter[]{new QFilter(DIST_ID, "=", (Object)distId), new QFilter(TENANT_ID, "=", (Object)tenantId), new QFilter(ISC_DATA_ID, "=", (Object)iscId)};
        String selectFields = CtsyUtils.getSelectField("id", "number", "name", DIST_ID, TENANT_ID, ISC_DATA_ID);
        DynamicObject[] triggerArr = BusinessDataServiceHelper.load((String)"ctsy_dist_trigger", (String)selectFields, (QFilter[])filters);
        if (null == triggerArr || 0 == triggerArr.length) {
            return triggerList;
        }
        for (DynamicObject triggerObj : triggerArr) {
            if (null == triggerObj) continue;
            triggerList.add(triggerObj);
        }
        return triggerList;
    }

    public static void saveTrigger(Long distId, Long tenantId, Long iscId, String triggerType, Long triggerId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"ctsy_dist_trigger");
        DynamicObject distTrigger = new DynamicObject((DynamicObjectType)dataEntityType);
        distTrigger.set(DIST_ID, (Object)distId);
        distTrigger.set(TRIGGER_TYPE, (Object)triggerType);
        distTrigger.set(TENANT_ID, (Object)tenantId);
        distTrigger.set(ISC_DATA_ID, (Object)iscId);
        distTrigger.set(TRIGGER_ID, (Object)triggerId);
        distTrigger.set(CREATOR, (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getCurrUserId(), (String)"bos_user"));
        OperationServiceHelper.executeOperate((String)"save", (String)"ctsy_dist_trigger", (DynamicObject[])new DynamicObject[]{distTrigger}, (OperateOption)OperateOption.create());
    }

    public static boolean triggerOperate(DynamicObject triggerObject, String operationKey) {
        try {
            DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)operationKey, (Object[])new Object[]{triggerObject.getString("number")});
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void setFilters(DynamicObject distObject, DynamicObject triggerObject) {
        DynamicObjectCollection filtersEntry = triggerObject.getDynamicObjectCollection(FILTER_ENTRIES);
        filtersEntry.clear();
        DynamicObjectCollection collection = (DynamicObjectCollection)distObject.get(FILTER_ENTRIES);
        DynamicObjectType entryType = filtersEntry.getDynamicObjectType();
        for (DynamicObject filter : collection) {
            DynamicObject item = new DynamicObject(entryType);
            item.set("filter_left_bracket", (Object)filter.getString("filter_left_bracket"));
            item.set("filter_column", (Object)filter.getString("filter_column"));
            item.set("filter_label", (Object)filter.getString("filter_label"));
            item.set("filter_compare", (Object)filter.getString("filter_compare"));
            item.set("filter_value_fixed", (Object)filter.getString("filter_value_fixed"));
            item.set("filter_right_bracket", (Object)filter.getString("filter_right_bracket"));
            item.set("filter_link", (Object)filter.getString("filter_link"));
            filtersEntry.add((Object)item);
        }
    }

    public static void setParams(Long distributeId, DynamicObject triggerObject) {
        if (null == distributeId || distributeId.equals(0L)) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(DIST_ID, "=", (Object)distributeId), new QFilter(TRIGGER_TYPE, "=", (Object)TRIGGER_TYPE_EVENT)};
        DynamicObjectCollection distTriggerCol = QueryServiceHelper.query((String)"ctsy_dist_trigger", (String)TRIGGER_ID, (QFilter[])qFilters);
        if (distTriggerCol.isEmpty()) {
            return;
        }
        DynamicObject distributeTrigger = (DynamicObject)distTriggerCol.get(0);
        Long triggerId = distributeTrigger.getLong(TRIGGER_ID);
        DynamicObject iscTrigger = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_data_copy_trigger");
        DynamicObjectCollection iscParamsCol = (DynamicObjectCollection)iscTrigger.get(PARAMS_ENTRY_ENTITY);
        DynamicObjectCollection paramsEntry = triggerObject.getDynamicObjectCollection(PARAMS_ENTRY_ENTITY);
        paramsEntry.clear();
        DynamicObjectType entryType = paramsEntry.getDynamicObjectType();
        for (DynamicObject paramObj : iscParamsCol) {
            DynamicObject item = new DynamicObject(entryType);
            item.set("params_name", (Object)paramObj.getString("params_name"));
            item.set("params_label", (Object)paramObj.getString("params_label"));
            item.set("params_data_type", (Object)paramObj.getString("params_data_type"));
            item.set("params_value", (Object)paramObj.getString("params_value"));
            paramsEntry.add((Object)item);
        }
    }

    public static void saveParams(DynamicObject distObject, DynamicObject triggerObject) {
        DynamicObjectCollection collection = (DynamicObjectCollection)distObject.get(PARAMS_ENTRY_ENTITY);
        DynamicObjectCollection paramsEntry = triggerObject.getDynamicObjectCollection(PARAMS_ENTRY_ENTITY);
        paramsEntry.clear();
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            DynamicObjectType entryType = paramsEntry.getDynamicObjectType();
            for (DynamicObject paramObj : collection) {
                DynamicObject item = new DynamicObject(entryType);
                item.set("params_name", (Object)paramObj.getString("params_name"));
                item.set("params_label", (Object)paramObj.getString("params_label"));
                item.set("params_data_type", (Object)paramObj.getString("params_data_type"));
                item.set("params_value", (Object)paramObj.getString("params_value"));
                paramsEntry.add((Object)item);
            }
        }
    }

    public static String getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException var1) {
            return null;
        }
    }

    public static String getAccessToken(String url, DynamicObject tarTenant) throws Exception {
        String tokenParam = "{\"appId\": \"" + tarTenant.getString("appid") + "\",\"appSecuret\": \"" + Encrypters.decode((String)tarTenant.getString("appsecret")) + "\",\"tenantid\": \"" + tarTenant.getString(TENANT_ID) + "\",\"accountId\": \"" + tarTenant.getString("accountid") + "\",\"language\": \"zh_CN\"}";
        String result = HttpClientUtils.postjson((String)(url + TOKEN_URL), null, (String)tokenParam);
        TokenResult tokenResult = (TokenResult)JSONObject.parseObject((String)result, TokenResult.class);
        if (tokenResult.getData() == null || tokenResult.getData().getApp_token() == null || kd.bos.login.utils.StringUtils.isEmpty((String)tokenResult.getData().getApp_token())) {
            throw new KDException(BosErrorCode.methodInvocation, new Object[]{"no accessToken returned"});
        }
        String appToken = tokenResult.getData().getApp_token();
        String accessTokenParam = "{\"apptoken\": \"" + appToken + "\",\"user\": \"administrator\",\"logintype\": \"2\",\"usertype\":\"UserName\",\"appSecuret\": \"" + Encrypters.decode((String)tarTenant.getString("appsecret")) + "\",\"tenantid\": \"" + tarTenant.getString(TENANT_ID) + "\",\"accountId\": \"" + tarTenant.getString("accountid") + "\",\"language\": \"zh_CN\"}";
        String accessTokenResult = HttpClientUtils.postjson((String)(url + LOGIN_URL), null, (String)accessTokenParam);
        LoginResult accessData = (LoginResult)JSONObject.parseObject((String)accessTokenResult, LoginResult.class);
        return accessData.getData().getAccess_token();
    }

    public static String getRandomNumber() {
        long id = IDService.get().genLongId();
        String digital = "ABCDEFGHIJKLMN123456789OPQRSTUVWXYZ";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            int d = (int)id & 0x1F;
            sb.append(digital.charAt(d));
            id >>= 5;
        }
        return sb.toString();
    }

    public static String getCronVal(String interval) {
        if ("1".equals(interval)) {
            return "0 0 * * * ?";
        }
        if ("2".equals(interval)) {
            return "0 0/30 * * * ?";
        }
        if ("3".equals(interval)) {
            return "0 0/20 * * * ?";
        }
        if ("5".equals(interval)) {
            return "0 0/12 * * * ?";
        }
        if ("10".equals(interval)) {
            return "0 0/6 * * * ?";
        }
        if ("d1".equals(interval)) {
            return "0 0 1 ? * *";
        }
        if ("d".equals(interval)) {
            return "0 0 1 ? * *";
        }
        if ("w".equals(interval)) {
            return "0 0 1 ? * MON";
        }
        return null;
    }

    public static String getTriggerNumber(DynamicObject distObject, DynamicObject tenantObject, String triggerType) {
        String randomNumber = CtsyUtils.getRandomNumber();
        String triggerNumber = randomNumber + "_" + triggerType + "_" + distObject.getString("number") + "_" + tenantObject.getString("number");
        if (triggerNumber.length() > 60) {
            triggerNumber = triggerNumber.substring(0, 59);
        }
        return triggerNumber;
    }

    public static String getTriggerName(DynamicObject distObject, DynamicObject tenantObject, String triggerType) {
        String randomNumber = CtsyUtils.getRandomNumber();
        String triggerName = randomNumber + "_" + triggerType + "_" + distObject.getString("name") + "_" + tenantObject.getString("name");
        if (triggerName.length() > 50) {
            triggerName = triggerName.substring(0, 49);
        }
        return triggerName;
    }

    public static ArrayList<ComboItem> getAccountItems(DynamicObject tenantObject) {
        String serverIp = tenantObject.getString(SERVER_IP);
        String serverPort = tenantObject.getString(SERVER_PORT);
        String webApp = tenantObject.getString(WEB_APP);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        if (StringUtils.isEmpty((CharSequence)serverIp) || StringUtils.isEmpty((CharSequence)serverPort)) {
            return items;
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(serverIp);
        urlBuilder.append(":");
        urlBuilder.append(serverPort);
        if (!StringUtils.isEmpty((CharSequence)webApp)) {
            urlBuilder.append(webApp);
        }
        urlBuilder.append(CTSY_TENANT_QUERY_URL);
        try {
            String result = HttpClientUtils.get((String)urlBuilder.toString());
            log.debug("getAllDatacenters result " + result);
            if (StringUtils.isEmpty((CharSequence)result)) {
                return items;
            }
            JSONArray resp = JSONObject.parseArray((String)result);
            for (Object account : resp) {
                JSONObject jsonObject = (JSONObject)account;
                String accountId = jsonObject.getString("accountId");
                String accountName = jsonObject.getString("accountName");
                ComboItem item = new ComboItem(new LocaleString(accountName), accountId);
                items.add(item);
            }
            return items;
        }
        catch (Exception e) {
            log.warn("getAllDatacenters error " + e.getMessage());
            return items;
        }
    }

    private static String getSelectField(String ... props) {
        if (null == props || props.length == 0) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(",");
        Stream.of(props).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }

    public static String getCipherKey() {
        StringBuilder sbd = new StringBuilder();
        sbd.append("p").append("w").append("d");
        return sbd.toString();
    }
}

