/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class FullTextIndexPlugin
extends AbstractFormPlugin
implements ICloseCallBack {
    private static final String FFIELDNAME = "ffieldname";
    private static final String FENTITYNUMBER = "fentitynumber";
    private static final String IDE_LISTFIELDID = "ide_listfieldid";

    public void registerListener(EventObject e) {
        TextEdit fieldnameedit = (TextEdit)this.getControl(FFIELDNAME);
        fieldnameedit.addButtonClickListener((ClickListener)this);
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (FFIELDNAME.equalsIgnoreCase(key.toLowerCase())) {
            if (this.getModel().getValue(FENTITYNUMBER) == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b9e\u4f53\u5bf9\u8c61", (String)"FullTextIndexPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showForm();
        }
    }

    public void propertyChanged(PropertyChangedArgs propertychangedargs) {
        if (propertychangedargs.getProperty().getName().equalsIgnoreCase(FENTITYNUMBER)) {
            if (this.getModel().getValue(FENTITYNUMBER) == null) {
                return;
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)((DynamicObject)this.getModel().getValue(FENTITYNUMBER)).getString("dentityid"));
            if (mainEntityType instanceof BasedataEntityType) {
                this.changeIsBaseData(mainEntityType);
            } else if (mainEntityType instanceof BillEntityType) {
                this.changeIsBill(mainEntityType);
            } else {
                this.getModel().setValue(FFIELDNAME, (Object)"");
            }
        }
    }

    private void changeIsBill(MainEntityType mainEntityType) {
        BillEntityType billEntityType = (BillEntityType)mainEntityType;
        if (StringUtils.isNotEmpty((CharSequence)billEntityType.getBillNo())) {
            this.getModel().setValue(FFIELDNAME, (Object)billEntityType.getBillNo());
        } else {
            this.getModel().setValue(FFIELDNAME, (Object)"");
        }
    }

    private void changeIsBaseData(MainEntityType mainEntityType) {
        ArrayList<String> fieldList = new ArrayList<String>();
        BasedataEntityType basedataEntityType = (BasedataEntityType)mainEntityType;
        if (StringUtils.isNotEmpty((CharSequence)basedataEntityType.getNumberProperty())) {
            fieldList.add(basedataEntityType.getNumberProperty());
        }
        if (StringUtils.isNotEmpty((CharSequence)basedataEntityType.getNameProperty())) {
            fieldList.add(basedataEntityType.getNameProperty());
        }
        this.getModel().setValue(FFIELDNAME, (Object)StringUtils.join((Object[])fieldList.toArray(), (char)','));
    }

    private void showForm() {
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue(FENTITYNUMBER);
        String entityId = entityObject.getString("dentityid");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(IDE_LISTFIELDID);
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u7d22\u5f15\u5b57\u6bb5", (String)"FullTextIndexPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, IDE_LISTFIELDID);
        parameter.setCloseCallBack(closeCallBack);
        parameter.setCustomParam("entityId", (Object)entityId);
        parameter.setCustomParam("isMulti", (Object)Boolean.TRUE);
        parameter.setCustomParam("isNeedSeq", (Object)Boolean.FALSE);
        parameter.setCustomParam("isNeedBaseData", (Object)Boolean.FALSE);
        parameter.setCustomParam("checkedFields", this.getModel().getValue(FFIELDNAME));
        ArrayList<String> fieldTypes = new ArrayList<String>();
        fieldTypes.add("text");
        fieldTypes.add("localetext");
        fieldTypes.add("textarea");
        parameter.setCustomParam("fieldTypes", fieldTypes);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (IDE_LISTFIELDID.equals(e.getActionId())) {
            List fieldList = (List)e.getReturnData();
            if (fieldList == null) {
                return;
            }
            this.getModel().setValue(FFIELDNAME, ((Map)fieldList.get(0)).get("value"));
        }
    }
}

