/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.param.utils.GatedLaunchUtils;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class GatedLaunchAppPlugin
extends AbstractBasePlugIn {
    private static final String KEY_APP = "app";
    private static final String COMBO_PROD = "prodnum";
    private static Log log = LogFactory.getLog(GatedLaunchAppPlugin.class);
    private static Map<String, Map<String, String>> appGroupMap;

    public void initialize() {
        appGroupMap = this.parseGrayAppGroup();
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(COMBO_PROD);
        List<ComboItem> items = this.buildComboItems(true);
        comboEdit.setComboItems(items);
        if (!items.isEmpty()) {
            ComboItem comboItem = items.get(0);
            String initProdNum = comboItem.getValue();
            this.getModel().setValue(COMBO_PROD, (Object)initProdNum);
            this.setAppGroupView(initProdNum);
        }
    }

    public void afterLoadData(EventObject e) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(COMBO_PROD);
        List<ComboItem> items = this.buildComboItems();
        comboEdit.setComboItems(items);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{COMBO_PROD});
    }

    public void beforeBindData(EventObject e) {
        String displayProd = (String)this.getModel().getValue("displayprod");
        if (StringUtils.isNotEmpty((String)displayProd)) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(COMBO_PROD);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            items.add(new ComboItem(new LocaleString(displayProd), displayProd));
            comboEdit.setComboItems(items);
            this.getModel().beginInit();
            this.getModel().setValue(COMBO_PROD, (Object)displayProd);
            this.getModel().endInit();
            this.getModel().setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (COMBO_PROD.equals(name)) {
            String prodNum = (String)e.getChangeSet()[0].getNewValue();
            this.setAppGroupView(prodNum);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (((FormOperate)source).getOperateKey().equals("save")) {
            String value = (String)this.getModel().getValue(COMBO_PROD);
            this.getModel().setValue("displayprod", (Object)value);
        }
    }

    private List<ComboItem> buildComboItems() {
        return this.buildComboItems(false);
    }

    private List<ComboItem> buildComboItems(boolean excludeExistStrategy) {
        if (excludeExistStrategy) {
            List<String> existProd = GatedLaunchUtils.listProdNum();
            return appGroupMap.keySet().stream().filter(k -> !existProd.contains(k)).map(k -> new ComboItem(new LocaleString(k), k)).collect(Collectors.toList());
        }
        return appGroupMap.keySet().stream().map(k -> new ComboItem(new LocaleString(k), k)).collect(Collectors.toList());
    }

    private void setAppGroupView(String prodNum) {
        this.getModel().beginInit();
        Map<String, String> map = appGroupMap.get(prodNum);
        String version = map.values().stream().findFirst().orElseGet(StringUtils::getEmpty);
        String appIds = String.join((CharSequence)",", map.keySet());
        this.getModel().setValue("version", (Object)version);
        this.getModel().setValue("appids", (Object)appIds);
        this.getModel().endInit();
        this.getView().updateView();
    }

    private Map<String, Map<String, String>> parseGrayAppGroup() {
        Map res = Collections.EMPTY_MAP;
        try {
            Object grayAppGroup = GatedLaunchUtils.getGrayAppGroup();
            if (grayAppGroup != null) {
                res = (Map)grayAppGroup;
            }
        }
        catch (Exception e) {
            log.warn("get grayAppGroup error ", (Throwable)e);
        }
        return res;
    }
}

